/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.slf4j.Logger;

public class TESVGImageSaveServlet
extends HttpServlet {
    private static Logger log = TELogFactory.getNormalLogger();
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String type = request.getParameter("type");
        String svg = request.getParameter("svg");
        String filename = request.getParameter("filename");
        filename = filename == null ? "chart" : filename;
        ServletOutputStream out = response.getOutputStream();
        try {
            if (null != type && null != svg) {
                svg = svg.replaceAll(":rect", "rect");
                svg = svg.replaceAll("width=\"-1\"", "width=\"0\"");
                svg = svg.replaceAll("height=\"-1\"", "height=\"0\"");
                String ext = "";
                PNGTranscoder transcoder = null;
                if (type.equals("image/png")) {
                    ext = "png";
                    transcoder = new PNGTranscoder();
                } else if (type.equals("image/jpeg")) {
                    ext = "jpg";
                    transcoder = new JPEGTranscoder();
                }
                response.addHeader("Content-Disposition", "attachment; filename=" + filename + "." + ext);
                response.addHeader("Content-Type", type + ";charset=utf-8");
                response.setHeader("Expires", "0");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Cache-Control", "public");
                if (null != transcoder) {
                    transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
                    TranscoderInput input = new TranscoderInput((Reader)new StringReader(svg));
                    TranscoderOutput output = new TranscoderOutput((OutputStream)out);
                    transcoder.transcode(input, output);
                }
            } else {
                log.info("TESVGImageSaveServlet type is null or svgdata is null.");
            }
        }
        catch (Exception e) {
            log.info("Save svgdata as image fail:", (Throwable)e);
            return;
        }
        finally {
            out.flush();
            out.close();
        }
    }
}

