/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.report.TEParseTableHeadBean;
import com.huawei.nglct.report.TETableHeadInfoBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEFileUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.system.TESystemUtil;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class TEReportServlet
extends HttpServlet {
    private static final long serialVersionUID = 132776166793818477L;
    private static final String SFID_PARAM = "sfid";
    private static final String FLAG_PARAM = "flag";
    private static final String FUNC_PARAM = "func";
    private static final String PRINT_PARAM = "isprint";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private static final String TBHEAD_PARAM = "filepath";
    private static final String FILENAME_PARAM = "filename";
    private static final String CAPTITLE_PARAM = "captitle";
    private static final String DYNTABLEHEAD = "dyncolumn";
    private static final int GET_DATA_FROM_NE = 1;
    private static final int GET_DATA_FROM_MEMORY = 0;
    private static final int PRINT_HTML = 1;
    private int totalResultNum = 0;
    private List tableConf = null;
    private String capTitle = "";
    private String fileName = "";
    private boolean dyntable = false;
    private static Logger log = TELogFactory.getNormalLogger();
    private static final int HTML_MAX_SIZE = 102400;
    private static final int LOG_MAX_SIZE = 20000;
    private String encode = "";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dyntable = false;
        this.encode = System.getProperty("file.encoding");
        String browse = request.getHeader("User-Agent");
        if ((browse = browse.substring(browse.indexOf(40), browse.length())).indexOf("IE") >= 0) {
            String Language = request.getHeader("Accept-Language");
            if (Language.indexOf("zh") >= 0) {
                this.encode = "GBK";
            } else if (Language.indexOf("en") >= 0) {
                this.encode = "ISO-8859-1";
            }
        } else {
            this.encode = browse.indexOf("Gecko") >= 0 ? "unicode" : System.getProperty("file.encoding");
        }
        int neid = -1;
        int sfid = -1;
        int flag = -1;
        int isPrint = -1;
        boolean func = false;
        String sessionId = request.getSession().getId();
        String dateFormat = TimeZoneDateBean.getTimeConvertFormat();
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
        String funcparam = request.getParameter(FUNC_PARAM);
        if (funcparam != null && "true".equals(funcparam)) {
            func = true;
        }
        TELogFactory.getNormalLogger().info("The function(reportServlet- sfid: " + sfid + ") start time is " + format.format(new Date()));
        try {
            flag = Integer.parseInt(request.getParameter(FLAG_PARAM));
        }
        catch (Exception e) {
            flag = 1;
        }
        try {
            isPrint = Integer.parseInt(request.getParameter(PRINT_PARAM));
        }
        catch (Exception e) {
            isPrint = 1;
        }
        String inputDataStr = URLDecoder.decode(request.getParameter(INPUTDATA_PARAM), "UTF-8");
        String ipAddress = request.getRemoteAddr();
        String nmUser = request.getParameter("nmUser");
        String nmUserName = request.getParameter("nmUserName");
        if (null == nmUserName) {
            nmUserName = nmUser;
        }
        if (null == nmUserName || "".equals(nmUserName)) {
            nmUserName = TESysManagerBean.getInstance().getSysUser();
        }
        Datainterface inputData_report = null;
        Datainterface allData_report = null;
        SubFunc subFunc__report = null;
        try {
            TELogFactory.getInterfaceLogger().info("The sfid is \u00a3\u00ba" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
            inputData_report = TECreateObjectFactory.parseInputData((String)inputDataStr);
            neid = this.getNEID(inputData_report);
            subFunc__report = -1 == neid ? TECreateObjectFactory.getSubFunc((int)sfid) : TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
            if (null == subFunc__report) {
                subFunc__report = TECreateObjectFactory.getSubFunc((int)sfid);
            }
            String classMapping = subFunc__report.getClassMapping();
            String interClassMapping = subFunc__report.getInterClassMapping();
            if (TESysManagerBean.getInstance().isIntegratedStatus() && null != interClassMapping && !"".equals(interClassMapping)) {
                classMapping = interClassMapping;
            }
            TENEMgrInterface neMgrBean = null;
            if (flag == 1) {
                if (classMapping == null) {
                    log.debug("The Bussiness Process program is com.huawei.nglct.explorer.TENEExplorerBean");
                    neMgrBean = (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance();
                } else {
                    log.debug("The BussinessProcess program is " + classMapping);
                    neMgrBean = (TENEMgrInterface)Class.forName(classMapping).newInstance();
                }
                allData_report = neMgrBean.performBussinessProcess(neid, subFunc__report, inputData_report, null, nmUser, ipAddress);
            } else if (flag == 0) {
                allData_report = (Datainterface)request.getSession().getAttribute(neid + "_" + sfid);
                if (null != classMapping) {
                    neMgrBean = (TENEMgrInterface)Class.forName(classMapping).newInstance();
                    allData_report = neMgrBean.performBussinessProcess(neid, subFunc__report, inputData_report, allData_report, nmUser, ipAddress);
                }
            }
            if (-1 == neid) {
                neid = 99999;
            }
            String ROOT_PATH_STR = "";
            String cfgFileRootPath = null;
            if (null != allData_report) {
                this.parse(inputData_report);
                this.getSplitPageData(allData_report, inputData_report);
                if (isPrint == 1) {
                    this.encode = "UTF-8";
                    GregorianCalendar neTimeCalendar = new GregorianCalendar();
                    String print_date = format.format(neTimeCalendar.getTime());
                    this.toHTML(neid, allData_report, this.capTitle, this.fileName, this.tableConf, sessionId, nmUserName, print_date, this.dyntable, inputData_report);
                    cfgFileRootPath = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, (String)"");
                    StringBuffer path = new StringBuffer(cfgFileRootPath).append(File.separator).append("report").append(File.separator).append(sessionId).append(File.separator).append(neid).append(File.separator).append(this.fileName).append(".html");
                    File file = new File(path.toString());
                    for (int i = 0; !file.exists() && i < 10; ++i) {
                        Thread.sleep(400L);
                    }
                    String url = "report/" + sessionId + "/" + neid + "/" + this.fileName + ".html";
                    TESystemUtil.sendRedirect((String)url, (HttpServletRequest)request, (HttpServletResponse)response);
                } else {
                    ByteArrayOutputStream byteArray = this.saveTxt(neid, allData_report, this.capTitle, this.tableConf, this.dyntable, inputData_report);
                    if (func) {
                        this.saveReportAsResponse(this.fileName, byteArray, response);
                    } else {
                        this.saveReportAsFile(neid, this.fileName, sessionId, byteArray, request, response);
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("print or save fail:", (Throwable)e);
            TESystemUtil.sendRedirect((String)("page/printerror.html?message=" + isPrint), (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    private void toHTML(int neid, Datainterface outputData, String capTitle, String filename, List tableConf, String sessionId, String user, String date, boolean isdyntable, Datainterface inputData) {
        TEResourceUtil resUtil = TEResourceUtil.getInstance((String)("res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini"));
        StringBuffer sb = new StringBuffer(102400);
        if (this.totalResultNum > 20000) {
            this.totalResultNum = 20000;
        }
        RowParams[] rowParams = outputData.getBussinessParams().getRowParams();
        sb.append("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
        sb.append("<link href='../../../css/common.css' rel=stylesheet><link rel='stylesheet' href='../../../script/thirdparty/jsdomenu1.3/themes/office_xp/office_xp.css'></link>");
        sb.append("<STYLE type=text/css>");
        sb.append(".NotVisibleFrame ");
        sb.append("{word-wrap:break-word; BORDER-RIGHT: 1px solid; BORDER-TOP: 1px solid; BORDER-LEFT: 0px solid; LINE-HEIGHT: 16pt; BORDER-BOTTOM: black 0px solid}");
        sb.append(".VisibleFrame {table-layout:fixed; margin-left:5px; margin-right:5px; BORDER-RIGHT: black 0px solid; BORDER-TOP: black 0px solid; BORDER-LEFT: black 1px solid; LINE-HEIGHT: 16pt; BORDER-BOTTOM: black 1px solid}");
        sb.append("</STYLE><title>").append(capTitle).append("</title>");
        sb.append("<script type='text/javascript' src='../../../script/common.js'></script>");
        sb.append("<script type='text/javascript' src='../../../script/thirdparty/jsdomenu1.3/jsdomenu.js'></script>");
        sb.append("<script language='javascript'>loadXMLdoc('../../../conf/system.xml', 'GET', false, EncapsulateSConf);getResourse('../../../res/commonres_' + SYSTEMCONF.getLanguage() + '.xml');");
        sb.append("window.onload=function(){document.oncontextmenu=setContextmenu;}\n");
        sb.append("window.onhelp=function(){return true;};");
        sb.append("function setContextmenu(){removejsDOMmenu();var cursorMenu1 = new jsDOMenu(125); cursorMenu1.addMenuItem(new menuItem(RESOURCE['printbutton'],'',printPage,'')); setPopUpMenu(cursorMenu1); rightClickHandler();}\n");
        sb.append("function printPage(){hideMenu();window.print();}</script>");
        sb.append("</head><body oncontextmenu='return false;'><TABLE width='100%' border=0><TBODY><TR><TH width='25%'>");
        sb.append(resUtil.getString("curUser")).append("<BR>").append(user);
        sb.append("</TH><TH vAlign=center align=middle width='50%' nowarp></TH>");
        sb.append("<TH vAlign=center align=right width='25%' nowarp>");
        sb.append(date.substring(0, date.length() - 8));
        sb.append("<BR>").append(date.substring(date.length() - 8));
        sb.append("</TH></TR></TBODY></TABLE>");
        sb.append("<HR width='100%' color=black SIZE=1><P>&nbsp;</P><div align='center'><h2>");
        sb.append(capTitle).append("</h2></div>");
        sb.append("<div>").append(resUtil.getString("total")).append(this.totalResultNum);
        sb.append(resUtil.getString("item")).append(resUtil.getString("note"));
        sb.append("</div><table align='center' class=VisibleFrame cellspacing=0 border='1'><tr>");
        List headList = isdyntable ? TEParseTableHeadBean.getTableHead((int)neid, (Datainterface)inputData) : TEParseTableHeadBean.getTableHead((int)neid, (String)((String)tableConf.get(0)));
        int size = headList.size();
        for (int j = 0; j < size; ++j) {
            TETableHeadInfoBean headInfo = (TETableHeadInfoBean)headList.get(j);
            sb.append("<th class=NotVisibleFrame id='").append(headInfo.id);
            sb.append("' width='").append(headInfo.width).append("'>");
            sb.append(headInfo.name).append("</th>");
        }
        sb.append("</tr>");
        int errIndex = -1;
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream(102400);
        try {
            int k = 0;
            while (k < this.totalResultNum) {
                RowParams row = rowParams[k];
                sb.append("<tr>");
                int n = headList.size();
                for (int m = 0; m < n; ++m) {
                    TETableHeadInfoBean headInfo = (TETableHeadInfoBean)headList.get(m);
                    String value = "";
                    if (row.getParam(headInfo.id) != null) {
                        value = row.getParam(headInfo.id).getValue();
                    }
                    if (headInfo.isTimeColumn) {
                        Calendar cal = Calendar.getInstance();
                        if (!"".equals(value)) {
                            cal.setTimeInMillis(Long.parseLong(value));
                            value = TEDateUtils.calendarToStr((Calendar)cal);
                        }
                    }
                    if (null == value || "".equals(value)) {
                        value = "-";
                    }
                    sb.append("<td class=NotVisibleFrame width='").append(headInfo.width);
                    sb.append("'>").append(value).append("</td>");
                }
                sb.append("</tr>");
                if (k % 100 == 0) {
                    outputBuffer.write(sb.toString().getBytes(this.encode));
                    sb.delete(0, sb.length());
                }
                errIndex = k++;
            }
            sb.append("</table></body></html>");
            outputBuffer.write(sb.toString().getBytes(this.encode));
            String saveFileName = filename + ".html";
            TEFileUtil.SaveFile((String)sessionId, (String)String.valueOf(neid), (String)saveFileName, (byte[])outputBuffer.toByteArray());
            outputBuffer.close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("print all / save txt Record Index: " + errIndex, (Throwable)e);
        }
    }

    private ByteArrayOutputStream saveTxt(int neid, Datainterface outputData, String capTitle, List tableConf, boolean isdyntable, Datainterface inputData) {
        TEResourceUtil resUtil = TEResourceUtil.getInstance((String)("res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini"));
        String lineSep = System.getProperty("line.separator");
        RowParams[] rowParams = outputData.getBussinessParams().getRowParams();
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream(102400);
        try {
            int mm = tableConf.size();
            for (int i = 0; i < mm; ++i) {
                TETableHeadInfoBean headInfo;
                int k;
                int j;
                if (this.totalResultNum > 20000) {
                    this.totalResultNum = 20000;
                }
                String pageNum = resUtil.getString("total") + this.totalResultNum + resUtil.getString("item") + resUtil.getString("note") + "\t";
                outputBuffer.write(pageNum.getBytes(this.encode));
                outputBuffer.write(lineSep.getBytes(this.encode));
                List headList = isdyntable ? TEParseTableHeadBean.getTableHead((int)neid, (Datainterface)inputData) : TEParseTableHeadBean.getTableHead((int)neid, (String)((String)tableConf.get(i)));
                int[] widthList = new int[headList.size()];
                int size = headList.size();
                for (j = 0; j < size; ++j) {
                    TETableHeadInfoBean headInfo2 = (TETableHeadInfoBean)headList.get(j);
                    widthList[j] = TEReportServlet.getChineseLength(headInfo2.name);
                }
                for (k = 0; k < this.totalResultNum; ++k) {
                    RowParams row = rowParams[k];
                    int n = headList.size();
                    for (int m = 0; m < n; ++m) {
                        headInfo = (TETableHeadInfoBean)headList.get(m);
                        int length = 0;
                        if (headInfo.isTimeColumn) {
                            long offset = 0L;
                            Param offsetParam = row.getParam("offset");
                            if (offsetParam != null && offsetParam.getValue() != null) {
                                offset = Long.parseLong(offsetParam.getValue());
                            }
                            Calendar cal = Calendar.getInstance();
                            cal.setTimeInMillis(Long.parseLong(row.getParam(headInfo.id).getValue()) - (long)cal.getTimeZone().getRawOffset() - offset);
                            String calStr = TEDateUtils.calendarToStr((Calendar)cal);
                            length = TEReportServlet.getChineseLength(calStr);
                        } else {
                            length = row.getParam(headInfo.id) == null ? 0 : TEReportServlet.getChineseLength(row.getParam(headInfo.id).getValue());
                        }
                        if (widthList[m] >= length) continue;
                        widthList[m] = length;
                    }
                }
                size = headList.size();
                for (j = 0; j < size; ++j) {
                    TETableHeadInfoBean headInfo3 = (TETableHeadInfoBean)headList.get(j);
                    String str = headInfo3.name;
                    str = str + this.getSpace(widthList[j] - TEReportServlet.getChineseLength(str)) + this.getSpace(4);
                    outputBuffer.write(str.getBytes(this.encode));
                }
                outputBuffer.write(lineSep.getBytes(this.encode));
                for (k = 0; k < this.totalResultNum; ++k) {
                    RowParams row = rowParams[k];
                    int n = headList.size();
                    for (int m = 0; m < n; ++m) {
                        headInfo = (TETableHeadInfoBean)headList.get(m);
                        String str = "";
                        if (row.getParam(headInfo.id) != null) {
                            str = row.getParam(headInfo.id).getValue();
                        }
                        if (str.length() >= 1 && str.substring(str.length() - 1, str.length()).equals("\r")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        if (headInfo.isTimeColumn) {
                            Calendar cal = Calendar.getInstance();
                            if (row.getParam(headInfo.id) != null && row.getParam(headInfo.id).getValue() != null) {
                                cal.setTimeInMillis(Long.parseLong(row.getParam(headInfo.id).getValue()));
                            }
                            String calStr = TEDateUtils.calendarToStr((Calendar)cal);
                            calStr = calStr + this.getSpace(widthList[m] - TEReportServlet.getChineseLength(calStr)) + this.getSpace(4);
                            outputBuffer.write(calStr.getBytes(this.encode));
                            continue;
                        }
                        str = str + this.getSpace(widthList[m] - TEReportServlet.getChineseLength(str)) + this.getSpace(4);
                        outputBuffer.write(str.getBytes(this.encode));
                    }
                    outputBuffer.write(lineSep.getBytes(this.encode));
                }
                outputBuffer.write(lineSep.getBytes(this.encode));
                outputBuffer.write(lineSep.getBytes(this.encode));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Save all txt Record", (Throwable)e);
        }
        return outputBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReportAsResponse(String filename, ByteArrayOutputStream outputBuffer, HttpServletResponse response) {
        try {
            String saveFileName = filename + ".txt";
            ServletOutputStream out = response.getOutputStream();
            response.reset();
            response.setHeader("Content-Type", "application/force-download");
            response.setHeader("Content-disposition", "attachment;filename=" + response.encodeURL(saveFileName));
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            response.setHeader("Cache-Control", "public");
            BufferedOutputStream bos = null;
            try {
                bos = new BufferedOutputStream((OutputStream)out);
                byte[] buff = outputBuffer.toByteArray();
                bos.write(buff, 0, buff.length);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("saveReportAsResponse fail!", (Throwable)e);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                outputBuffer.close();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("saveReportAsResponse", (Throwable)e);
        }
    }

    private void saveReportAsFile(int neid, String filename, String sessionId, ByteArrayOutputStream outputBuffer, HttpServletRequest request, HttpServletResponse response) {
        try {
            String saveFileName = filename + ".txt";
            TEFileUtil.SaveFile((String)sessionId, (String)String.valueOf(neid), (String)saveFileName, (byte[])outputBuffer.toByteArray());
            outputBuffer.close();
            String cfgFileRootPath = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, (String)"");
            StringBuffer path = new StringBuffer(cfgFileRootPath).append(File.separator).append("report").append(File.separator).append(sessionId).append(File.separator).append(neid).append(File.separator).append(this.fileName).append(".txt");
            File file = new File(path.toString());
            for (int i = 0; !file.exists() && i < 10; ++i) {
                Thread.sleep(200L);
            }
            String url = "report/" + sessionId + "/" + neid + "/" + this.fileName + ".txt";
            TESystemUtil.sendRedirect((String)url, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("saveReportAsFile", (Throwable)e);
        }
    }

    private void getSplitPageData(Datainterface allData, Datainterface inputData) {
        if (allData.getBussinessParams() != null) {
            Param param = allData.getBussinessParams().getRowParams(0).getParam("totalResultNum");
            if (null != param) {
                allData.getBussinessParams().removeRowParams(0);
            }
            this.totalResultNum = allData.getBussinessParams().getRowParamsCount();
        } else {
            this.totalResultNum = 0;
        }
    }

    public static int getChineseLength(String value) {
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getSpace(int length) {
        StringBuffer spaceSb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            spaceSb.append(' ');
        }
        return spaceSb.toString();
    }

    private void parse(Datainterface inputData) {
        this.tableConf = new ArrayList();
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        try {
            int size = paramArr.length;
            for (int i = 0; i < size; ++i) {
                String pName = paramArr[i].getName();
                String pvalue = paramArr[i].getValue();
                if (pName.equalsIgnoreCase(TBHEAD_PARAM)) {
                    this.tableConf.add(URLDecoder.decode(pvalue, "UTF-8"));
                    continue;
                }
                if (pName.equalsIgnoreCase(FILENAME_PARAM)) {
                    this.fileName = URLDecoder.decode(pvalue, "UTF-8").replaceAll(" ", "");
                    if (!TESysManagerBean.getInstance().getlanguage().equals("zh")) continue;
                    this.fileName = new String(this.fileName.getBytes("GBK"), "ISO8859_1");
                    continue;
                }
                if (pName.equalsIgnoreCase(CAPTITLE_PARAM)) {
                    this.capTitle = URLDecoder.decode(pvalue, "UTF-8");
                    continue;
                }
                if (!pName.equalsIgnoreCase(DYNTABLEHEAD)) continue;
                this.dyntable = URLDecoder.decode(pvalue, "UTF-8").equalsIgnoreCase("yes");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("convert code err!");
        }
    }

    private int getNEID(Datainterface inputData) {
        Param[] paramArr_report = inputData.getBussinessParams().getRowParams(0).getParam();
        int neid_report = -1;
        int size = paramArr_report.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr_report[i].getName().equalsIgnoreCase(NEID_PARAM)) continue;
            try {
                neid_report = Integer.parseInt(paramArr_report[i].getValue());
            }
            catch (NumberFormatException e) {
                log.error("Get neid fail:\n", (Throwable)e);
                return -1;
            }
            return neid_report;
        }
        return -1;
    }
}

