/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.t2kinterface.TEDBConnMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENERegisterInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TECheckStaticDataServlet;
import com.huawei.nglct.nelist.TEDevicePackageUpload;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENELdDevPkgNoticeReceiver;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENELoadDevPkgNoticeReceiver;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TENERequestPool {
    private static final int RTN910_DEVTYPE = 76;
    private static final int RTN950_DEVTYPE = 77;
    private static final int PTN910_DEVTYPE = 64;
    private static final int PTN950_DEVTYPE = 65;
    private static final String PTN910_HOST_VERSION = "5.64.01.10";
    private static final String PTN950_HOST_VERSION = "5.65.01.10";
    private static final int LOAD_FROM_LOCAL = 0;
    private static final int IS_SSL_FLAG = 1;
    private static final int COMM_TCP = 1;
    private static final int COMM_SSL = 4;
    private static final String SBIPORT = "11017";
    private static Map<String, String> neTypeMap = null;
    private Map<String, String> neUserInfoMap = null;
    private static final byte[] KEY = new byte[]{89, 69, 75, 48, 48, 48, 50, 84};
    private static final byte[] ADD_ENCRPT_STR = new byte[]{68, 50, 67, 56, 49, 50, 55, 56, 68, 70, 53, 65, 65, 67, 53, 53};
    private static String imapRootEnv = "";
    private static final String neTypeMapFileName = "server" + File.separator + "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "model" + File.separator + "netype_map.xml";
    private static final String sslFileName = "server" + File.separator + "conf" + File.separator + "imapsec.cfg";
    private Properties sslInfo = null;
    private Connection mcdbConn = null;
    private static final String SFID_PARAM = "sfid";
    private static final String FLAG_PARAM = "flag";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private static final int GET_DATA_FROM_NE = 1;
    private static final int GET_DATA_FROM_MEMORY = 0;
    private Logger log = TELogFactory.getNormalLogger();
    private static final String NE_NOT_EXIST = "1090629639";
    private List<Callable<Datainterface>> lstTask = new ArrayList<Callable<Datainterface>>();
    private List<Datainterface> lstOutputData = new ArrayList<Datainterface>();
    private boolean isFinish = false;
    private int iFinishCount = 0;
    private int iTaskCount = 0;
    private String inputDataStr;
    private int sfid;
    private String ipAddress;
    private String nmUser;
    private String commStr;
    private int flag;
    private String lan;
    private HttpSession oHttpSession;

    public TENERequestPool(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/xml;charset=UTF-8");
        this.inputDataStr = new String(request.getParameter(INPUTDATA_PARAM).getBytes("ISO-8859-1"), "UTF-8");
        this.sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
        this.ipAddress = request.getRemoteAddr();
        this.nmUser = request.getParameter("nmUser");
        this.commStr = TECheckStaticDataServlet.staticData;
        this.flag = -1;
        try {
            this.flag = Integer.parseInt(request.getParameter(FLAG_PARAM));
        }
        catch (Exception e) {
            this.flag = 1;
        }
        this.lan = request.getParameter("lan");
        this.oHttpSession = request.getSession();
    }

    public synchronized void initThreadPool() {
        Datainterface inputData = null;
        try {
            inputData = TECreateObjectFactory.parseInputData((String)this.inputDataStr);
            int[] arrNeid = this.getNEIDList(inputData);
            if (null == arrNeid) {
                throw new Exception("The neid list is null!");
            }
            this.iTaskCount = arrNeid.length;
            for (int neid : arrNeid) {
                SubFunc subFunc = null;
                Datainterface inputDataSingle = TECreateObjectFactory.parseInputData((String)this.inputDataStr);
                this.setNEID(neid, inputDataSingle);
                TENE ne = TENEListMgr.getInstance().getNE(neid);
                if (null == ne) {
                    try {
                        ne = this.createTENE(neid, this.nmUser, this.lan, this.commStr);
                    }
                    catch (Exception e) {
                        ne = null;
                    }
                }
                if (null == ne) {
                    this.defaultOutputData(neid, Integer.parseInt(NE_NOT_EXIST));
                    continue;
                }
                subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)this.sfid);
                if (null == subFunc && null == (subFunc = TECreateObjectFactory.getSubFunc((int)this.sfid))) {
                    this.log.info("Don't found subfunction(sfid = " + this.sfid + ") description in Functions description file\u00a3\u00a1");
                    throw new Exception();
                }
                String classMapping = subFunc.getClassMapping();
                TENERegisterInterface neMgrBean = null;
                if (1 == this.flag) {
                    try {
                        if (null == classMapping) {
                            this.log.debug("The Bussiness Process program is com.huawei.nglct.explorer.TENEExplorerBean");
                            neMgrBean = (TENERegisterInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance();
                        } else {
                            this.log.debug("The BussinessProcess program is " + classMapping);
                            neMgrBean = (TENERegisterInterface)Class.forName(classMapping).newInstance();
                        }
                        neMgrBean.registerBussinessProcess(neid, subFunc, inputDataSingle, null, this.nmUser, this.ipAddress);
                        this.lstTask.add((Callable<Datainterface>)neMgrBean);
                    }
                    catch (Exception e) {
                        this.defaultOutputData(neid, 1090646019);
                    }
                    continue;
                }
                if (0 == this.flag) {
                    Datainterface memeryData = (Datainterface)this.oHttpSession.getAttribute(neid + "_" + this.sfid);
                    if (null != classMapping) {
                        this.log.debug("The BussinessProcess program is " + classMapping);
                        try {
                            neMgrBean = (TENERegisterInterface)Class.forName(classMapping).newInstance();
                        }
                        catch (Exception e) {
                            this.defaultOutputData(neid, 1090646019);
                        }
                        if (neMgrBean == null) continue;
                        neMgrBean.registerBussinessProcess(neid, subFunc, inputDataSingle, memeryData, this.nmUser, this.ipAddress);
                        this.lstTask.add((Callable<Datainterface>)neMgrBean);
                        continue;
                    }
                    this.lstOutputData.add(memeryData);
                    ++this.iFinishCount;
                    continue;
                }
                this.defaultOutputData(neid, 1090646019);
                break;
            }
        }
        catch (Exception e) {
            this.log.debug("parse interface is failed\u00a3\u00a1", (Throwable)e);
            this.isFinish = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TENE createTENE(int neid, String nmUser, String lan, String strComm) throws Exception {
        try {
            this.loadNeTypeMapping();
            this.parseUserInfo(strComm);
            this.sslInfo = new Properties();
            FileInputStream inputFS = null;
            try {
                inputFS = new FileInputStream(imapRootEnv + File.separator + sslFileName);
            }
            catch (FileNotFoundException ex1) {
                TELogFactory.getNormalLogger().error("Creat TENE fail! neid = " + neid, (Throwable)ex1);
                TENE tENE = null;
                return tENE;
            }
            finally {
                try {
                    if (inputFS != null) {
                        inputFS.close();
                    }
                }
                catch (IOException ex2) {
                    TELogFactory.getNormalLogger().error("Close file failed for " + imapRootEnv + File.separator + sslFileName, (Throwable)ex2);
                }
            }
            this.sslInfo.load(inputFS);
            if (null == this.mcdbConn) {
                this.mcdbConn = TEDBConnMgr.getInstance().getDBConn("MCDB");
                if (null == this.mcdbConn) {
                    TELogFactory.getNormalLogger().error("Get DB connection is fail!");
                    return null;
                }
            }
            int nePhyID = 0;
            CallableStatement callstaGetPhyID = null;
            String strGetPhyID = "{call p_GetPhyIDByDevID(?,?)}";
            try {
                callstaGetPhyID = this.mcdbConn.prepareCall(strGetPhyID);
                callstaGetPhyID.setInt(1, neid);
                callstaGetPhyID.registerOutParameter(2, 4);
                callstaGetPhyID.execute();
                nePhyID = callstaGetPhyID.getInt(2);
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("Get NE PhyID is fail!", (Throwable)e);
                TENE ex2 = null;
                return ex2;
            }
            finally {
                if (callstaGetPhyID != null) {
                    callstaGetPhyID.close();
                }
            }
            String t2000Lang = lan;
            DeploymentMode sysStatus = TESysManagerBean.getInstance().getSysStauts();
            String lang = TESysManagerBean.getInstance().getlanguage();
            if (sysStatus == TESysManagerConstants.SYS_SINGLE_STATUS) {
                TELogFactory.getNormalLogger().info("sysStatus is wrong!");
                return null;
            }
            if (null == t2000Lang || !t2000Lang.toLowerCase(Locale.ENGLISH).equals("zh")) {
                t2000Lang = "en";
            }
            if (!t2000Lang.toLowerCase(Locale.ENGLISH).equals(lang.toLowerCase(Locale.ENGLISH))) {
                return null;
            }
            int gneType = 1;
            String gneAdd = "";
            String gnePort = "";
            ResultSet reStatementGetGne = null;
            CallableStatement callstaGetGne = null;
            String strGetGne = "{?=call p_GetGneParaByPhyID(?)}";
            try {
                callstaGetGne = this.mcdbConn.prepareCall(strGetGne);
                callstaGetGne.setInt(2, nePhyID);
                callstaGetGne.registerOutParameter(1, 1111);
                if (callstaGetGne.execute()) {
                    reStatementGetGne = callstaGetGne.getResultSet();
                    while (reStatementGetGne.next()) {
                        gneType = reStatementGetGne.getInt(2);
                        gneAdd = this.conversion(reStatementGetGne.getInt(3));
                        gnePort = String.valueOf(reStatementGetGne.getInt(4));
                    }
                    reStatementGetGne.close();
                }
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("Get NE gne info is fail!", (Throwable)e);
                TENE tENE = null;
                return tENE;
            }
            finally {
                if (callstaGetGne != null) {
                    callstaGetGne.close();
                }
                if (reStatementGetGne != null && !reStatementGetGne.isClosed()) {
                    reStatementGetGne.close();
                }
            }
            String devType = "";
            String hostVersion = "";
            ResultSet reStatementGetNePara = null;
            CallableStatement callstaGetNePara = null;
            String strGetNePara = "{?=call p_GetNEParaByNEID(?)}";
            try {
                callstaGetNePara = this.mcdbConn.prepareCall(strGetNePara);
                callstaGetNePara.registerOutParameter(1, 1111);
                callstaGetNePara.setInt(2, neid);
                if (callstaGetNePara.execute()) {
                    reStatementGetNePara = callstaGetNePara.getResultSet();
                    while (reStatementGetNePara.next()) {
                        devType = neTypeMap.get(String.valueOf(reStatementGetNePara.getInt(1)));
                        hostVersion = this.conversion(reStatementGetNePara.getInt(3));
                    }
                    reStatementGetNePara.close();
                }
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("Get NE Pare info is fail!", (Throwable)e);
                TENE tENE = null;
                return tENE;
            }
            finally {
                if (callstaGetNePara != null) {
                    callstaGetNePara.close();
                }
                if (reStatementGetNePara != null && !reStatementGetNePara.isClosed()) {
                    reStatementGetNePara.close();
                }
            }
            if (76 == Integer.parseInt(devType.trim())) {
                devType = Integer.toString(64);
                hostVersion = PTN910_HOST_VERSION;
            }
            if (77 == Integer.parseInt(devType.trim())) {
                devType = Integer.toString(65);
                hostVersion = PTN950_HOST_VERSION;
            }
            String neName = "";
            ResultSet reStatementGetNeName = null;
            CallableStatement callstaGetNeName = null;
            String strGetNeName = "{?=call p_GetNENameByNEID(?)}";
            try {
                callstaGetNeName = this.mcdbConn.prepareCall(strGetNeName);
                callstaGetNeName.registerOutParameter(1, 1111);
                callstaGetNeName.setInt(2, neid);
                if (callstaGetNeName.execute()) {
                    reStatementGetNeName = callstaGetNeName.getResultSet();
                    while (reStatementGetNeName.next()) {
                        neName = reStatementGetNeName.getString(1);
                    }
                    reStatementGetNeName.close();
                }
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("Get NE Name is fail!", (Throwable)e);
                TENE tENE = null;
                return tENE;
            }
            finally {
                if (callstaGetNeName != null) {
                    callstaGetNeName.close();
                }
                if (reStatementGetNeName != null && !reStatementGetNeName.isClosed()) {
                    reStatementGetNeName.close();
                }
            }
            int connMode = 0;
            try {
                connMode = Integer.parseInt(this.sslInfo.getProperty("SSLMode"));
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().info("get Connect mode final!");
            }
            gneType = 1 == connMode ? 4 : 1;
            String userName = "";
            String userPassword = "";
            String sbiAdd = "";
            String sbiPort = SBIPORT;
            String commStr = this.neUserInfoMap.get(String.valueOf(neid));
            if (null == commStr) {
                TELogFactory.getNormalLogger().error("Get User info is fail!");
                return null;
            }
            String[] obc = commStr.split(":");
            if (4 != obc.length) {
                TELogFactory.getNormalLogger().error("Get User info is fail!");
                return null;
            }
            byte[] user = this.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString((String)(obc[0] + new String(ADD_ENCRPT_STR))));
            byte[] pwd = this.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString((String)(obc[1] + new String(ADD_ENCRPT_STR))));
            byte[] sbiads = this.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString((String)(obc[2] + new String(ADD_ENCRPT_STR))));
            byte[] sbiport = this.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString((String)(obc[3] + new String(ADD_ENCRPT_STR))));
            userName = IOStreamConvertor.replaceSpecialStr((String)new String(user));
            byte[] newpwd = IOStreamConvertor.removeByteZero((byte[])pwd);
            EncryptUtils.clearByte((byte[])pwd);
            sbiAdd = IOStreamConvertor.replaceSpecialStr((String)new String(sbiads));
            sbiPort = IOStreamConvertor.replaceSpecialStr((String)new String(sbiport));
            TENE ne = new TENE();
            ne.setNEID(neid);
            ne.setRealNEID(nePhyID);
            ne.setNEGWAddress(sbiAdd);
            ne.setPort(sbiPort);
            ne.setNEGWType(gneType);
            ne.setCurUser(userName);
            ne.setCurUserPassword(newpwd);
            TENECommMgr.getInstance().putLogicNEID((long)nePhyID, (long)neid);
            TENEListMgr.getInstance().deleteNE(ne.getNEID(), ne.getRealNEID());
            TENE oldNe = TENEListMgr.getInstance().getNE(neid);
            if (!(null == oldNe || oldNe.getNEGWAddress().equalsIgnoreCase(sbiAdd) && oldNe.getPort().equalsIgnoreCase(sbiPort))) {
                TELogFactory.getNormalLogger().info("The Connect Port Change!!");
                TELogFactory.getNormalLogger().info("The Old Connect Address=" + oldNe.getNEGWAddress() + ",Port=" + oldNe.getPort() + "!!");
                TELogFactory.getNormalLogger().info("The New Connect Address=" + sbiAdd + ",Port=" + sbiPort + "!!");
                TENECommMgr.getInstance().closeConnect((long)neid, Integer.parseInt(oldNe.getPort()), oldNe.getNEGWAddress(), 0);
                TENECommMgr.getInstance().createConect((long)neid, Integer.parseInt(sbiPort), sbiAdd, 0, ne.getBaudRate());
            }
            ne.setNEName(neName);
            this.setNEAttr(ne, devType, hostVersion);
            int result = TENEListMgr.getInstance().addNE(ne, sbiAdd, sbiPort);
            if (0 != result && result != 1090781210) {
                TELogFactory.getNormalLogger().debug("Connect to SBI Fail!");
                return null;
            }
            ne = TENEListMgr.getInstance().getNE(neid);
            if (ne.getHostVersion() == null || ne.getHostVersion().equals("")) {
                ne.setNEGWAddress(gneAdd);
                ne.setPort(gnePort);
                ne.setNEGWType(gneType);
                ne.setCurUser(userName);
                ne.setCurUserPassword(newpwd);
                ne.setHostVersion(hostVersion);
            }
            if (userName.equals(ne.getCurUser()) && userPassword.equals(ne.getCurUserPassword()) && ne.getLogStatus() == 1) {
                this.setNEAttr(ne, devType, hostVersion);
                TELogFactory.getNormalLogger().debug("user has logined.");
                ne.initNEData();
                return ne;
            }
            result = ne.login(userName, newpwd, 1);
            if (0 == result) {
                TELogFactory.getNormalLogger().debug("Login ne success!");
                this.setNEAttr(ne, devType, hostVersion);
                ArrayList<TENE> succNEList = new ArrayList<TENE>();
                succNEList.add(ne);
                int uploadtype = Integer.parseInt(TESysManagerBean.getInstance().getProperty("uploadtype"));
                if (uploadtype == 0) {
                    new TENELdDevPkgNoticeReceiver().handleNotice(ne.getNEID());
                } else {
                    TEDevicePackageUpload devPkgLoader = TEDevicePackageUpload.getInstance();
                    devPkgLoader.devicePakageUpload(succNEList, (TENELoadDevPkgNoticeReceiver)new TENELdDevPkgNoticeReceiver());
                }
            } else {
                TELogFactory.getNormalLogger().debug("Login ne Fail!");
            }
            EncryptUtils.clearByte((byte[])newpwd);
            return ne;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Creat TENE fail! neid = " + neid, (Throwable)e);
            return null;
        }
    }

    private void setNEAttr(TENE ne, String devType, String hostVersion) {
        String devPkgVersion = "";
        if (null != devType && !"".equals(devType)) {
            ne.setDeviceType(devType);
            int neType = Integer.parseInt(devType);
            ne.setNEType(neType);
            HashMap<String, String> devPkgVersionMap = new HashMap<String, String>();
            devPkgVersionMap.put("52", "ne_05520110v01");
            devPkgVersionMap.put("51", "ne_05240100v01");
            devPkgVersionMap.put("54", "ne_05540110v01");
            devPkgVersionMap.put("55", "ne_05540110v01");
            devPkgVersionMap.put("58", "ne_05580110v01");
            devPkgVersionMap.put("59", "ne_05590110v01");
            devPkgVersionMap.put("60", "ne_05600110v01");
            devPkgVersionMap.put("61", "ne_05610110v01");
            devPkgVersionMap.put("63", "ne_05630110v01");
            devPkgVersionMap.put("64", "ne_05640110v01");
            devPkgVersionMap.put("65", "ne_05650110v01");
            devPkgVersionMap.put("29", "ne_05211910v01");
            devPkgVersionMap.put("31", "ne_05361910v01");
            devPkgVersionMap.put("36", "ne_05361910v01");
            devPkgVersionMap.put("41", "ne_05211910v01");
            devPkgVersionMap.put("43", "ne_05361910v01");
            devPkgVersionMap.put("67", "ne_05670110v01");
            devPkgVersionMap.put("68", "ne_05240100v01");
            String temp = (String)devPkgVersionMap.get(String.valueOf(devType));
            if (null != temp && !"".equals(temp)) {
                devPkgVersion = temp;
            }
        }
        if (!"".equals(devPkgVersion)) {
            ne.setDevPkgVersion(devPkgVersion);
            String[] tempStrArr = hostVersion.split("\\p{Punct}");
            int insertPoint = tempStrArr[0].length() + tempStrArr[1].length() + 2;
            String tmpStr = tempStrArr[2].length() == 1 ? "0" + hostVersion.substring(insertPoint) : hostVersion.substring(insertPoint);
            hostVersion = hostVersion.substring(0, insertPoint) + tmpStr;
            ne.setHostVersion(ne.getHostVer(hostVersion));
            ne.setShowNEVersion(hostVersion);
            TELogFactory.getNormalLogger().debug("ne hostVersion:" + ne.getHostVersion());
            TELogFactory.getNormalLogger().debug("ne ShowNEVersion:" + hostVersion);
        }
    }

    private synchronized void defaultOutputData(int neid, int errorCode) {
        Datainterface outputData = new Datainterface();
        RowParams rowparams = new RowParams();
        Param param = new Param(NEID_PARAM, String.valueOf(neid));
        rowparams.addParam(param);
        BussinessParams bussinessParams = outputData.getBussinessParams();
        if (null == bussinessParams) {
            bussinessParams = new BussinessParams();
            outputData.setBussinessParams(bussinessParams);
        }
        outputData.getBussinessParams().addRowParams(0, rowparams);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorCode));
        this.lstOutputData.add(outputData);
        ++this.iFinishCount;
        if (this.iFinishCount == this.iTaskCount) {
            this.isFinish = true;
        }
    }

    private int[] getNEIDList(Datainterface inputData) {
        String strNeid = "";
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr[i].getName().equalsIgnoreCase(NEID_PARAM)) continue;
            strNeid = paramArr[i].getValue();
            break;
        }
        if (null == strNeid || "".equals(strNeid)) {
            return null;
        }
        String[] neid = strNeid.split(",");
        int[] arrNeid = new int[neid.length];
        int j = neid.length;
        for (int i = 0; i < j; ++i) {
            try {
                arrNeid[i] = Integer.parseInt(neid[i]);
                continue;
            }
            catch (Exception e) {
                arrNeid[i] = -1;
            }
        }
        return arrNeid;
    }

    private void setNEID(int neid, Datainterface inputDataSingle) {
        Param[] paramArr = inputDataSingle.getBussinessParams().getRowParams(0).getParam();
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr[i].getName().equalsIgnoreCase(NEID_PARAM)) continue;
            paramArr[i].setValue(String.valueOf(neid));
            break;
        }
    }

    public void execute() {
        ExecutorService exec = Executors.newCachedThreadPool();
        for (Callable<Datainterface> task : this.lstTask) {
            final Future<Datainterface> outputData = exec.submit(task);
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<?> clazz = this.getClass();
                    synchronized (clazz) {
                        try {
                            TENERequestPool.this.getOutPutDataList().add((Datainterface)outputData.get());
                            TENERequestPool.this.iFinishCount++;
                            if (TENERequestPool.this.iFinishCount == TENERequestPool.this.iTaskCount) {
                                TENERequestPool.this.isFinish = true;
                            }
                        }
                        catch (Exception e) {
                            TENERequestPool.this.log.debug("get result failed!");
                        }
                    }
                }
            };
            thread.start();
        }
    }

    public synchronized List<Datainterface> getOutPutDataList() {
        return this.lstOutputData;
    }

    public synchronized boolean isFinish() {
        return this.isFinish;
    }

    public void removeOutputData(Datainterface outputData) {
        this.getOutPutDataList().remove(outputData);
    }

    public synchronized void clean() {
        this.lstTask.clear();
        this.getOutPutDataList().clear();
        this.lstTask = null;
        this.lstOutputData = null;
    }

    private String conversion(int iAboriginality) {
        String strResult = "";
        try {
            String strAboriginality = Integer.toHexString(iAboriginality);
            int m = 8 - strAboriginality.length();
            for (int i = 0; i < m; ++i) {
                strAboriginality = "0" + strAboriginality;
            }
            String[] lst = new String[4];
            for (int i = 0; i < 4; ++i) {
                int j = i * 2;
                lst[i] = strAboriginality.substring(j, j + 2);
            }
            for (int n = 0; n < 4; ++n) {
                strResult = strResult + Integer.decode("0X" + lst[n]);
                if (3 == n) continue;
                strResult = strResult + ".";
            }
        }
        catch (Exception e) {
            strResult = "";
        }
        return strResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadNeTypeMapping() {
        if (null != neTypeMap) {
            return;
        }
        neTypeMap = new HashMap<String, String>();
        this.getImapPath();
        File file = new File(imapRootEnv + File.separator + neTypeMapFileName);
        if (!file.exists()) {
            return;
        }
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
            InputSource input = new InputSource(fileStream);
            input.setSystemId(file.getName());
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(input);
            Element root = doc.getDocumentElement();
            NodeList children = root.getElementsByTagName("device");
            for (int j = 0; j < children.getLength(); ++j) {
                Element child = (Element)children.item(j);
                neTypeMap.put(child.getAttribute("platformTypeID"), child.getAttribute("optixTypeID"));
            }
        }
        catch (Exception ex) {
            this.log.debug("get NE Type Map failed!", (Throwable)ex);
        }
        finally {
            this.safeCloseileStream(fileStream);
        }
    }

    private void safeCloseileStream(FileInputStream fileStream) {
        if (fileStream != null) {
            try {
                fileStream.close();
            }
            catch (IOException ex) {
                this.log.info("close file stream failed!", (Throwable)ex);
            }
        }
    }

    private void getImapPath() {
        imapRootEnv = System.getenv("IMAPROOT");
    }

    private void parseUserInfo(String commStr) {
        if (null != this.neUserInfoMap) {
            return;
        }
        this.neUserInfoMap = new HashMap<String, String>();
        String[] lstUserInfo = commStr.split(";");
        int j = lstUserInfo.length;
        for (int i = 0; i < j; ++i) {
            String[] lst = lstUserInfo[i].split(",");
            if (2 != lst.length) continue;
            this.neUserInfoMap.put(lst[0], lst[1]);
        }
    }

    public byte[] decryptPwd(String key, byte[] encrptbyte) throws Exception {
        String arithmetic = "DES";
        byte[] b_key = key.getBytes();
        SecretKeySpec deskey = new SecretKeySpec(b_key, arithmetic);
        Cipher c1 = Cipher.getInstance(arithmetic);
        c1.init(2, deskey);
        return c1.doFinal(encrptbyte);
    }
}

