/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogUtil;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TESplitPageBean;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.genfunctionbean.TEGenNEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

public class TENEExplorerServlet
extends HttpServlet {
    private static final String SFID_PARAM = "sfid";
    private static final String FLAG_PARAM = "flag";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private static final int GET_DATA_FROM_NE = 1;
    private static final int GET_DATA_FROM_MEMORY = 0;
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String SUBMIT_STATUS_WAIT = "wait";
    private static final String SUBMIT_STUTUS_PARAMNAME = "submitstatus";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int neid = -1;
        int sfid = -1;
        int flag = -1;
        Datainterface outputData = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        response.setContentType("text/xml;charset=UTF-8");
        PrintWriter print = response.getWriter();
        Writer out = null;
        sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
        boolean isDebugNeeded = TELogUtil.isContainsPasswordPrint((int)sfid);
        boolean isImportanceLog = TELogUtil.isContainsImportancePrint((int)sfid);
        flag = this.getFlag(request);
        String inputDataStr = request.getParameter(INPUTDATA_PARAM);
        String submitstatus = request.getParameter(SUBMIT_STUTUS_PARAMNAME);
        if (submitstatus != null && !submitstatus.isEmpty()) {
            String sessionParamName;
            HttpSession session = request.getSession();
            String inputDataStrSession = (String)session.getAttribute(sessionParamName = "inputdata_" + sfid);
            if (null != inputDataStrSession && !inputDataStrSession.isEmpty()) {
                inputDataStr = inputDataStrSession + inputDataStr;
            }
            if (SUBMIT_STATUS_WAIT.equals(submitstatus)) {
                session.setAttribute(sessionParamName, (Object)inputDataStr);
                return;
            }
            if (null != inputDataStrSession) {
                session.removeAttribute(sessionParamName);
            }
            inputDataStr = URLDecoder.decode(inputDataStr, "UTF-8");
        }
        String ipAddress = this.getClientIPAddress(request);
        String nmUser = request.getParameter("nmUser");
        Datainterface inputData = null;
        Datainterface allData = null;
        SubFunc subunc = null;
        try {
            this.writeLog(sfid, isDebugNeeded, isImportanceLog, inputDataStr);
            inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
            neid = this.getNEID(inputData);
            TELogFactory.getNormalLogger().info("neid:" + neid + ", the sfid:" + sfid + ", start time:" + format.format(new Date()));
            if (neid == -1) {
                throw new Exception("Don't write neid!!");
            }
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (null == ne) {
                log.info("The ne is null, neid:" + neid);
                this.printErrorInfo(neid, sfid, response, 1090629639);
                return;
            }
            if (inputData.getFunctionParams() == null) {
                subunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
                if (null == subunc && null == (subunc = TECreateObjectFactory.getSubFunc((int)sfid))) {
                    log.info("Don't found subfunction(sfid = " + sfid + ") description in Functions description file!");
                    throw new Exception();
                }
                if (!this.checkUserRight(neid, nmUser, sfid)) {
                    this.printErrorInfo(neid, sfid, response, 1090584579);
                    return;
                }
                if (flag == 0) {
                    allData = (Datainterface)request.getSession().getAttribute(neid + "_" + sfid);
                }
                allData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess(neid, subunc, inputData, allData, nmUser, ipAddress, flag);
            } else {
                TEGenNEExplorerBean genbean = new TEGenNEExplorerBean();
                allData = genbean.performBussinessProcess(neid, inputData, null, nmUser, ipAddress);
            }
            PageParams pageParams = inputData.getPageParams();
            outputData = allData;
            if (pageParams != null) {
                log.debug("Need split page!");
                if (flag == 1) {
                    request.getSession().setAttribute(neid + "_" + sfid, (Object)allData);
                }
                outputData = TESplitPageBean.getSplitPageData((Datainterface)allData, (PageParams)inputData.getPageParams(), (SubFunc)subunc);
            } else {
                log.debug("Don't need split page!");
            }
            if (null == outputData) {
                throw new Exception("The Output Data is null !!!");
            }
            out = new CharArrayWriter();
            outputData.marshal(out);
            print.println(((CharArrayWriter)out).toCharArray());
            this.writeSecurityLog(sfid, out, isDebugNeeded, isImportanceLog);
            out.close();
        }
        catch (Exception e) {
            log.error("The sfid is " + sfid + ", program inner error:\n", (Throwable)e);
            outputData = new Datainterface();
            out = new StringWriter();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                outputData.marshal(out);
                print.println(out.toString());
                if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                    TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data is :" + out.toString());
                }
            }
            catch (Exception ex) {
                log.error("Parse fail:", (Throwable)ex);
                return;
            }
        }
        finally {
            TELogFactory.getNormalLogger().info("neid:" + neid + ", the sfid:" + sfid + ", end time:" + format.format(new Date()));
            if (null != out) {
                out.close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printErrorInfo(int neid, int sfid, HttpServletResponse response, int errorCode) throws IOException {
        StringWriter out = null;
        PrintWriter print = response.getWriter();
        try {
            out = new StringWriter();
            Datainterface outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorCode));
            outputData.marshal((Writer)out);
            print.println(((Object)out).toString());
            TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data is :" + ((Object)out).toString());
            ((Writer)out).close();
        }
        catch (Exception e) {
            log.error("The sfid is " + sfid + ", program inner error:\n", (Throwable)e);
        }
        finally {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            TELogFactory.getNormalLogger().info("neid:" + neid + ", the sfid:" + sfid + ", end time:" + format.format(new Date()));
            if (null != out) {
                ((Writer)out).close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    private boolean checkUserRight(int neID, String nmUserID, int sfid) {
        boolean isRight = true;
        if (TESysManagerBean.getInstance().isIntegratedStatus() && TESecurityVerify.isNeedServerCheckRight((int)sfid)) {
            isRight = false;
            if (nmUserID != null && !nmUserID.isEmpty()) {
                int userID = -1;
                try {
                    userID = Integer.parseInt(nmUserID);
                }
                catch (NumberFormatException e) {
                    TELogFactory.getNormalLogger().error("The nmUserID is error: " + nmUserID);
                }
                isRight = TESecurityVerify.checkUserRight((int)neID, (int)userID, (int)sfid);
            }
        }
        return isRight;
    }

    private void writeSecurityLog(int sfid, Writer out, boolean isDebugNeeded, boolean isImportanceLog) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus() && !isDebugNeeded) {
            TELogFactory.getInterfaceLogger().info("The sfid is " + sfid + "\nReturn page's XML Data:" + out.toString());
        } else if (isImportanceLog) {
            TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data: :\n" + out.toString());
        }
    }

    private void writeLog(int sfid, boolean isDebugNeeded, boolean isImportanceLog, String inputDataStr) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            if (!isDebugNeeded) {
                TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
            }
        } else if (isImportanceLog) {
            TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
        }
    }

    private int getFlag(HttpServletRequest request) {
        int flag;
        try {
            flag = Integer.parseInt(request.getParameter(FLAG_PARAM));
        }
        catch (Exception e) {
            flag = 1;
        }
        return flag;
    }

    private String getClientIPAddress(HttpServletRequest request) {
        String ipAddress = null;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            ipAddress = request.getHeader("X-Forwarded-For");
            if (null == ipAddress || ipAddress.isEmpty()) {
                ipAddress = request.getRemoteAddr();
            }
        } else {
            ipAddress = request.getRemoteAddr();
        }
        return ipAddress;
    }

    private int getNEID(Datainterface inputData) {
        if (null == inputData || null == inputData.getBussinessParams() || 0 == inputData.getBussinessParams().getRowParamsCount()) {
            return -1;
        }
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        int neid = -1;
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr[i].getName().equalsIgnoreCase(NEID_PARAM)) continue;
            try {
                neid = Integer.parseInt(paramArr[i].getValue());
            }
            catch (NumberFormatException e) {
                log.error("Get neid fail:\n", (Throwable)e);
                return -1;
            }
            return neid;
        }
        return -1;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

