/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEFuncTreeInterface;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TEConfigModelUtil;
import com.huawei.nglct.nelist.pnp.boardmgr.TEPNPBDCfgDataMgr;
import com.huawei.nglct.nelist.pnp.boardmgr.TEPNPBDSupportFunObj;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.teneexplorer.TEFuncTreeParams;
import com.huawei.nglct.util.device.TEVersionRelationBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TECharsetConverter;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class TEFuncTreeServlet
extends HttpServlet {
    private static final long serialVersionUID = 2835131710476714211L;
    private static final String BOARD_TYPE = "boardType";
    private static final String LEAF = "leaf";
    private static final String NON_LEAF = "nonleaf";
    private static final String LINK_ATTRIBUTE = "link";
    private static final String FUNC_ID_ATTRIBUTE = "funID";
    private static final String SUPPORTED_BY_TAG = "supported_by";
    private static final String FUNCTION_ITEM_TAG = "functionItem";
    private static final String BOARD_TYPE_ATTR = "bdType";
    private static final String NM_USER_ATTR = "nmUser";
    private static final String OBJ_IMPL_ATTR = "objsel_impl";
    private static final String IS_T2000_FLAG = "t2000Flag";
    private static final String NM_USER_NAME_ATTR = "nmUserName";
    private static final String[] LINK_CONF_FUNCIDS = new String[]{"49221", "49270"};
    private static final String T2000_CLIENT_LANGUAGE = "language";
    private static final String ONLY_SINGLESTATUS_USE = "0";
    private static final String ONLY_INTEGSTATUS_USE = "1";
    private static final String SUPPORT_PRE_CONFIG = "true";
    private DeploymentMode sysStatus;
    private String isT2000Flag = null;
    private String funcLanguage;
    private boolean isNewPNPBoard = false;
    private transient TEPNPBDSupportFunObj bdSupportFunObj = null;
    private String neVersion = null;

    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.sysStatus = TESysManagerBean.getInstance().getSysStauts();
        TELogFactory.getNormalLogger().info("begin to get TEFuncTreeServlet");
        TEFuncTreeParams funParams = new TEFuncTreeParams(request);
        String urlPrefix = request.getRequestURL().toString();
        urlPrefix = urlPrefix.substring(0, urlPrefix.lastIndexOf(47) + 1);
        TELogFactory.getNormalLogger().info("The page request URL is: " + urlPrefix);
        int neid = funParams.getNeid();
        String slotid = funParams.getSlotid();
        String linkslotid = funParams.getLinkslotid();
        boolean isPrefigNe = funParams.isPrefigNe();
        String snkneid = funParams.getSnkNeid();
        String snklinkslotid = funParams.getSnkLinkSlotid();
        String resid = funParams.getResid();
        String sessionid = funParams.getSessionId();
        TELogFactory.getNormalLogger().info("ResID is: " + resid);
        TELogFactory.getNormalLogger().info("LinkSlotID is: " + linkslotid);
        if (resid != null && !"".equals(resid)) {
            linkslotid = resid;
            funParams.setLinkslotid(resid);
        }
        String boardType = request.getParameter(BOARD_TYPE);
        this.isT2000Flag = request.getParameter(IS_T2000_FLAG);
        this.isNewPNPBoard = TEPNPBDCfgDataMgr.getInstance().isNewPNPBoard(boardType);
        if (this.isNewPNPBoard) {
            this.bdSupportFunObj = TEPNPBDCfgDataMgr.getInstance().getBDSupportFun(Integer.parseInt(boardType));
            if (this.bdSupportFunObj == null) {
                TELogFactory.getNormalLogger().info("Get PNP Board Function Tree Error : slotId=" + slotid + ",boardType=" + boardType);
                return;
            }
        }
        this.funcLanguage = this.getLanguageParam(request);
        String nmUser = this.getNMUserParam(request, NM_USER_ATTR);
        String nmUserName = this.getNMUserParam(request, NM_USER_NAME_ATTR);
        TELogFactory.getNormalLogger().info("The System Running Status is :" + this.sysStatus);
        TELogFactory.getNormalLogger().info("slotid = " + slotid + " boardType = " + boardType + " nmUserName = " + nmUserName);
        Document doc = null;
        NodeList leaf_list = null;
        NodeList tmp_list = null;
        NodeList noleaf_leaf_list = null;
        Element element = null;
        Element noleaf = null;
        PrintWriter print = null;
        String linkValue = "";
        int neType = 0;
        String codelength = "";
        try {
            String bundlename;
            String path;
            response.setContentType("text/xml;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            print = response.getWriter();
            if (null != this.isT2000Flag && !TESysManagerBean.getInstance().isIntegratedStatus()) {
                this.handleException(1090650129, print);
                return;
            }
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (ne == null) {
                TELogFactory.getNormalLogger().error("ne is null by id  " + neid);
                return;
            }
            neType = ne.getNEType();
            this.neVersion = ne.getHostVersion();
            codelength = TECharsetConverter.getChineseLength((String)ne.getNeGlobalSign());
            String domain = TEGetFilePath.getNEDomain((int)neType);
            String neName = ne.getNEName();
            String neUserName = ne.getCurUser();
            int realNeId = ne.getRealNEID();
            int shelfType = ne.getShelfType();
            String neIP = "";
            if (ne.getIsTL1OrQX() == 1) {
                urlPrefix = urlPrefix + "nemgr" + File.separator + domain + File.separator + "ne_" + neType + File.separator + TEVersionRelationBean.getInstance().gerParentVersion(neType, this.neVersion) + File.separator + TEPathManager.PAGE_PROFILE_PATH;
                TELogFactory.getNormalLogger().info("TL1 urlPrefix->  " + urlPrefix);
            } else {
                urlPrefix = urlPrefix + "nemgr" + File.separator + "device" + File.separator + TEGetFilePath.getNEDomain((int)neType) + File.separator + "ne_" + neType + File.separator + TEGetFilePath.getFirstVersion((int)neType, (String)this.neVersion) + File.separator + TEPathManager.PAGE_PROFILE_PATH;
                neIP = ne.getNeIp();
                if (neIP == null || neIP.equals("")) {
                    neIP = ne.getNEGWAddress();
                }
                TELogFactory.getNormalLogger().info("QX urlPrefix->  " + urlPrefix);
            }
            if (null == slotid || slotid.equals("")) {
                TELogFactory.getNormalLogger().info("Get NE function tree!");
                String NE_FUNC_TREE_FILE_NAME = "nefunctiontree_" + ne.getNEType() + "_" + this.funcLanguage + ".xml";
                path = TEResourceManager.getPath() + File.separator + "nemgr" + File.separator + "device" + File.separator + TEGetNEDomainVersion.getInstance().getDomain(neType) + File.separator + "ne_" + neType + File.separator + "conf" + File.separator + NE_FUNC_TREE_FILE_NAME;
                if (ne.getIsTL1OrQX() == 1) {
                    path = TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)neType, (String)this.neVersion, (String)("conf" + File.separator + NE_FUNC_TREE_FILE_NAME));
                    TELogFactory.getNormalLogger().info("get TL1 functree path");
                }
                TELogFactory.getNormalLogger().info("get ne functree, functreefilepath-> " + path);
                bundlename = TEGetFilePath.getNEBundleName((int)neType);
                TELogFactory.getNormalLogger().info("get bundle name by netype->" + bundlename);
                try {
                    doc = TEParseXMLFile.parseFile((String)bundlename, (String)path);
                }
                catch (Exception ex) {
                    TELogFactory.getNormalLogger().error("Parse file fail!", (Throwable)ex);
                }
                if (null == doc) {
                    TELogFactory.getNormalLogger().error("Parse file fail\u00a3\u00a1");
                    throw new Exception();
                }
                linkValue = "?nmUser=" + nmUser + "&nmUserName=" + nmUserName + "&neUserName=" + neUserName + "&neid=" + neid + "&neversion=" + this.neVersion + "&sysStatus=" + this.sysStatus + "&neType=" + neType + "&shelfType=" + shelfType + "&domain=" + domain + "&realneid=" + realNeId + "&codelength=" + codelength + "&PreConfigedNE=" + isPrefigNe + "&lang=" + TEFuncTreeServlet.getNMSLanguage(this.funcLanguage);
                if (neIP != null && !"".equals(neIP)) {
                    linkValue = linkValue + "&ipaddr=" + neIP;
                }
                if (linkslotid != null && !"".equals(linkslotid)) {
                    linkValue = linkValue + "&linkslotid=" + linkslotid;
                }
                if (snkneid != null && !"".equals(snkneid)) {
                    linkValue = linkValue + "&snkneid=" + snkneid;
                }
                if (snklinkslotid != null && !"".equals(snklinkslotid)) {
                    linkValue = linkValue + "&snklinkslotid=" + snklinkslotid;
                }
                if (sessionid != null && !"".equals(sessionid)) {
                    linkValue = linkValue + "&sessionid=" + sessionid;
                }
                String replacedNename = URLEncoder.encode(neName, "utf-8");
                replacedNename = replacedNename.replace("+", "%20");
                linkValue = linkValue + "&nename=" + replacedNename;
                TELogFactory.getNormalLogger().info("get ne functree, linkValue-> " + linkValue);
                TELogFactory.getNormalLogger().debug("Parse file success\u00a3\u00a1");
            } else {
                String BOARD_FUNC_TREE_FILE_NAME = "boardfunctiontree_" + this.funcLanguage + ".xml";
                TELogFactory.getNormalLogger().info("Get board function tree!");
                path = "";
                path = ne.getIsTL1OrQX() == 1 ? TEResourceManager.getPath() + File.separator + TEGetFilePath.getFilePath((int)neType, (String)this.neVersion, (String)(TEPathManager.CONFIG_PROFILE_PATH + BOARD_FUNC_TREE_FILE_NAME)) : TEResourceManager.getPath() + File.separator + TEGetFilePath.getFilePath((int)TEBoardUtil.getSubrackType((int)neid, (int)neType, (int)Integer.valueOf(slotid)), null, (String)(TEPathManager.CONFIG_PROFILE_PATH + BOARD_FUNC_TREE_FILE_NAME));
                TELogFactory.getNormalLogger().info("get board functree path-> " + path);
                bundlename = TEGetFilePath.getNEBundleName((int)neType);
                TELogFactory.getNormalLogger().info("get bundle name by netype->" + bundlename);
                try {
                    doc = TEParseXMLFile.parseFile((String)bundlename, (String)path);
                }
                catch (Exception ex) {
                    TELogFactory.getNormalLogger().error("TEFuncTreeServlet.doGet() fail!path=" + path);
                }
                if (null == doc) {
                    TELogFactory.getNormalLogger().error("Parse file fail\u00a3\u00a1");
                    throw new Exception();
                }
                String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, Integer.parseInt(boardType));
                linkValue = "?nmUser=" + nmUser + "&nmUserName=" + nmUserName + "&neUserName=" + neUserName + "&neid=" + neid + "&neversion=" + this.neVersion + "&slotid=" + slotid + "&boardType=" + boardType + "&boardname=" + boardname + "&neType=" + neType + "&domain=" + domain + "&codelength=" + codelength + "&PreConfigedNE=" + isPrefigNe;
                if (sessionid != null && !"".equals(sessionid)) {
                    linkValue = linkValue + "&sessionid=" + sessionid;
                }
                String subrackname = URLEncoder.encode(TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)Integer.valueOf(slotid)), "utf-8");
                subrackname = subrackname.replace("+", "%20");
                linkValue = linkValue + "&subrackname=" + subrackname;
                TELogFactory.getNormalLogger().debug("Parse file success!");
                TELogFactory.getNormalLogger().info("get board functree linkValue-> " + linkValue);
            }
            NodeList noleaf_list = doc.getElementsByTagName(NON_LEAF);
            for (int index = noleaf_list.getLength() - 1; index >= 0; --index) {
                int i;
                noleaf = (Element)noleaf_list.item(index);
                if (!this.checkElementSupport(neid, noleaf)) {
                    noleaf.getParentNode().removeChild(noleaf);
                    continue;
                }
                if (!this.checkElementImplSupport(neid, noleaf)) {
                    noleaf.getParentNode().removeChild(noleaf);
                    continue;
                }
                leaf_list = noleaf.getElementsByTagName(LEAF);
                for (i = leaf_list.getLength() - 1; i >= 0; --i) {
                    element = (Element)leaf_list.item(i);
                    if (element.getParentNode().equals(noleaf)) {
                        this.processLeafNode(funParams, element, urlPrefix, linkValue);
                        continue;
                    }
                    NodeList nodelist = element.getElementsByTagName(FUNCTION_ITEM_TAG);
                    if (null != nodelist && nodelist.getLength() != 0) continue;
                    element.getParentNode().removeChild(element);
                }
                tmp_list = noleaf.getElementsByTagName(NON_LEAF);
                for (i = tmp_list.getLength() - 1; i >= 0; --i) {
                    element = (Element)tmp_list.item(i);
                    noleaf_leaf_list = element.getElementsByTagName(LEAF);
                    if (null != noleaf_leaf_list && noleaf_leaf_list.getLength() != 0) continue;
                    element.getParentNode().removeChild(element);
                }
                leaf_list = noleaf.getElementsByTagName(LEAF);
                tmp_list = noleaf.getElementsByTagName(NON_LEAF);
                if (index == 0 || null != leaf_list && leaf_list.getLength() != 0 || null != tmp_list && tmp_list.getLength() != 0) continue;
                noleaf.getParentNode().removeChild(noleaf);
            }
            String out = this.serializeDom(doc);
            print.println(out);
            TELogFactory.getInterfaceLogger().info("The function tree is\u00a3\u00ba\n" + out);
        }
        catch (Exception e) {
            this.handleException(1090646019, print);
            TELogFactory.getNormalLogger().error("Get function tree fail\u00a3\u00ba\n", (Throwable)e);
            return;
        }
        finally {
            TELogFactory.getNormalLogger().info("end to get TEFuncTreeServlet");
            if (null != print) {
                print.close();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private boolean containThisStr(String[] hasSortfunIDs, String funID) {
        return Arrays.binarySearch(hasSortfunIDs, funID) > -1;
    }

    public void processLeafNode(TEFuncTreeParams funParams, Element element, String urlPrefix, String linkValue) {
        NodeList nodelist = element.getElementsByTagName(FUNCTION_ITEM_TAG);
        Element tmpElement = null;
        if (null == nodelist || nodelist.getLength() == 0) {
            element.getParentNode().removeChild(element);
        } else {
            boolean linkSlotFlag;
            boolean bl = linkSlotFlag = funParams.getLinkslotid() != null && !"".equals(funParams.getLinkslotid());
            if (funParams.isHopMgr() && linkSlotFlag && !element.hasAttribute("hopMgr")) {
                element.getParentNode().removeChild(element);
                return;
            }
            if (linkSlotFlag && !element.hasAttribute("hopFunc") && !element.hasAttribute("hopMgr") && !TESysManagerBean.getInstance().isIntegratedStatus()) {
                element.getParentNode().removeChild(element);
                return;
            }
            if (element.hasAttribute("hopFunc") && !this.containThisStr(LINK_CONF_FUNCIDS, element.getAttribute("defaultFunID")) && (!linkSlotFlag || !funParams.isHopMgr() && TESysManagerBean.getInstance().isIntegratedStatus())) {
                element.getParentNode().removeChild(element);
                return;
            }
            if (!this.checkElementSupport(funParams.getNeid(), element)) {
                element.getParentNode().removeChild(element);
                return;
            }
            if (!this.checkElementPrefigSupport(funParams.getNeid(), funParams.isPrefigNe(), element)) {
                element.getParentNode().removeChild(element);
                return;
            }
            if (!this.checkElementImplSupport(funParams.getNeid(), element)) {
                element.getParentNode().removeChild(element);
                return;
            }
            for (int i = nodelist.getLength() - 1; i >= 0; --i) {
                tmpElement = (Element)nodelist.item(i);
                tmpElement.setAttribute("name", TEStringUtils.encodeUnicode((String)tmpElement.getAttribute("name")));
                String funId = tmpElement.getAttribute(FUNC_ID_ATTRIBUTE);
                if (this.isNewPNPBoard) {
                    if (!this.bdSupportFunObj.isSupportFunId(funId)) {
                        tmpElement.getParentNode().removeChild(tmpElement);
                        continue;
                    }
                    String flag = tmpElement.getAttribute("flag");
                    String pnpflag = this.bdSupportFunObj.getSpecialFlag(funId);
                    if (flag != null && !flag.equals("") && pnpflag == null || pnpflag != null && !pnpflag.equals(flag)) {
                        tmpElement.getParentNode().removeChild(tmpElement);
                        continue;
                    }
                }
                if (funParams.getFunids() != null && funParams.getFunids().indexOf("," + funId + ",") < 0) {
                    tmpElement.getParentNode().removeChild(tmpElement);
                    continue;
                }
                this.processFunctionItemNode(funParams, tmpElement, urlPrefix, linkValue);
            }
            nodelist = element.getElementsByTagName(FUNCTION_ITEM_TAG);
            if (null == nodelist || nodelist.getLength() == 0) {
                element.getParentNode().removeChild(element);
            }
        }
    }

    public void processFunctionItemNode(TEFuncTreeParams funParams, Element element, String urlPrefix, String linkValue) {
        if (!this.checkElementSupport(funParams.getNeid(), element)) {
            element.getParentNode().removeChild(element);
            return;
        }
        NodeList nodelist = element.getElementsByTagName(SUPPORTED_BY_TAG);
        Element childElement = null;
        boolean isSupport = false;
        if (null == nodelist || nodelist.getLength() == 0) {
            isSupport = true;
        }
        if (null != nodelist) {
            for (int i = nodelist.getLength() - 1; i >= 0; --i) {
                childElement = (Element)nodelist.item(i);
                if (isSupport) {
                    element.removeChild(childElement);
                    continue;
                }
                if (childElement.hasAttribute(BOARD_TYPE_ATTR)) {
                    String bdType = childElement.getAttribute(BOARD_TYPE_ATTR).trim();
                    if (!"".equals(bdType)) {
                        bdType = bdType.substring(1, bdType.length() - 1);
                        Vector boardlist = null;
                        if (null == funParams.getBoardType() || funParams.getBoardType().equals("")) {
                            boardlist = TENEListMgr.getInstance().getNE(funParams.getNeid()).getBoardList();
                        }
                        isSupport = this.isSupportFunc(funParams.getNeid(), bdType, boardlist, funParams.getBoardType(), childElement.getAttribute("neversion"));
                    }
                } else {
                    isSupport = true;
                }
                if (isSupport) {
                    isSupport = this.checkElementImplSupport(funParams.getNeid(), childElement);
                }
                if (!isSupport && i == 0) {
                    element.getParentNode().removeChild(element);
                    break;
                }
                element.removeChild(childElement);
            }
        }
        if (isSupport) {
            String link = element.getAttribute(LINK_ATTRIBUTE);
            if (null != this.isT2000Flag) {
                link = urlPrefix + link;
            }
            link = link + linkValue + "&funnodeid=" + element.getAttribute(FUNC_ID_ATTRIBUTE);
            link = link.replace('\\', '/');
            element.setAttribute(LINK_ATTRIBUTE, link);
        }
    }

    private boolean isSupportFunc(int neid, String supportbdType, Vector boardList, String boardtypeStr, String suppVersions) {
        int boardType = 0;
        try {
            boardType = Integer.parseInt(boardtypeStr);
        }
        catch (NumberFormatException e) {
            boardType = 0;
        }
        if (null == boardList) {
            boardList = new Vector();
        }
        if (this.isNewPNPBoard) {
            return this.checkNeVersion(neid, suppVersions);
        }
        String[] bdTypeArr = supportbdType.split(",");
        TEBoard board = null;
        for (int i = bdTypeArr.length - 1; i >= 0; --i) {
            if (bdTypeArr[i].indexOf(45) > 0) {
                int minBoardType = Integer.parseInt(bdTypeArr[i].split("-")[0].trim());
                int maxBoardType = Integer.parseInt(bdTypeArr[i].split("-")[1].trim());
                if (boardType >= minBoardType && boardType <= maxBoardType) {
                    return this.checkNeVersion(neid, suppVersions);
                }
                for (int len = boardList.size() - 1; len >= 0; --len) {
                    board = (TEBoard)boardList.get(len);
                    if (board.getBoardType() < minBoardType || board.getBoardType() > maxBoardType) continue;
                    return this.checkNeVersion(neid, suppVersions);
                }
                continue;
            }
            if (bdTypeArr[i].trim().isEmpty()) continue;
            if (boardType == Integer.parseInt(bdTypeArr[i].trim())) {
                return this.checkNeVersion(neid, suppVersions);
            }
            for (int len = boardList.size() - 1; len >= 0; --len) {
                board = (TEBoard)boardList.get(len);
                if (Integer.parseInt(bdTypeArr[i].trim()) != board.getBoardType()) continue;
                return this.checkNeVersion(neid, suppVersions);
            }
        }
        return false;
    }

    private String serializeDom(Document doc) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer ser = domImplLS.createLSSerializer();
            LSOutput out = domImplLS.createLSOutput();
            StringWriter stringOut = new StringWriter();
            out.setCharacterStream(stringOut);
            ser.write(doc, out);
            return stringOut.toString();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("serialize document fail\u00a3\u00ba", (Throwable)e);
            return null;
        }
    }

    public void handleException(int code, PrintWriter print) {
        ErrorMessage error = TEErrorResourceUtil.getErrorMessage((int)code);
        StringWriter stringout = null;
        try {
            stringout = new StringWriter();
            error.marshal((Writer)stringout);
        }
        catch (Exception marshalException) {
            TELogFactory.getNormalLogger().error("Parse file fail\u00a3\u00ba", (Throwable)marshalException);
        }
        TELogFactory.getInterfaceLogger().info("The function tree is\u00a3\u00ba\n" + stringout.toString());
        print.println(stringout.toString());
    }

    private boolean checkNeVersion(int neid, String suppVersions) {
        if (suppVersions == null || suppVersions.equals("")) {
            return true;
        }
        String[] spaceVersions = new String[]{};
        spaceVersions = suppVersions.startsWith("[") && suppVersions.endsWith("]") ? suppVersions.substring(1, suppVersions.length() - 1).split(",") : suppVersions.substring(0, suppVersions.length()).split(",");
        int m = spaceVersions.length;
        for (int i = 0; i < m; ++i) {
            String[] versions = spaceVersions[i].trim().split("-");
            if (this.neVersion.compareToIgnoreCase(versions[0]) < 0 || this.neVersion.compareToIgnoreCase(versions[1]) > 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkRunStatus(String runstatus) {
        boolean isSupport = true;
        if (!TESysManagerBean.getInstance().isIntegratedStatus() && runstatus.equals(ONLY_INTEGSTATUS_USE) || TESysManagerBean.getInstance().isIntegratedStatus() && runstatus.equals(ONLY_SINGLESTATUS_USE)) {
            isSupport = false;
        }
        return isSupport;
    }

    private boolean checkShelfType(int neid, String shelfType) {
        List shelfTypeList;
        if (!TEBoardUtil.isSupportShelfDevice((int)neid) && (shelfTypeList = TEConvertUtil.parseIntList((String)shelfType)) != null && !shelfTypeList.isEmpty()) {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            return shelfTypeList.contains(ne.getShelfType());
        }
        return true;
    }

    private boolean checkElementSupport(int neid, Element element) {
        if (element.hasAttribute("neversion") && !this.checkNeVersion(neid, element.getAttribute("neversion"))) {
            return false;
        }
        if (this.checkShelfType(neid, element)) {
            return false;
        }
        if (element.hasAttribute("runStatus") && !this.checkRunStatus(element.getAttribute("runStatus"))) {
            return false;
        }
        if (this.checkOptFeatureId(neid, element)) {
            return false;
        }
        if (this.checkDependExistBd(neid, element)) {
            return false;
        }
        return !this.checkDependNoExistBd(neid, element);
    }

    private boolean checkElementPrefigSupport(int neid, boolean isPrefigNe, Element element) {
        return !isPrefigNe || element.hasAttribute("isPreConfig") && element.getAttribute("isPreConfig").equals(SUPPORT_PRE_CONFIG);
    }

    private boolean checkShelfType(int neid, Element element) {
        return element.hasAttribute("shelftype") && !this.checkShelfType(neid, element.getAttribute("shelftype"));
    }

    private boolean checkOptFeatureId(int neid, Element element) {
        return element.hasAttribute("neOptFeatureId") && !TEConfigModelUtil.isSupportFeature((int)neid, (String)element.getAttribute("neOptFeatureId"));
    }

    private boolean checkDependExistBd(int neid, Element element) {
        return element.hasAttribute("dependExistBd") && !TEConfigModelUtil.isExistBoardType((int)neid, (String)element.getAttribute("dependExistBd"));
    }

    private boolean checkDependNoExistBd(int neid, Element element) {
        return element.hasAttribute("dependNoExistBd") && TEConfigModelUtil.isExistBoardType((int)neid, (String)element.getAttribute("dependNoExistBd"));
    }

    private boolean checkElementImplSupport(int neid, Element element) {
        String adpterClass;
        if (element.hasAttribute(OBJ_IMPL_ATTR) && !"".equals(adpterClass = element.getAttribute(OBJ_IMPL_ATTR).trim())) {
            try {
                TEFuncTreeInterface funcTreeinterface = (TEFuncTreeInterface)Class.forName(adpterClass).newInstance();
                return funcTreeinterface.isSupportFunc(neid, 0, null, element);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEFuncTreeServlet fail!", (Throwable)e);
            }
        }
        return true;
    }

    private String getLanguageParam(HttpServletRequest request) {
        String language = TESysManagerBean.getInstance().getlanguage();
        String param = request.getParameter(T2000_CLIENT_LANGUAGE);
        if (param != null && (param.equalsIgnoreCase("zh") || param.equalsIgnoreCase("en"))) {
            language = param.toLowerCase(Locale.ENGLISH);
            TELogFactory.getNormalLogger().info("Current client language = " + this.funcLanguage);
        }
        return language;
    }

    public static String getNMSLanguage(String language) {
        return language.equalsIgnoreCase("zh") ? "zh_CN" : "en_US";
    }

    private String getNMUserParam(HttpServletRequest request, String paramName) {
        String nmUser = request.getParameter(paramName);
        if (null == nmUser) {
            nmUser = TESysManagerBean.getInstance().getSysUser();
        }
        return nmUser;
    }

    static {
        Arrays.sort(LINK_CONF_FUNCIDS);
    }
}

