/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TESplitPageBean;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.comservlets.TETL1NEExplorerServlet;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class TEASNExplorerServlet
extends TETL1NEExplorerServlet {
    private static final String SFID_PARAM = "sfid";
    private static final String FLAG_PARAM = "flag";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static int GET_DATA_FROM_NE = 1;
    private static int GET_DATA_FROM_MEMORY = 0;
    private static final String NE_NOT_EXIST = "1090629639";
    private static Logger log = TELogFactory.getNormalLogger();

    @Override
    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int neid = -1;
        int sfid = -1;
        int flag = -1;
        Datainterface outputData = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        response.setContentType("text/xml;charset=UTF-8");
        Writer out = null;
        PrintWriter print = response.getWriter();
        sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
        TELogFactory.getNormalLogger().info("The function(TEASNExplorerServlet- sfid:" + sfid + ") start time is " + format.format(new Date()));
        try {
            flag = Integer.parseInt(request.getParameter(FLAG_PARAM));
        }
        catch (Exception e) {
            flag = GET_DATA_FROM_NE;
        }
        String inputDataStr_asn = request.getParameter(INPUTDATA_PARAM);
        String ipAddress_asn = this.getClientIPAddress(request);
        String nmUser_asn = request.getParameter("nmUser");
        Datainterface inputData_asn = null;
        Datainterface allData_asn = null;
        SubFunc subFunc_asn = null;
        try {
            if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                TELogFactory.getInterfaceLogger().info("The sfid is \u00a3\u00ba" + sfid + "\nThe Page request XML is :\n" + inputDataStr_asn);
            }
            if ((neid = this.getNEID(inputData_asn = TECreateObjectFactory.parseInputData((String)inputDataStr_asn))) == -1) {
                throw new Exception("Don't write neid!!");
            }
            subFunc_asn = TECreateObjectFactory.getSubFunc((int)sfid, (String)"e2e");
            if (null == subFunc_asn && null == (subFunc_asn = TECreateObjectFactory.getSubFunc((int)sfid))) {
                log.info("Don't found subfunction(sfid = " + sfid + ") description in Functions description file\u00a3\u00a1");
                throw new Exception();
            }
            if (flag == GET_DATA_FROM_MEMORY) {
                allData_asn = (Datainterface)request.getSession().getAttribute(neid + "_" + sfid);
            }
            allData_asn = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess(neid, subFunc_asn, inputData_asn, allData_asn, nmUser_asn, ipAddress_asn, flag);
            PageParams pageParams = inputData_asn.getPageParams();
            if (pageParams != null && !pageParams.getParam(0).getName().equals("custom")) {
                log.debug("Need split page\u00a3\u00a1");
                if (flag == GET_DATA_FROM_NE) {
                    request.getSession().setAttribute(neid + "_" + sfid, (Object)allData_asn);
                }
                outputData = TESplitPageBean.getSplitPageData((Datainterface)allData_asn, (PageParams)inputData_asn.getPageParams(), (SubFunc)subFunc_asn);
            } else {
                log.debug("Don't need split page\u00a3\u00a1");
                outputData = allData_asn;
            }
            if (null == outputData) {
                throw new Exception("The Output Data is null !!!");
            }
            out = new CharArrayWriter();
            outputData.marshal(out);
            print.println(((CharArrayWriter)out).toCharArray());
            if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                TELogFactory.getInterfaceLogger().info("The sfid is " + sfid + "\nReturn page's XML Data\u00a3\u00ba" + out.toString());
            }
            out.close();
        }
        catch (Exception e) {
            log.error("The sfid is " + sfid + ", program inner error\u00a3\u00ba\n", (Throwable)e);
            outputData = new Datainterface();
            out = new StringWriter();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                outputData.marshal(out);
                print.println(out.toString());
                if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                    TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data is \u00a3\u00ba" + out.toString());
                }
            }
            catch (Exception ex) {
                log.error("Parse fail\u00a3\u00ba", (Throwable)ex);
                return;
            }
        }
        finally {
            TELogFactory.getNormalLogger().info(" The function(TEASNExplorerServlet- sfid: " + sfid + ") end time is " + format.format(new Date()));
            if (null != out) {
                out.close();
            }
            if (null != print) {
                print.close();
            }
        }
    }
}

