/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.jfreechartservlets;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class TEAMGraphicServlet
extends HttpServlet {
    private static final long serialVersionUID = 6115226467645379156L;
    private static final String PORTID = "1";
    private static final String preFilePath = "../../../../";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private static final String SLOTID_PARAM = "slotid";
    private static final String FILENAME = "AMGraphic";
    private static final String QUERY_CMD = "NSCMD_CFG_GET_ACM_HISTORY_WBID";
    private static final String initImgFlag = "1";
    private String FILEPATH = "";
    protected Datainterface outputData = new Datainterface();
    private static final String BASE_PATH = "rtn" + File.separator + "res";
    private static final String STRING_SOURCE = BASE_PATH + File.separator + "graphanalyse" + File.separator + "odugraphres_";
    private int neid = -1;
    private int slotid = -1;
    private boolean displayNullData = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)(STRING_SOURCE + TESysManagerBean.getInstance().getlanguage() + ".ini"));
        String inputDataStr = URLDecoder.decode(request.getParameter(INPUTDATA_PARAM), "UTF-8");
        Datainterface inputData_report = null;
        Writer out = null;
        PrintWriter print = null;
        try {
            inputData_report = TECreateObjectFactory.parseInputData((String)inputDataStr);
            this.neid = this.getNEID(inputData_report);
            this.slotid = this.getSLOTID(inputData_report);
            int imgH = Integer.parseInt(inputData_report.getBussinessParams().getRowParams(0).getParam("imgH").getValue());
            int imgW = Integer.parseInt(inputData_report.getBussinessParams().getRowParams(0).getParam("imgW").getValue());
            String imgXres = resourceUtil.getString("imgX");
            String imgYres = resourceUtil.getString("imgY");
            String flagres = inputData_report.getBussinessParams().getRowParams(0).getParam("flagres").getValue().trim();
            String cfgFileRootPath = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, (String)"");
            String sessionId = request.getSession().getId();
            StringBuffer tmpFileName = new StringBuffer();
            tmpFileName.append(FILENAME).append("_").append(sessionId).append("_").append(this.neid).append("_").append(this.slotid).append(".jpg");
            StringBuffer path = new StringBuffer();
            path.append(cfgFileRootPath).append("report").append(File.separator).append(tmpFileName);
            this.FILEPATH = path.toString();
            StringBuffer tmpFileNamePath = new StringBuffer();
            tmpFileNamePath.append(preFilePath).append("report").append(File.separator).append(tmpFileName);
            String tmpLegend = resourceUtil.getString("legend");
            if (flagres.equals("1")) {
                path = new StringBuffer();
                path.append(cfgFileRootPath).append("report").append(File.separator).append(FILENAME).append(".jpg");
                this.FILEPATH = path.toString();
                this.displayNullData = false;
                this.createChart("", imgXres, imgYres, this.createNullData(tmpLegend), true, true, false, request, response, imgH, imgW);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                RowParams row = new RowParams();
                BussinessParams bs = new BussinessParams();
                bs.addRowParams(row);
                this.outputData.setBussinessParams(bs);
            } else {
                String sdate = inputData_report.getBussinessParams().getRowParams(0).getParam("sdate").getValue().trim();
                String edate = inputData_report.getBussinessParams().getRowParams(0).getParam("edate").getValue().trim();
                Calendar startD_rtn = TEDateUtils.strToCalendar((String)sdate);
                Calendar endD_rtn = TEDateUtils.strToCalendar((String)edate);
                this.createChart("111", imgXres, imgYres, this.createXYData(startD_rtn, endD_rtn, tmpLegend), true, true, false, request, response, imgH, imgW);
            }
            BussinessParams bs = this.outputData.getBussinessParams();
            if (this.outputData.getErrorMessage().getErrorcode().equals("0") && null != bs && null != this.outputData.getBussinessParams().getRowParams(0)) {
                String reFileName = tmpFileName.toString();
                if (flagres.equals("1")) {
                    reFileName = "AMGraphic.jpg";
                    tmpFileNamePath = new StringBuffer();
                    tmpFileNamePath.append(preFilePath).append("report").append(File.separator).append(reFileName);
                }
                Param tmppar = new Param("filepath", tmpFileNamePath.toString());
                this.outputData.getBussinessParams().getRowParams(0).addParam(tmppar);
                tmppar = new Param("filename", reFileName);
                this.outputData.getBussinessParams().getRowParams(0).addParam(tmppar);
            }
            response.setContentType("text/xml;charset=UTF-8");
            print = response.getWriter();
            out = new CharArrayWriter();
            this.outputData.marshal(out);
            print.println(((CharArrayWriter)out).toCharArray());
            out.close();
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("TEAMGraphicServlet fail!", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("TEAMGraphicServlet fail!", (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    public void createChart(String title, String timeAxisLabel, String valueAxisLabel, DefaultCategoryDataset dataset, boolean legend, boolean tooltips, boolean urls, HttpServletRequest request, HttpServletResponse response, int imgH, int imgW) throws IOException {
        JFreeChart chart = ChartFactory.createLineChart((String)title, (String)timeAxisLabel, (String)valueAxisLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)urls);
        this.SetChartInfo(chart);
        this.SaveChart(chart, request, response, imgH, imgW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveChart(JFreeChart chart, HttpServletRequest request, HttpServletResponse response, int imgH, int imgW) throws IOException {
        FileOutputStream fos_jpg = null;
        try {
            fos_jpg = new FileOutputStream(this.FILEPATH);
            ChartUtilities.writeChartAsJPEG((OutputStream)fos_jpg, (JFreeChart)chart, (int)imgW, (int)imgH);
            fos_jpg.flush();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEAMGraphicServlet SaveChart fail!", (Throwable)e);
        }
        finally {
            if (fos_jpg != null) {
                fos_jpg.close();
            }
        }
    }

    private void SetChartInfo(JFreeChart chart) {
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(true);
        TextTitle title1 = new TextTitle("", new Font("\u00cb\u00ce\u00cc\u00e5", 1, 20));
        chart.setTitle(title1);
        chart.getLegend().setItemFont(new Font("\u00ba\u00da\u00cc\u00e5", 0, 15));
        CategoryPlot categoryplot = (CategoryPlot)chart.getPlot();
        categoryplot.setBackgroundPaint((Paint)Color.lightGray);
        categoryplot.setRangeGridlinePaint((Paint)Color.white);
        NumberAxis numberaxis = (NumberAxis)categoryplot.getRangeAxis();
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberaxis.setAutoRangeIncludesZero(true);
        numberaxis.setAutoTickUnitSelection(false);
        numberaxis.setLabelFont(new Font("sans-serif", 0, 14));
        CategoryAxis domainAxis = categoryplot.getDomainAxis();
        domainAxis.setTickLabelFont(new Font("\u00cb\u00ce\u00cc\u00e5", 0, 11));
        domainAxis.setLabelFont(new Font("\u00cb\u00ce\u00cc\u00e5", 0, 14));
        domainAxis.setTickMarksVisible(this.displayNullData);
        LineAndShapeRenderer lineandshaperenderer = (LineAndShapeRenderer)categoryplot.getRenderer();
        lineandshaperenderer.setBaseShapesVisible(this.displayNullData);
        lineandshaperenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        lineandshaperenderer.setBaseItemLabelsVisible(this.displayNullData);
    }

    private DefaultCategoryDataset createXYData(Calendar start, Calendar end, String tmpLegend) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)QUERY_CMD);
        Input input = operation.getInput();
        input.getPart(SLOTID_PARAM).setValue(this.slotid + "");
        input.getPart("portid").setValue("1");
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add(operation);
        int retCode = 0;
        int timeourt = TESysManagerBean.getInstance().getExplorerBeanTimeout();
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neid, operations, timeourt, null);
        if (null != result) {
            retCode = result.retCode;
        }
        if (retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)retCode));
        } else {
            Operation opr = (Operation)operations.get(0);
            int errCode = Integer.parseInt(opr.getOutput(0).getFault(0).getCode());
            if (errCode != 0 && !this.getFilterErrorCodeList().contains(errCode)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                this.handleErrData(opr, errCode);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                if (this.getFilterErrorCodeList().contains(errCode)) {
                    this.displayNullData = false;
                    dataset = this.createNullData(tmpLegend);
                    RowParams row = new RowParams();
                    BussinessParams bs = new BussinessParams();
                    bs.addRowParams(row);
                    this.outputData.setBussinessParams(bs);
                } else {
                    Output[] data = opr.getOutput();
                    Output tmpout2 = null;
                    StringBuffer sb = null;
                    Calendar tmpCal = null;
                    for (Output tmpout2 : data) {
                        int evtparm = Integer.parseInt(tmpout2.getPart("evtparm").getValue());
                        sb = new StringBuffer();
                        sb.append(tmpout2.getPart("acmyear").getValue()).append('-').append(tmpout2.getPart("acmmonth").getValue()).append('-').append(tmpout2.getPart("acmday").getValue()).append(' ').append(tmpout2.getPart("acmhour").getValue()).append(':').append(tmpout2.getPart("acmmin").getValue()).append(':').append(tmpout2.getPart("acmsec").getValue());
                        tmpCal = TEDateUtils.strToCalendar((String)sb.toString());
                        if (start.compareTo(tmpCal) > 0 || end.compareTo(tmpCal) < 0) continue;
                        dataset.addValue((double)evtparm, (Comparable)((Object)tmpLegend), (Comparable)((Object)sb.toString()));
                    }
                }
            }
        }
        return dataset;
    }

    private DefaultCategoryDataset createNullData(String res) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(5.0, (Comparable)((Object)res), (Comparable)((Object)""));
        dataset.addValue(6.0, (Comparable)((Object)res), (Comparable)((Object)""));
        dataset.addValue(4.0, (Comparable)((Object)res), (Comparable)((Object)""));
        dataset.addValue(2.0, (Comparable)((Object)res), (Comparable)((Object)""));
        dataset.addValue(5.0, (Comparable)((Object)res), (Comparable)((Object)""));
        dataset.addValue(5.0, (Comparable)((Object)res), (Comparable)((Object)""));
        dataset.addValue(6.0, (Comparable)((Object)res), (Comparable)((Object)""));
        return dataset;
    }

    private void handleErrData(Operation opr, int errCode) {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String neName = neObj.getNEName();
        String boardName = TEConfigurationDataMgr.getInstance().getBoardName(this.neid, this.slotid);
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errCode + "");
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errCode));
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param(NEID_PARAM, this.neid + "");
        rowError.addParam(errorparam);
        errorparam = new Param("nename", neName);
        rowError.addParam(errorparam);
        errorparam = new Param(SLOTID_PARAM, this.slotid + "");
        rowError.addParam(errorparam);
        errorparam = new Param("boardname", boardName);
        rowError.addParam(errorparam);
        errorparam = new Param("portid", "1");
        rowError.addParam(errorparam);
        RowParams row = new RowParams();
        row.addRowErrors(rowError);
        BussinessParams bs = new BussinessParams();
        bs.addRowParams(row);
        this.outputData.setBussinessParams(bs);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private int getNEID(Datainterface inputData) {
        RowParams paramArr_report = inputData.getBussinessParams().getRowParams(0);
        int neid_report = -1;
        Param nepar = paramArr_report.getParam(NEID_PARAM);
        if (null != nepar && null != nepar.getValue() && !nepar.getValue().isEmpty()) {
            neid_report = Integer.parseInt(nepar.getValue());
        }
        return neid_report;
    }

    private int getSLOTID(Datainterface inputData) {
        RowParams paramArr_report = inputData.getBussinessParams().getRowParams(0);
        int slotid_report = -1;
        Param slotidpar = paramArr_report.getParam(SLOTID_PARAM);
        if (null != slotidpar && null != slotidpar.getValue() && !slotidpar.getValue().isEmpty()) {
            slotid_report = Integer.parseInt(slotidpar.getValue());
        }
        return slotid_report;
    }

    private ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errCodeList = new ArrayList<Integer>();
        errCodeList.add(38662);
        return errCodeList;
    }
}

