var winobj = getNeProperty(top);

var CMD_OBJ = {};
CMD_OBJ.QUERY_ALL = TECMDCODE_IP_STATICIGMP_GET;
CMD_OBJ.QUERY_DETAIL = TECMDCODE_IP_STATICIGMP_GET_SUPPORT;
CMD_OBJ.MODIFY = TECMDCODE_IP_STATICIGMP_MODIFY;

var upTable = null;
var upTableConf = null;
var downTable = null;
var downTableConf = null;
var btnRightObj = new Object();
var PARTSUCC = 1;
var FAIL = 2;
var EMPTY_RESULT1 = "38662";
var EMPTY_RESULT = "42597";
var EMPTYRESULT = "42617";
var ELAN_INEXISTENCE = "42615";
var SVL_VLAN = "65534";
var selectedRowID;

loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/snooping/snooping_" + SYSTEMCONF.getLanguage() + ".xml");

loadXMLdoc("../../conf/snooping/snoopingdatagramcountuptable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
loadXMLdoc("../../conf/snooping/snoopingdatagramcountdowntable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

function initPage()
{
    initUpTable();
    initDownTable();
    initButton();
    doQuery();
    $("totalrow").innerHTML = RESOURCE["totalrow"];
    $("selrow").innerHTML = RESOURCE["selectedrow"];
}

function initUpTable()
{
    upTable = new SortTable();
    upTable.head.setAttribute("id", "htmlTable_STHead_datacount");
    upTable.body.setAttribute("id", "htmlTable_STBody_datacount");
    upTable.setImage("../../../../../images/");
    upTable.setOnRowSelectHandler(upTableRowSelected);
    upTableConf = window.tableconf[0];
    
    createTableHead(upTable, upTableConf);
    
    document.getElementById("upTableComponent").appendChild(upTable.getTable());
    
    upTable.setBodyHeight(getComponetHeight($("upTableComponent"), 70) * 0.80 + "px");
    window.onresize = function()
    {
        upTable.setBodyHeight(getComponetHeight($("upTableComponent"), 70) + "px");
    };
    $("totalrownum").innerHTML = upTable.getDataRowLength();
    $("selrownum").innerHTML = 0;
}

function upTableRowSelected(rows)
{
    if (!rows || !rows.length) 
    {
        return;
    }
    
    $("totalrownum").innerHTML = upTable.getDataRowLength();
    $("selrownum").innerHTML = rows.length;
    
    $('applyBtn').disabled = true;
    $('queryBtn').disabled = true;
    selectedRowID = rows[0];
    var xmlData = createQueryDetailXmlInfo(selectedRowID);
    var url = "../../../../../neExlorerServlet?sfid=" + CMD_OBJ.QUERY_DETAIL + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", true, queryDetailHandler, null, "inputdata=" + xmlData);
}

function createQueryDetailXmlInfo(row)
{
    var indexid = upTable.getCellStoreValue(row, "indexID", "indexID");
    var vlanID = upTable.getCellStoreValue(row, "vlanID", "vlanID");
    if ("-" == vlanID) 
    {
        vlanID = SVL_VLAN;
    }
    
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winobj["neid"]);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "indexID");
    param.setAttribute("value", indexid);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vlanID");
    param.setAttribute("value", vlanID);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portType_UNI");
    param.setAttribute("value", "1");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portType_NNI");
    param.setAttribute("value", "2");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portID");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function queryDetailHandler(doc)
{
    $('queryBtn').disabled = false;
    downTable.clearTableData();
    var data = EncapsulateData(doc);
    var errCode = data.getSErrorCode();
    if (0 != errCode) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (EMPTYRESULT == data.errObj.rowErrors[i].error.code ||
            EMPTY_RESULT == data.errObj.rowErrors[i].error.code ||
            EMPTY_RESULT1 == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (PARTSUCC == errCode || FAIL == errCode)) 
        {
            data.errObj.s_error.code = 0;
        }
        else 
        {
            for (var i = 0; i < len; i++) 
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["querybutton"] + RESOURCE["interfaceInfo"];
            }
            
            var errArr = [];
            errArr[0] = "operateObj";
            openErrPage("../../../../../page/", data.getError(), errArr);
        }
    }
    if (data.getSErrorCode() == 0 || data.getSErrorCode == 1) 
    {
        var servicID = upTable.getCellCurrentValue(selectedRowID, "serviceID", "serviceID");
        for (var len = data.getDataRowLength() - 1; len >= 0; len--) 
        {
            var row = data.rows[len];
            
            if (SVL_VLAN == row["vlanID"].value) 
            {
                row["vlanID"].value = "-";
            }
            
            var ptag = new ParamTag();
            ptag.value = servicID;
            row["serviceID"] = ptag;
        }
        
        createTableBody(downTable, window.tableconf[1], data, RESOURCE);
        
        if (!downTable.element.colsArray.selectedId) 
        {
            downTable.element.colsArray.selectedId = "indexID";
            downTable.element.colsArray.imgflag = 1;
        }
        var td = downTable.element.headRow.element.cols[downTable.element.colsArray.selectedId].element;
        downTable.sortRows(td, downTable.element.colsArray.imgflag);
    }
}

function initDownTable()
{
    downTable = new SortTable();
    downTable.head.setAttribute("id", "htmlTable_STHead_datacount1");
    downTable.body.setAttribute("id", "htmlTable_STBody_datacount1");
    downTable.setImage("../../../../../images/");
    downTableConf = window.tableconf[1];
    
    downTable.setOnCellEditHandler(downTableCellEditHandler);
    createTableHead(downTable, downTableConf);
    
    document.getElementById("downTableComponent").appendChild(downTable.getTable());
    document.getElementById("downTableComponent").oncontextmenu = popupMenuHandler;
    downTable.setBodyHeight("130px");
}

function downTableCellEditHandler()
{
    $("applyBtn").disabled = !btnRightObj.applyBtn.right;
}

function initButton()
{
    $("queryBtn").value = RESOURCE["querybutton"];
    $("applyBtn").value = RESOURCE["applybutton"];
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    btnRightObj.queryBtn = new BtnRightObj("queryBtn", CMD_OBJ.QUERY_ALL);
    btnRightObj.applyBtn = new BtnRightObj("applyBtn", CMD_OBJ.MODIFY);
    
    checkRights();
}

function checkRights()
{
    var xmlData = createCheckRightXmlData();
    var checkUrl = "../../../../../securityServlet?neID=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(checkUrl, "POST", false, checkRightsHandler, null, "inputdata=" + xmlData);
}

function checkRightsHandler(doc)
{
    var data = EncapsulateData(doc);
    var right = null;
    for (var i = 0, rowLength = data.getDataRowLength(); i < rowLength; ++i) 
    {
        right = ("1" == data.getDataRowParam(i, 'right'));
        
        btnRightObj[data.getDataRowParam(i, 'btnId')].right = right;
    }
    
    updataButtonState();
}

function updataButtonState()
{
    $("queryBtn").disabled = !btnRightObj.queryBtn.right;
    $("applyBtn").disabled = !btnRightObj.applyBtn.right;
}

function createCheckRightXmlData()
{
    var root = new inputxml('datainterface');
    
    var bussinessNode = new tagElement('bussiness-params');
    var rowParams = null;
    var param = null;
    
    for (var oneRight in btnRightObj) 
    {
        rowParams = new tagElement('row-params');
        param = new tagElement('param');
        param.setAttribute('name', 'btnId');
        param.setAttribute('value', btnRightObj[oneRight].btnId);
        rowParams.appendChild(param);
        
        param = new tagElement('param');
        param.setAttribute('name', 'sfid');
        param.setAttribute('value', btnRightObj[oneRight].sfid);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
    
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function doQuery()
{
    if (!btnRightObj.queryBtn.right) 
    {
        return;
    }
    
    $("queryBtn").disabled = true;
    $("applyBtn").disabled = true;
    
    var xmlData = createQueryAllXmlData();
    var url = "../../../../../neExlorerServlet?sfid=" + CMD_OBJ.QUERY_ALL + "&neid=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", true, queryAllHandler, null, "inputdata=" + xmlData);
}

function createQueryAllXmlData()
{
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var rowParams = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "indexID");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winobj["neid"]);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "vlanID");
    param.setAttribute("value", 0xffff);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portType_UNI");
    param.setAttribute("value", "1");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portType_NNI");
    param.setAttribute("value", "2");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portID");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
    
    root.getRoot().appendChild(bussinessNode);
    return root.toString();
}

function queryAllHandler(doc)
{
    var data = EncapsulateData(doc);
    
    upTable.clearTableData();
    downTable.clearTableData();
    var errCode = data.getSErrorCode();
    if (0 != errCode) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (EMPTY_RESULT == data.errObj.rowErrors[i].error.code ||
            EMPTY_RESULT1 == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (PARTSUCC == errCode || FAIL == errCode)) 
        {
            data.errObj.s_error.code = 0;
        }
        else 
        {
            for (var i = 0; i < len; i++) 
            {
                var tempObj = data.getError().rowErrors[i].errorObj;
                tempObj["operateObj"] = RESOURCE["querybutton"] + RESOURCE["dataCount"];
            }
            
            var errArr = [];
            errArr[0] = "operateObj";
            openErrPage("../../../../../page/", data.getError(), errArr);
        }
    }
    
    if (0 == errCode || 1 == errCode) 
    {
        for (var len = data.getDataRowLength() - 1; len >= 0; len--) 
        {
            var row = data.rows[len];
            
            if ("" == row["vlanID"].value) 
            {
                data.rows.removeAt(len);
                continue;
            }
            
            if (SVL_VLAN == row["vlanID"].value) 
            {
                row["vlanID"].value = "-";
            }
        }
        
        createTableBody(upTable, upTableConf, data, RESOURCE);
        if (0 != upTable.getDataRowLength()) 
        {
            upTable.setRowSelect(0);
            upTableRowSelected(upTable.getSelectedRows());
        }
    }
    $("queryBtn").disabled = false;
}

function doApply()
{
    var xmlData = createModifyXmlData();
    if (!xmlData) 
    {
        return;
    }
    $('applyBtn').disabled = true;
    $('queryBtn').disabled = true;
    
    var url = "../../../../../neExlorerServlet?sfid=" + CMD_OBJ.MODIFY + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", true, modifyHandler, null, "inputdata=" + xmlData);
}

function createModifyXmlData()
{
    var root = new inputxml('datainterface');
    var bussinessNode = new tagElement('bussiness-params');
    var rowParams = null; //new tagElement('row-params');
    var param = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    
    for (var row = 0, rowCount = downTable.getDataRowLength(); row < rowCount; ++row) 
    {
        if (!downTable.getModify(row)) 
        {
            continue;
        }
        rowParams = new tagElement('row-params');
        param = new tagElement('param');
        param.setAttribute('name', 'neid');
        param.setAttribute('value', winobj['neid']);
        rowParams.appendChild(param);
        
        var indexID = downTable.getCellCurrentValue(row, "indexID", "indexID");
        param = new tagElement('param');
        param.setAttribute('name', 'indexID');
        param.setAttribute('value', indexID);
        rowParams.appendChild(param);
        
        var vlanID = downTable.getCellCurrentValue(row, "vlanID", "vlanID");
        if (vlanID == "-") 
        {
            vlanID = SVL_VLAN;
        }
        param = new tagElement('param');
        param.setAttribute('name', 'vlanID');
        param.setAttribute('value', vlanID);
        rowParams.appendChild(param);
        
        var portType = downTable.getCellCurrentValue(row, "portType", "portType");
        param = new tagElement('param');
        param.setAttribute('name', 'portType');
        param.setAttribute('value', portType);
        rowParams.appendChild(param);
        var portID = downTable.getCellCurrentValue(row, "portID", "portID");
        param = new tagElement('param');
        param.setAttribute('name', 'portID');
        param.setAttribute('value', portID);
        rowParams.appendChild(param);
        
        var state = downTable.getCellCurrentValue(row, "mcState", "mcState");
        param = new tagElement('param');
        param.setAttribute('name', 'mcState');
        param.setAttribute('value', state);
        rowParams.appendChild(param);
        
        var opDesc = RESOURCE["indexID"] + ":" + indexID + " " +
        RESOURCE["vlanID"] +
        ":" +
        vlanID +
        " " +
        RESOURCE["frameStatus"] +
        ":" +
        RESOURCE["frameStatus" + state];
        param = new tagElement('param');
        param.setAttribute('name', 'opDesc');
        param.setAttribute('value', opDesc);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
    
    if (!bussinessNode.childNodes.length) 
    {
        return null;
    }
    
    root.getRoot().appendChild(bussinessNode);
    
    return root.toString();
}

function modifyHandler(doc)
{
    var dataInterface = EncapsulateData(doc);
    $('queryBtn').disabled = !btnRightObj.queryBtn.right;
    
    if (0 != dataInterface.getSErrorCode()) 
    {
        $("applyBtn").disabled = !btnRightObj.applyBtn.right;
        var size = dataInterface.getBErrLength();
        for (var i = 0; i < size; i++) 
        {
            var tempObj = dataInterface.getError().rowErrors[i].errorObj;
            tempObj["operateObj"] = RESOURCE["setPortParam"];
        }
        
        var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", dataInterface.getError(), errArr);
    }
    
    refreshTableState(downTable, downTableConf, dataInterface);
}

function convertMsg(res, obj, key)
{

    if ("function" == (typeof obj)) 
    {
        return obj(key);
    }
    else //       
     {
        if (null == obj) 
        {
            return key;
        }
        var resValue = obj[key];
        if (null == resValue) 
        {
            resValue = "/";
        }
        return resValue;
    }
}
