
var winobj = getNeProperty(self);
var parentWin = getParentWindow();
var table = null;//     

var DEFAULT_INDEXID = 1;
var MIN_INDEXID = 1;
var MAX_INDEXID = 4294967295;
var DEFAULT_VLANID = 1;
var MIN_VLANID = 1;
var MAX_VLANID = 4094;
var DEFAULT_MACADD = "01-00-5E-00-01-00"

var MACARRAYLEN = 6;
var MACLEN = 2;
var selectControlWidth = 275;
var charWidth = 8;
var CMD_OBJ = {};
CMD_OBJ.CREATE_CMD = TECMDCODE_IPPTN_STATICIGMP_CREATE;
CMD_OBJ.GETSERVICE_CMD = TECMDCODE_IPPTN_ETHSRV_GET_ELAN_RES;

var serviceInfo = new Array();
var portObj = parentWin.availablePortObj;
var MACMODE_SVL = "1";
var serviceIndex;
var TRANSFER = "0";

loadXMLdoc("../../../../../conf/system.xml", "GET", false,EncapsulateSConf);
getResourse("../../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/snooping/snooping_"+SYSTEMCONF.getLanguage()+".xml");  
document.title = parentWin.RESOURCE["createMemPortTitle"];
var RESOURCE = parentWin.RESOURCE;

/**
 *      
 * @param  
 * @return  
 */
function initBody()
{		
	$("selectableInfTitle").appendChild(document.createTextNode(parentWin.RESOURCE["selectableInfTitle"]));
	$("selectedInfTitle").appendChild(document.createTextNode(parentWin.RESOURCE["selectedInfTitle"]));
	$("okBtn").value = parentWin.RESOURCE["okbutton"];	
  	$("cancleBtn").value = parentWin.RESOURCE["cancelbutton"];    
	$("applyBtn").value = parentWin.RESOURCE["applybutton"];	
	
	getElanService();
	initTable();
	serviceChanged(table.getAtom("indexID").getValue());
		
	$("applyBtn").disabled = true;
}

function getElanService()
{
	  var xmlstr = createGetServiceXML();
    
    var urlreq = "../../../../../neExlorerServlet?sfid=" + CMD_OBJ.GETSERVICE_CMD +"&nmUser="+parentWin.winobj["nmUser"];
    loadXMLdoc(urlreq, "POST",false,handleBackgetService,null,"inputdata="+xmlstr);
}

function createGetServiceXML()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",parentWin.winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","indexID");
    param.setAttribute("value",0);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackgetService(doc)
{	  
    var data = EncapsulateData(doc);
    
    if (0 == data.getError().getGlobleECode()) 
    {
        processServiceData(data);
    }
}

function processServiceData(data)
{
	  for(var i = 0, len = data.getDataRowLength(); i < len; i ++)
		{
			  if (TRANSFER == data.getDataRowParam(i ,"tagFlag" ))
			  {
			  	  continue;
			  }
				var service = new TEService();
				service.serviceIndex = data.getDataRowParam(i ,"indexID" );
				service.serviceID = data.getDataRowParam(i ,"serviceID" );
				service.serviceName = data.getDataRowParam(i ,"serviceName" );
				service.macMode = data.getDataRowParam(i ,"macMode" );
				serviceInfo.push(service);
		}
}

function TEService()
{    
		this.serviceIndex = null;
		this.serviceID = null;
		this.serviceName = null;
		this.macMode = null;
}

/**
 *          
 * @param  
 * @return  
 */
function initTable()
{   
	table = new CTable();
	table.addHead(parentWin.RESOURCE["PROPERTY"], parentWin.RESOURCE["VALUE"]);
	var cTableAtom = null;
	var cTableAtomEle = null;
	
	cTableAtom = new Atom("select");
	for(var i = 0, len = serviceInfo.length; i < len; i++)
	{
		  var service = serviceInfo[i];
		  var tempStr = service.serviceID + "(" + service.serviceName + ")";
		  var index = service.serviceIndex + "-" + service.macMode;
		  cTableAtom.addOption(tempStr, index); 
	}
	cTableAtom.element["onchange"] = function()
  {
	    serviceChanged(this.value);
  }
  table.addAttrRow("indexID", parentWin.RESOURCE["indexID"], cTableAtom); 
	
	cTableAtom = new Atom('text');
	cTableAtom.setValue(DEFAULT_VLANID);
	cTableAtomEle = cTableAtom.element; 
	cTableAtomEle.disabled = false;
	checkText(cTableAtomEle,MIN_VLANID + "",MAX_VLANID + "");
	cTableAtomEle["onchange"] = function()
  {
	    vlanidChanged();
  }
	cTableAtomEle.style.imeMode = "disabled"; 	
  	table.addAttrRow("vlanID", parentWin.RESOURCE["vlanID"], cTableAtom); 
  	
  	var atom = new Atom("text");
  	atom.setValue(DEFAULT_MACADD);
    atom.element.style.imeMode = "disabled";   
    
    atom.element["onkeypress"] = function()
    {
        if(!restrict(this, event, "0123456789abcdefABCDEF-"))
        {
            return false;
        }
        return true;
    }       
    atom.element["onchange"] = function()
    {	     
	  	  $("applyBtn").disabled = false;
    }   
    atom.element["onblur"] = function()
    {	     
	  	  if (!checkMAC(this.value))
    	  {
    	  	  this.value = "01-00-5E-00-01-00";    	  	  
    	  }
    }
    table.addAttrRow("macAdd", parentWin.RESOURCE["macAdd"], atom);

  	$("tableArea").appendChild(table.getTable()); 
}

function serviceChanged(value)
{
	  $("selectedport").options.length = 0;
	  
	  $("applyBtn").disabled = false;
	  var keyArray = value.split("-");
	  serviceIndex = keyArray[0];
	  var vlanID = table.getAtom("vlanID");
	  if (MACMODE_SVL == keyArray[1])
	  {	  	 
        vlanID.setValue("-");
        vlanID.element.disabled = true;
	  }
	  else
	  {
	  	  vlanID.setValue(DEFAULT_VLANID);
        vlanID.element.disabled = false;
	  }

	  var portArray = portObj[keyArray[0]];	 
	  if (null == portArray)
	  {
	  	 $("availableport").options.length = 0;
	  	  return;
	  }
		$("availableport").options.length = 0;
	  for (var i=0,len=portArray.length; i<len; ++i)
	  {
	  	  var interfaceStr = portArray[i].split(":");
	  	  
	  	  var oOption = document.createElement("OPTION");
	  	  oOption.text = interfaceStr[0];
	  	  oOption.value = interfaceStr[1];
	  	  
	  	  $("availableport").options.add(oOption);
	  }
	  
	  adjustSelectControlWidth("availableport");
	  
}

function adjustSelectControlWidth(selectControl)
{                        
	  $(selectControl).style.width	= selectControlWidth + 'px';
	  var ops = $(selectControl).options;
	  var maxlen=0;
	  for(var i=0; i<ops.length; i++)
	  {
	      if( ops[i].text.length>maxlen)
	      {
	        maxlen = 	ops[i].text.length;
	      } 	   	
	  }
	  var selectwidth = maxlen * charWidth ;	 
	  if(selectwidth > selectControlWidth)
	  {
	      $(selectControl).style.width	= selectwidth + 'px';
	  }	
}

function vlanidChanged()
{
	  $("applyBtn").disabled = false;
}

function checkMAC(strparam)
{
	  var ipAddressArray = strparam.split("-");
    
    if (MACARRAYLEN != ipAddressArray.length)
    {
    	  alert(parentWin.RESOURCE["wrongMAC"]);
	  	  return false;
    }
    
    for(var i = 0, len = ipAddressArray.length; i < len; i++)
    {
    	  if (MACLEN != ipAddressArray[i].length)
    	  {
    	  	  alert(parentWin.RESOURCE["wrongMAC"]);
	  	      return false;
    	  }
    }
	  
	  return true;
}

function initPortRes()
{	  
		var availaRes = parentWin.availablePortArray;
		if (!availaRes)
		{
			return;
		}
		var selectableList = $("availableport");
		for (var i=0; i<availaRes.length; ++i)
		{
				var port = availaRes[i];				
				var text = port.toString();
				var value = {};
				value["infID"] = port.infID;
				value["infType"] = port.infType;																
				var option = new Option(text, selectableList.options.length);	
				option.value = port.infType + "&" + port.infID;
				addOptionToSelect(selectableList, option);
		}			 
}
function doSelect()
{
		$("applyBtn").disabled = false;
		var src = $("availableport");
		var snk = $("selectedport");
		doAddRemoveRes(src, snk);
}

function doDeSelect()
{		
		$("applyBtn").disabled = false;
		var src = $("selectedport");
		var snk = $("availableport");		
		doAddRemoveRes(src, snk);
}

function doAddRemoveRes(src, snk)
{		
	if(src.selectedIndex == -1)
    {
    	alert(parentWin.RESOURCE["selectInterface"]);
    	return;
    }    
    var srcOptions = src.options;
    var snkOptions = snk.options;
    var option = null;
    for (var i=0; i<srcOptions.length; ++i)
    {
    		option = srcOptions[i];
    		if (!option.selected)
    		{
    				continue;
    		}
    		option.selected = false;
    		src.remove(i);
    		addOptionToSelect(snk, option);    		
    		i--;
    }
    
		adjustSelectControlWidth("availableport");
		adjustSelectControlWidth("selectedport");
}

function doOK()
{
		if ($("applyBtn").disabled)
		{
				xcloseDialog();
		}
		doOperation(true);
}


function doApply()
{
		doOperation(false);
}

function doOperation(okBtnPressed)
{
	  if ("" == table.getAttrValue("vlanID"))
		{
				alert(parentWin.RESOURCE["inputVlan"]);
				return;
		}
		if (!$("selectedport").options.length)
		{
				alert(parentWin.RESOURCE["selectInterface"]);
				return;
		}
		$("okBtn").disabled = true;
		$("applyBtn").disabled = true;
		
		var url = "../../../../../neExlorerServlet?sfid=" + CMD_OBJ.CREATE_CMD +"&nmUser="+parentWin.winobj["nmUser"];
    loadXMLdoc(url,"POST",true,callbackCreateHandler,okBtnPressed,"inputdata="+ createAddRoutePortXMLInfo());
}

function createAddRoutePortXMLInfo()
{
		var root = new inputxml("datainterface");
		var bussinessNode = new tagElement("bussiness-params");
		var rowparams = null;
		var param = null;
		var vlanID = table.getAttrValue("vlanID");
		if ("-" == vlanID)
		{
			  vlanID = 0xfffe;
		}
		var options = $("selectedport").options;
		var macAdd = convertMAC(table.getAttrValue("macAdd"));
		for (var i=0; i<options.length; ++i)
		{
				var option = options[i];								
				rowparams = new tagElement("row-params");
				
				param = new tagElement("param");
				param.setAttribute("name", "neid");
				param.setAttribute("value", parentWin.winobj["neid"]); 
				rowparams.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "indexID");
				param.setAttribute("value", serviceIndex); 
				rowparams.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "vlanID");
				param.setAttribute("value", vlanID);
				rowparams.appendChild(param);				
				
				param = new tagElement("param");
				param.setAttribute("name", "macAdd");
				param.setAttribute("value", macAdd);
				rowparams.appendChild(param);				
				
				var port = option.value;
				var portAttr = port.split("-");				
				param = new tagElement("param");
				param.setAttribute("name", "infType");
				param.setAttribute("value", portAttr[1]);
				rowparams.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "useGivenID");
				param.setAttribute("value", "0");
				rowparams.appendChild(param);	
				
				param = new tagElement("param");
				param.setAttribute("name", "infID");
				param.setAttribute("value", portAttr[0]);
				rowparams.appendChild(param);				
				
				param = new tagElement("param");
				param.setAttribute("name", "portFullName");
				param.setAttribute("value", option.text);
				rowparams.appendChild(param);			
				
				bussinessNode.appendChild(rowparams);							
		}		
		
		root.getRoot().appendChild(bussinessNode);				
		return root.toString();
}

function convertMAC(strparam)
{
	var ipAry = strparam.split("-");
	var rs = "";
	for(var i = 0; i < ipAry.length; i++)
	{	
		rs += ipAry[i];
	}
	return rs;
}

function callbackCreateHandler(doc, okBtnPressed)
{
		$("okBtn").disabled = false;

		var datainterface = EncapsulateData(doc);
		showOperResult(datainterface);
		if (datainterface.getSErrorCode() == 0)
		{
				parentWin.doQuery();
				if (okBtnPressed)
				{
						xcloseDialog();
				}
		}
		else
		{
				$("applyBtn").disabled = false;
		}
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data)
{
	var errArr = [];//           
	errArr[0] = "operObj";//           

	for(var i = 0, len = data.getBErrLength(); i < len; i++)
	{	
	    var tempObj = data.getError().rowErrors[i].errorObj;
      tempObj["operObj"] = parentWin.RESOURCE["createMemPortTitle"];
	}		
	openErrPage("../../../../../page/",data.getError(),errArr);
}
