var language=SYSTEMCONF.getLanguage();

var funID = "shaping";;
var funName = "shapingid";
var obj = getNeProperty(top); 
mincir = 64;
maxcir = 1048576;

var dm;
function init()
{
  st.setImage("../../../../../images/");
  createTableHead(st, window.tableconf[0]);
  var hc=st.getHeadCell("shapingid");
  st.setHCAttribute(hc,1,1,compareNum);
  
  st.setOnCellEditHandler(cellEditHandler);
  st.setOnRowSelectHandler(tableSelectHandler);
  document.getElementById("shapingtable").appendChild(st.getTable());
  st.setBodyHeight(getTableHeight($("shapingtable"),st)+"px");
  st.element.oncontextmenu=popupMenuHandler;  
  
  btnRightArr.querybtn = new BtnRightObj("querybtn",TE_ETHER_QUERY_FLOWSHAPING);    
  btnRightArr.newbtn = new BtnRightObj("newbtn",TE_ETHER_CREATE_FLOWSHAPING);    
  btnRightArr.applybtn = new BtnRightObj("applybtn",TE_ETHER_SET_FLOWSHAPING);    
  btnRightArr.deletebtn = new BtnRightObj("deletebtn",TE_ETHER_DEL_FLOWSHAPING); 
  sendRightInfo(btnRightArr);  
    
  initBtnStatue(); 
  if(!$("querybtn").disabled)
  {
      query();
  }    
}

function cellEditHandler(param)
{
	if((param.colid == "cir") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
	{
		var opsary = getDataArr();
		dm = st.getCellEdit(param.rowindex, param.colid).element.parent;
		dm.selview.options.length = 0;
		dm.initComboBox(opsary,"dm",0,true);
		var textview = st.getCellEdit(i, "cir").element.parent.txtview;
		textview.onkeypress = keypressHandler;
		textview.onkeyup = keyupHandler;
		textview.onblur = onblurHandler;
		textview.style.imeMode = "disabled";
		textview.onpaste = function()
	  {
		  return false;
	  }
		textview.maxLength = 7;
	}	
	$("applybtn").disabled = !btnRightArr.applybtn.right;
}

function tableSelectHandler(param)
{
	updateRowStat(st.getDataRowLength(),param.length);
	if(btnRightArr.deletebtn.right == false)
	{
		return;
	}
	if(param.length > 0)
	{
		document.getElementById("deletebtn").disabled = false;
	}
	else
	{
		document.getElementById("deletebtn").disabled = true;
	}
}

function addCellListener()
{
	for(var i = 0;i < st.getDataRowLength();i++)
	{
		addListenerByCol(i,"cbs","cbs");
	}
}

function addListenerByCol(row,colId,colkey)
{
	var tableCell = st.getCell(row,colId);
	var colAtom = st.getCellEdit(row,colId);
	
	EventUtil.addEventHandler(colAtom.element,"blur",blurHandler);
	function blurHandler()
	{
		if(colkey == "cir")
		{
			var inputValue = st.getCellEdit(row,colId).element.children[0].value; 
			if(inputValue=="" || parseInt(inputValue) < 64)
			{
				alertDialog("64", "1048576");
				tableCell.element.showElement.element.innerText = "64";
				st.setCellValue(tableCell,colkey,"64");
			}
			else if(parseInt(inputValue) > 1048576)
			{
				alertDialog("64", "1048576");
				tableCell.element.showElement.element.innerText = "1048576";
				st.setCellValue(tableCell,colkey,"1048576");
			}
		}
		else
		{
			var inputValue = st.getCellStoreValue(row,colId,colkey); 
			if(!inputValue || inputValue < 0)
			{
				alert(RESOURCE["input_tips"]);
				tableCell.element.showElement.element.innerText = "0";
				st.setCellValue(tableCell,colkey,"0");
			}
			else if(inputValue > 512)
			{
				alert(RESOURCE["input_tips"]);
				tableCell.element.showElement.element.innerText = "512";
				st.setCellValue(tableCell,colkey,"512");
			}
		}
	}
	if(colkey == "cbs")
	{
	  colAtom.element.onpaste = function()
	  {
		  return false;
	  }
	  textCheck(colAtom.element,"0","512");
	}
			if(colkey == "cir")
	{
	  colAtom.element.onpaste = function()
	  {
		  return false;
	  }
	}
}

function checkInputData(textinput, event,min,max)
{
	if(!restrict(textinput, event, "0123456789"))
  {
    return false;
  }
  if(!checkDataRan(textinput,min,max))
  {
    return false;
  }
  return true;
}

function checkDataRan(textinput,minData,maxData)
{
   var key,keychar;
   
   if(window.event)
   {
      key = window.event.keyCode;
   }  
   keychar = String.fromCharCode(key);
   oldtextcontent = textinput.value;
   var pos = digitalTag_getPos(textinput);
   
   if(pos == 0 && keychar == 0 && oldtextcontent != "")
   {
   	  return false;
   }
   else if(pos != 0 && oldtextcontent == "0")
   	{
   		return false;
   	}
   textcontent = parseInt(textinput.value + keychar);
   if(textcontent < minData || textcontent > maxData)
   {
   	   var alertStr = RESOURCE["wrong1"] + minData + RESOURCE["wrong2"] + maxData + RESOURCE["wrong3"];
		   alert(alertStr);
       return false;
   }
  else
  {
  	return true;
  }
}

function query()
{
	if(btnRightArr.querybtn.right == false)
	{
		return;
	}
  var URL = "../../../../../neExlorerServlet?sfid="+TE_ETHER_QUERY_FLOWSHAPING+"&flag=1"+"&nmUser="+obj["nmUser"];
  sendQueryInfo(URL);
}

function deleteShaping()
{
  var URL = "../../../../../neExlorerServlet?sfid="+TE_ETHER_DEL_FLOWSHAPING+"&flag=1"+"&nmUser="+obj["nmUser"];
  sendDeleteInfo(URL,"shapingid","shapingid");
}

function convertDataToArray(data)
{
  var result = new Object();
  for(var i = 0;i < data.getDataRowLength();i++)
  {
    shapingId = data.getDataRowParam(i,"shapingid");
    portID = data.getDataRowParam(i,"port");
    if(portID > 0X8000)
    {
    	portname = "VCTRUNK" + (portID - 0X8000);
    }
    else
    {
      portname = "port" + portID;
    }	
    var shapingInfo = "Shaping ID:"+data.getDataRowParam(i,"shapingid")+";"+RESOURCE["port"]+":"+portname+";"+RESOURCE["priority"]+":"+data.getDataRowParam(i,"pri")+";"+"CIR(kbit/s):"+data.getDataRowParam(i,"cir")+";"+"DCBS(kbit/s):"+data.getDataRowParam(i,"cbs")+";"+"PIR(kbit/s):"+data.getDataRowParam(i,"pir")+";";
    result[shapingId] = shapingInfo;
  }
  return result;
}

function createSecondlevel(shapingid,pri,cir,cbs)
{
  var secondlevel = new tagElement("row-params");
  
  thirdlevel = new tagElement("param");
  thirdlevel.setAttribute("name","neid");
  thirdlevel.setAttribute("value",parent.neid);
  secondlevel.appendChild(thirdlevel);
  
  thirdlevel = new tagElement("param");
  thirdlevel.setAttribute("name","slotid");
  thirdlevel.setAttribute("value",parent.slotid);
  secondlevel.appendChild(thirdlevel);
  
  thirdlevel = new tagElement("param");
  thirdlevel.setAttribute("name","shapingid");
  thirdlevel.setAttribute("value",shapingid);
  secondlevel.appendChild(thirdlevel);
  
  if(pri)
  {
  	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name","pri");
  	thirdlevel.setAttribute("value",pri);
  	secondlevel.appendChild(thirdlevel);
	}
  else
  {
  	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name","cir");
  	thirdlevel.setAttribute("value",cir);
  	secondlevel.appendChild(thirdlevel);
  	
  	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name","cbs");
  	thirdlevel.setAttribute("value",cbs);
  	secondlevel.appendChild(thirdlevel);
  	
  	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name","pbs");
  	thirdlevel.setAttribute("value","0"); 
  	secondlevel.appendChild(thirdlevel);
  	
  	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name","pir");
  	thirdlevel.setAttribute("value","0"); 
  	secondlevel.appendChild(thirdlevel);
	}
  return secondlevel;
}

function createModifyShapingXML()
{
  var root = new inputxml("datainterface");//Create the root of a xml file
  var firstlevel = new tagElement("bussiness-params");
  for(var i = 0,size = st.getDataRowLength();i < size;i++)
  {
  	var priorityIsModify = st.getCellModify(i,"pri");
  	var cirIsModify = st.getCellModify(i,"cir");
  	var cbsIsModify = st.getCellModify(i,"cbs");
  	var pirIsModify = st.getCellModify(i,"pir");
  	var shapingid = st.getCellStoreValue(i,"shapingid","shapingid");  
  	if(priorityIsModify)
  	{            
      var pri = st.getCellStoreValue(i,"pri","pri");           
      var secondlevel = createSecondlevel(shapingid,pri);
      firstlevel.appendChild(secondlevel);
    }
    if(cirIsModify || cbsIsModify)
  	{                      
      var cir = st.getCellShow(i,"cir").getValue();    
      var cbs = st.getCellStoreValue(i,"cbs","cbs");
      var secondlevel = createSecondlevel(shapingid,null,cir,cbs);
      firstlevel.appendChild(secondlevel);
    }
  }
  root.getRoot().appendChild(firstlevel);
	
  var xml = root.toString();
  return xml;
}

function modifyShaping()
{
		for (var i=0,size = st.getDataRowLength();i<size; i++)
	{
		if (!event)
	{
		event = window.event;
	}	
	var numobj = st.getCellShow(i,"cir").getValue();
  if(numobj == "" || Number(numobj)% 64 != 0 || Number(numobj) == 0)
   {		   

       alert(RESOURCE["wrong"]);
       return;
   }
   
  }  				
  var xml = createModifyShapingXML();
	document.getElementById("applybtn").disabled = true;
  var URL = "../../../../../neExlorerServlet?sfid="+TE_ETHER_SET_FLOWSHAPING+"&flag=1"+"&nmUser="+obj["nmUser"];
  loadXMLdoc(URL,"POST",true,modifyHandleBack,null,"inputdata="+xml);
}

function modifyHandleBack(doc)
{
	data = EncapsulateData(doc);
	if(data.getSErrorCode() != "0")
	{
     showErrorDialog(data,"shapingid","Shaping ID:");
     document.getElementById("applybtn").disabled = !btnRightArr.applybtn.right;
  }
  refreshTableState(st,window.tableconf[0],data);
}

function checkPort(newPort)
{
	for(var i = 0,dataLength = st.getDataRowLength();i < dataLength; i++)
	{
		var usedPort = st.getCellStoreValue(i,"port","port");
		if(newPort == usedPort)
		{
			return false;
		}
	}
	return true;
}
window.onresize=function()
{
	st.setBodyHeight(getTableHeight($("shapingtable"),st)+"px");
}

function setOptionValue(param)
{
	var showtext=param[0];
	var txtvalue=param[1];
	var elem=param[2];
	var colid=elem.colid;

	var rows=elem.parent.getSelectedRows();
	for(var i=0; i<rows.length; i++)
	{
	   var cell=elem.parent.getCell(rows[i],colid);
	   if(cell.element.isEdit == 0)
	   {
	   		continue;
	   }
	   elem.parent.setCellValue(cell,colid,txtvalue);
	   var showElement=cell.element.showElement;
	   cell.element.modify = true;
	   cell.element.parentNode.modify = true;
	   cell.element.style.backgroundColor = "#d0f946";
       handleCellEdit(cell.element,TABLE_CONSTANT.AFTEREDIT); 
	   if(showElement.type == 'span'|| showElement.type =='text')
	   {
	   	 showElement.element.innerText=txtvalue;
	   }
	   else if(showElement.type == 'select')
	   {
	     	var options =showElement.element.options;
	     	for(var j=0; j<options.length; j++)
	     	{
	     		if(options[j].value== txtvalue)
	     		{
	  	     	    showElement.element.selectedIndex=j;	  	
	  	     	    break;
	     	    }
	     	}
	   }      
       if(cell.element.editElement.element.onchange)
       {
	       	cell.element.editElement.element.value = txtvalue;
		    cell.element.editElement.element.onchange();
       }
	}
}
function onblurHandler(event)
{

	if (!event)
	{
		event = window.event;
	}	
	var numobj = event.target ? event.target : event.srcElement;
  if(numobj.value == "" )
   {		   
       numobj.value = 64;
       return;
   } 			
}

function keyupHandler(event)
{
	if (!event)	{event=window.event;}
	var numobj = event.target ? event.target : event.srcElement;	
  
  if (numobj.value >1048576)
  {
		alert(RESOURCE["wrong"]);
		numobj.value = 1048576;
		return;
  }	
}

function keypressHandler(event)
{
	var key,keychar;
	if (!event)	
	{
	  event=window.event;
	  key = window.event.keyCode;
	}
	var numobj = event.target ? event.target : event.srcElement;
	
	var code= (event.keyCode!=0?event.keyCode:event.charCode);  
  
	if(event.keyCode == 13)
	{
		if(numobj.value == "")
		{
			alert(RESOURCE["wrong"]);
			return false;
		}
	  event.srcElement.blur();
	  return true;	
	}
  
  if(code == 8 ||code == 46||code==37||code==39){
    return true;	
  }
	
	if (code < 48 || code > 57)
	{
		return false;
	}
	window.status = "code:"+code+"; value:"+numobj.value;
	var position = digitalTag_getPos(numobj);
	if(position == 0 && numobj.value.length > 0 && 
	   (code == 48 || code  == 96))
	{
    return false;
  }
  
  if(numobj.value=='0' && position>0)
  {
   
    return false;
  }
  
  keychar = String.fromCharCode(key);  
  if (numobj.value + keychar >1048576)
  {
		alert(RESOURCE["wrong"]);
		numobj.value = 1048576;
		return false;
  }	
}
function queryHandleBack(doc)
{
  var data = EncapsulateData(doc);//deal with the data.
  st.clearTableData();
  if(funName == "shapingid")//  shaping  ,     
  {
  	if(data.getSErrorCode() != "0")
  	{
  		showErrorDialog(data,"shapingid",RESOURCE["queryshaping"]);//dispose err dialog
  	}
  	createTableBody(st,window.tableconf[0],data,RESOURCE);//put data to table	
  	    if(!st.element.colsArray.selectedId)
    {
  	   st.element.colsArray.selectedId = "shapingid";
  	   st.element.colsArray.imgflag = 1;
    }
    var td=st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
    st.sortRows(td,st.element.colsArray.imgflag);
  }
  else
  { 	
    dealWithData(data);//  cos     
  }
  if(st.getDataRowLength() > 0)
  {
		var opsary = getDataArr();
		dm = st.getCellEdit(0, "cir").element.parent;
		dm.selview.options.length = 0;
		dm.initComboBox(opsary,"dm",0,true); 
	}
  addCellListener();//                
	updateRowStat(st.getDataRowLength(),0);
  var dataArray = convertDataToArray(data);//         ,          
  parent.updateData(dataArray, funID);//       ,    
  initBtnStatue();
}

function getDataArr()
{
	var opsary = new Array();
	opsary[0] = new Option("0Kbit/s",0);
	opsary[1] = new Option("512Kbit/s",512);
	opsary[2] = new Option("1Mbit/s",1024);            
	opsary[3] = new Option("2Mbit/s",2048);            
	opsary[4] = new Option("3Mbit/s",3072);            
	opsary[5] = new Option("4Mbit/s",4096);            
	opsary[6] = new Option("5Mbit/s",5120);            
	opsary[7] = new Option("6Mbit/s",6144);            
	opsary[8] = new Option("7Mbit/s",7168);            
	opsary[9] = new Option("8Mbit/s",8192);           
	opsary[10] = new Option("9Mbit/s",9216);           
	opsary[11] = new Option("10Mbit/s",10240);         
	opsary[12] = new Option("20Mbit/s",20480);         
	opsary[13] = new Option("30Mbit/s",30720);         
	opsary[14] = new Option("40Mbit/s",40960);         
	opsary[15] = new Option("50Mbit/s",51200);         
	opsary[16] = new Option("100Mbit/s",102400);    
	opsary[17] = new Option("1000Mbit/s",1024000);  
	return opsary;	
}
