var language = SYSTEMCONF.getLanguage();
var funID = "car";;
var funName = "carid";

var carstatus = new Object();
carstatus["0"] = "disabled";
carstatus["1"] = "enabled";
var obj = getNeProperty(parent);
var mincir = 0;
var maxcir = 1048576; //                 
var maxdcbs = 1024; //                   
var maxTxtLength = 7;
var sCirWrong = RESOURCE["wrong00"];
var sInputTrips = RESOURCE["input_tips"];

var BOARD_SL61EFP6 = 2057;
var BOARD_SL61EFP8 = 2102;
var BDTYPE_SL61EGS4 = '2423';

var dm;

/**
 ** DTS2011091700758
 **                               
 **/
switch(obj["boardType"])
{
    case '2423':
    case '2439':
        maxdcbs = 16384;
    default:
        break;
}

function tabSelectHandler()
{
	st.setBodyHeight(getComponetHeight($("cartable"), 60) + "px");
}

function init()
{
	SpecialAttrMgr.getCPFunInfo(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS");
	
	st.setImage("../../../../../images/");
	
	var tc = window.tableconf[0];
	
	if (obj["boardType"] == 927 || SpecialAttrMgr.isCPNotSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_PIR_TABLE_SHOW"))
	{
		tc.colArray[tc.getIndexByid("pir")].width = 0;
	}
	
	if (obj["boardType"] == 927 || SpecialAttrMgr.isCPNotSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_DMBS_TABLE_SHOW"))
	{
		tc.colArray[tc.getIndexByid("dmbs")].width = 0;
	}
	
	if(obj["boardType"] == BOARD_SL61EFP6 || obj["boardType"] == BOARD_SL61EFP8)
	{
		mincir = 0;
		maxcir = 100032;
		sCirWrong = RESOURCE["wrong11"];
	}
	
	var customCirRange = SpecialAttrMgr.getCpAttrListValueByType(obj["neid"],obj["boardType"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_CIR_INPUT_RANGE_CUSTOM");
	if(customCirRange != null && 3 == customCirRange.length)
	{
		mincir = customCirRange[0];
		maxcir = customCirRange[1];
		sCirWrong = RESOURCE["wrong1"] + mincir + RESOURCE["wrong2"] + maxcir + RESOURCE["wrong3"] + RESOURCE["steplen"] + customCirRange[2] + RESOURCE["wrong3"];
	}

	createTableHead(st, window.tableconf[0]);
	var hc = st.getHeadCell("carid");
	st.setHCAttribute(hc, 1, 1, compareNum);
	st.setOnCellEditHandler(cellEditHandler);
	st.setOnRowSelectHandler(tableSelectHandler);
	document.getElementById("cartable").appendChild(st.getTable());
	st.element.oncontextmenu = popupMenuHandler;

	btnRightArr.querybtn = new BtnRightObj("querybtn", TE_ETHER_QUERY_CAR);
	btnRightArr.newbtn = new BtnRightObj("newbtn", TE_ETHER_CREATE_CAR);
	btnRightArr.applybtn = new BtnRightObj("applybtn", TE_ETHER_SET_CAR);
	btnRightArr.deletebtn = new BtnRightObj("deletebtn", TE_ETHER_DEL_CAR);
	sendRightInfo(btnRightArr);

	initBtnStatue();
	if (!$("querybtn").disabled)
	{
		query();
	}
}

function cellEditHandler(param)
{
	if (((param.colid == "cir") || (param.colid == "pir"))
			&& (param.stage == TABLE_CONSTANT.BEFOREEDIT))
	{
		var opsary = getDataArr();
		dm = st.getCellEdit(param.rowindex, param.colid).element.parent;
		dm.selview.options.length = 0;
		dm.initComboBox(opsary, "dm", 0, true);
		st.getCellEdit(i, "dcbs").element.style.imeMode = "disabled";
		var textview = st.getCellEdit(i, param.colid).element.parent.txtview;
		textview.onkeypress = keypressHandler;
		textview.onkeyup = keyupHandler;
		textview.onblur = onblurHandler;
		textview.style.imeMode = "disabled";
		textview.onpaste = function()
		{
			return false;
		};
		textview.maxLength = maxTxtLength;
	}
	$("applybtn").disabled = !btnRightArr.applybtn.right;
}

/*
 *             
 */
function tableSelectHandler(param)
{
	var selectedrowcount = st.getSelectedRowCount();
	if (selectedrowcount > 0)
	{
		document.getElementById("deletebtn").disabled = !btnRightArr.deletebtn.right;
	}
	else
	{
		document.getElementById("deletebtn").disabled = true;
	}
	updateRowStat(st.getDataRowLength(), selectedrowcount);
}

function addCellListener()
{
	if (obj["boardType"] == 1550 || SpecialAttrMgr.isCPSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_CIR_TABLE_EDIT"))
	{
		for ( var i = 0; i < st.getDataRowLength(); i++)
		{
			addListenerByCol(i, "cir", "cir");
			st.setCellIsEdit(st.getCell(i, "dcbs"), 0);
			st.setCellIsEdit(st.getCell(i, "pir"), 0);
			st.setCellIsEdit(st.getCell(i, "dmbs"), 0);
		}
	}
	
	if (obj["boardType"] != 1550 && !SpecialAttrMgr.isCPNotSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_DCBS_TABLE_EDIT"))
	{
		for ( var i = 0; i < st.getDataRowLength(); i++)
		{
			addListenerByCol(i, "dcbs", "dcbs");
		}
	}
	
}

function addListenerByCol(row, colId, colkey)
{
	var tableCell = st.getCell(row, colId);
	var colAtom = st.getCellEdit(row, colId);

	EventUtil.addEventHandler(colAtom.element, "blur", blurHandler);
	function blurHandler()
	{
		if (colkey == "cir")
		{
			var inputValue = parseInt(tableCell.element.showElement.element.innerText); 
			if (null == inputValue || inputValue < 0)
			{
				alert(sInputTrips);
				tableCell.element.showElement.element.innerText = "0";
				st.setCellValue(tableCell, colkey, "0");
			}
			else if (inputValue > maxcir)
			{
				alert(sInputTrips);
				tableCell.element.showElement.element.innerText = maxcir
						.toString();
				st.setCellValue(tableCell, colkey, maxcir.toString());
			}
			if (obj["boardType"] == 1550 || SpecialAttrMgr.isCPSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_PIR_SAME_AS_CIR"))
			{
				var pirCell = st.getCell(row,"pir");
				pirCell.element.showElement.element.innerText = "" + inputValue;
			}
		}
		else
		{
			var inputValue = st.getCellStoreValue(row, colId, colkey);
			if (!inputValue || inputValue < 0)
			{
				alert(sInputTrips);
				tableCell.element.showElement.element.innerText = "0";
				st.setCellValue(tableCell, colkey, "0");
			}
			else if (inputValue > maxdcbs)
			{
				alert(sInputTrips);
				tableCell.element.showElement.element.innerText = maxdcbs
						.toString();
				st.setCellValue(tableCell, colkey, maxdcbs.toString());
			}
		}
	}
	if (colkey == "dcbs")
	{
		colAtom.element.onpaste = function()
		{
			return false;
		};
		textCheck(colAtom.element, "0", maxdcbs.toString());
	}
	if (colkey == "cir")
	{
		colAtom.element.onpaste = function()
		{
			return false;
		};
		
		if (obj["boardType"] != 1550 && !SpecialAttrMgr.isCPSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_PIR_SAME_AS_CIR"))
		{
			textCheck(colAtom.element, "0", maxcir.toString());
		}
	}
}

/**
 *                      MAX      submitfunc          ,      ,           ''
 */
function digitalTag(obj, min, max, submitfunc, maxalertflag, resource, alertstr)
{
	var code = event.keyCode;
	var ch = String.fromCharCode(code);
	if (code == 13)
	{
		event.srcElement.blur();
		return true;
	}

	if (code == 8 || code == 46 || code == 9)
	{
		return true; // DEL   
	}
	if (code > 36 && code < 41)
	{
		return true; //    
	}
	if (event.ctrlKey)
	{
		if (ch == 'X' || ch == 'C' || ch == 'V' || ch == 'A')
		{ // X C V A
			return true;
		}
		else
		{
			return false;
		}
	}
	if (event.shiftKey)
	{
		return false;
	}
	if (code < 48 || (code > 57 && code < 96 || code > 105))
	{
		return false; //    
	}
	var value = obj.value;
	pos = digitalTag_getPos(obj); //         
	if ((value.length == 0) && (pos == 0))
	{
		return true;
	}

	if (value == '0' && pos > 0)
	{
		return false;
	}

	if (code < 58)
	{
		ch = '' + code - 48;
	}
	else
	{
		ch = '' + code - 96;
	}
	var SelectChars = document.selection.createRange().text;
	var endleng = 0;
	if (SelectChars != null && SelectChars.length == null)
	{
		endleng = 1;
	}
	if (SelectChars != null && SelectChars.length != null)
	{
		endleng = SelectChars.length;
	}

	var newVal = value.substring(0, pos) + ch + value.substring(pos + endleng);
	if (parseInt(newVal, 10) > max)
	{
		if (maxalertflag && resource && alertstr)
		{
			alert(resource[alertstr]);
			return false;
		}
		else
		{
			obj.value = max;
			var alertStr = RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max
					+ RESOURCE["wrong3"];
			alert(alertStr);
			return false;
		}
	}
	return true;
}

function query()
{
	if (btnRightArr.querybtn.right == false)
	{
		return;
	}
	var URL = "../../../../../neExlorerServlet?sfid=" + TE_ETHER_QUERY_CAR
			+ "&flag=1" + "&nmUser=" + obj["nmUser"];
	sendQueryInfo(URL);
}

function dealWithData(returnData)
{
	if (returnData.getSErrorCode() != "0")
	{
		showErrorDialog(returnData, "carid", RESOURCE["querycar"]);// dispose
	}
	var tempData = new DataInterface();
	var tempDataArr = new Object();

	for ( var i = 0, size = returnData.getDataRowLength(); i < size; i++)
	{
		var carid = returnData.getDataRowParam(i, "carid");
		var carCir = returnData.getDataRowParam(i, "cir");
		if (carCir == "0" || carCir == "" || !tempDataArr[carid])
		{
			tempDataArr[carid] = returnData.rows[i];
			continue;
		}
		else
		{
			tempDataArr[carid]["cir"].value = carCir;
		}
	}
	for ( var j in tempDataArr)
	{
		tempData.rows[tempData.getDataRowLength()] = tempDataArr[j];
	}
	createTableBody(st, window.tableconf[0], tempData, RESOURCE);//        
	if (!st.element.colsArray.selectedId)
	{
		st.element.colsArray.selectedId = "carid";
		st.element.colsArray.imgflag = 1;
	}
	var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
	st.sortRows(td, st.element.colsArray.imgflag);

	if (st.getDataRowLength() > 0)
	{
		var opsary = getDataArr();
		dm = st.getCellEdit(0, "cir").element.parent;
		dm.selview.options.length = 0;
		dm.initComboBox(opsary, "dm", 0, true);
		
		if (obj["boardType"] != 927 && !SpecialAttrMgr.isCPNotSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_PIR_TABLE_SHOW"))
		{
			var opsary = getDataArr();
			dm = st.getCellEdit(0, "pir").element.parent;
			dm.selview.options.length = 0;
			dm.initComboBox(opsary, "dm", 0, true);
		}
	}

	if(obj["boardType"] != 927 && !SpecialAttrMgr.isCPNotSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_DMBS_TABLE_SHOW"))
	{
		for ( var i = 0, size = st.getDataRowLength(); i < size; i++)
		{
			st.getCellEdit(i, "dcbs").element.style.imeMode = "disabled";
			var dmbsCell = st.getCellEdit(i, "dmbs").element;
			checkDataCellEvent(dmbsCell, 0, maxdcbs, 0);
		}
	}else{
		for ( var i = 0, size = st.getDataRowLength(); i < size; i++)
		{
			st.getCellEdit(i, "dcbs").element.style.imeMode = "disabled";
		}
	}
	
}

function selectChangeEvent()
{
    this.style.backgroundColor = "#d0f946";
    if(isIE)
    {
        this.onselectstart = null;
    }
    else
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;  
    this.parentNode.modify = true; 
    this.showElement.element.style.display = "none"; 
    var colid = this.colid;
    var atom = null;

    atom = st.createAtom("select");
    getBurstValue(atom.element);
		
    this.editElement.type = "select";
    atom.element.onblur= cellonblur;

    atom.setValue(this.storeValue[colid]);
    atom.element.onclick=stopEventPropagation;
    atom.element.onmousedown=atomOnMouseDownHandle;
    atom.element.ondblclick=stopEventPropagation;
    
    this.appendChild(atom.element);
    atom.element.focus();
}

function getBurstValue(atom)
{
	atom.options[atom.options.length] = new Option("0", 0);
	atom.options[atom.options.length] = new Option("4", 4);
	atom.options[atom.options.length] = new Option("8", 8);
	atom.options[atom.options.length] = new Option("16", 16);
	atom.options[atom.options.length] = new Option("32", 32);
	atom.options[atom.options.length] = new Option("64", 64);
	atom.options[atom.options.length] = new Option("128", 128);
	atom.options[atom.options.length] = new Option("256", 256);
	atom.options[atom.options.length] = new Option("512", 512);
	atom.options[atom.options.length] =  new Option("1024", 1024);
	atom.options[atom.options.length] = new Option("2048", 2048);
	atom.options[atom.options.length] = new Option("4096", 4096);
	atom.options[atom.options.length] = new Option("8192", 8192);
	atom.options[atom.options.length] = new Option("16384", 16384);
}
function onblurHandler(event)
{

	if (!event)
	{
		event = window.event;
	}
	var numobj = event.target ? event.target : event.srcElement;
	if (numobj.value == "")
	{
		numobj.value = mincir;
		return;
	}
	if (((Number(numobj.value) != 0) && (Number(numobj.value) % 64 != 0)) 
	     || Number(numobj.value) < mincir  || Number(numobj.value) > maxcir)
	{
		numobj.value = mincir;
		alert(sCirWrong);
		return;
	}
}

function keyupHandler(event)
{
	if (!event)
	{
		event = window.event;
	}
	var numobj = event.target ? event.target : event.srcElement;

	if (numobj.value > maxcir)
	{
		numobj.value = maxcir;
		alert(sCirWrong);
		return;
	}
}

function keypressHandler(event)
{
	var key, keychar;
	if (!event)
	{
		event = window.event;
		key = window.event.keyCode;
	}
	var numobj = event.target ? event.target : event.srcElement;

	var code = (event.keyCode != 0 ? event.keyCode : event.charCode);

	if (event.keyCode == 13)
	{
		if (numobj.value == "")
		{
			alert(sCirWrong);
			return false;
		}
		event.srcElement.blur();
		return true;
	}

	if (code == 8 || code == 46 || code == 37 || code == 39)
	{
		return true;
	}

	if (code < 48 || code > 57)
	{
		return false;
	}
	var position = digitalTag_getPos(numobj);

	if (numobj.value == '0' && position > 0)
	{

		return false;
	}

	keychar = String.fromCharCode(key);
	if (numobj.value + keychar > maxcir)
	{
		numobj.value = maxcir;
		alert(sCirWrong);
		return false;
	}
}

/*
 *   car   
 */
function deleteCar()
{
	var URL = "../../../../../neExlorerServlet?sfid=" + TE_ETHER_DEL_CAR
			+ "&flag=1" + "&nmUser=" + obj["nmUser"];//   JAVABEAN       TENEExplorerServlet web.xml   
	sendDeleteInfo(URL, "carid", "carid");
}

/*
 *   :                   ,           .     : data:           
 */
function convertDataToArray(data)
{
	var length = data.getDataRowLength();
	var result = new Object();
	for ( var i = 0; i < length; i++)
	{
		carId = data.getDataRowParam(i, "carid");
		var carid = data.getDataRowParam(i, "carid");
		var carEnable = data.getDataRowParam(i, "status");
		var resourceStatus = RESOURCE["enabled"];
		if (carEnable == "0")
		{
			resourceStatus = RESOURCE["disabled"];
		}
		var carInfo = "CAR ID:" + carid + ";" + "Status:" + resourceStatus
				+ ";" + "CIR(kbit/s):" + data.getDataRowParam(i, "cir") + ";";
		
		if (parent.boardType == "927" || SpecialAttrMgr.isCPNotSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_PIR_TABLE_SHOW"))
		{
			carInfo = carInfo + "DCBS(kbyte):"
					+ data.getDataRowParam(i, "dcbs");
		}
		else
		{
			carInfo = carInfo + "PIR(kbit/s):" + data.getDataRowParam(i, "pir")
					+ ";" + "DCBS(kbyte):" + data.getDataRowParam(i, "dcbs")
					+ ";" + "DMBS(kbyte):" + data.getDataRowParam(i, "dmbs")
					+ ";";
		}
		result[carId] = carInfo;
	}
	return result;
}

/*
 *       ,  createModifyCARXML()  
 */
function createSecondlevel(carid, carstatus, cir, dcbs, i)
{
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", parent.neid);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "slotid");
	thirdlevel.setAttribute("value", parent.slotid);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "carid");
	thirdlevel.setAttribute("value", carid); // car id
	secondlevel.appendChild(thirdlevel);

	if (carstatus)
	{
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "status");
		thirdlevel.setAttribute("value", carstatus); // car    
		secondlevel.appendChild(thirdlevel);
	}
	else
	{
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "cir");
		thirdlevel.setAttribute("value", cir); //       
		secondlevel.appendChild(thirdlevel);

		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "dcbs");
		thirdlevel.setAttribute("value", dcbs); //         ,     ,         
		secondlevel.appendChild(thirdlevel);

		pirValue = "0";
		pbsValue = "0";
		
		if (obj["boardType"] != 927 && !SpecialAttrMgr.isCPNotSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_PIR_TABLE_SHOW"))
		{
			pirValue = st.getCellShow(i, "pir").getValue();
			pbsValue = st.getCellStoreValue(i, "dmbs", "dmbs");
		}
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "pir");
		thirdlevel.setAttribute("value", pirValue); //     
		secondlevel.appendChild(thirdlevel);

		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "dmbs");
		thirdlevel.setAttribute("value", pbsValue); //         
		secondlevel.appendChild(thirdlevel);
	}

	return secondlevel;
}

/*
 *      XML  
 */
function createModifyCARXML()
{
	var root = new inputxml("datainterface");// Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	for ( var i = 0, size = st.getDataRowLength(); i < size; i++)
	{
		var statusIsModify = st.getCellModify(i, "status");
		var cirIsModify = st.getCellModify(i, "cir");
		var dcbsIsModify = st.getCellModify(i, "dcbs");
		var pirIsModify = st.getCellModify(i, "pir");
		var dmbsIsModify = st.getCellModify(i, "dmbs");
		var carid = st.getCellStoreValue(i, "carid", "carid");
		if (statusIsModify)
		{
			var carstatus = st.getCellStoreValue(i, "status", "status");
			var secondlevel = createSecondlevel(carid, carstatus, null, null, i);//       
			firstlevel.appendChild(secondlevel);
		}
		if (cirIsModify || dcbsIsModify || pirIsModify || dmbsIsModify)
		{
			var cir = st.getCellShow(i, "cir").getValue();
			var dcbs = st.getCellStoreValue(i, "dcbs", "dcbs");
			var secondlevel = createSecondlevel(carid, null, cir, dcbs, i);//       
			firstlevel.appendChild(secondlevel);
		}
	}

	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function modifyCar()
{
	for ( var i = 0, size = st.getDataRowLength(); i < size; i++)
	{
		if (!event)
		{
			event = window.event;
		}
		var numobj = st.getCellShow(i, "cir").getValue();
		if (numobj == "" || Number(numobj) % 64 != 0)
		{
			alert(sCirWrong);
			return;
		}
		
		if (obj["boardType"] == 1067 || SpecialAttrMgr.isCPSupport(obj["neid"],obj["slotid"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_PIR_GREATER_THAN_CIR"))
		{
			var cir = st.getCellShow(i, "cir").getValue();
			var pir = st.getCellShow(i, "pir").getValue();
			if (parseInt(cir) > parseInt(pir))
			{
				alert(RESOURCE["INPUT_INVALID_PIR"]);
				return;
			}
		}
	}

	var xml = createModifyCARXML();//       QX   XML  
	document.getElementById("applybtn").disabled = true;
	var URL = "../../../../../neExlorerServlet?sfid=" + TE_ETHER_SET_CAR
			+ "&flag=1" + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(URL, "POST", true, modifyHandleBack, null, "inputdata=" + xml);
}

function modifyHandleBack(doc)
{
	data = EncapsulateData(doc);

	refreshTableState(st, window.tableconf[0], data);

	if (data.getSErrorCode() != "0")
	{
		showErrorDialog(data, "carid", "CAR ID:");//     
		document.getElementById("applybtn").disabled = !btnRightArr.applybtn.right;
	}
}

window.onresize = function()
{
	st.setBodyHeight(getComponetHeight($("cartable"), 60) + "px");
};

function setOptionValue(param)
{
	var showtext = param[0];
	var txtvalue = param[1];
	var elem = param[2];
	var colid = elem.colid;

	var rows = elem.parent.getSelectedRows();
	for ( var i = 0; i < rows.length; i++)
	{
		var cell = elem.parent.getCell(rows[i], colid);
		if (cell.element.isEdit == 0)
		{
			continue;
		}
		elem.parent.setCellValue(cell, colid, txtvalue);
		var showElement = cell.element.showElement;
		cell.element.modify = true;
		cell.element.parentNode.modify = true;
		cell.element.style.backgroundColor = "#d0f946";
		handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		if (showElement.type == 'span' || showElement.type == 'text')
		{
			if (colid == "status")
			{
				showElement.element.innerText = showtext;
			}
			else
			{
				showElement.element.innerText = txtvalue;
			}
		}
		else if (showElement.type == 'select')
		{
			var options = showElement.element.options;
			for ( var j = 0; j < options.length; j++)
			{
				if (options[j].value == txtvalue)
				{
					showElement.element.selectedIndex = j;
					break;
				}
			}
		}
		if (cell.element.editElement.element.onchange)
		{
			cell.element.editElement.element.value = txtvalue;
			cell.element.editElement.element.onchange();
		}
	}
}

function getDataArr()
{
	var customCirOrPirSampleRange = SpecialAttrMgr.getCpAttrListValueByType(obj["neid"],obj["boardType"],"TE_FUNC_CFG_ETH_QOS","QOS_ATTR_CIR_OR_PIR_VALUE_SAMPLE");
	
	opsary = new Array();
	if(obj["boardType"] == BOARD_SL61EFP6  || obj["boardType"] == BOARD_SL61EFP8)
	{
		opsary[0] = new Option("0Kbit/s", 0);
		opsary[1] = new Option("512Kbit/s", 512);
		opsary[2] = new Option("1Mbit/s", 1024);
		opsary[3] = new Option("2Mbit/s", 2048);
		opsary[4] = new Option("3Mbit/s", 3072);
		opsary[5] = new Option("4Mbit/s", 4096);
		opsary[6] = new Option("5Mbit/s", 5120);
		opsary[7] = new Option("6Mbit/s", 6144);
		opsary[8] = new Option("7Mbit/s", 7168);
		opsary[9] = new Option("8Mbit/s", 8192);
		opsary[10] = new Option("9Mbit/s", 9216);
		opsary[11] = new Option("10Mbit/s", 10240);
		opsary[12] = new Option("20Mbit/s", 20480);
		opsary[13] = new Option("30Mbit/s", 30720);
		opsary[14] = new Option("40Mbit/s", 40960);
		opsary[15] = new Option("50Mbit/s", 51200);
		opsary[16] = new Option("90Mbit/s", 92160);
	}else if(customCirOrPirSampleRange != null && 0 < customCirOrPirSampleRange.length)
	{
		for ( var j = 0; j < customCirOrPirSampleRange.length; j++)
		{
			var speedVal = 0;
			var speedStr = customCirOrPirSampleRange[j];
			if(speedStr.indexOf("K") != -1)
			{
				speedVal = speedStr.replace('K','');
			}else if(speedStr.indexOf("M") != -1)
			{
				speedVal = speedStr.replace('M','') * 1024;
			}
			options[j] = new Option(customCirOrPirSampleRange[j] + "bit/s", speedVal);
		}
	}
	else
	{
		opsary[0] = new Option("0Kbit/s", 0);
		opsary[1] = new Option("512Kbit/s", 512);
		opsary[2] = new Option("1Mbit/s", 1024);
		opsary[3] = new Option("2Mbit/s", 2048);
		opsary[4] = new Option("3Mbit/s", 3072);
		opsary[5] = new Option("4Mbit/s", 4096);
		opsary[6] = new Option("5Mbit/s", 5120);
		opsary[7] = new Option("6Mbit/s", 6144);
		opsary[8] = new Option("7Mbit/s", 7168);
		opsary[9] = new Option("8Mbit/s", 8192);
		opsary[10] = new Option("9Mbit/s", 9216);
		opsary[11] = new Option("10Mbit/s", 10240);
		opsary[12] = new Option("20Mbit/s", 20480);
		opsary[13] = new Option("30Mbit/s", 30720);
		opsary[14] = new Option("40Mbit/s", 40960);
		opsary[15] = new Option("50Mbit/s", 51200);
		opsary[16] = new Option("100Mbit/s", 102400);
		opsary[17] = new Option("1000Mbit/s", 1024000);
	}
	return opsary;
}

function newCar()
{
	var newDlgWidth = 400;
	var newDlgHeight = 300;
	if (SYSTEMCONF.getLanguage() == "en")
	{
		newDlgWidth = 480;
	}
	xshowModalDialog("newcardlg.html", RESOURCE["newcar"], newDlgWidth,
			newDlgHeight, "../../../../../images/", "no");
}
