 var protocolType = new Object();
protocolType[1] = "802.1agOAM";
protocolType[2] = "802.3ahOAM";
protocolType[3] = "LAG";
protocolType[4] = "DLAG";
protocolType[5] = "RSTP";
protocolType[6] = "IGMP Snooping";
protocolType[7] = "LCAS";
protocolType[8] = "DBPS";

 var diagnoseInfos = new Object();
diagnoseInfos[0] = "alldata";
diagnoseInfos[1] = "processinfo";
diagnoseInfos[2] = "packetinfo";
diagnoseInfos[3] = "statusdata";
diagnoseInfos[4] = "statisticdata";

var urlObject = getNeProperty(self);//the URL object of this page 
var neID = urlObject.neid; //network element id
var slotID = urlObject.slotid; //slot id
var nmUsrID = urlObject.nmUser ;//network manager userID, write operation log and check right
var nmUserName = urlObject.nmUserName ;//network manager userName

var btnRightArr = new Object();//save to button right

/**
 * initialize this page
 * @param no
 * @return no
 */
function initPage()
{	
	initButton();//initialize buttons
	
	$("protocoltypelabel").innerHTML = RESOURCE["protocoltypelabel"];
	$("diagnoseportlabel").innerHTML = RESOURCE["diagnoseportlabel"];
	$("diagnoseinfolabel").innerHTML = RESOURCE["diagnoseinfolabel"];
	$("faultlable").innerHTML = RESOURCE["faultlable"];
	getAvailablePort();
	initProtocolType();//initialize protocol type
	initDiagnoseInfo();
	getProCheckPara();
	getRightInfo(urlObject, btnRightArr);//call the function which come from the right.js file, get function right;
	
	$("faultbtn").disabled = !btnRightArr.faultbtn.right;
}

/**
 * initialize butons
 * @param no
 * @return no
 */
function initButton()
{
	document.getElementById("faultbtn").value = RESOURCE["faultbtn"];
	
    btnRightArr.faultbtn = new BtnRightObj("faultbtn",TECMDCODE_IP_PROTOCOL_DIAGNOSIS);//come form macrores.js
}

/**
 * initialize protocol type
 * @param no
 * @return no
 */
function initProtocolType()
{
	var protocolTypeEle = document.getElementById("protocolType");
	protocolTypeEle.options[protocolTypeEle.options.length] = new Option(protocolType[5],5);
	protocolTypeEle.options[protocolTypeEle.options.length] = new Option(protocolType[6],6);
	protocolTypeEle.options[protocolTypeEle.options.length] = new Option(protocolType[7],7);
}

/**
 * initialize Diagnose Infomation
 * @param no
 * @return no
 */
function initDiagnoseInfo()
{
    var i;
    for(i in diagnoseInfos)
    {
        $("diagnoseInfo").options[$("diagnoseInfo").options.length] = new Option(RESOURCE[diagnoseInfos[i]],i);
    }
    $("diagnoseInfo").selectedIndex = 1;
}

/**
 * click to resumebtn
 * @param no
 * @return no
 */
function doProtocolResume()
{
	setButtonStatus(false);
	
	var xmlData = constructProtocolResumeXML();//construct the xml of protocol resume 
	var resumeURL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IP_PROTOCOL_RESTORE +"&nmUser="+nmUsrID;// come form macrores.js
	loadXMLdoc(resumeURL, "POST", true, handleProtocolResumeBack, null, "inputdata="+xmlData);//send protocol resume request   	
}

/**
 * construct the xml of protocol resume 
 * @param no
 * return xml
 */
function constructProtocolResumeXML()
{
	var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");  
    
    var thirdlevel = new tagElement("param");              
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",neID);
    secondlevel.appendChild(thirdlevel); 
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", slotID);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "proType");
    var protocolTypeEle = document.getElementById("protocolType");
    var protocolTypeValue = protocolTypeEle.options[protocolTypeEle.selectedIndex].value
    thirdlevel.setAttribute("value", protocolTypeValue);      
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
}

/**
 * handle protocol resume callback
 * @param doc
 * @return no
 */
function handleProtocolResumeBack(doc)
{
	var data = EncapsulateData(doc);
	
	setButtonStatus(true);
	
	if( 0 == data.getSErrorCode() )
	{
	    var error = new AllError();
		var eTag = new ErrorTag();
		eTag.code = "succ";
		eTag.info = RESOURCE["optSucc"];
		error.s_error = eTag;
		openErrPage("../../../../../page/", error, ""); 
	}
	else
	{
		handleErrInfo(data);
	}
}

/**
 * click to faultbtn
 * @param no
 * @return no
 */
function doFaultDiagnose()
{	
	var xmlData = constructFaultDiagnoseXML();//construct the xml of protocol resume 
	var faultURL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IP_PROTOCOL_DIAGNOSIS +"&nmUser="+nmUsrID;//? come form macrores.js
	loadXMLdoc(faultURL, "POST", true, handleFaultDiagnoseBack, null, "inputdata="+xmlData);//send fault diagnose request   	
}


/**
 * construct the xml of fault diagnose 
 * @param no
 * return xml
 */
function constructFaultDiagnoseXML()
{
	return constructProtocolResumeXML();
}

/**
 * handle fault diagnose callback
 * @param doc
 * @return no
 */
function handleFaultDiagnoseBack(doc)
{
	var data = EncapsulateData(doc);
	var faultContext = document.getElementById("faultcontext");
	faultContext.value = "";
	setButtonStatus(true);
	
	if( 0 != data.getSErrorCode() )
	{
		handleErrInfo(data);
	}
	else
	{
		var diObj;
		for(var i = 0, size = data.getDataRowLength(); i < size; i++)
		{
	    diObj = data.rows[i];
	    faultContext.value = faultContext.value+ '\n' + diObj["diagnosisInfo"].value;
 		}
	}
}

/**
 * handle operate error
 * @param datainterface data
 * @return no
 */
function handleErrInfo(data)
{
	var errArr = [];//define errors object
	errArr.push("nename");
	errArr.push("slotid");
	errArr.push("boardname");
	
	openErrPage("../../../../../page/", data.getError(), errArr);//open the error page
}

/**
 * set buttons status
 * @param btnStatus
 * @return no
 */
function setButtonStatus(btnStatus) 
{
	$("faultbtn").disabled = !(btnStatus && btnRightArr.faultbtn.right);
}

/**
 * protocol type select changed
 * @param no
 * @return no
 */
function protocolType_OnChange()
{
}

function faultbtn_OnClick()
{
	setButtonStatus(false);
	setProCheckPara();
}

/**
 * create get port xml
 * @param no
 * @return no
 */
function createGetPortXML()                                            
{                                                                         
    var root = new inputxml("datainterface"); 
    var firstlevel = new tagElement("bussiness-params");      
    var secondlevel = new tagElement("row-params"); 
          
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neID);
    secondlevel.appendChild(thirdlevel); 
	  
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", slotID);
    secondlevel.appendChild(thirdlevel);
	                         
    firstlevel.appendChild(secondlevel);     
    root.getRoot().appendChild(firstlevel); 
    return root.toString();                              
}
/**
 * get available port
 * @param no
 * @return no
 */
function getAvailablePort()
{
    var xmldata = createGetPortXML();
    var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_GET_ETH_MACFORBID_AVAILPORT+"&nmUser=" + nmUsrID;
    loadXMLdoc(url, "POST", false, handleGetPortData, null, "inputdata=" + xmldata);
}

/**
 * get available port back function
 * @param no
 * @return no
 */
function handleGetPortData(doc)
{
    var portDoc = EncapsulateData(doc);
    var tempObj;
    $("diagnosePort").options[0] = new Option(RESOURCE["allport"],0);
    for(var i = 0, datalen = portDoc.getDataRowLength(); i < datalen; i++)
    {
        $("diagnosePort").options[$("diagnosePort").options.length] = new Option(portDoc.getDataRowParam(i, "portname"), portDoc.getDataRowParam(i, "port"));
    }
}

/**
 * create get procheckpara xml
 * @param no
 * @return no
 */
function createGetProCheckParaXML()
{
    var root = new inputxml("datainterface"); 
    var firstlevel = new tagElement("bussiness-params");      
    var secondlevel = new tagElement("row-params"); 
          
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neID);
    secondlevel.appendChild(thirdlevel); 
	  
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", slotID);
    secondlevel.appendChild(thirdlevel);
	
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "proType");
    thirdlevel.setAttribute("value", $("protocolType").options[$("protocolType").selectedIndex].value);
    secondlevel.appendChild(thirdlevel);
                           
    firstlevel.appendChild(secondlevel);     
    root.getRoot().appendChild(firstlevel); 
    return root.toString(); 
}

/**
 * get ProCheckPara
 * @param no
 * @return no
 */
function getProCheckPara()
{
    var xmldata = createGetProCheckParaXML();
    var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_GET_PROCHECKPARA+"&nmUser=" + nmUsrID;
    loadXMLdoc(url, "POST", false, handleGetProCheckPara, null, "inputdata=" + xmldata);
}

/**
 * get ProCheckPara back function 
 * @param no
 * @return no
 */
function handleGetProCheckPara(doc)
{
    var data = EncapsulateData(doc);
    if( 0 != data.getSErrorCode() )
    {
        handleErrInfo(data);
    }
    else
    {
        var diagnoseport;
        var diagnoseinfo;
        for(var i = 0, size = data.getDataRowLength(); i < size; i++)
        {
            diagnoseport = data.getDataRowParam(i,"diagnoseport");
            $("diagnosePort").value = diagnoseport;
            diagnoseinfo = data.getDataRowParam(i,"diagnoseinfo");
            $("diagnoseInfo").value = diagnoseinfo;
				}
    }
}


function createSetProCheckParaXML()
{
    var root = new inputxml("datainterface"); 
    var firstlevel = new tagElement("bussiness-params");      
    var secondlevel = new tagElement("row-params"); 
          
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neID);
    secondlevel.appendChild(thirdlevel); 
	  
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", slotID);
    secondlevel.appendChild(thirdlevel);
	
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "proType");
    thirdlevel.setAttribute("value", $("protocolType").options[$("protocolType").selectedIndex].value);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "diagnoseport");
    thirdlevel.setAttribute("value", $("diagnosePort").options[$("diagnosePort").selectedIndex].value);
    secondlevel.appendChild(thirdlevel);  
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "diagnoseinfo");
    thirdlevel.setAttribute("value", $("diagnoseInfo").options[$("diagnoseInfo").selectedIndex].value);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);     
    root.getRoot().appendChild(firstlevel); 
    return root.toString(); 
}

function setProCheckPara()
{
    var xmldata = createSetProCheckParaXML();
    var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_SET_PROCHECKPARA+"&nmUser=" + nmUsrID;
    loadXMLdoc(url, "POST", false, handleSetProCheckPara, null, "inputdata=" + xmldata);
}

function handleSetProCheckPara(doc)
{
    var data = EncapsulateData(doc);
    if( 0 != data.getSErrorCode() )
    {
    		setButtonStatus(true);
        handleErrInfo(data);
    }
    else
    {
        doFaultDiagnose();
    }
}
