 
language = SYSTEMCONF.getLanguage();

document.title = RESOURCE["portmirrormgr"];

var win = getParentWindow();

var TBE = "1067";

var EGSH = "1557";

var winurlobj = getNeProperty(win.document);

var portList = new Array();
var tmpValue = "";

var subrackid = -1;
var subrackname = "";
var showslotid = winurlobj["slotid"];

function initPage()
{
	getSupportPort();
	createButton();    
	createTable();
}

function getSupportPort()
{
	var xml = createXML();	
	var URL = "../../../../../neExlorerServlet?sfid="+TECMDCODE_PORTMIRROR_GETPORT+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(URL,"POST",false,getPortCallBack,null,"inputdata="+xml);
}

function createXML()
{
	var di =new inputxml("datainterface");
  var bussiness = new tagElement("bussiness-params");
  var row = new tagElement("row-params");
  var param = new tagElement("param");
  
  var neid = winurlobj["neid"];
  param.setAttribute("name","neid");
  param.setAttribute("value",neid);
  row.appendChild(param);
  
  param = new tagElement("param");
  var slotid = winurlobj["slotid"];
  param.setAttribute("name","slotid");
  param.setAttribute("value",slotid);
  row.appendChild(param);
  
  param = new tagElement("param");
  var boardType = winurlobj["boardType"];
  param.setAttribute("name","boardType");
  param.setAttribute("value",boardType);
  row.appendChild(param);
  
  bussiness.appendChild(row);
  di.getRoot().appendChild(bussiness);
  
  return di.toString();
}

function getPortCallBack(doc)
{
	var data = EncapsulateData(doc);
	boardname = data.getDataRowParam(0, "boardname");
	subrackid = data.getDataRowParam(0, "subrackid");
	subrackname = data.getDataRowParam(0, "subrackname");
	showslotid = data.getDataRowParam(0, "showslotid");
	for(var i=0,len=data.getDataRowLength();i<len;i++)
	{
		portList[i] = data.getDataRowParam(i, "portid");
		for (var j = portList[i].length; j<5; j++)
		{
		  portList[i] = "0" + portList[i];
		}
	}
	if(portList.length != 0)
	{
    portList.sort();	
	}	
}

function createButton()
{	
	$("submitbtn").value=RESOURCE["okbutton"];
	$("cancel").value=RESOURCE["cancelbutton"];
	$("apply").value=RESOURCE["applybutton"];

}

function refreshOption(atom,portList)
{
	atom.clearOptions();
		atom.addOption("/","-1");
	for(var i=0,len=portList.length;i<len;i++)
	{		
		atom.addOption(getPortName(portList[i]),portList[i]);
	}
}

function getShowName()
{
	var str = "";
	if (subrackid >= 0)
	{
		str = subrackname + "-" + showslotid + "-" + boardname;
	}
	else
	{
		str = winurlobj["slotid"]+"-"+boardname;
	}
	return str;
}

function createTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"],RESOURCE["value"]);
    
    var atom = new Atom("span");
    atom.setValue(getShowName());
    atom.element.style.width="100%";
    ct.addAttrRow("board",RESOURCE["board"],atom);
    
    atom = new Atom("select");
    var portList = getPortList();
    for(var i=0,len=portList.length;i<len;i++)
    {
       /*if(winurlobj["boardType"] != EGSH)
       {
       		if((parseInt(portList[i]) > 32768) && (winurlobj["boardType"] != TBE ))
       		{
       	 			continue;
       		}
       }*/
       atom.addOption(getPortName(portList[i]),portList[i]);
    }
    ct.addAttrRow("mirrorport",RESOURCE["mirrorport"],atom);
    tmpValue = portList[0];
    portList.splice(0,1);
    
    atom.element["onchange"] = function()
    {
	    portList.push(tmpValue);
	    portList.sort();
	    for(var i=0,len=portList.length;i<len;i++)
      {
  	    if(this.value == portList[i])
  	    {
  	        tmpValue = portList[i];
  		    portList.splice(i,1);
  	    }
      }
      refreshOption(ct.getAtom("upmirrorport"),portList);
      	refreshOption(ct.getAtom("downmirrorport"),portList);
    }
    
    atom = new Atom("select");
    	atom.addOption("/","-1");
    for(var i=0,len=portList.length;i<len;i++)
    {
        atom.addOption(getPortName(portList[i]),portList[i]);
    }
    ct.addAttrRow("upmirrorport",RESOURCE["upmirrorport"],atom);
    
    atom = new Atom("select");
    	atom.addOption("/","-1");
    
    {
    	for(var i=0,len=portList.length;i<len;i++)
    	{
         atom.addOption(getPortName(portList[i]),portList[i]);
    	} 
    }
    {
    }
    ct.addAttrRow("downmirrorport",RESOURCE["downmirrorport"],atom);

    document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

function getPortList()
{
   return portList;
}

function getPortName(portID)
{
    var portName;
    var portid = parseInt(portID,10);
    if(0x8000 < portid)
    {
    	portName = "VCTRUNK" + (portid - 0x8000);
    }
    else
    {
    	portName = "PORT" + portid;
    }
    
    return portName;
}

function createXMLData()
{
	var neid = winurlobj["neid"];
	var slotid = winurlobj["slotid"];
	var mirrorport = ct.getAttrValue("mirrorport");
	var upmirrorport = ct.getAttrValue("upmirrorport");
	var downmirrorport = ct.getAttrValue("downmirrorport");
	if(downmirrorport == "" || downmirrorport == null)
	{
	  	downmirrorport = "65535";
	}
	
  var di =new inputxml("datainterface");
  var bussiness = new tagElement("bussiness-params");
  var row = new tagElement("row-params");
  var param = new tagElement("param");

  param.setAttribute("name","neid");
  param.setAttribute("value",neid);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name","slotid");
  param.setAttribute("value",slotid);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name","mirrorport");
  param.setAttribute("value",mirrorport);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name","upportid");
  param.setAttribute("value",upmirrorport);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name","downportid");
  param.setAttribute("value",downmirrorport);
  row.appendChild(param);

  bussiness.appendChild(row);
  di.getRoot().appendChild(bussiness);
	
  return di.toString();
}

function sendCreateInfo(flag)
{	
	var mirrorport = ct.getAttrValue("mirrorport");
	var upmirrorport = ct.getAttrValue("upmirrorport");
  if(mirrorport == upmirrorport)
	{   
		alert(RESOURCE["cantEqual"]);
		return;
	}
	
 	$("submitbtn").disabled = true;
  $("cancel").disabled = true;   
  $("apply").disabled = true; 
  
  var xml = createXMLData();
  var URL = "../../../../../neExlorerServlet?sfid="+TE_FUNC_CFG_SET_PORTMIRROR+"&nmUser="+winurlobj["nmUser"];
  loadXMLdoc(URL,"POST",true,PostCallBackHandler,flag,"inputdata="+xml);
}

function PostCallBackHandler(doc,flag)
{
	 	$("submitbtn").disabled = false;
	  $("cancel").disabled = false;   
	  $("apply").disabled = false; 
	  
    var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(data);
    	return;
    }
    
    win.sendQueryInfo();
    
    if(flag)
    {
    	xcloseDialog();
    }
}

function showErrorDialog(data)
{
	var errArr = [];
  errArr[0] = "nename";
  errArr[1] = "slotid";
  errArr[2] = "boardname";
  openErrPage("../../../../../page/", data.getError(), errArr); 
}
