
var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var slotID = winurlobj.winurlobj["slotid"];
var btnRightArr = new Object();
var OPRSUCC = 0;
var OPRPART = 1;
var FAIL = 2;
var MIN_HOPCOUNT = "1";
var MAX_HOPCOUNT = "40";
var MIN_DIAMETER = "2";
var MAX_DIAMETER = "7";
var MIN_HELLOTIME = "1";
var MAX_HELLOTIME = "10";
var MIN_MAXAGE = "6";
var MAX_MAXAGE = "40";
var MIN_FORWARDDELAY = "4";
var MAX_FORWARDDELAY = "30";
var st;
var selectedRowID = 0;
var tc;
var IN_STP = "42457";
var VRF_SHORT = "43874"
var INVALID = "255";

var isLoadOver = false; //          

var pathCostStandard = new Object();
pathCostStandard["0"] = "dot1d";
pathCostStandard["1"] = "dot1t";

var enable = new Object();
enable["0"] = "disable";
enable["1"] = "enable";

function initPage()
{
   isLoadOver = false;
   createTable();
   initButtonText();
}


function createTable()
{
   st = new SortTable();
   st.setImage( "../../../../../images/" );
   tc = window.tableconf[0];
   createTableHead( st, tc );
   st.setOnCellEditHandler( cellEditHandler );
   st.element.style.width = "100%";
   $( "protectteam" ).appendChild( st.getTable() );
   $( "protectteam" ).oncontextmenu = popupMenuHandler;
   st.setBodyHeight( "170px" );
}

function cellEditHandler( param )
{
   $( "applybtn" ).disabled = ! btnRightArr.applybtn.right;

	/**
	 * AU9D26145
	 *                                    
	 *                            ,                      /
	 */
   var colid = param.colid;
   if ( "helloTime" == colid || "maxAge" == colid || "forwardDelay" == colid )
   {
      var cell = st.getCell( 0, "netDiameter" );
      cell.element.showElement.setValue( "/" );
      st.setCellValue( cell, "netDiameter", "/" );
   }
}

function tabSelectHandler()
{
   if( - 1 != winurlobj.selectedRowID_last && selectedRowID != winurlobj.selectedRowID_last && btnRightArr.querybtn.right )
   {
      selectedRowID = winurlobj.selectedRowID_last;
      sendQueryInfo( selectedRowID );
   }
   
   if(!isLoadOver)
   {
      sendQueryInfo(winurlobj.selectedRowID_last);
   }
}

function sendQueryInfo( selectedRowID )
{
   if ( null == selectedRowID || selectedRowID == "-1")
   {
      return;
   }

   $( "querybtn" ).disabled = true;
   $( "applybtn" ).disabled = true;

   var xmlstr = createQueryXML( selectedRowID );

   var urlreq = "../../../../../neExlorerServlet?sfid=" + TE_ETH_QUERY_BRIDGE_PARAMETER + "" + "&nmUser=" + winurlobj.winurlobj["nmUser"];
   loadXMLdoc( urlreq, "POST", true, handleBackQuery, null, "inputdata=" + xmlstr );
}


function createQueryXML( selectedRowID )
{
   var di = new inputxml( "datainterface" );
   var bussiness = new tagElement( "bussiness-params" );
   var row = new tagElement( "row-params" );

   var param = new tagElement( "param" );
   param.setAttribute( "name", "neid" );
   param.setAttribute( "value", neid );
   row.appendChild( param );

   param = new tagElement( "param" );
   param.setAttribute( "name", "slotid" );
   param.setAttribute( "value", slotID );
   row.appendChild( param );

   param = new tagElement( "param" );
   param.setAttribute( "name", "vbid" );
   param.setAttribute( "value", winurlobj.st.getCellStoreValue( selectedRowID, "vbid", "vbid" ) );
   row.appendChild( param );

   bussiness.appendChild( row );
   di.getRoot().appendChild( bussiness );
   return di.toString();
}

function handleBackQuery( doc )
{
   $( "querybtn" ).disabled = ! btnRightArr.querybtn.right;

   var data = EncapsulateData( doc );
   var errCode = data.getSErrorCode();
   if ( 0 != errCode )
   {
      var len = data.getBErrLength();
      for ( var i = len - 1 ; i >= 0; i -- )
      {
         if ( IN_STP == data.errObj.rowErrors[i].error.code||VRF_SHORT == data.errObj.rowErrors[i].error.code)
         {
            data.errObj.rowErrors.removeAt( i );
            len -- ;
         }
      }
      if ( 0 == len && ( OPRPART == errCode || FAIL == errCode ) )
      {
         data.errObj.s_error.code = 0;
      }
      else
      {
         
         for ( var i = 0; i < data.getBErrLength(); i ++ )
         {
            var tempObj = data.getError().rowErrors[i].errorObj;
            tempObj["opObjName"] = RESOURCE["portGroup"];
         }
   	  	 showErrDlg(data,"vbid");

      }
	  
      isLoadOver = true;
   }

   if ( OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode() )
   {
      st.clearTableData();
      createTableBody( st, tc, data, RESOURCE );

      addCellEvent();

      if( 0 < st.getDataRowLength() )
      {
         if( ! st.element.colsArray.selectedId )
         {
            st.element.colsArray.selectedId = "vbid";
            st.element.colsArray.imgflag = 1;
         }

         var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
         st.sortRows( td, st.element.colsArray.imgflag );
      }
   }
}

function addCellEvent()
{
   var cell = null;
   for( var i = 0, len = st.getDataRowLength();i < len;i ++ )
   {
      cell = st.getCellElement( i, "mstMaxHop" );
      if ( "-1" == cell.innerText || "" == cell.innerText.trim())
      {
         cell.showElement.element.innerText = "-";
         st.setCellIsEdit(st.getCell(i,"mstMaxHop"),0);
      }
      else
      {
         textCheck( cell.editElement.element, MIN_HOPCOUNT, MAX_HOPCOUNT );
      }

      cell = st.getCellElement( i, "netDiameter" );
      if ( INVALID == cell.innerText )
      {
         cell.showElement.setValue( "/" );
      }
      textCheck( cell.editElement.element, MIN_DIAMETER, MAX_DIAMETER );
      cell.editElement.element["onchange"] = function()
      {
         var netDiameter = this.value;
         changeValue( "helloTime", 2 );

         switch( netDiameter )
         {
            case "2" :
               changeValue( "maxAge", 10 );
               changeValue( "forwardDelay", 7 );
               break;
            case "3" :
               changeValue( "maxAge", 12 );
               changeValue( "forwardDelay", 9 );
               break;
            case "4" :
               changeValue( "maxAge", 14 );
               changeValue( "forwardDelay", 10 );
               break;
            case "5" :
               changeValue( "maxAge", 16 );
               changeValue( "forwardDelay", 12 );
               break;
            case "6" :
               changeValue( "maxAge", 18 );
               changeValue( "forwardDelay", 13 );
               break;
            case "7" :
               changeValue( "maxAge", 20 );
               changeValue( "forwardDelay", 15 );
               break;
         }
      }

      cell = st.getCellElement( i, "helloTime" );
      textCheck( cell.editElement.element, MIN_HELLOTIME, MAX_HELLOTIME );

      cell = st.getCellElement( i, "maxAge" );
      textCheck( cell.editElement.element, MIN_MAXAGE, MAX_MAXAGE );

      cell = st.getCellElement( i, "forwardDelay" );
      textCheck( cell.editElement.element, MIN_FORWARDDELAY, MAX_FORWARDDELAY );
   }
}

function changeValue( colid, value )
{
   var cell = st.getCell( 0, colid );
   cell.element.showElement.setValue( value );
   st.setCellValue( cell, colid, value );
}

function isValidateInput( obj )
{
   var str = obj.value.split( "," );
   if ( "" != str )
   {
      var pattern1 = new RegExp( "^\\d+$", "i" );
      var pattern2 = new RegExp( "^\\d+-\\d+$", "i" );

      for( var i = 0; i < str.length; i ++ )
      {
         var b = str[i].indexOf( "-" ) != - 1;
         if( b )
         {
            if( ! pattern2.test( str[i] ) )
            {
               alert( RESOURCE["inputFormat"] );
            }
         }
         else
         {
            if( ! pattern1.test( str[i] ) )
            {
               alert( RESOURCE["inputFormat"] );
            }
         }
      }

      for( var i = 0; i < str.length; i ++ )
      {
         var b = str[i].indexOf( "-" ) != - 1;
         if( b )
         {
            var range = str[i].split( "-" );
            var rangeStart = parseInt( range[0] );
            var rangeEnd = parseInt( range[1] );

            if ( rangeEnd < rangeStart )
            {
               alert( RESOURCE["startEnd"] );
            }
         }
      }
   }

   obj.style.position = "static";
   obj.style.border = "1px solid #999999";
   obj.style.width = obj.parentNode.offsetWidth;
   obj.parentNode.showElement.element.style.display = "";
   var rows = obj.parentNode.parent.getSelectedRows();
   for( var j = 0; j < rows.length; j ++ )
   {
      var cell =  obj.parentNode.parent.getCell( rows[j], obj.parentNode.colid );
      if( null == cell.element.editElement || cell.element.isEdit == 0 )
      {
         continue;
      }
      cell.element.showElement.setValue( obj.value );

      cell.element.modify = true;
      cell.element.parentNode.modify = true;
      cell.element.style.backgroundColor = "#d0f946";
      cell.element.parent.setTdCellValue( cell.element, obj.parentNode.colid, obj.value );
      cell.element.showElement.element.style.display	 = 	"";
      handleCellEdit( cell.element, TABLE_CONSTANT.AFTEREDIT );
   }
   obj.style.display = "none";
   obj.parentNode.showElement.element.style.display	 = 	"";

   handleCellEdit( obj.parentNode, TABLE_CONSTANT.AFTEREDIT );
}

function initButtonText()
{
   $( "querybtn" ).value = RESOURCE["querybtn"];
   $( "applybtn" ).value = RESOURCE["applybtn"];
   btnRightArr.querybtn = new BtnRightObj( "querybtn", TE_QUERY_BRIDGE_PARAMETER );
   btnRightArr.applybtn = new BtnRightObj( "applybtn", TE_APPLY_BRIDGE_PARAMETER );

   getRightInfo( winurlobj.winurlobj, btnRightArr )
   initrightbtn( btnRightArr );

   if( btnRightArr.querybtn.right )
   {
   }
}

function sendApplyInfo()
{
   var xmlstr = createApplyXML();
   if ( null == xmlstr )
   {
      return;
   }
   
   if (!xmlstr)
   {
      alert( RESOURCE["inputMSTName"] );
      return;
   }

   $( "querybtn" ).disabled = true;
   $( "applybtn" ).disabled = true;

   var urlreq = "../../../../../neExlorerServlet?sfid=" + TE_ETH_APPLY_BRIDGE_PARAMETER + "" + "&nmUser=" + winurlobj.winurlobj["nmUser"];
   loadXMLdoc( urlreq, "POST", true, handleBackApply, null, "inputdata=" + xmlstr );
}

function createApplyXML()
{
   var di = new inputxml( "datainterface" );
   var bussiness = new tagElement( "bussiness-params" );
   var row = new tagElement( "row-params" );

   var param = new tagElement( "param" );
   param.setAttribute( "name", "neid" );
   param.setAttribute( "value", neid );
   row.appendChild( param );
   bussiness.appendChild( row );

   var st1 = winurlobj.st;
   for( var rowindex = 0, rowlen = st1.getDataRowLength();
   rowindex < rowlen;
   rowindex ++ )
   {
      if( ! st1.getModify( rowindex ) )
      {
         continue;
      }
      row = new tagElement( "row-params" );

      param = new tagElement( "param" );
      param.setAttribute( "name", "slotid" );
      param.setAttribute( "value", slotID );
      row.appendChild( param );

      param = new tagElement( "param" );
      param.setAttribute( "name", "vbid");
      param.setAttribute( "value", st1.getCellStoreValue( rowindex, "vbid", "vbid" ) );
      row.appendChild( param );

      
      param = new tagElement( "param" );
      param.setAttribute( "name", "mstFieldName" );
      var mstName = st1.getCellStoreValue( rowindex, "mstFieldName", "mstFieldName" )
      if(mstName == null || mstName == "-")
      {
         return false;
       }
       param.setAttribute( "value", mstName );
       row.appendChild( param );
     

      if ( st1.getCellModify( rowindex, "modifyLevel" ) )
      {
         param = new tagElement( "param" );
         param.setAttribute( "name", "modifyLevel" );
         param.setAttribute( "value", st1.getCellStoreValue( rowindex, "modifyLevel", "modifyLevel" ) );
         row.appendChild( param );
      }

      if ( st1.getCellModify( rowindex, "mappingModel" ) )
      {
         param = new tagElement( "param" );
         param.setAttribute( "name", "mappingModel" );
         param.setAttribute( "value", st1.getCellStoreValue( rowindex, "mappingModel", "mappingModel" ) );
         row.appendChild( param );
      }

      bussiness.appendChild( row );
   }

   var length = st.getDataRowLength();
   if ( 0 < length )
   {
      portGroupID = st.getCellStoreValue( 0, "vbid", "vbid" );
      for( var rowindex = 0; rowindex < length; rowindex ++ )
      {
         if( ! st.getModify( rowindex ) )
         {
            continue;
         }
         row = new tagElement( "row-params" );

         param = new tagElement( "param" );
         param.setAttribute( "name", "slotid" );
         param.setAttribute( "value", slotID );
         row.appendChild( param );

         param = new tagElement( "param" );
         param.setAttribute( "name", "vbid" );
         param.setAttribute( "value", portGroupID );
         row.appendChild( param );

         if ( st.getCellModify( rowindex, "mstMaxHop" ) )
         {
            param = new tagElement( "param" );
            param.setAttribute( "name", "mstMaxHop" );
            param.setAttribute( "value", st.getCellStoreValue( rowindex, "mstMaxHop", "mstMaxHop" ) );
            row.appendChild( param );
         }

         var netDiameter = st.getCellStoreValue( rowindex, "netDiameter", "netDiameter" );
         if ( "/" != netDiameter && st.getCellModify( rowindex, "netDiameter" ) )
         {
            param = new tagElement( "param" );
            param.setAttribute( "name", "netDiameter" );
            param.setAttribute( "value", netDiameter );
            row.appendChild( param );
         }
         else
		 {
             if ( st.getCellModify( rowindex, "helloTime" )
             || st.getCellModify( rowindex, "maxAge" )
             || st.getCellModify( rowindex, "forwardDelay" ) )
             {
                var helloTime = st.getCellStoreValue( rowindex, "helloTime", "helloTime" );
                var maxAge = st.getCellStoreValue( rowindex, "maxAge", "maxAge" );
                var forwardDelay = st.getCellStoreValue( rowindex, "forwardDelay", "forwardDelay" );
                if ( 2 * ( parseInt( helloTime ) + 1 ) > parseInt( maxAge )
                || parseInt( maxAge ) > ( 2 * ( parseInt( forwardDelay ) - 1 ) ) )
                {
                   alert( RESOURCE["timeParam"] );
                   return null;
                }

                param = new tagElement( "param" );
                param.setAttribute( "name", "helloTime" );
                param.setAttribute( "value", st.getCellStoreValue( rowindex, "helloTime", "helloTime" ) );
                row.appendChild( param );

                param = new tagElement( "param" );
                param.setAttribute( "name", "maxAge" );
                param.setAttribute( "value", st.getCellStoreValue( rowindex, "maxAge", "maxAge" ) );
                row.appendChild( param );

                param = new tagElement( "param" );
                param.setAttribute( "name", "forwardDelay" );
                param.setAttribute( "value", st.getCellStoreValue( rowindex, "forwardDelay", "forwardDelay" ) );
                row.appendChild( param );
             }
         }

         bussiness.appendChild( row );
      }
   }

   di.getRoot().appendChild( bussiness );
   return di.toString();
}

function handleBackApply( doc )
{
   var data = EncapsulateData( doc );

   if ( OPRSUCC != data.getError().getGlobleECode() )
   {

       for ( var i = 0; i < data.getBErrLength(); i ++ )
       {
          var tempObj = data.getError().rowErrors[i].errorObj;
          tempObj["opObjName"] = RESOURCE["portGroup"];
       }
 	   showErrDlg(data,"vbid");
 	  	 
      $( "applybtn" ).disabled = ! btnRightArr.applybtn.right;
      $( "querybtn" ).disabled = ! btnRightArr.querybtn.right;
   }

   if ( OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode() )
   {
      refreshTableState( winurlobj.st, winurlobj.window.tableconf[0], data );
      refreshTableState( st, tc, data );

      $( "querybtn" ).disabled = ! btnRightArr.querybtn.right;
   }
}

window.onhelp = F1;


function F1()
{
	if(SYSTEMCONF.getStatus() == 1 && SYSTEMCONF.getM2000() == 0){
	 	return;
	}
	var pos=document.location.href.lastIndexOf("/");
	var page=document.location.href.substring(pos+1);
	var pagename=page.substring(0,page.indexOf("."));
	
	var pagename = "bridgeparam1";

	if (pagename == "tabs")
	{
		return false;
	}
	var pagepos=document.location.href.indexOf("page");

  var neProperty = getNeProperty(top);
  if((neProperty == null) || (neProperty.neversion == null))
  {
  	try
		{
  		neProperty = getNeProperty(getParentWindow().top);
  	}
  	catch(e)
  	{
  		neProperty = null;
  	}
  	if((neProperty == null) || (neProperty.neversion == null))
		{
			try
			{
				neProperty = getNeProperty(getParentWindow().getParentWindow().top);
			}
			catch(e)
			{
				neProperty = null;
			}
		}
  }	
	
	var urlprefix=document.location.href.substr(0,pagepos);
	var newUrl = null;
	if(neProperty != null)
	{
  	var temUrl = urlprefix.substring(0,urlprefix.length-1);
  	newUrl = temUrl.substring(0,temUrl.lastIndexOf("/")) + "/";
  }
  else
  {
  	newUrl = urlprefix;
  }

  if( neProperty.neType == 79 )
	{
		newUrl = newUrl.replace("ne_51","ne_79");
	}

  loadXMLdoc(newUrl+"help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig); 	
	var helpurl = urlidMap[pagename];
	if(null == helpurl)
	{
		if(null != document.referrer && "" != document.referrer)
		{
			pos = document.referrer.lastIndexOf("/");
			page = document.referrer.substring(pos+1)
			pagename = page.substring(0,page.indexOf("."));			
			helpurl = urlidMap[pagename];
	  }
	  else
	  {
	      var parentWin = getParentWindow();
	      if(parentWin)
	      {
	          pos = parentWin.location.toString().lastIndexOf("/");
		  page = parentWin.location.toString().substring(pos+1)
		  pagename = page.substring(0,page.indexOf("."));
		  helpurl = urlidMap[pagename];	
	      }
	  }
	}
	helpurl=newUrl+helpurl;

	if( neProperty.neType == 79 )
	{
		helpurl = helpurl.replace("ne_51","ne_79");
	}
	

  open_HelpWindow(helpurl, null);
  return false;
}

function showErrDlg(result,opObject)
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	errArr[3] = "portname";
	errArr[4] = "opObjName";
	errArr[5] = opObject;
	openErrPage("../../../../../page/", result.getError(), errArr);
}
