 //global variable
var obj = getNeProperty(parent);
var neid = obj.neid;
var slotId = obj.slotid;
var boardName = "L4G";
if (obj.boardType == 1067)
{
	boardName = "TBE";
}

var boardNameTemp = SpecialAttrMgr.getCPAttrValue(obj['neid'],obj['slotid'],"","IGMP_ATTR_STATICBOARD_BOARDNAME");
if(boardNameTemp != null)
{
	boardName = boardNameTemp;
}

var resource = null;
var boardType = obj.boardType;
var btnRightArr = new Object();
var st0,st1;

window.onload = function()
{
		initTable();
		initRight();
		initButton();
		/*
		if (btnRightArr["querybtn"].right)
		{
				staticBroadcastQuery();
		} */
}

function initTable()
{
	st0 = new SortTable();
    st0.setImage("../../../../../images/");
    createTableHead(st0, window.tableconf[0]);
    st0.setOnRowSelectHandler(rowSelectHandler);
    $("staticbc").appendChild(st0.getTable());
    $("staticbc").oncontextmenu = popupMenuHandler;
    st0.setBodyHeight(getTableHeight($("staticbc"), st0) + "px");
    
    st1 = new SortTable();
    st1.setImage("../../../../../images/");
    createTableHead(st1, window.tableconf[1]);
    $("vbport").appendChild(st1.getTable());
    $("vbport").oncontextmenu = popupMenuHandler;
    st1.setBodyHeight(getTableHeight($("vbport"), st1) + "px");
}

function initButton()
{
		$("querybtn").value = RESOURCE["querybtn"];
		$("createbtn").value = RESOURCE["createbtn"];
		$("deletebtn").value = RESOURCE["deletebtn"];		
		$("modifybtn").value = RESOURCE["modifybtn"];
		
		$("deletebtn").disabled = true;
		$("modifybtn").disabled = true;		
}

function initRight()
{
	btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_STATICIGMP_TABLE);
	btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_CREATE_STATICIGMP_TABLE);
	btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_DELETE_STATICIGMP_TABLE);
	btnRightArr.modifybtn = new BtnRightObj("modifybtn", TECMDCODE_MODIFY_STATICIGMP_TABLE);
    
    getRightInfo(obj, btnRightArr);
    initrightbtn(btnRightArr);
}

function tabSelectHandler()
{
    if(!$("querybtn").disabled)
    {
  			staticBroadcastQuery();
    }
}

function rowSelectHandler(param)
{
	st1.clearTableData();
    if (param.length > 0)
    {
    	$("deletebtn").disabled = !btnRightArr.deletebtn.right;
    	if (param.length == 1)
    	{    		
    		$("modifybtn").disabled = !btnRightArr.modifybtn.right;
			var rowIndex = param[0];
			var vbid = st0.getCellStoreValue(rowIndex, "vbid", "vbid");
			var vlanid = st0.getCellStoreValue(rowIndex, "vlanid", "vlanid");
			var mac = st0.getCellStoreValue(rowIndex, "mac", "mac");
			var snoopObj = getSnoopingObj(vbid, vlanid, mac);
		
			fillSt1Table(snoopObj);
		}
		else
		{
			$("modifybtn").disabled = true;
		}
	}
	else
	{
		$("deletebtn").disabled = true;
		$("modifybtn").disabled = true;
	}
}

function fillSt1Table(obj)
{
	var root = document.createElement("datainterface");      
  	var firstlevel = document.createElement("bussiness-params");
    
    for (var i=0,len=obj.portList.length; i<len; i++)
    {
    	var secondlevel = document.createElement("row-params");
   	
   		var thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "slotid");
   		thirdlevel.setAttribute("value", obj.slotid);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "boardname");
   		thirdlevel.setAttribute("value", obj.boardname);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "vbid");
   		thirdlevel.setAttribute("value", obj.vbid);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "mac");
   		thirdlevel.setAttribute("value", convertMAC(obj.mac));
   		secondlevel.appendChild(thirdlevel);
   		
   		var vlanid = obj.vlanid;
   		if (parseInt(obj.vlanid) == 0xfffe)
		{
			vlanid = "-";
		}
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "vlanid");
   		thirdlevel.setAttribute("value", vlanid);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = document.createElement("param");
  		thirdlevel.setAttribute("name", "port");
   		thirdlevel.setAttribute("value", obj.portList[i] - 28672);
   		secondlevel.appendChild(thirdlevel);	
   		firstlevel.appendChild(secondlevel);
    }    
    root.appendChild(firstlevel);    
    createTableBody(st1, window.tableconf[1], EncapsulateData(root), RESOURCE);
}

function staticBroadcastQuery()
{
		$("querybtn").disabled = true;
		$("createbtn").disabled = true;
		$("deletebtn").disabled = true;
		$("modifybtn").disabled = true;
		
		var xmldata = createQueryXml();
		var urlstr = "../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_STATICIGMP_TABLE+"&nmUser="+obj["nmUser"];
		loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata="+xmldata);
}

function createQueryXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    var keys = new Array("neid", "slotid", "vbid", "vlanid");
    var vals = new Array(neid, slotId, "0", "-1");
    
    business.appendChild(createRow(keys, vals));
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackQuery(doc)
{
		$("querybtn").disabled = !btnRightArr.querybtn.right;
		$("createbtn").disabled = !btnRightArr.createbtn.right;
		
		var data = EncapsulateData(doc);
		if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
		{
				st0.clearTableData();
				st1.clearTableData();
				createTableBody(st0, window.tableconf[0], data, RESOURCE);
				for (var j = 0, m = st0.getDataRowLength(); j < m; j++)
				{
					var vlanid = st0.getCellStoreValue(j, "vlanid", "vlanid");
					if (parseInt(vlanid) == 0xfffe)
					{
						st0.getCellShow(j, "vlanid").element.innerHTML = "-";
					}
					st0.getCellShow(j, "mac").element.innerHTML = convertMAC(st0.getCellStoreValue(j, "mac", "mac"));
				}
				snoopingList = new Array();				
		}
		
		for (var i=0, len=data.getDataRowLength(); i<len; i++)
		{
				var boardname = data.getDataRowParam(i,"boardname");
				var vbid = data.getDataRowParam(i,"vbid");
				var vlanid = data.getDataRowParam(i,"vlanid");
				var mac = data.getDataRowParam(i, "mac");
				var portNum = data.getDataRowParam(i,"portnum");
				var portStr = data.getDataRowParam(i,"portlist");
				var list = initSnoopingPortList(portNum, portStr);
				
				var snoopingObj = new SnoopingObject(slotId, boardname, vbid, mac, vlanid, list);
				snoopingList.push(snoopingObj);
		}
		if (st0.getDataRowLength() > 0)
		{
			st0.setRowSelect(0);
			rowSelectHandler(st0.getSelectedRows());
		}
		
		showErrorDialog(data);
}

function staticBroadcastDelete()
{
		$("querybtn").disabled = true;
		$("createbtn").disabled = true;
		$("deletebtn").disabled = true;
		$("modifybtn").disabled = true;
		
		var xmldata = createDeleteXml();
		var urlstr = "../../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_STATICIGMP_TABLE+"&nmUser="+obj["nmUser"];
		loadXMLdoc(urlstr, "POST", false, callbackDelete, null, "inputdata="+xmldata);
}

function createDeleteXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    for (var i=0,len=st0.getSelectedRowCount(); i<len; i++)
    {
	    	var rowIndex = st0.getSelectedRows()[i];
	    	var board = st0.getCellShow(rowIndex, "board").element.innerHTML;
	    	var vbid = st0.getCellStoreValue(rowIndex, "vbid", "vbid");
	    	var vlanid = st0.getCellStoreValue(rowIndex, "vlanid", "vlanid");
	    	var mac = st0.getCellStoreValue(rowIndex, "mac", "mac");
	    	var macStr = st0.getCellShow(rowIndex, "mac").element.innerHTML;
	    	
	    	var keys = new Array("neid", "slotid", "board", "vbid", "vlanid", "macStr", "mac");
	    	var vals = new Array(neid, slotId, board, vbid, vlanid, macStr, mac);
    		business.appendChild(createRow(keys, vals));
	}
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackDelete(doc)
{
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("createbtn").disabled = !btnRightArr.createbtn.right;
	
	var data = EncapsulateData(doc);		
	showErrorDialog(data);
	
	if(0 == data.getSErrorCode())//      
    {
    	st1.clearTableData();
    	
        var rowIndex = st0.getSelectedRows();

        for(var j = 0;j < rowIndex.length;j++)
        {
            st0.deleteRow(rowIndex[j]);
        }
        st0.adjustDataRows();        
    }
    else if(1 == data.getSErrorCode())//    
    {
        var tempVbId = null;
        var tempVlanId = null;
        var tempMac = null;
        var errObj = data.getError();//AllError          
        var rowErrorArray = errObj.rowErrors;//    RowError  

		var selectedRows = st0.getSelectedRows();
		for (var k = selectedRows.length - 1; k >= 0; k--)
		{
			var flag = false;
			tempVbId = st0.getCellStoreValue(selectedRows[k],"vbid","vbid");
			tempVlanId = st0.getCellStoreValue(selectedRows[k],"vlanid","vlanid");
			tempMac = st0.getCellStoreValue(selectedRows[k],"mac","mac");
			for (var m = 0, len = rowErrorArray.length; m < len; m++)
			{
			  	var errorObj = rowErrorArray[m].errorObj;//    RowError       
			  	if (tempVbId == errorObj.vbid && tempVlanId== errorObj.vlanid && tempMac == errorObj.mac)
			  	{
			  	  	flag = true;
			  	}
			}
			if (!flag)
			{			  	      
			  	st0.deleteRow(selectedRows[k]);
			}
		}
		st0.adjustDataRows();
		
		st1.clearTableData();
		rowSelectHandler(st0.getSelectedRows());
	}
	else
	{
		rowSelectHandler(st0.getSelectedRows());
	}
	if (st0.getDataRowLength() == 0)
    {
    	adjustTableLayout(st0, window.tableconf[0], 0);
    }
}

function staticBroadcastCreate()
{
	var xmldata = createQueryXml();
	var urlstr = "../../../../../neExlorerServlet?sfid="+TECMDCODE_GET_STATICIGMP_VALIDRESOURCE+"&nmUser="+obj["nmUser"];
	loadXMLdoc(urlstr, "POST", false, callbackQueryRes, null, "inputdata="+xmldata);	
}

function callbackQueryRes(doc)
{
	var data = EncapsulateData(doc);
	if (data.getDataRowLength() > 0 )
	{
		resource = data;
		xshowModalDialog("staticbroadcastnew.html?parIndex="+"-1"+"&nmUser="+obj["nmUser"], RESOURCE["staticBroadcastCreate"], 430, 450, "../../../../../images/");
	}
	else
	{
		alert(RESOURCE["nonport"]);
	}
}

function staticBroadcastModify()
{
		if (st0.getSelectedRowCount() <= 0)
		{
				alert(RESOURCE["nodata"]);
				return;
		}
		
		var parIndex = st0.getSelectedRows()[0];
		xshowModalDialog("staticbroadcastnew.html?parIndex="+parIndex+"&nmUser="+obj["nmUser"], RESOURCE["staticBroadcastModify"], 430, 450, "../../../../../images/");
}
