 /***************
 *       
****************/
var win = getParentWindow();
if (!isIE)
{
	win = win.frames[0];
}
var neid = win.neid;//  ID
var slotid = win.slotid;//  ID
var nmUser = win.nmUser;//    
var currentVBId = win.currentVBId;

document.oncontextmenu = returnFalse;
window.onload = initPage;

document.title = RESOURCE["createvlanunicast"];

/**************
 *      
***************/
function initPage()
{
    $("macaddrlable").innerHTML = RESOURCE["macaddr"];
    $("okbtn").value = RESOURCE["ID_OK"];
    $("canclebtn").value = RESOURCE["ID_CANCEL"];
    
    validateNum($("vlanid"), 1, 4095, 4);
    checkMACFormat($("macaddr"));
    checkSVLDisable();
}

function checkSVLDisable()
{
	 if(win.parent.vbTable.getCellStoreValue(0,"vbswitchtype","vbswitchtype") == "4")
	 {
	 	 $("vlanid").value = "-";
	 	 $("vlanid").disabled = true;
	 }
}

/***********
 *     
************/
function commitInput()
{
    if(!blurFormat($("macaddr")))
    {
        return false;
    }
    setAllComponentStatus(true);
    var xmldata = createXMLData(); //  XML  
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IP_MACROUTE_CREATE + "&nmUser=" + nmUser;     
    loadXMLdoc(url, "POST", false, handleBackData, null, "inputdata=" + xmldata); //      
}

/*******************
 *         
********************/
function setAllComponentStatus(flg)
{
    $("vlanid").disabled = flg;
    $("macaddr").disabled = flg;
    $("okbtn").disabled = flg;
    $("canclebtn").disabled = flg;
}

/************************
 *     VLAN XML  
*************************/
function createXMLData()
{
    var root = new inputxml("datainterface"); //    datainterface    
    var firstlevel = new tagElement("bussiness-params"); //         
    var secondlevel, thirdlevel;
    
    var vbLinkTable = win.vbLinkTable;
    var selectedRows = vbLinkTable.getSelectedRows();
    for(var i = 0, rowlen = selectedRows.length; i < rowlen; i++)
    {
        if(0 != vbLinkTable.getCellStoreValue(selectedRows[i], "portid", "portid"))
        {
            secondlevel = new tagElement("row-params"); //         
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "neid");
            thirdlevel.setAttribute("value", neid);
            secondlevel.appendChild(thirdlevel); 
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "slotid");
            thirdlevel.setAttribute("value", slotid);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "board");
            var vbTable = win.parent.vbTable;
            thirdlevel.setAttribute("value", vbTable.getAtomValue(vbTable.getCellShow(0, "board")));
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "vbid");
            thirdlevel.setAttribute("value", currentVBId);
            secondlevel.appendChild(thirdlevel);
            
            var vlanid = 0xFFFE;
            if($("vlanid").value != "-")
            {
            	 vlanid = $("vlanid").value;
            }
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "vlanid");
            thirdlevel.setAttribute("value", vlanid);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "macaddress");
            var macaddrArr = $("macaddr").value.split("-");
            var macaddrStr = "";
            for(var j = 0, len = macaddrArr.length; j < len; j++)
            {
                macaddrStr += macaddrArr[j];
            }
            thirdlevel.setAttribute("value", macaddrStr);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "macaddrvalue");
            thirdlevel.setAttribute("value", $("macaddr").value);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "vbport");
            thirdlevel.setAttribute("value", vbLinkTable.getCellStoreValue(selectedRows[i], "vbport", "vbport"));
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "vbportname");
            var vbportname = parseInt(vbLinkTable.getCellStoreValue(selectedRows[i], "vbport", "vbport")) - VBPORT_FLG;
            thirdlevel.setAttribute("value", "LP" + vbportname);
            secondlevel.appendChild(thirdlevel);
            
            firstlevel.appendChild(secondlevel);
        }
    }
             
    root.getRoot().appendChild(firstlevel); //               
    return root.toString(); //    
}

/***************************
 *   VLAN       
****************************/
function handleBackData(doc)
{
    var data = EncapsulateData(doc);//          
    handleErrInfo(data); //                    
    if(0 == data.getSErrorCode())//                0 1 
    {
        xcloseDialog();
    }
    setAllComponentStatus(false);    
}

/*********************************                                              
 *                    
**********************************/
function handleErrInfo(data)
{
    var errArr = [];//                   neid slotid
	  errArr.push("nename");
	  errArr.push("slotid");
	  errArr.push("boardname");
	  errArr.push("vbport");
	  
	  var allerror = data.getError();
	  var reobj;
	  var errArridStr;
	  if(data.getSErrorCode() != 0)
	  {
	      for(var i = 0, errlen = data.getBErrLength(); i < errlen; i++)
	      {
	      	  reobj = allerror.rowErrors[i];
	      	      	  
	          if(data.getBErrParam(i, "vbport") != null)
	          {
	              errArridStr = data.getBErrParam(i, "vbport");
	              errArridStr = "LP" + (parseInt(errArridStr) - VBPORT_FLG);
	              
	          }
	          reobj.errorObj["vbport"] = errArridStr;
	      }
	  }
	  openErrPage("../../../../../page/", data.getError(), errArr);//         
}
