/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.service_v2r6c03;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TEGetEtherBoardInfoBean
implements TENEMgrInterface {
    private int neID = -1;
    private int boardType = -1;
    private int slotID = -1;
    private Datainterface output = null;
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_NAME_PARAM = "boardName";
    private static final String PORT_NM_PARAM = "portName";
    private static final String PORT_NO_PARAM = "portNO";
    private Logger log = TELogFactory.getNormalLogger();
    private static final int LGCBD_NOTINSTALL = 24588;
    private static final int IFUP_PORT = 36864;
    private static final int EMS6_PORT8 = 8;
    private boolean fail = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        this.output = new Datainterface();
        try {
            Param param = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)SLOT_ID_PARAM);
            this.slotID = Integer.parseInt(param.getValue());
            this.getEthBoardInfo(subFunc, memeryData);
            if (!this.fail) {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
        catch (Exception e) {
            this.log.error("Get BoardInfo Fail!\n", (Throwable)e);
        }
        return this.output;
    }

    private void getEthBoardInfo(SubFunc subFunc, Datainterface memeryData) {
        int portNO = -1;
        RowParams rowParam = null;
        String portName = "";
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        if (null == configurDataMgr.getBoard(this.neID, this.slotID)) {
            this.fail = true;
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)24588));
            return;
        }
        this.boardType = configurDataMgr.getBoard(this.neID, this.slotID).getBoardType();
        Param param = null;
        param = new Param(BOARD_NAME_PARAM, configurDataMgr.getBoardTypeName(this.neID, this.boardType));
        rowParam = new RowParams();
        rowParam.addParam(param);
        this.output.setBussinessParams(new BussinessParams());
        this.output.getBussinessParams().addRowParams(rowParam);
        ArrayList macPortList = this.getMacPortList();
        int len = macPortList.size();
        for (int i = 0; i < len; ++i) {
            portNO = Integer.parseInt(macPortList.get(i).toString());
            portName = TEConfigurationDataMgr.getMACName((int)portNO);
            rowParam = new RowParams();
            param = new Param(PORT_NO_PARAM, String.valueOf(portNO));
            rowParam.addParam(param);
            param = new Param(PORT_NM_PARAM, portName);
            rowParam.addParam(param);
            this.output.getBussinessParams().addRowParams(rowParam);
        }
        ArrayList vcPortList = configurDataMgr.getETHVCTrunkPort(this.neID, this.boardType);
        int len2 = vcPortList.size();
        for (int i = 0; i < len2; ++i) {
            portNO = Integer.parseInt(vcPortList.get(i).toString());
            portName = TEConfigurationDataMgr.getVCTrunkName((int)(portNO - 32768));
            rowParam = new RowParams();
            param = new Param(PORT_NO_PARAM, String.valueOf(portNO));
            rowParam.addParam(param);
            param = new Param(PORT_NM_PARAM, portName);
            rowParam.addParam(param);
            this.output.getBussinessParams().addRowParams(rowParam);
        }
        if (this.boardType == 2095) {
            int portNo = 36865;
            rowParam = new RowParams();
            param = new Param(PORT_NO_PARAM, String.valueOf(portNo));
            rowParam.addParam(param);
            param = new Param(PORT_NM_PARAM, "IFUP1");
            rowParam.addParam(param);
            this.output.getBussinessParams().addRowParams(rowParam);
        }
    }

    private ArrayList getMacPortList() {
        ArrayList existPortList;
        ArrayList allPortList = TEConfigurationDataMgr.getInstance().getETHMACPort(this.neID, this.boardType);
        if (this.boardType == 2439) {
            for (int i = 0; i < allPortList.size(); ++i) {
                int portid = (Integer)allPortList.get(i);
                if (portid != 8) continue;
                allPortList.remove(i);
                break;
            }
        }
        if ((existPortList = this.getExistPortList(allPortList)).isEmpty()) {
            return allPortList;
        }
        return existPortList;
    }

    private ArrayList getExistPortList(ArrayList portList) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_PORT");
        Input input = oper.getInput();
        Part part = input.getPart(SLOT_ID_PARAM);
        part.setValue(String.valueOf(this.slotID));
        part = input.getPart("portID");
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            part.setValue(String.valueOf((Integer)portList.get(i)));
            operationList.add(oper.clone());
        }
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        if (operationList.size() == 0) {
            return returnList;
        }
        int result = TENECommMgr.getInstance().sendCommand((int)this.neID, operationList, (int)10).retCode;
        if (result == 0) {
            int len = operationList.size();
            for (int j = 0; j < len; ++j) {
                Operation oOperation = (Operation)operationList.get(j);
                if (!String.valueOf(0).equals(oOperation.getOutput()[0].getFault()[0].getCode())) continue;
                String portId = oOperation.getOutput()[0].getPartValue("portID");
                returnList.add(Integer.valueOf(portId));
            }
        }
        return returnList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

