/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.service;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.ip.TEEthBindXc;
import com.huawei.nglct.nelist.model.ip.TEIPDescription;
import com.huawei.nglct.nelist.model.ip.TEIpModel;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class TEVCTrunk
implements Comparable {
    static final int BIDIRECTIONAL = 0;
    static final int UPLINK = 1;
    static final int DOWNLINK = 2;
    static final int LEVEL_GE = 129;
    static final int LEVEL_VC12 = 3;
    static final int LEVEL_VC3 = 2;
    static final int INT_INVALID = 65535;
    static final int BYTE_INVALID = 255;
    int neid = -1;
    int slotID = -1;
    TEResourceUtil res = null;
    int vctrunk = 65535;
    int level = 255;
    Set upLinkList = new HashSet();
    Set downLinkList = new HashSet();
    Set usedupLinkList = new HashSet();
    Set useddownLinkList = new HashSet();
    ArrayList bindXcList = null;

    public TEVCTrunk() {
    }

    public TEVCTrunk(TEVCTrunk other) {
        this.vctrunk = other.vctrunk;
        this.upLinkList = other.upLinkList;
        this.downLinkList = other.downLinkList;
        this.level = other.level;
    }

    List toRowParams() {
        HashSet tempBiSet = new HashSet();
        HashSet tempUpSet = new HashSet();
        HashSet tempDownSet = new HashSet();
        HashSet tempUsedUpSet = new HashSet();
        HashSet tempUsedDownSet = new HashSet();
        tempBiSet.addAll(this.upLinkList);
        tempBiSet.retainAll(this.downLinkList);
        tempUpSet.addAll(this.upLinkList);
        tempUpSet.removeAll(tempBiSet);
        tempDownSet.addAll(this.downLinkList);
        tempDownSet.removeAll(tempBiSet);
        this.createBindXcList();
        ArrayList rows = new ArrayList(3);
        if (tempBiSet.size() > 0) {
            tempUsedUpSet.addAll(this.usedupLinkList);
            tempUsedUpSet.retainAll(tempBiSet);
            tempUsedDownSet.addAll(this.useddownLinkList);
            tempUsedDownSet.retainAll(tempBiSet);
            rows.addAll(this.toVarRow(tempBiSet, 0, tempUsedUpSet, tempUsedDownSet));
            tempUsedUpSet.clear();
            tempUsedDownSet.clear();
        }
        if (tempUpSet.size() > 0) {
            tempUsedUpSet.addAll(this.usedupLinkList);
            tempUsedUpSet.retainAll(tempUpSet);
            rows.addAll(this.toVarRow(tempUpSet, 1, tempUsedUpSet, null));
            tempUsedUpSet.clear();
        }
        if (tempDownSet.size() > 0) {
            tempUsedDownSet.addAll(this.useddownLinkList);
            tempUsedDownSet.retainAll(tempDownSet);
            rows.addAll(this.toVarRow(tempDownSet, 2, null, tempUsedDownSet));
            tempUsedDownSet.clear();
        }
        return rows;
    }

    private ArrayList toVarRow(Set pathList, int direction, Set usedUpList, Set usedDownList) {
        ArrayList<RowParams> rows = new ArrayList<RowParams>();
        String vcLevelStr = "";
        TEEthBindXc bindXc = null;
        Object[] upPaths = null;
        Object[] downPaths = null;
        Object[] paths = pathList.toArray(new Integer[0]);
        Arrays.sort(paths);
        if (null != usedUpList && 0 < usedUpList.size()) {
            upPaths = usedUpList.toArray(new Integer[0]);
            Arrays.sort(upPaths);
        }
        if (null != usedDownList && 0 < usedDownList.size()) {
            downPaths = usedDownList.toArray(new Integer[0]);
            Arrays.sort(downPaths);
        }
        if (129 == this.level) {
            vcLevelStr = "GE-";
            rows.add(this.toOneRow((Integer[])paths, (Integer[])upPaths, (Integer[])downPaths, direction, vcLevelStr));
            return rows;
        }
        if (null != this.bindXcList) {
            int len = this.bindXcList.size();
            for (int i = 0; i < len; ++i) {
                bindXc = (TEEthBindXc)this.bindXcList.get(i);
                int serverNolen = bindXc.getBindXcServerNO().size();
                String serverNo = "";
                int trunkValue = 0;
                if (this.level != bindXc.getVcLever()) continue;
                if (1 == serverNolen) {
                    serverNo = "" + bindXc.getBindXcServerNO().get(0);
                    vcLevelStr = "VC4-" + bindXc.getBindXcServerNO().get(0) + "-" + bindXc.getBindXcname();
                    trunkValue = 0;
                    rows.add(this.toOneRow((Integer[])paths, (Integer[])upPaths, (Integer[])downPaths, direction, vcLevelStr, serverNo, trunkValue));
                    return rows;
                }
                int m = 0;
                int mup = 0;
                int mdown = 0;
                int pathslen = paths.length;
                int maxPerTrunk = bindXc.getMaxPerTrunk() / serverNolen;
                for (int j = 0; j < serverNolen; ++j) {
                    int maxTrunkServeNo = maxPerTrunk * j + maxPerTrunk;
                    ArrayList<Object> rowPaths = new ArrayList<Object>();
                    ArrayList<Object> rowUpPaths = new ArrayList<Object>();
                    ArrayList<Object> rowDownPaths = new ArrayList<Object>();
                    trunkValue = maxPerTrunk * j;
                    while (m < pathslen && (Integer)paths[m] <= maxTrunkServeNo) {
                        rowPaths.add(paths[m]);
                        ++m;
                    }
                    if (null != upPaths) {
                        while (mup < upPaths.length && (Integer)upPaths[mup] <= maxTrunkServeNo) {
                            rowUpPaths.add(upPaths[mup]);
                            ++mup;
                        }
                    }
                    if (null != downPaths) {
                        while (mdown < downPaths.length && (Integer)downPaths[mdown] <= maxTrunkServeNo) {
                            rowDownPaths.add(downPaths[mdown]);
                            ++mdown;
                        }
                    }
                    if (rowPaths.size() <= 0) continue;
                    serverNo = "" + bindXc.getBindXcServerNO().get(j);
                    vcLevelStr = "VC4-" + serverNo + "-" + bindXc.getBindXcname();
                    Object[] rowPathsInt = rowPaths.toArray(new Integer[0]);
                    Integer[] rowUpPathsInt = rowUpPaths.toArray(new Integer[0]);
                    Integer[] rowDownPathsInt = rowDownPaths.toArray(new Integer[0]);
                    Arrays.sort(rowPathsInt);
                    rows.add(this.toOneRow((Integer[])rowPathsInt, rowUpPathsInt, rowDownPathsInt, direction, vcLevelStr, serverNo, trunkValue));
                }
            }
        }
        return rows;
    }

    private void createBindXcList() {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        TEBoard boardObj = null;
        TEIpModel getIpModel = null;
        if (null != neObj && this.slotID >= 1 && null != (boardObj = neObj.getBoard(this.slotID)) && null != (getIpModel = TEIPDescription.getInstance().getIPModel(boardObj.getBoardType())) && null != getIpModel.getEthVctrunkRes() && null != getIpModel.getEthVctrunkRes().getBindXcList()) {
            this.bindXcList = getIpModel.getEthVctrunkRes().getBindXcList();
        }
    }

    private RowParams toOneRow(Integer[] paths, Integer[] upPaths, Integer[] downPaths, int direction, String vcLevelStr) {
        String serverNo = "0";
        int trunkValue = 0;
        return this.toOneRow(paths, upPaths, downPaths, direction, vcLevelStr, serverNo, trunkValue);
    }

    private RowParams toOneRow(Integer[] paths, Integer[] upPaths, Integer[] downPaths, int direction, String vcLevelStr, String serverNo, int trunkValue) {
        RowParams rowParams = new RowParams();
        Param param = null;
        param = new Param("vctrunk", String.valueOf(this.vctrunk));
        rowParams.addParam(param);
        param = new Param("direction", String.valueOf(direction));
        rowParams.addParam(param);
        param = new Param("level", String.valueOf(this.level));
        rowParams.addParam(param);
        param = new Param("pathNum", String.valueOf(paths.length));
        rowParams.addParam(param);
        param = new Param("pathList", this.getPathName(paths, vcLevelStr, trunkValue));
        rowParams.addParam(param);
        StringBuffer usedChannelStr = new StringBuffer();
        String usedPath = null;
        usedPath = this.getPathName(upPaths, vcLevelStr, trunkValue);
        if (!usedPath.equals("")) {
            usedChannelStr.append(this.res.getString("upDir")).append(": ").append(usedPath).append("  ");
        }
        if (!(usedPath = this.getPathName(downPaths, vcLevelStr, trunkValue)).equals("")) {
            usedChannelStr.append(this.res.getString("downDir")).append(": ").append(usedPath).append("  ");
        }
        if ((usedPath = usedChannelStr.toString()).equals("")) {
            usedPath = usedPath + "/";
        }
        param = new Param("usedChannel", usedPath);
        rowParams.addParam(param);
        param = new Param("serverNo", serverNo);
        rowParams.addParam(param);
        param = new Param("trunkValue", String.valueOf(trunkValue));
        rowParams.addParam(param);
        param = new Param("pathListNum", TEStringUtils.pathToString((Integer[])paths));
        rowParams.addParam(param);
        return rowParams;
    }

    private String getPathName(Integer[] paths, String vcLevelStr, int trunkValue) {
        if (paths == null || paths.length <= 0) {
            return "";
        }
        String pathsStr = "";
        if (129 == this.level) {
            if (1 == paths.length) {
                vcLevelStr = vcLevelStr + paths[0];
            } else {
                Arrays.sort((Object[])paths);
                vcLevelStr = vcLevelStr + TEStringUtils.pathToString((Integer[])paths);
            }
        } else {
            pathsStr = this.numToContinuum(paths, trunkValue);
            vcLevelStr = vcLevelStr + "(" + pathsStr + ")";
        }
        return vcLevelStr;
    }

    public String numToContinuum(Integer[] paths, int trunkValue) {
        StringBuffer numToStr = new StringBuffer();
        int conNumStart = -1;
        int conNumEnd = -1;
        int firstNum = -1;
        int nextNum = -1;
        if (1 == paths.length) {
            int onePath = 0;
            onePath = paths[0] - trunkValue;
            return String.valueOf(onePath);
        }
        Arrays.sort((Object[])paths);
        int len = paths.length - 1;
        for (int i = 0; i < len; ++i) {
            firstNum = paths[i] - trunkValue;
            if (firstNum + 1 == (nextNum = paths[i + 1] - trunkValue)) {
                if (-1 != conNumStart) {
                    conNumEnd = nextNum;
                } else {
                    conNumStart = firstNum;
                    conNumEnd = nextNum;
                }
            } else if (-1 == conNumStart) {
                numToStr.append(",").append(firstNum);
            } else {
                numToStr.append(",").append(conNumStart).append("-").append(conNumEnd);
                conNumStart = -1;
                conNumEnd = -1;
            }
            if (len != i + 1) continue;
            if (-1 == conNumStart) {
                numToStr.append(",").append(nextNum);
                continue;
            }
            numToStr.append(",").append(conNumStart).append("-").append(conNumEnd);
            conNumStart = -1;
            conNumEnd = -1;
        }
        return numToStr.toString().substring(1);
    }

    public String toString() {
        return this.vctrunk + "-" + this.level;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TEVCTrunk)) {
            return false;
        }
        TEVCTrunk other = (TEVCTrunk)obj;
        return this.vctrunk == other.vctrunk;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.vctrunk;
        return result;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof TEVCTrunk)) {
            return 1;
        }
        TEVCTrunk other = (TEVCTrunk)obj;
        return this.vctrunk - other.vctrunk;
    }

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public void setRes(TEResourceUtil Res) {
        this.res = Res;
    }
}

