/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.service;

import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.TETimeSlotConvertUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TEBoundPathConfig
extends TENEExplorerBean {
    private static final String ADD_PATH = "NSCMD_ETHN_ADD_VCTRUNK_PATH";
    private static final String DEL_PATH = "NSCMD_ETHN_DEL_VCTRUNK_PATH";
    private static final String STATE = "state";
    private static final String PATHLIST = "pathListNum";
    private static final String LEVEL = "level";
    private static final int LEVEL_VC12 = 3;
    private static final int VCTRUNK_NUM = 32768;
    private TEResourceUtil res = null;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        return this.convertToOperation(subFunc, inputData, neid);
    }

    public ArrayList convertToOperation(SubFunc subfunc, Datainterface inputData, int neid) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList operationList = new ArrayList();
        ArrayList<Operation> addOperationList = new ArrayList<Operation>();
        ArrayList<Operation> delOperationList = new ArrayList<Operation>();
        Operation operation = null;
        Input input = null;
        RowParams rowparams = null;
        Param rowparam = null;
        boolean modifyFlag = true;
        int defaultPartCount = 0;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            if (rowparams.getParam(STATE).getValue().equals("add")) {
                operation = TECreateObjectFactory.getOperation((int)neid, (String)ADD_PATH);
            } else {
                if (!rowparams.getParam(STATE).getValue().equals("del")) continue;
                operation = TECreateObjectFactory.getOperation((int)neid, (String)DEL_PATH);
            }
            if (null == operation) continue;
            input = operation.getInput();
            int partlen = input.getPartCount();
            modifyFlag = input.getPartCount() == 0;
            defaultPartCount = 0;
            int level = 0;
            if (null != rowparams.getParam(LEVEL)) {
                level = Integer.parseInt(rowparams.getParam(LEVEL).getValue());
            }
            String pathListStr = rowparams.getParam(PATHLIST).getValue();
            String[] pathListStrList = pathListStr.split(",");
            StringBuffer pathListBuf = new StringBuffer();
            int pathNo = 0;
            int strlen = pathListStrList.length;
            for (int i = 0; i < strlen; ++i) {
                pathNo = Integer.parseInt(pathListStrList[i]);
                if (level == 3) {
                    pathNo = TETimeSlotConvertUtil.revertSlotMode((int)pathNo);
                }
                pathListBuf.append(this.tenToHex(String.valueOf(pathNo)));
            }
            rowparams.getParam(PATHLIST).setValue(pathListBuf.toString());
            for (int part = 0; part < partlen; ++part) {
                rowparam = rowparams.getParam(input.getPart(part).getName());
                if (null == rowparam) {
                    if (!input.getPart(part).hasDefault()) {
                        modifyFlag = false;
                        break;
                    }
                    ++defaultPartCount;
                    continue;
                }
                if (null != rowparam.getValue()) {
                    input.getPart(part).setValue(rowparam.getValue());
                }
                if (!rowparam.getModifyFlag()) continue;
                modifyFlag = true;
            }
            if (!modifyFlag && defaultPartCount != partlen) continue;
            if (rowparams.getParam(STATE).getValue().equals("add")) {
                addOperationList.add(operation);
                continue;
            }
            if (!rowparams.getParam(STATE).getValue().equals("del")) continue;
            delOperationList.add(operation);
        }
        operationList.addAll(delOperationList);
        operationList.addAll(addOperationList);
        return operationList;
    }

    private String tenToHex(String converNum) {
        int converHexConfig = Integer.parseInt(converNum);
        converNum = converHexConfig < 16 ? "000" + Integer.toHexString(converHexConfig) : "00" + Integer.toHexString(converHexConfig);
        return converNum;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final int sneid = neid;
        final Datainterface sinputData = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEBoundPathConfig.this.boundPathConfigDetail(sinputData, sneid);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String boundPathConfigDetail(Datainterface inputData, int neid) {
        StringBuffer strBuf = new StringBuffer();
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams1 = null;
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int slotId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"slotID").getValue());
        StringBuffer filePath = new StringBuffer();
        String slotName = TENEListMgr.getInstance().getNE(neid).getBoard(slotId).getBoardName();
        filePath.append("ip").append(File.separator).append("sdh").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append(File.separator).append("service").append(File.separator).append("evplres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
        strBuf.append(slotId).append("-").append(slotName).append(" ");
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams1 = businessparams.getRowParams(row);
            if (!rowparams1.getParam(STATE).getValue().equals("all")) continue;
            int vctrunk = Integer.parseInt(rowparams1.getParam("vctrunk").getValue()) - 32768;
            String pathDir = rowparams1.getParam("direction").getValue();
            if ("0".equals(pathDir)) {
                pathDir = "dbDir";
            } else if ("1".equals(pathDir)) {
                pathDir = "upDir";
            } else if ("2".equals(pathDir)) {
                pathDir = "downDir";
            }
            strBuf.append("VCTRUNK").append(vctrunk).append(": ").append(this.res.getString(pathDir)).append(",");
            strBuf.append(rowparams1.getParam(PATHLIST).getValue()).append("; ");
        }
        return strBuf.toString();
    }
}

