/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2.portshaping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.eth.TEWebLCTPortShapingMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEShapingDBMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    private TEShapingDBMgr() {
    }

    public static List<TEWebLCTPortShapingMOPO> getAllShapingFromDB(int neID, int slotid, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEShapingDBMgr.getShapingFromDB";
        normalLogger.info("TEShapingDBMgr.getShapingFromDB: begin.");
        ArrayList<TEWebLCTPortShapingMOPO> shapingList = new ArrayList<TEWebLCTPortShapingMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                normalLogger.error("ne is null! neID->" + neID);
                errRet.setResult(1090596385);
                TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.getShapingFromDB");
                return shapingList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotid}, TEWebLCTPortShapingMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotid}, TEWebLCTPortShapingMOPO.class);
        }
        catch (Exception e) {
            normalLogger.error("get shaping from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.getShapingFromDB");
            return shapingList;
        }
        if (null == dbResult) {
            normalLogger.error("get shaping from db fail! dbResult is null! neID->" + neID);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.getShapingFromDB");
            return shapingList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    shapingList.add((TEWebLCTPortShapingMOPO)obj);
                }
            }
        } else {
            String tipStr = String.format("get shaping to db device fail! neID:%d, retCode:%d", neID, retCode);
            normalLogger.error(tipStr);
            errRet.setResult(retCode);
        }
        TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.getShapingFromDB");
        return shapingList;
    }

    public static void delShapingFromDB(int neID, int slotid, TEWebLCTPortShapingMOPO portshapingMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEShapingDBMgr.delShapingFromDB";
        normalLogger.info("TEShapingDBMgr.delShapingFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID, slotid}, (Object)portshapingMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID, slotid}, (Object)portshapingMO);
        }
        catch (Exception e) {
            normalLogger.error("delete shaping from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.delShapingFromDB");
            return;
        }
        if (null == dbResult) {
            TEShapingDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.delShapingFromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEShapingDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.delShapingFromDB");
    }

    public static void createShapingToDB(int neID, TEWebLCTPortShapingMOPO shapingMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEShapingDBMgr.createShapingToDB";
        normalLogger.info("TEShapingDBMgr.createShapingToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID, shapingMO.getBoard()}, (Object)shapingMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID, shapingMO.getBoard()}, (Object)shapingMO);
        }
        catch (Exception e) {
            normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.createShapingToDB");
            return;
        }
        if (null == dbResult) {
            TEShapingDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.createShapingToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEShapingDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.createShapingToDB");
    }

    public static TEWebLCTPortShapingMOPO getShapingFromDB(int neID, int slotid, int port) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("Board", String.valueOf(slotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair("Port", String.valueOf(port));
        criteria.add(aPair);
        TEWebLCTPortShapingMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID, slotid}, TEWebLCTPortShapingMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID, slotid}, TEWebLCTPortShapingMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEWebLCTPortShapingMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                normalLogger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEWebLCTPortShapingMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            normalLogger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEWebLCTPortShapingMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateShapingToDB(int neID, TEWebLCTPortShapingMOPO shapingMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEShapingDBMgr.updateShapingToDB";
        normalLogger.info("TEShapingDBMgr.updateShapingToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID, shapingMO.getBoard()}, (Object)shapingMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID, shapingMO.getBoard()}, (Object)shapingMO);
        }
        catch (Exception e) {
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.updateShapingToDB");
            return;
        }
        if (null == dbResult) {
            TEShapingDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.updateShapingToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEShapingDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEShapingDBMgr.logFuncEnd("TEShapingDBMgr.updateShapingToDB");
    }

    private static void logNullError(int neID) {
        normalLogger.error("delet fail! neID->" + neID);
    }

    private static void logFuncEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }

    private static void logRetCodeError(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    public static void setShapingAttr(TEWebLCTPortShapingMOPO shapingMO, RowParams row) {
        Param enable;
        Param dmbs;
        Param pir;
        Param dcbs;
        Param cir = row.getParam("cir");
        if (!TEStringUtils.isParamEmpty((Param)cir)) {
            shapingMO.setShapingcir(Long.parseLong(cir.getValue()));
        }
        if (!TEStringUtils.isParamEmpty((Param)(dcbs = row.getParam("dcbs")))) {
            shapingMO.setShapingdcbs(Long.parseLong(dcbs.getValue()));
        }
        if (!TEStringUtils.isParamEmpty((Param)(pir = row.getParam("pir")))) {
            shapingMO.setShapingpir(Long.parseLong(pir.getValue()));
        }
        if (!TEStringUtils.isParamEmpty((Param)(dmbs = row.getParam("dmbs")))) {
            shapingMO.setShapingdmbs(Long.parseLong(dmbs.getValue()));
        }
        if (!TEStringUtils.isParamEmpty((Param)(enable = row.getParam("enable")))) {
            shapingMO.setShapingen(enable.getValue());
        }
    }
}

