/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2.TEQosFlowData;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class TEQosFlowCache {
    private Map<Integer, List<TEQosFlowData>> flowDatas = new Hashtable<Integer, List<TEQosFlowData>>();
    private TimeZoneDateBean timeProccessor = null;
    private int numOfData = 20;
    private double maxVelocity = 0.0;
    private double minVelocity = 0.0;
    private static final int OFFSET = 15;
    private static final int UNITOFFSET = 1;
    static final double INVALIDVALUE = 4.294967295E9;
    private static TEQosFlowCache instance = null;

    public int getNumOfData() {
        return this.numOfData;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public double getMinVelocity() {
        return this.minVelocity;
    }

    public List<TEQosFlowData> getFlowDatas(int neid, Datainterface inputData) {
        TELogFactory.getNormalLogger().info("the buffer map's size->!" + this.flowDatas.size());
        List<TEQosFlowData> list = this.flowDatas.get(neid);
        if (list == null) {
            list = this.queryQosFlowData(neid, inputData);
        }
        return list;
    }

    private TEQosFlowCache() {
    }

    public static synchronized TEQosFlowCache getInstance() {
        if (instance == null) {
            instance = new TEQosFlowCache();
        }
        return instance;
    }

    public List<TEQosFlowData> queryQosFlowData(int neid, Datainterface inputData) {
        this.flowDatas.clear();
        int retCode = 0;
        List<TEQosFlowData> list = new ArrayList<TEQosFlowData>();
        try {
            this.timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
            this.splitTime(inputData);
            SubFunc subfunc = TECreateObjectFactory.getSubFunc((int)neid, (int)1000001);
            ArrayList operationList = TEDataConverter.convertToOperation((SubFunc)subfunc, (Datainterface)inputData, (int)neid);
            if (null == operationList || operationList.size() == 0) {
                TELogFactory.getNormalLogger().info("queryQosFlowData fail, no operation!");
                return list;
            }
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, 60, subfunc);
            if (null != result) {
                retCode = result.retCode;
            }
            if (retCode == 0) {
                list = this.parseQosFlowData(neid, operationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("queryQosFlowData fail!", (Throwable)e);
        }
        return list;
    }

    private List<TEQosFlowData> parseQosFlowData(int neid, List opers) {
        ArrayList<TEQosFlowData> list = new ArrayList<TEQosFlowData>();
        this.flowDatas.clear();
        TimeZoneDateBean timezone = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        Calendar calendar = null;
        TEQosFlowData qosdata = null;
        int ilen = opers.size();
        for (int i = 0; i < ilen; ++i) {
            Operation oper = (Operation)opers.get(i);
            for (Output outPut : oper.getOutput()) {
                int slotid = Integer.parseInt(outPut.getPartValue("slotid"));
                int flowid = Integer.parseInt(outPut.getPartValue("flowid"));
                int datenum = Integer.parseInt(outPut.getPartValue("datenum"));
                calendar = TEDateUtils.byteStrToCalendar((String)outPut.getPartValue("date"));
                if (calendar == null) continue;
                String values = outPut.getPartValue("daterate");
                int n = datenum;
                for (int j = 0; j < n; ++j) {
                    qosdata = new TEQosFlowData(slotid, flowid);
                    if (j > 0) {
                        calendar.add(12, 15);
                    }
                    qosdata.setDate(timezone.calendarToTime((Calendar)calendar.clone()));
                    String value = "0";
                    double dbvalue = 0.0;
                    if (values.length() < j * 8 + 8) continue;
                    value = values.substring(j * 8, j * 8 + 8);
                    dbvalue = IOStreamConvertor.readUnSignedPositiveLong((byte[])value.getBytes(), (int)0);
                    if (Double.compare(dbvalue, 4.294967295E9) != 0 && Double.compare(this.maxVelocity, dbvalue /= 1.0) < 0) {
                        this.maxVelocity = dbvalue;
                    }
                    qosdata.setFlowVelocity(dbvalue);
                    list.add(qosdata);
                }
            }
        }
        this.flowDatas.put(neid, list);
        return list;
    }

    public List<TEQosFlowData> parseFlowData(int neid, Datainterface outputData) {
        BussinessParams bussiness = outputData.getBussinessParams();
        RowParams row = null;
        RowErrors rowerror = null;
        TimeZoneDateBean timezone = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        Calendar calendar = null;
        TEQosFlowData qosdata = null;
        ArrayList<TEQosFlowData> list = new ArrayList<TEQosFlowData>();
        int m = bussiness.getRowParamsCount();
        for (int i = 0; i < m; ++i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) {
                int n = row.getRowErrorsCount();
                for (int j = 0; j < n; ++j) {
                    rowerror = row.getRowErrors(j);
                    if (rowerror.getParam("begindate") != null) {
                        rowerror.getParam("begindate").setValue("");
                    }
                    if (rowerror.getParam("enddate") == null) continue;
                    rowerror.getParam("enddate").setValue("");
                }
                continue;
            }
            int slotid = Integer.parseInt(row.getParam("slotid").getValue());
            int flowid = Integer.parseInt(row.getParam("flowid").getValue());
            int datenum = Integer.parseInt(row.getParam("datenum").getValue());
            calendar = TEDateUtils.byteStrToCalendar((String)row.getParam("date").getValue());
            if (calendar == null) {
                return list;
            }
            String values = row.getParam("daterate").getValue();
            int n = datenum;
            for (int j = 0; j < n; ++j) {
                qosdata = new TEQosFlowData(slotid, flowid);
                if (j > 0) {
                    calendar.add(12, 15);
                }
                qosdata.setDate(timezone.calendarToTime((Calendar)calendar.clone()));
                String value = "0";
                double dbvalue = 0.0;
                if (values.length() < j * 8 + 8) continue;
                value = values.substring(j * 8, j * 8 + 8);
                dbvalue = IOStreamConvertor.readUnSignedPositiveLong((byte[])value.getBytes(), (int)0);
                if (Double.compare(dbvalue, 4.294967295E9) != 0 && Double.compare(this.maxVelocity, dbvalue /= 1.0) < 0) {
                    this.maxVelocity = dbvalue;
                }
                qosdata.setFlowVelocity(dbvalue);
                list.add(qosdata);
            }
        }
        this.flowDatas.clear();
        this.flowDatas.put(neid, list);
        return list;
    }

    private void splitTime(Datainterface inputData) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        Calendar beg = TEDateUtils.byteStrToCalendar((String)this.timeProccessor.strToUTC(rowParams.getParam("begindate").getValue()));
        Calendar end = TEDateUtils.byteStrToCalendar((String)this.timeProccessor.strToUTC(rowParams.getParam("enddate").getValue()));
        this.refTime(beg, false);
        this.refTime(end, true);
        BussinessParams bussiness_new = new BussinessParams();
        Calendar tmp = null;
        RowParams tmpRow = null;
        while (beg.get(5) != end.get(5) || beg.get(2) != end.get(2)) {
            tmp = (Calendar)beg.clone();
            beg.add(5, 1);
            beg.set(11, 0);
            beg.set(12, 0);
            beg.set(13, 0);
            tmpRow = (RowParams)rowParams.clone();
            tmpRow.getParam("begindate").setValue(TEDateUtils.calendarToByteStr((Calendar)tmp));
            tmpRow.getParam("enddate").setValue(TEDateUtils.calendarToByteStr((Calendar)beg));
            bussiness_new.addRowParams(tmpRow);
        }
        if (beg.compareTo(end) < 0) {
            tmpRow = (RowParams)rowParams.clone();
            tmpRow.getParam("begindate").setValue(TEDateUtils.calendarToByteStr((Calendar)beg));
            tmpRow.getParam("enddate").setValue(TEDateUtils.calendarToByteStr((Calendar)end));
            bussiness_new.addRowParams(tmpRow);
        }
        inputData.setBussinessParams(bussiness_new);
    }

    private void refTime(Calendar cal, boolean flg) {
        int sec;
        int basicTime = 900;
        int min = cal.get(12);
        int total = min * 60 + (sec = cal.get(13));
        if (total % basicTime != 0) {
            cal.set(12, 0);
            cal.set(13, 0);
            if (flg) {
                cal.add(13, (total / basicTime + 1) * basicTime);
            } else {
                cal.add(13, total / basicTime * basicTime);
            }
        }
    }
}

