/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2.TEQosFlowCache;
import com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2.TEQosFlowData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;

public class TEDrawQosFlowPic {
    private static final String BASE_PATH = "ip" + File.separator + "sdh" + File.separator + "res" + File.separator;
    private static final String PAKAGE_PATH = BASE_PATH + "qos_u2kv1r2" + File.separator + "flowchart_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private String labelX = "labelx";
    private String labelY = "labely";
    List<TEQosFlowData> data = null;
    private static final int PIC_HEIGHT = 379;
    private static final int PIC_WIDTH = 900;
    private BufferedImage flowImage = new BufferedImage(900, 379, 1);
    private Color standcoler = new Color(239, 239, 239);
    private int xLeft = 115;
    private int xRight = 885;
    private int yTop = 8;
    private int yBottom = 344;
    private int yGridNum = 20;
    private static double yGridValue = 0.05;
    DecimalFormat format = new DecimalFormat("0.00");
    private static TEDrawQosFlowPic instance = null;

    private TEDrawQosFlowPic() {
    }

    public static synchronized TEDrawQosFlowPic getInstance() {
        if (instance == null) {
            instance = new TEDrawQosFlowPic();
        }
        return instance;
    }

    public BufferedImage drawBitTestPic(int neid, Datainterface inputData) {
        this.initResource(neid);
        this.data = TEQosFlowCache.getInstance().getFlowDatas(neid, inputData);
        if (this.data == null) {
            this.drawInitPic();
        } else {
            this.drawDataPic();
        }
        return this.flowImage;
    }

    private void initResource(int neid) {
        this.labelX = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.labelX);
        this.labelY = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.labelY);
    }

    public void drawInitPic() {
        Graphics2D waveg2d = this.getSVGGraphics();
        this.paintFrame(waveg2d);
        this.paintYScale(waveg2d, yGridValue);
    }

    private void drawDataPic() {
        Graphics2D waveg2d = this.getSVGGraphics();
        this.paintFrame(waveg2d);
        double maxYValue = TEQosFlowCache.getInstance().getMaxVelocity();
        double scaleValue = yGridValue;
        if (maxYValue > (double)this.yGridNum * yGridValue) {
            scaleValue = maxYValue / (double)this.yGridNum;
        }
        this.paintYScale(waveg2d, scaleValue);
        this.paintXScale(waveg2d);
        this.paintFlowData(waveg2d, scaleValue);
    }

    public Graphics2D getSVGGraphics() {
        return (Graphics2D)this.flowImage.getGraphics();
    }

    public void paintFrame(Graphics2D dc) {
        dc.setColor(this.standcoler);
        dc.fillRect(0, 0, 900, 379);
        dc.setColor(Color.LIGHT_GRAY);
        dc.fillRect(this.xLeft, this.yTop, this.xRight - this.xLeft, this.yBottom - this.yTop);
        dc.setColor(Color.BLACK);
        dc.drawLine(this.xLeft, this.yBottom, this.xRight, this.yBottom);
        dc.drawLine(this.xLeft, this.yBottom, this.xLeft, this.yTop);
        Font biggerFont = new Font("Dialog", 0, 14);
        dc.setColor(Color.BLACK);
        dc.setFont(biggerFont);
        dc.drawString(this.labelX, 3, this.yBottom / 2);
        dc.drawString(this.labelY, this.xRight / 2, this.yBottom + 30);
    }

    public void paintYScale(Graphics2D dc11, double scaleValue) {
        BasicStroke normal1 = new BasicStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f);
        FontMetrics fontmetri1 = dc11.getFontMetrics();
        Font normalFont = new Font("Dialog", 0, 12);
        Font smallerFont = new Font("Dialog", 0, 10);
        int y_gridh = (this.yBottom - this.yTop) / this.yGridNum;
        for (int i = 0; i <= this.yGridNum; ++i) {
            dc11.setColor(Color.BLACK);
            dc11.setStroke(normal1);
            dc11.setFont(normalFont);
            dc11.drawLine(this.xLeft - 2, this.yBottom - y_gridh * i, this.xLeft + 2, this.yBottom - y_gridh * i);
            int cswidth = fontmetri1.stringWidth(this.format.format(scaleValue) + "");
            int csheight = fontmetri1.getHeight();
            dc11.setColor(Color.BLACK);
            dc11.setFont(smallerFont);
            dc11.drawString(this.format.format(scaleValue * (double)i) + "", this.xLeft - cswidth, this.yBottom - y_gridh * i + csheight / 4);
            if (i == 0) continue;
            dc11.setColor(Color.WHITE);
            dc11.setStroke(dotted);
            dc11.drawLine(this.xLeft + 2, this.yBottom - y_gridh * i, this.xRight, this.yBottom - y_gridh * i);
        }
    }

    public void paintXScale(Graphics2D dc) {
        BasicStroke normal = new BasicStroke();
        FontMetrics fontmetri = dc.getFontMetrics();
        Font normalFont = new Font("Dialog", 0, 12);
        int xGridNum = this.data.size();
        if (xGridNum <= 0) {
            return;
        }
        int x_gridw = (this.xRight - this.xLeft) / xGridNum;
        dc.setStroke(normal);
        dc.setFont(normalFont);
        int tmpX = 0;
        for (int j = 0; j < xGridNum; ++j) {
            dc.setColor(Color.BLACK);
            dc.drawLine(this.xLeft + x_gridw * j, this.yBottom + 2, this.xLeft + x_gridw * j, this.yBottom - 2);
            dc.setColor(Color.BLUE);
            dc.drawLine(this.xLeft + x_gridw * j, this.yBottom + 2, this.xLeft + x_gridw * j, this.yBottom - 5);
            String scale = this.data.get(j).getDate();
            int cswidth = fontmetri.stringWidth(scale);
            if (tmpX >= this.xLeft + x_gridw * j - cswidth / 2 - 20) continue;
            dc.drawString(scale, this.xLeft + x_gridw * j - cswidth / 2, this.yBottom + 20);
            tmpX = this.xLeft + x_gridw * j - cswidth / 2 + cswidth;
        }
    }

    public void paintFlowData(Graphics2D dc, double yScaleValue) {
        BasicStroke normal = new BasicStroke();
        int xScaleNum = this.data.size();
        if (xScaleNum <= 0) {
            return;
        }
        int y_gridh = (this.yBottom - this.yTop) / this.yGridNum;
        int x_gridw = (this.xRight - this.xLeft) / xScaleNum;
        dc.setColor(Color.BLUE);
        dc.setStroke(normal);
        TEQosFlowData temp1 = null;
        TEQosFlowData temp2 = null;
        int len = xScaleNum;
        for (int i = 0; i < len; ++i) {
            temp1 = this.data.get(i);
            if (Double.compare(temp1.getFlowVelocity(), 4.294967295E9) == 0) {
                temp2 = temp1;
                continue;
            }
            int y1 = (int)(temp1.getFlowVelocity() / yScaleValue);
            dc.fillOval(this.xLeft + x_gridw * i - 3, this.yBottom - y_gridh * y1 - 3, 6, 6);
            if (temp2 != null && Double.compare(temp2.getFlowVelocity(), 4.294967295E9) != 0) {
                int y2 = (int)(temp2.getFlowVelocity() / yScaleValue);
                dc.drawLine(this.xLeft + x_gridw * (i - 1), this.yBottom - y_gridh * y2, this.xLeft + x_gridw * i, this.yBottom - y_gridh * y1);
            }
            temp2 = temp1;
        }
    }
}

