/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2.TEPortFlowCache;
import com.huawei.nglct.nemgr.ip.sdh.qos_u2kv1r2.TEQosPortFlowData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

public class TEDrawPortFlowPic {
    private static final String BASE_PATH = "ip" + File.separator + "sdh" + File.separator + "res" + File.separator;
    private static final String PAKAGE_PATH = BASE_PATH + "qos_u2kv1r2" + File.separator + "flowchart_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private String labelX = "labelx";
    private String labelY = "labely";
    private String input = "Input";
    private String output = "Output";
    List<TEQosPortFlowData> data = null;
    private static final int PIC_HEIGHT = 379;
    private static final int PIC_WIDTH = 900;
    private BufferedImage flowImage = new BufferedImage(900, 379, 1);
    private Color standcoler = new Color(239, 239, 239);
    private int xLeft = 115;
    private int xRight = 885;
    private int yTop = 8;
    private int yBottom = 344;
    private int yGridNum = 20;
    private int minXSclae = 2;
    private static double yGridValue = 0.05;
    private static final String inval = "4294967295";
    DecimalFormat format = new DecimalFormat("0.0");
    private static TEDrawPortFlowPic instance = null;

    private TEDrawPortFlowPic() {
    }

    public static synchronized TEDrawPortFlowPic getInstance() {
        if (instance == null) {
            instance = new TEDrawPortFlowPic();
        }
        return instance;
    }

    public BufferedImage drawBitTestPic(int neid, Datainterface inputData) {
        this.initResource(neid);
        this.data = TEPortFlowCache.getInstance().getFlowDatas(neid, inputData);
        if (this.data == null) {
            this.drawInitPic();
        } else {
            this.drawDataPic();
        }
        return this.flowImage;
    }

    private void initResource(int neid) {
        this.labelX = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.labelX);
        this.labelY = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.labelY);
        this.input = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.input);
        this.output = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.output);
    }

    public void drawInitPic() {
        Graphics2D waveg2d = this.getSVGGraphics();
        this.paintFrame(waveg2d);
        this.paintYScale(waveg2d, yGridValue);
    }

    private void drawDataPic() {
        Graphics2D waveg2d = this.getSVGGraphics();
        this.paintFrame(waveg2d);
        double maxYValue = TEPortFlowCache.getInstance().getMaxVelocity();
        double scaleValue = yGridValue;
        if (maxYValue > (double)this.yGridNum * yGridValue) {
            scaleValue = maxYValue / (double)this.yGridNum;
        }
        this.paintYScale(waveg2d, scaleValue);
        this.paintXScale(waveg2d);
        this.paintFlowData(waveg2d, scaleValue);
    }

    public Graphics2D getSVGGraphics() {
        return (Graphics2D)this.flowImage.getGraphics();
    }

    public void paintFrame(Graphics2D dc) {
        FontMetrics fontmetri = dc.getFontMetrics();
        Font tmpFont = dc.getFont();
        int speedW = fontmetri.stringWidth(this.labelX);
        dc.setFont(new Font("Dialog", 0, 10));
        this.xLeft = speedW + fontmetri.stringWidth(inval);
        dc.setFont(tmpFont);
        dc.setColor(this.standcoler);
        dc.fillRect(0, 0, 900, 379);
        dc.setColor(Color.LIGHT_GRAY);
        dc.fillRect(this.xLeft, this.yTop, this.xRight - this.xLeft, this.yBottom - this.yTop);
        dc.setColor(Color.BLACK);
        dc.drawLine(this.xLeft, this.yBottom, this.xRight, this.yBottom);
        dc.drawLine(this.xLeft, this.yBottom, this.xLeft, this.yTop);
        Font biggerFont = new Font("Dialog", 0, 14);
        dc.setColor(Color.BLACK);
        dc.setFont(biggerFont);
        dc.drawString(this.labelX, 3, this.yBottom / 2);
        dc.drawString(this.labelY, this.xRight / 2, this.yBottom + 33);
        dc.drawString(this.input, this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6, this.yBottom + 33);
        dc.drawString(this.output, this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.input) + 40, this.yBottom + 33);
        dc.setColor(Color.BLUE);
        dc.fillRect(this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.input) + 10, this.yBottom + 27, 20, 5);
        dc.setColor(Color.GREEN);
        dc.fillRect(this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.input) + fontmetri.stringWidth(this.output) + 55, this.yBottom + 27, 20, 5);
    }

    public void paintYScale(Graphics2D dc, double scaleValue) {
        BasicStroke normal = new BasicStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f);
        FontMetrics fontmetri = dc.getFontMetrics();
        Font normalFont = new Font("Dialog", 0, 12);
        Font smallerFont = new Font("Dialog", 0, 10);
        int y_gridh = (this.yBottom - this.yTop) / this.yGridNum;
        for (int i = 0; i <= this.yGridNum; ++i) {
            dc.setColor(Color.BLACK);
            dc.setStroke(normal);
            dc.setFont(normalFont);
            dc.drawLine(this.xLeft - 2, this.yBottom - y_gridh * i, this.xLeft + 2, this.yBottom - y_gridh * i);
            int cswidth = fontmetri.stringWidth(this.format.format(scaleValue) + "");
            int csheight = fontmetri.getHeight();
            dc.setColor(Color.BLACK);
            dc.setFont(smallerFont);
            dc.drawString(this.format.format(scaleValue * (double)i) + "", this.xLeft - cswidth, this.yBottom - y_gridh * i + csheight / 4);
            if (i == 0) continue;
            dc.setColor(Color.WHITE);
            dc.setStroke(dotted);
            dc.drawLine(this.xLeft + 2, this.yBottom - y_gridh * i, this.xRight, this.yBottom - y_gridh * i);
        }
    }

    public void paintXScale(Graphics2D dc) {
        BasicStroke normal = new BasicStroke();
        FontMetrics fontmetri = dc.getFontMetrics();
        Font normalFont = new Font("Dialog", 0, 12);
        int xGridNum = this.data.size();
        if (xGridNum <= 0) {
            return;
        }
        int x_gridw = (this.xRight - this.xLeft) / xGridNum;
        dc.setStroke(normal);
        dc.setFont(normalFont);
        int gap = 0;
        if (x_gridw < this.minXSclae) {
            x_gridw = this.minXSclae;
            gap = xGridNum * x_gridw % (this.xRight - this.xLeft) == 0 ? xGridNum * x_gridw / (this.xRight - this.xLeft) : xGridNum * x_gridw / (this.xRight - this.xLeft) + 1;
        }
        int tmpX = 0;
        int basLen = 0;
        for (int j = 0; j < xGridNum; ++j) {
            if (gap != 0) {
                if (j % gap != 0) continue;
                basLen = j / gap;
            } else {
                basLen = j;
            }
            dc.setColor(Color.BLACK);
            dc.drawLine(this.xLeft + x_gridw * basLen, this.yBottom + 2, this.xLeft + x_gridw * basLen, this.yBottom - 2);
            dc.setColor(Color.BLUE);
            dc.drawLine(this.xLeft + x_gridw * basLen, this.yBottom + 2, this.xLeft + x_gridw * basLen, this.yBottom - 5);
            String scale = this.data.get(j).getDate();
            int cswidth = fontmetri.stringWidth(scale);
            if (tmpX >= this.xLeft + x_gridw * basLen - cswidth / 2 - 20) continue;
            dc.drawString(scale, this.xLeft + x_gridw * basLen - cswidth / 2, this.yBottom + 20);
            tmpX = this.xLeft + x_gridw * basLen - cswidth / 2 + cswidth;
        }
    }

    public void paintFlowData(Graphics2D dc, double yScaleValue) {
        BasicStroke normal = new BasicStroke();
        int xScaleNum = this.data.size();
        if (xScaleNum <= 0) {
            return;
        }
        int y_gridh = (this.yBottom - this.yTop) / this.yGridNum;
        int x_gridw = (this.xRight - this.xLeft) / xScaleNum;
        dc.setColor(Color.BLUE);
        dc.setStroke(normal);
        TEQosPortFlowData inTmp1 = null;
        TEQosPortFlowData inTmp2 = null;
        int gap = 0;
        int tmpXCount = 0;
        boolean firstFlg = false;
        if (x_gridw < this.minXSclae) {
            x_gridw = this.minXSclae;
            gap = xScaleNum * x_gridw % (this.xRight - this.xLeft) == 0 ? xScaleNum * x_gridw / (this.xRight - this.xLeft) : xScaleNum * x_gridw / (this.xRight - this.xLeft) + 1;
        }
        int basLen = 0;
        int len = xScaleNum;
        for (int i = 0; i < len; ++i) {
            if (gap != 0) {
                if (i % gap != 0) continue;
                basLen = i / gap;
            } else {
                basLen = i;
            }
            inTmp1 = this.data.get(i);
            if (firstFlg) {
                ++tmpXCount;
            }
            if (Double.compare(inTmp1.getFlowVelocityIn(), 4.294967295E9) == 0) continue;
            int y1 = this.compute(inTmp1.getFlowVelocityIn(), yScaleValue, y_gridh);
            firstFlg = true;
            dc.fillOval(this.xLeft + x_gridw * basLen - 3, this.yBottom - y1 - 3, 6, 6);
            if (inTmp2 != null && Double.compare(inTmp2.getFlowVelocityIn(), 4.294967295E9) != 0) {
                int y2 = this.compute(inTmp2.getFlowVelocityIn(), yScaleValue, y_gridh);
                dc.drawLine(this.xLeft + x_gridw * (basLen - tmpXCount), this.yBottom - y2, this.xLeft + x_gridw * basLen, this.yBottom - y1);
                tmpXCount = 0;
            }
            inTmp2 = inTmp1;
        }
        dc.setColor(Color.GREEN);
        dc.setStroke(normal);
        TEQosPortFlowData outTmp1 = null;
        TEQosPortFlowData outTmp2 = null;
        firstFlg = false;
        tmpXCount = 0;
        basLen = 0;
        int len2 = xScaleNum;
        for (int i = 0; i < len2; ++i) {
            if (gap != 0) {
                if (i % gap != 0) continue;
                basLen = i / gap;
            } else {
                basLen = i;
            }
            outTmp1 = this.data.get(i);
            if (firstFlg) {
                ++tmpXCount;
            }
            if (Double.compare(outTmp1.getFlowVelocityOut(), 4.294967295E9) == 0) continue;
            int y1 = this.compute(outTmp1.getFlowVelocityOut(), yScaleValue, y_gridh);
            dc.fillOval(this.xLeft + x_gridw * basLen - 3, this.yBottom - y1 - 3, 6, 6);
            firstFlg = true;
            if (outTmp2 != null && Double.compare(outTmp2.getFlowVelocityOut(), 4.294967295E9) != 0) {
                int y2 = this.compute(outTmp2.getFlowVelocityOut(), yScaleValue, y_gridh);
                dc.drawLine(this.xLeft + x_gridw * (basLen - tmpXCount), this.yBottom - y2, this.xLeft + x_gridw * basLen, this.yBottom - y1);
                tmpXCount = 0;
            }
            outTmp2 = outTmp1;
        }
    }

    private int compute(double value, double yScaleValue, int gap) {
        BigDecimal inData = new BigDecimal(value);
        BigDecimal yScl = new BigDecimal(yScaleValue);
        BigDecimal grad = new BigDecimal(gap);
        int res = inData.divide(yScl, 2, 5).multiply(grad).intValue();
        return res;
    }
}

