/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.qos;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.qos.TEFlowData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEQueryFlowBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private static final String SOURCE_FLOW_ID = "flowid";
    private static final String SOURCE_QOS_TYPE = "qostype";
    private static final String SOURCE_PARA_ID = "paraid";
    private static final String SOURCE_FLOW_TYPE = "flowtype";
    private static final int TYPE_OF_CAR = 1;
    private static final int TYPE_OF_COS = 2;
    private static final int TYPE_OF_SHAPING = 3;
    private static final int TIME_OUT = 10;
    private ArrayList firstOperList;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData1, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData1;
            ArrayList<String> firstOperationNameList = new ArrayList<String>();
            this.outputData = new Datainterface();
            firstOperationNameList.add("NSCMD_ETHN_GET_PORTFLOW");
            firstOperationNameList.add("NSCMD_ETHN_GET_PORTVLANFLOW");
            firstOperationNameList.add("NSCMD_ETHN_GET_PORTSVLANFLOW");
            firstOperationNameList.add("NSCMD_ETHN_GET_PORTCSVLANFLOW");
            this.firstOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData1, (int)neid, firstOperationNameList);
            int firstResult = this.sendMessage(neid, this.firstOperList);
            if (firstResult == 0) {
                ArrayList<String> secondOperNameList = new ArrayList<String>();
                secondOperNameList.add("NSCMD_ETHN_GET_FLOWTYPE");
                secondOperNameList.add("NSCMD_ETHN_GET_FLOW_ACTION");
                ArrayList secondOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData1, (int)neid, secondOperNameList);
                if (this.structureSecondlyData(this.firstOperList, secondOperList)) {
                    int secondResult1 = this.sendMessage(neid, secondOperList);
                    if (secondResult1 == 0) {
                        this.handleMessage(neid, secondOperList, subFunc, this.getFilterErrorCodeList());
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)secondResult1));
                    }
                } else {
                    this.handleMessage(neid, this.firstOperList, subFunc, this.getFilterErrorCodeList());
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)firstResult));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData1, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryFlowBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    public int sendMessage(int neid, ArrayList operList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)operList, 10);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public boolean structureSecondlyData(ArrayList parentOperationList, ArrayList childOperationList) {
        if (parentOperationList.size() == 0) {
            return false;
        }
        ArrayList<Operation> tempList = new ArrayList<Operation>();
        int nullIdCount = 0;
        int size = parentOperationList.size();
        for (int i = 0; i < size; ++i) {
            Operation parentOperation = (Operation)parentOperationList.get(i);
            Output[] outPutArray = parentOperation.getOutput();
            int count = 0;
            for (int j = 0; j < outPutArray.length; ++j) {
                String flowid = outPutArray[j].getPart(SOURCE_FLOW_ID).getValue();
                if (flowid == null) {
                    ++count;
                    continue;
                }
                int length = childOperationList.size();
                for (int k = 0; k < length; ++k) {
                    Operation childOperation = (Operation)((Operation)childOperationList.get(k)).clone();
                    childOperation.getInput().setPartValue(SOURCE_FLOW_ID, flowid);
                    tempList.add(childOperation);
                }
            }
            if (count != outPutArray.length) continue;
            ++nullIdCount;
        }
        childOperationList.clear();
        childOperationList.addAll(tempList);
        return nullIdCount != size;
    }

    public void handleMessage(int neid, ArrayList secondOperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        RowParams tempRowParam;
        int errorCount;
        String flowId;
        this.outputData = TEFlowData.convertToDatainterface(neid, subfunc, secondOperList, filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        RowParams rowparams = null;
        Param param = null;
        int size = this.outputData.getBussinessParams().getRowParamsCount();
        HashMap<Integer, TEFlowData> flowDataMap = new HashMap<Integer, TEFlowData>(size);
        for (int i = size - 1; i >= 0; --i) {
            boolean idIsExist = true;
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams.getParam().length == 0) continue;
            param = Datainterface.getParam((Param[])rowparams.getParam(), (String)SOURCE_FLOW_ID);
            flowId = param.getValue();
            TEFlowData flowData = (TEFlowData)flowDataMap.get(new Integer(flowId));
            if (flowData == null) {
                flowData = new TEFlowData();
                idIsExist = false;
            }
            if ("".equals((param = Datainterface.getParam((Param[])rowparams.getParam(), (String)SOURCE_QOS_TYPE)).getValue())) {
                if (!idIsExist) {
                    flowDataMap.put(new Integer(flowId), flowData);
                    continue;
                }
                this.outputData.getBussinessParams().setRowParams(i, null);
                continue;
            }
            int qosType = new Integer(param.getValue());
            param = Datainterface.getParam((Param[])rowparams.getParam(), (String)SOURCE_PARA_ID);
            int idOfboundType = new Integer(param.getValue());
            switch (qosType) {
                case 1: {
                    flowData.setBoundCarId(idOfboundType);
                    break;
                }
                case 2: {
                    flowData.setBoundCosId(idOfboundType);
                    break;
                }
                case 3: {
                    flowData.setBoundShapingId(idOfboundType);
                    break;
                }
            }
            flowDataMap.put(new Integer(flowId), flowData);
            if (!idIsExist) continue;
            this.outputData.getBussinessParams().setRowParams(i, null);
        }
        Datainterface temp = new Datainterface();
        temp.setBussinessParams(new BussinessParams());
        int rowParamsCount = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = rowParamsCount - 1; i >= 0; --i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams == null || rowparams.getParam().length == 0) continue;
            param = Datainterface.getParam((Param[])rowparams.getParam(), (String)SOURCE_FLOW_ID);
            flowId = param.getValue();
            rowparams.addParam("vbid", "-");
            rowparams.addParam("priority", "-");
            rowparams.addParam("boundCAR", ((TEFlowData)flowDataMap.get(new Integer(flowId))).getBoundCarId());
            rowparams.addParam("boundCoS", ((TEFlowData)flowDataMap.get(new Integer(flowId))).getBoundCosId());
            rowparams.addParam("boundShaping", ((TEFlowData)flowDataMap.get(new Integer(flowId))).getBoundShapingId());
            param = Datainterface.getParam((Param[])rowparams.getParam(), (String)SOURCE_FLOW_TYPE);
            int length = this.firstOperList.size();
            for (int j = 0; j < length; ++j) {
                Output[] tempOutput = ((Operation)this.firstOperList.get(j)).getOutput();
                int outputLength = tempOutput.length;
                for (int k = 0; k < outputLength; ++k) {
                    String tempId = tempOutput[k].getPart(SOURCE_FLOW_ID).getValue();
                    if (!flowId.equals(tempId)) continue;
                    rowparams.getParam("portid").setValue(tempOutput[k].getPart("portid").getValue());
                    rowparams.getParam(SOURCE_FLOW_TYPE).setValue("1");
                    Part vlanIdPart = tempOutput[k].getPart("vlanid");
                    Part svlanIdPart = tempOutput[k].getPart("svlanid");
                    if (vlanIdPart != null && !"".equals(vlanIdPart.getValue())) {
                        if (svlanIdPart != null && !"".equals(svlanIdPart.getValue())) {
                            rowparams.getParam(SOURCE_FLOW_TYPE).setValue("4");
                            rowparams.getParam("svlanid").setValue(tempOutput[k].getPart("svlanid").getValue());
                        } else {
                            rowparams.getParam(SOURCE_FLOW_TYPE).setValue("2");
                            rowparams.getParam("svlanid").setValue("-");
                        }
                        rowparams.getParam("vlanid").setValue(tempOutput[k].getPart("vlanid").getValue());
                        continue;
                    }
                    rowparams.getParam("vlanid").setValue("-");
                    if (svlanIdPart != null && !"".equals(svlanIdPart.getValue())) {
                        rowparams.getParam(SOURCE_FLOW_TYPE).setValue("3");
                        rowparams.getParam("svlanid").setValue(tempOutput[k].getPart("svlanid").getValue());
                        continue;
                    }
                    rowparams.getParam("svlanid").setValue("-");
                }
            }
            temp.getBussinessParams().addRowParams(rowparams);
        }
        if (rowParamsCount > 0 && (errorCount = (tempRowParam = this.outputData.getBussinessParams().getRowParams(rowParamsCount - 1)).getRowErrorsCount()) > 0) {
            String errCode = tempRowParam.getRowErrors(0).getErrorMessage().getErrorcode();
            for (int z = tempRowParam.getRowErrorsCount() - 1; z >= 0; --z) {
                String tempErrCode = tempRowParam.getRowErrors(z).getErrorMessage().getErrorcode();
                if (errCode == null || !errCode.equals(tempErrCode) || z <= 0 || tempErrCode.equals("0")) continue;
                tempRowParam.removeRowErrors(tempRowParam.getRowErrors(z));
            }
            temp.getBussinessParams().addRowParams(tempRowParam);
        }
        this.outputData.setBussinessParams(temp.getBussinessParams());
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>(1);
        filterErrorCodeList.add(new Integer(38662));
        return filterErrorCodeList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEQueryFlowBean.this.addProtectionToString();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String addProtectionToString() {
        int rowCount1 = this.outputData.getBussinessParams().getRowParamsCount();
        StringBuffer strBuf1 = new StringBuffer();
        Param[] params1 = this.inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params1, (String)"neId").getValue());
        StringBuffer filePath1 = new StringBuffer();
        filePath1.append("ip").append(File.separator).append("sdh").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("qos").append(File.separator).append("qosloginres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath1);
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        String slotid = rParams[0].getParam("slotid").getValue();
        int slot1 = Integer.parseInt(slotid);
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int boardType = configurDataMgr.getBoard(this.neid, slot1).getBoardType();
        String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
        strBuf1.append(this.res.getString("board")).append(":").append(slot1).append("-").append(boardName).append(";");
        for (int i = 0; i < rowCount1; ++i) {
            Param[] params = this.outputData.getBussinessParams().getRowParams(i).getParam();
            String flowType = Datainterface.getParam((Param[])params, (String)SOURCE_FLOW_TYPE).getValue();
            String vbid = Datainterface.getParam((Param[])params, (String)"vbid").getValue();
            String priority = Datainterface.getParam((Param[])params, (String)"priority").getValue();
            int port = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"portid").getValue());
            String portname = port > 32768 ? "VCTRUNK" + (port - 32768) : "port" + port;
            String vlanID = Datainterface.getParam((Param[])params, (String)"vlanid").getValue();
            if (vlanID.equals("")) {
                if (flowType.equals("1")) {
                    strBuf1.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_flow")).append(",").append(this.res.getString("VB ID")).append(":").append(vbid).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("flow_Pri")).append(":").append(priority).append(";");
                }
                if (!flowType.equals("2")) continue;
                strBuf1.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_vlan_flow")).append(",").append(this.res.getString("VB ID")).append(":").append(vbid).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("flow_Pri")).append(":").append(priority).append(";");
                continue;
            }
            if (flowType.equals("1")) {
                strBuf1.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_flow")).append(",").append(this.res.getString("VB ID")).append(":").append(vbid).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("VLAN ID")).append(":").append(vlanID).append(",").append(this.res.getString("flow_Pri")).append(":").append(priority).append(";");
            }
            if (!flowType.equals("2")) continue;
            strBuf1.append(this.res.getString("qostype_Qostype")).append(":").append(this.res.getString("port_vlan_flow")).append(",").append(this.res.getString("VB ID")).append(":").append(vbid).append(",").append(this.res.getString("Port_name")).append(":").append(portname).append(",").append(this.res.getString("VLAN ID")).append(":").append(vlanID).append(",").append(this.res.getString("flow_Pri")).append(":").append(priority).append(";");
        }
        return strBuf1.toString();
    }
}

