/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.qos;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEModifyCoSBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            ArrayList<String> operationNameList = new ArrayList<String>();
            RowParams rowParam = inputData.getBussinessParams().getRowParams(0);
            int cosType = new Integer(rowParam.getParam("costype").getValue());
            switch (cosType) {
                case 1: {
                    operationNameList.add("NSCMD_ETHN_SET_COS_SIMPLE_PARA");
                    break;
                }
                case 2: {
                    operationNameList.add("NSCMD_ETHN_SET_COS_VLANPRI_PARA");
                    break;
                }
                case 5: {
                    operationNameList.add("NSCMD_ETHN_SET_COS_DSCP_PARA");
                    break;
                }
                case 4: {
                    operationNameList.add("NSCMD_ETHN_SET_COS_MPLSEXP_PARA");
                    break;
                }
                case 3: {
                    operationNameList.add("NSCMD_ETHN_SET_COS_IPTOS_PARA");
                    break;
                }
                default: {
                    operationNameList = null;
                }
            }
            this.operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, operationNameList);
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEModifyCoSBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEModifyCoSBean.this.addProtectionToString1();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String addProtectionToString1() {
        StringBuffer strBuf = new StringBuffer();
        Param[] params = this.inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("sdh").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("qos").append(File.separator).append("qosloginres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        String slotid1 = rParams[0].getParam("slotid").getValue();
        int slot = Integer.parseInt(slotid1);
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int boardType = configurDataMgr.getBoard(this.neid, slot).getBoardType();
        String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
        strBuf.append(this.res.getString("board")).append(":").append(slot).append("-").append(boardName).append(",");
        String cosid = Datainterface.getParam((Param[])params, (String)"cosid").getValue();
        String costype = Datainterface.getParam((Param[])params, (String)"costype").getValue();
        String pri = Datainterface.getParam((Param[])params, (String)"pri").getValue();
        strBuf.append(this.res.getString("cosid_ID")).append(":").append(cosid).append(",").append(this.res.getString("costype_Type")).append(":").append(this.res.getString("costype_Type_" + costype)).append(",");
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            Param cospara = rParams[i].getParam("cospara");
            Param dscpPara = rParams[i].getParam("dscp");
            if (cospara != null && !cospara.getValue().equals("")) {
                strBuf.append(this.res.getString("cospara")).append(":").append(this.res.getString("cospara_" + cospara.getValue())).append(",").append(this.res.getString("pri_Pir")).append(":").append(rParams[i].getParam("pri").getValue()).append(";");
                continue;
            }
            if (dscpPara != null && !dscpPara.getValue().equals("")) {
                strBuf.append(this.res.getString("cospara")).append(":").append(this.res.getString("dscppriority_" + dscpPara.getValue())).append(",").append(this.res.getString("pri_Pir")).append(":").append(rParams[i].getParam("pri").getValue()).append(";");
                continue;
            }
            strBuf.append(this.res.getString("pri_Pir")).append(":").append(pri);
        }
        return strBuf.toString();
    }
}

