/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.portmirror;

import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEGetSupportETHPort
implements TENEMgrInterface {
    protected Datainterface outputData = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        ArrayList supportETHPort = TEConfigurationDataMgr.getInstance().getETHPort(neid, boardType);
        boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        int slotid = Integer.parseInt(boardTypeParam.getValue());
        String boardName = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid).getBoardName();
        this.convertToOutPutData(neid, slotid, supportETHPort, boardName);
        return this.outputData;
    }

    public void convertToOutPutData(int neid, int slotid, ArrayList supportETHPort, String boardName) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (null == supportETHPort) {
            return;
        }
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowparams = null;
        String portID = null;
        boolean flag = true;
        int len = supportETHPort.size();
        for (int i = 0; i < len; ++i) {
            rowparams = new RowParams();
            portID = supportETHPort.get(i).toString();
            rowparams.addParam("portid", portID);
            if (flag) {
                rowparams.addParam("boardname", boardName);
            }
            flag = false;
            rowparams.addParam(new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)slotid))));
            rowparams.addParam(new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid)));
            rowparams.addParam(new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid))));
            bussinessParams.addRowParams(rowparams);
        }
        this.outputData.setBussinessParams(bussinessParams);
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

