/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.portmirror;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.List;

public class TEDeletePortMirror
extends TENEExplorerBean {
    private static final int PROTEMIRROR_NOT_EXIST_ERRORCODE = 38751;
    private static final int VCTRUNK = 32768;
    private List logInfoList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(new Integer(38751));
        return filterErrorCodeList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData2) {
        try {
            if (outputData2.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operateObject = "";
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int errorCode2 = Integer.parseInt(outputData2.getErrorMessage().getErrorcode());
            switch (errorCode2) {
                case 1090646019: {
                    break;
                }
                case 0: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode2);
                    break;
                }
                case 1: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode2);
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                case 2: {
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operateObject, operateName, errorCode2);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        int userID = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userID = Integer.parseInt(user);
            }
            catch (Exception e) {
                userID = 0;
            }
        }
        RowParams rowParams2 = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo2 = new TELogInfo();
            loginfo2.setCmdID(this.subfunc.getCode());
            loginfo2.setLocation(ipAddress);
            loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo2.setUserID(userID);
            loginfo2.setOperateObject(operateObject);
            loginfo2.setOperateName(operateName);
            rowParams2 = this.inputData.getBussinessParams().getRowParams(i);
            int slotid = Integer.parseInt(rowParams2.getParam("slotid").getValue());
            int bdType = this.cfgDataMgr.getBoardType(this.neid, slotid);
            String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            int mirrorport = Integer.parseInt(rowParams2.getParam("mirrorport").getValue());
            desc = operateObject + "-" + slotid + "-" + boardName + ":";
            desc = mirrorport > 32768 ? "VCTRUNK" + (mirrorport - 32768) : "PORT" + mirrorport;
            loginfo2.setOperateDesc(desc);
            loginfo2.setResult(0);
            loginfo2.setErrCode(0);
            loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginfo2);
        }
    }

    private void logFail(String user, String ipAddress, String operateObject, String operateName) {
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors2 = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors2.length;
            for (int j = 0; j < size; ++j) {
                int slotid = Integer.parseInt(rowErrors2[j].getParam("slotid").getValue());
                int bdType = this.cfgDataMgr.getBoardType(this.neid, slotid);
                String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                int mirrorport = Integer.parseInt(rowErrors2[j].getParam("mirrorport").getValue());
                String desc = operateObject + "-" + slotid + "-" + boardName + ":" + "PORT" + mirrorport;
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(desc)) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo loginfo2 = new TELogInfo();
                loginfo2.setCmdID(this.subfunc.getCode());
                loginfo2.setLocation(ipAddress);
                loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo2.setOperateObject(operateObject);
                loginfo2.setOperateName(operateName);
                loginfo2.setOperateDesc(desc);
                loginfo2.setResult(2);
                loginfo2.setErrCode(Integer.parseInt(rowErrors2[j].getErrorMessage().getErrorcode()));
                loginfo2.setErrInfo(rowErrors2[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(loginfo2);
            }
        }
    }

    private void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        TELogInfo loginfo2 = new TELogInfo();
        loginfo2.setCmdID(this.subfunc.getCode());
        loginfo2.setLocation(ipAddress);
        loginfo2.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo2.setOperateObject(operateObject);
        loginfo2.setOperateName(operateName);
        loginfo2.setOperateDesc(operateName);
        loginfo2.setResult(2);
        loginfo2.setErrCode(errorCode);
        loginfo2.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginfo2);
    }
}

