/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.portflow_u2kv2r5c01.bwuswatch;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.nemgr.ip.sdh.portflow_u2kv2r5c01.bwuswatch.TEBWUSWatchCache;
import com.huawei.nglct.nemgr.ip.sdh.portflow_u2kv2r5c01.bwuswatch.TEBWUSWatchData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

public class TEDrawBWUSWatchPic {
    private static final String BASE_PATH = "ip" + File.separator + "sdh" + File.separator + "res" + File.separator;
    private static final String PAKAGE_PATH = BASE_PATH + "qos_u2kv1r2" + File.separator + "flowchart_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private String labelX = "labelx_bwuswatch";
    private String labelY = "labely_bwuswatch";
    private String input = "Input";
    private String output = "Output";
    List<TEBWUSWatchData> bwusdata = null;
    private static final int PIC_HEIGHT = 379;
    private static final int PIC_WIDTH = 900;
    private BufferedImage flowImage = new BufferedImage(900, 379, 1);
    private Color standcoler = new Color(239, 239, 239);
    private int xLeft = 115;
    private int xRight = 885;
    private int yTop = 8;
    private int yBottom = 344;
    private int yGridNum = 20;
    private int minXSclae = 2;
    private static double yGridValue = 0.05;
    private static final String inval = "4294967295";
    DecimalFormat format = new DecimalFormat("0.0");
    private static TEDrawBWUSWatchPic instance = null;

    private TEDrawBWUSWatchPic() {
    }

    public static synchronized TEDrawBWUSWatchPic getInstance() {
        if (instance == null) {
            instance = new TEDrawBWUSWatchPic();
        }
        return instance;
    }

    public BufferedImage drawBitTestPic(int neid, Datainterface inputData) {
        this.initResource(neid);
        this.bwusdata = TEBWUSWatchCache.getInstance().getFlowDatas(neid, inputData);
        if (this.bwusdata == null) {
            this.drawInitPic();
        } else {
            this.drawDataPic();
        }
        return this.flowImage;
    }

    private void initResource(int neid) {
        this.labelX = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.labelX);
        this.labelY = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.labelY);
        this.input = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.input);
        this.output = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.output);
    }

    public void drawInitPic() {
        Graphics2D waveg2d = this.getSVGGraphics();
        this.paintFrame(waveg2d);
        this.paintYScale(waveg2d, yGridValue);
    }

    private void drawDataPic() {
        Graphics2D wavegBwus2d = this.getSVGGraphics();
        this.paintFrame(wavegBwus2d);
        double maxYValue = TEBWUSWatchCache.getInstance().getMaxVelocity();
        double scaleValue = yGridValue;
        if (maxYValue > (double)this.yGridNum * yGridValue) {
            scaleValue = maxYValue / (double)this.yGridNum;
        }
        this.paintYScale(wavegBwus2d, scaleValue);
        this.paintXScale(wavegBwus2d);
        this.paintFlowData(wavegBwus2d, scaleValue);
    }

    public Graphics2D getSVGGraphics() {
        return (Graphics2D)this.flowImage.getGraphics();
    }

    public void paintFrame(Graphics2D bwusdc) {
        FontMetrics fontmetri = bwusdc.getFontMetrics();
        Font tmpFont = bwusdc.getFont();
        int speedW = fontmetri.stringWidth(this.labelX);
        bwusdc.setFont(new Font("Dialog", 0, 10));
        this.xLeft = speedW + fontmetri.stringWidth(inval);
        bwusdc.setFont(tmpFont);
        bwusdc.setColor(this.standcoler);
        bwusdc.fillRect(0, 0, 900, 379);
        bwusdc.setColor(Color.LIGHT_GRAY);
        bwusdc.fillRect(this.xLeft, this.yTop, this.xRight - this.xLeft, this.yBottom - this.yTop);
        bwusdc.setColor(Color.BLACK);
        bwusdc.drawLine(this.xLeft, this.yBottom, this.xRight, this.yBottom);
        bwusdc.drawLine(this.xLeft, this.yBottom, this.xLeft, this.yTop);
        Font biggerFont = new Font("Dialog", 0, 14);
        bwusdc.setColor(Color.BLACK);
        bwusdc.setFont(biggerFont);
        bwusdc.drawString(this.labelX, 3, this.yBottom / 2);
        bwusdc.drawString(this.labelY, this.xRight / 2, this.yBottom + 33);
        bwusdc.drawString(this.input, this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6, this.yBottom + 33);
        bwusdc.drawString(this.output, this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.input) + 40, this.yBottom + 33);
        bwusdc.setColor(Color.BLUE);
        bwusdc.fillRect(this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.input) + 10, this.yBottom + 27, 20, 5);
        bwusdc.setColor(Color.GREEN);
        bwusdc.fillRect(this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.input) + fontmetri.stringWidth(this.output) + 55, this.yBottom + 27, 20, 5);
    }

    public void paintYScale(Graphics2D bwusdc, double scaleValue) {
        BasicStroke normal = new BasicStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f);
        FontMetrics fontmetri = bwusdc.getFontMetrics();
        Font normalFont = new Font("Dialog", 0, 12);
        Font smallerFont = new Font("Dialog", 0, 10);
        int y_gridh = (this.yBottom - this.yTop) / this.yGridNum;
        for (int i = 0; i <= this.yGridNum; ++i) {
            bwusdc.setColor(Color.BLACK);
            bwusdc.setStroke(normal);
            bwusdc.setFont(normalFont);
            bwusdc.drawLine(this.xLeft - 2, this.yBottom - y_gridh * i, this.xLeft + 2, this.yBottom - y_gridh * i);
            int cswidth = fontmetri.stringWidth(this.format.format(scaleValue) + "");
            int csheight = fontmetri.getHeight();
            bwusdc.setColor(Color.BLACK);
            bwusdc.setFont(smallerFont);
            bwusdc.drawString(this.format.format(scaleValue * (double)i) + "", this.xLeft - cswidth, this.yBottom - y_gridh * i + csheight / 4);
            if (i == 0) continue;
            bwusdc.setColor(Color.WHITE);
            bwusdc.setStroke(dotted);
            bwusdc.drawLine(this.xLeft + 2, this.yBottom - y_gridh * i, this.xRight, this.yBottom - y_gridh * i);
        }
    }

    public void paintXScale(Graphics2D bwusdc) {
        BasicStroke normal = new BasicStroke();
        FontMetrics fontmetri = bwusdc.getFontMetrics();
        Font normalFont = new Font("Dialog", 0, 12);
        int xGridNum = this.bwusdata.size();
        if (xGridNum <= 0) {
            return;
        }
        int x_gridw = (this.xRight - this.xLeft) / xGridNum;
        bwusdc.setStroke(normal);
        bwusdc.setFont(normalFont);
        int gap = 0;
        if (x_gridw < this.minXSclae) {
            x_gridw = this.minXSclae;
            gap = xGridNum * x_gridw % (this.xRight - this.xLeft) == 0 ? xGridNum * x_gridw / (this.xRight - this.xLeft) : xGridNum * x_gridw / (this.xRight - this.xLeft) + 1;
        }
        int tmpX = 0;
        int basLen = 0;
        for (int j = 0; j < xGridNum; ++j) {
            if (gap != 0) {
                if (j % gap != 0) continue;
                basLen = j / gap;
            } else {
                basLen = j;
            }
            bwusdc.setColor(Color.BLACK);
            bwusdc.drawLine(this.xLeft + x_gridw * basLen, this.yBottom + 2, this.xLeft + x_gridw * basLen, this.yBottom - 2);
            bwusdc.setColor(Color.BLUE);
            bwusdc.drawLine(this.xLeft + x_gridw * basLen, this.yBottom + 2, this.xLeft + x_gridw * basLen, this.yBottom - 5);
            String scale = this.bwusdata.get(j).getDate();
            int cswidth = fontmetri.stringWidth(scale);
            if (tmpX >= this.xLeft + x_gridw * basLen - cswidth / 2 - 20) continue;
            bwusdc.drawString(scale, this.xLeft + x_gridw * basLen - cswidth / 2, this.yBottom + 20);
            tmpX = this.xLeft + x_gridw * basLen - cswidth / 2 + cswidth;
        }
    }

    public void paintFlowData(Graphics2D bwusdc, double yScaleValue) {
        BasicStroke normal = new BasicStroke();
        int xScaleNum = this.bwusdata.size();
        if (xScaleNum <= 0) {
            return;
        }
        int y_gridh = (this.yBottom - this.yTop) / this.yGridNum;
        int x_gridw = (this.xRight - this.xLeft) / xScaleNum;
        bwusdc.setColor(Color.BLUE);
        bwusdc.setStroke(normal);
        TEBWUSWatchData inBwusTmp1 = null;
        TEBWUSWatchData inBwusTmp2 = null;
        int gap = 0;
        int tmpXCount = 0;
        boolean firstFlg = false;
        if (x_gridw < this.minXSclae) {
            x_gridw = this.minXSclae;
            gap = xScaleNum * x_gridw % (this.xRight - this.xLeft) == 0 ? xScaleNum * x_gridw / (this.xRight - this.xLeft) : xScaleNum * x_gridw / (this.xRight - this.xLeft) + 1;
        }
        int basLen = 0;
        int len = xScaleNum;
        for (int i = 0; i < len; ++i) {
            if (gap != 0) {
                if (i % gap != 0) continue;
                basLen = i / gap;
            } else {
                basLen = i;
            }
            inBwusTmp1 = this.bwusdata.get(i);
            if (firstFlg) {
                ++tmpXCount;
            }
            if (Double.compare(inBwusTmp1.getFlowVelocityIn(), 255.0) == 0) continue;
            int y1 = this.compute(inBwusTmp1.getFlowVelocityIn(), yScaleValue, y_gridh);
            firstFlg = true;
            bwusdc.fillOval(this.xLeft + x_gridw * basLen - 3, this.yBottom - y1 - 3, 6, 6);
            if (inBwusTmp2 != null && Double.compare(inBwusTmp2.getFlowVelocityIn(), 255.0) != 0) {
                int y2 = this.compute(inBwusTmp2.getFlowVelocityIn(), yScaleValue, y_gridh);
                bwusdc.drawLine(this.xLeft + x_gridw * (basLen - tmpXCount), this.yBottom - y2, this.xLeft + x_gridw * basLen, this.yBottom - y1);
                tmpXCount = 0;
            }
            inBwusTmp2 = inBwusTmp1;
        }
        bwusdc.setColor(Color.GREEN);
        bwusdc.setStroke(normal);
        TEBWUSWatchData outbwusTmp1 = null;
        TEBWUSWatchData outbwusTmp2 = null;
        firstFlg = false;
        tmpXCount = 0;
        basLen = 0;
        int len2 = xScaleNum;
        for (int i = 0; i < len2; ++i) {
            if (gap != 0) {
                if (i % gap != 0) continue;
                basLen = i / gap;
            } else {
                basLen = i;
            }
            outbwusTmp1 = this.bwusdata.get(i);
            if (firstFlg) {
                ++tmpXCount;
            }
            if (Double.compare(outbwusTmp1.getFlowVelocityOut(), 255.0) == 0) continue;
            int y1 = this.compute(outbwusTmp1.getFlowVelocityOut(), yScaleValue, y_gridh);
            bwusdc.fillOval(this.xLeft + x_gridw * basLen - 3, this.yBottom - y1 - 3, 6, 6);
            firstFlg = true;
            if (outbwusTmp2 != null && Double.compare(outbwusTmp2.getFlowVelocityOut(), 255.0) != 0) {
                int y2 = this.compute(outbwusTmp2.getFlowVelocityOut(), yScaleValue, y_gridh);
                bwusdc.drawLine(this.xLeft + x_gridw * (basLen - tmpXCount), this.yBottom - y2, this.xLeft + x_gridw * basLen, this.yBottom - y1);
                tmpXCount = 0;
            }
            outbwusTmp2 = outbwusTmp1;
        }
    }

    private int compute(double bwusvalue, double yScaleValue, int gap) {
        BigDecimal inData = new BigDecimal(bwusvalue);
        BigDecimal yScl = new BigDecimal(yScaleValue);
        BigDecimal grad = new BigDecimal(gap);
        return inData.divide(yScl, 2, 5).multiply(grad).intValue();
    }
}

