/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.portflow_u2kv2r5c01.bwuswatch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.sdh.portflow_u2kv2r5c01.bwuswatch.TEBWUSWatchData;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEBWUSWatchCache {
    private Map<Integer, List<TEBWUSWatchData>> flowDatas = new Hashtable<Integer, List<TEBWUSWatchData>>();
    private TimeZoneDateBean timeProccessor = null;
    private int numOfData = 20;
    private double maxVelocity = 0.0;
    private double minVelocity = 0.0;
    static final double INVALIDVALUE = 255.0;
    private static TEBWUSWatchCache instance = null;

    public int getNumOfData() {
        return this.numOfData;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public void setMaxVelocity(double maxVelocity) {
        this.maxVelocity = maxVelocity;
    }

    public double getMinVelocity() {
        return this.minVelocity;
    }

    public void setFlowDatas(Map<Integer, List<TEBWUSWatchData>> flowDatas) {
        this.flowDatas = flowDatas;
    }

    public List<TEBWUSWatchData> getFlowDatas(int neid, Datainterface inputData) {
        TELogFactory.getNormalLogger().info("the buffer map's size->!" + this.flowDatas.size());
        List<TEBWUSWatchData> list = this.flowDatas.get(neid);
        if (list == null) {
            list = this.queryPortFlowData(neid, inputData);
        }
        return list;
    }

    private TEBWUSWatchCache() {
    }

    public static synchronized TEBWUSWatchCache getInstance() {
        if (instance == null) {
            instance = new TEBWUSWatchCache();
        }
        return instance;
    }

    public List<TEBWUSWatchData> queryPortFlowData(int neid, Datainterface inputData) {
        this.flowDatas.clear();
        List<TEBWUSWatchData> list = new ArrayList<TEBWUSWatchData>();
        int retCode = 0;
        try {
            this.timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
            this.splitTime(inputData);
            SubFunc subfunc = TECreateObjectFactory.getSubFunc((int)neid, (int)2179654);
            ArrayList operationList = TEDataConverter.convertToOperation((SubFunc)subfunc, (Datainterface)inputData, (int)neid);
            if (null == operationList || operationList.size() == 0) {
                TELogFactory.getNormalLogger().info("queryBWUSWatchData fail, no operation!");
                return list;
            }
            this.fliterOperation(neid, operationList);
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, 60, subfunc);
            if (null != result) {
                retCode = result.retCode;
            }
            if (retCode == 0) {
                list = this.parsePortFlowData(neid, operationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("queryBWUSWatchData fail!", (Throwable)e);
        }
        return list;
    }

    private void fliterOperation(int neid, List operationList) {
        Iterator iter = operationList.iterator();
        String operName = "NSCMD_PTNETH_GET_PORT_BWUSWATCH_FLUX";
        if (this.isRtn600(neid)) {
            operName = "NSCMD_ETHN_GET_PORT_BWWATCH_FLUX";
        }
        Operation oper = null;
        while (iter.hasNext()) {
            oper = (Operation)iter.next();
            if (operName.equalsIgnoreCase(oper.getName())) continue;
            iter.remove();
        }
    }

    public List<TEBWUSWatchData> parsePortFlowData(int neid, List opers) {
        String calendar = null;
        TEBWUSWatchData qosdata = null;
        ArrayList<TEBWUSWatchData> list = new ArrayList<TEBWUSWatchData>();
        int ilen = opers.size();
        for (int i = 0; i < ilen; ++i) {
            Operation oper = (Operation)opers.get(i);
            if (this.isRtn600(neid) ? !"NSCMD_ETHN_GET_PORT_BWWATCH_FLUX".equals(oper.getName()) : !"NSCMD_PTNETH_GET_PORT_BWUSWATCH_FLUX".equals(oper.getName())) continue;
            for (Output outPut : oper.getOutput()) {
                if (0 != Integer.valueOf(outPut.getFault(0).getCode())) continue;
                int slotid = Integer.parseInt(outPut.getPartValue("slotid"));
                int port = Integer.parseInt(outPut.getPartValue("port"));
                calendar = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).UTCToTime(outPut.getPartValue("date"));
                double rxData = Double.valueOf(outPut.getPartValue("rxdata_bwus"));
                double txData = Double.valueOf(outPut.getPartValue("txdata_bwus"));
                if (Double.compare(rxData, 255.0) != 0 && Double.compare(this.maxVelocity, rxData) < 0) {
                    this.maxVelocity = rxData;
                }
                if (Double.compare(txData, 255.0) != 0 && Double.compare(this.maxVelocity, txData) < 0) {
                    this.maxVelocity = txData;
                }
                qosdata = new TEBWUSWatchData(slotid, port);
                qosdata.setDate(calendar);
                qosdata.setFlowVelocityIn(rxData);
                qosdata.setFlowVelocityOut(txData);
                list.add(qosdata);
            }
        }
        this.flowDatas.clear();
        this.flowDatas.put(neid, list);
        return list;
    }

    private void splitTime(Datainterface inputData) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        Calendar beg = TEDateUtils.byteStrToCalendar((String)this.timeProccessor.strToUTC(rowParams.getParam("begindate").getValue()));
        Calendar end = TEDateUtils.byteStrToCalendar((String)this.timeProccessor.strToUTC(rowParams.getParam("enddate").getValue()));
        this.refTime(beg, false);
        this.refTime(end, true);
        BussinessParams bussiness_new = new BussinessParams();
        Calendar tmp = null;
        RowParams tmpRow = null;
        while (beg.get(5) != end.get(5) || beg.get(2) != end.get(2)) {
            tmp = (Calendar)beg.clone();
            beg.add(5, 1);
            beg.set(11, 0);
            beg.set(12, 0);
            beg.set(13, 0);
            tmpRow = (RowParams)rowParams.clone();
            tmpRow.getParam("begindate").setValue(TEDateUtils.calendarToByteStr((Calendar)tmp));
            tmpRow.getParam("enddate").setValue(TEDateUtils.calendarToByteStr((Calendar)beg));
            bussiness_new.addRowParams(tmpRow);
        }
        if (beg.compareTo(end) < 0) {
            tmpRow = (RowParams)rowParams.clone();
            tmpRow.getParam("begindate").setValue(TEDateUtils.calendarToByteStr((Calendar)beg));
            tmpRow.getParam("enddate").setValue(TEDateUtils.calendarToByteStr((Calendar)end));
            bussiness_new.addRowParams(tmpRow);
        }
        inputData.setBussinessParams(bussiness_new);
    }

    private void refTime(Calendar cal, boolean flg) {
        int sec;
        int basicTime = 900;
        int min = cal.get(12);
        int total = min * 60 + (sec = cal.get(13));
        if (total % basicTime != 0) {
            cal.set(12, 0);
            cal.set(13, 0);
            if (flg) {
                cal.add(13, (total / basicTime + 1) * basicTime);
            } else {
                cal.add(13, total / basicTime * basicTime);
            }
        }
    }

    private boolean isRtn600(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        return neType == 60 || neType == 55 || neType == 54;
    }
}

