/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.policy.portpolicy;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.List;
import java.util.Vector;

public class TEQueryLogicalBoardBean
extends TENEExplorerBean {
    private static final int BOARD_AUXQ = 1413;
    private static final int BOARD_IFE2 = 1404;
    private static final int BOARD_EF8T = 1414;
    private static final int BOARD_EF8F = 1415;
    private static final int BOARD_EG2 = 1416;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            Vector logBoardList = neObj.getBoardList();
            this.outputData = new Datainterface();
            BussinessParams bussiness = new BussinessParams();
            int len = logBoardList.size();
            for (int i = 0; i < len; ++i) {
                RowParams row;
                TEBoard board = (TEBoard)logBoardList.get(i);
                int boardType = board.getBoardType();
                int boardSlot = board.getSlotID();
                String boardName = cfgDataMgr.getBoardTypeName(neid, boardType);
                if (this.isPortPolicySuppBoard(neid, boardType)) {
                    row = new RowParams();
                    row.addParam("board", boardSlot + "-" + boardName);
                    bussiness.addRowParams(row);
                }
                List subBoardList = board.getSubBoardList();
                int size = subBoardList.size();
                for (int j = 0; j < size; ++j) {
                    TESubBoard subBoard = (TESubBoard)subBoardList.get(j);
                    String subBoardName = cfgDataMgr.getBoardTypeName(neid, subBoard.getSubBoardType());
                    int subBoardId = subBoard.getSubSlotID();
                    int subBType = TEConfigurationDataMgr.getInstance().getSubboardType(neid, boardSlot, subBoardId);
                    if (!this.isPortPolicySuppBoard(neid, subBType)) continue;
                    row = new RowParams();
                    row.addParam("board", boardSlot + "-" + boardName + "-" + subBoardId + "-" + subBoardName);
                    bussiness.addRowParams(row);
                }
            }
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public boolean isPortPolicySuppBoard(int neid, int boardType) {
        TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
        boolean ret = false;
        if (boardType == 1413 || boardType == 1414 || boardType == 1415 || boardType == 1416 || boardType == 1404) {
            ret = true;
            return ret;
        }
        List list = instance.getPortPropertyList(boardType);
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                int portType = ((TEPortProperty)list.get(i)).getPortType();
                if (portType == 1799 || portType == 1797) {
                    ret = true;
                    break;
                }
                if (portType != 1798 || boardType != 1134) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }
}

