/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.mstp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryMstiBean
extends TENEExplorerBean {
    private ArrayList rowErrorList = new ArrayList();
    private StringBuffer portGroupIDArray = new StringBuffer();
    private static final String MSTP = "1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        try {
            BussinessParams businessparams = inputData.getBussinessParams();
            RowParams rowparams = businessparams.getRowParams(0);
            String isQeryPortGroup = rowparams.getParam("isQeryPortGroup").getValue();
            String slotid = rowparams.getParam("slotid").getValue();
            if ("false".equals(isQeryPortGroup)) {
                return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            }
            int resultCode = -1;
            resultCode = this.queryPortGroup(slotid);
            if (resultCode != 0) {
                resultCode = 2;
                int size = this.rowErrorList.size();
                for (int i = 0; i < size; ++i) {
                    RowParams rParam = new RowParams();
                    RowErrors rError = (RowErrors)this.rowErrorList.get(i);
                    rParam.addRowErrors(rError);
                    this.outputData.getBussinessParams().addRowParams(rParam);
                }
                ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)resultCode);
                this.outputData.setErrorMessage(bigErr);
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData, true);
                }
                return this.outputData;
            }
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, subFunc);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData, true);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private int queryPortGroup(String slotid) {
        boolean flag = false;
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_GET_MST_WORKMODE_WBID");
        Input input = oper.getInput();
        input.setPartValue("vbid", "0");
        input.setPartValue("slotid", slotid);
        this.operationList.add(oper);
        int result = this.sendMessage(this.neid);
        if (result != 0) {
            return result;
        }
        Operation tmpOper = (Operation)this.operationList.get(0);
        this.operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 0) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
                String neName = neObj.getNEName();
                TEBoard bd = neObj.getBoard(Integer.parseInt(slotid));
                String bdName = bd.getBoardName();
                String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)Integer.valueOf(slotid));
                RowErrors rowError = new RowErrors();
                Param errorParamNeName = new Param("nename", neName + "-" + subrack);
                rowError.addParam(errorParamNeName);
                Param errorParamBdName = new Param("boardname", bdName);
                rowError.addParam(errorParamBdName);
                Param errorParamSlotId = new Param("slotid", slotid);
                rowError.addParam(errorParamSlotId);
                Param errorParam = new Param("vbid", "");
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                this.rowErrorList.add(rowError);
                return code;
            }
            String portGroupID = output.getPartValue("vbid");
            String protocolType = output.getPartValue("protocolType");
            if (!MSTP.equals(protocolType)) continue;
            this.portGroupIDArray.append(portGroupID).append(",");
            if (flag) continue;
            flag = true;
            for (int j = 1; j <= 48; ++j) {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_GET_MST_MSTIINFO_WBID");
                input = oper.getInput();
                input.setPartValue("vbid", portGroupID);
                input.setPartValue("mstiID", j + "");
                input.setPartValue("slotid", slotid);
                this.operationList.add(oper);
            }
        }
        return 0;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (0 < this.portGroupIDArray.length()) {
            RowParams rowparam = new RowParams();
            Param param = new Param("vbid", this.portGroupIDArray.toString());
            rowparam.addParam(param);
            this.outputData.getBussinessParams().addRowParams(0, rowparam);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (0 < this.portGroupIDArray.length()) {
            RowParams rowparam = new RowParams();
            Param param = new Param("vbid", this.portGroupIDArray.toString());
            rowparam.addParam(param);
            this.outputData.getBussinessParams().addRowParams(0, rowparam);
        }
        for (RowParams row : this.outputData.getBussinessParams().getRowParamList()) {
            if (row.getParam("rootvbno") == null || row.getParam("rootvbno").getValue() == null || row.getParam("rootvbno").getValue().isEmpty()) continue;
            int designvbnovalue = Integer.parseInt(row.getParam("rootvbno").getValue());
            if (designvbnovalue > 0) {
                String rootPort = "";
                rootPort = row.getParam("rootvbno").getValue() + "-" + this.getPortName(row);
                row.getParam("port").setValue(rootPort);
                continue;
            }
            row.getParam("port").setValue("0");
        }
    }

    private String getPortName(RowParams row) {
        if (row.getParam("port") != null && row.getParam("port").getValue() != null && !row.getParam("port").getValue().isEmpty()) {
            return "LP" + row.getParam("port").getValue();
        }
        return "";
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
        TELogInfo loginfo = null;
        int userID = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userID = Integer.parseInt(user);
            }
            catch (Exception e) {
                userID = 0;
            }
        }
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String operObj = "";
        operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
        RowParams rowparams = null;
        RowParams errorRowParams = null;
        int tmpErrorCode = 0;
        loginfo = new TELogInfo();
        rowparams = inputData.getBussinessParams().getRowParams(1);
        loginfo.setOperateDesc(this.getDetailStr(rowparams));
        if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
            loginfo.setResult(2);
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        } else if (errorCode == 0) {
            loginfo.setResult(0);
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        } else {
            int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
            errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
            tmpErrorCode = this.getOperResult(rowparams, errorRowParams);
            if (tmpErrorCode != 0) {
                loginfo.setResult(2);
            } else {
                loginfo.setResult(0);
            }
            loginfo.setErrCode(tmpErrorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)tmpErrorCode));
        }
        loginfoList.add(loginfo);
        int size = loginfoList.size();
        for (int i = 0; i < size; ++i) {
            loginfo = (TELogInfo)loginfoList.get(i);
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserID(userID);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo.setOperateObject(operObj);
            TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
        }
    }
}

