/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.mstp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryBridgePortBean
extends TENEExplorerBean {
    private ArrayList rowErrorList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.subfunc = subFunc;
        String portGroupID = inputData.getBussinessParams().getRowParams(0).getParam("vbid").getValue();
        String slotid = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        String logicPortID = inputData.getBussinessParams().getRowParams(0).getParam("logicPortID").getValue();
        int result = this.getQueryBridgePortOper(portGroupID, slotid, logicPortID);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            int size = this.rowErrorList.size();
            for (int i = 0; i < size; ++i) {
                RowParams rParam = new RowParams();
                RowErrors rError = (RowErrors)this.rowErrorList.get(i);
                rParam.addRowErrors(rError);
                this.outputData.getBussinessParams().addRowParams(rParam);
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
            return this.outputData;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int getQueryBridgePortOper(String vbid, String slotid, String logicPortID) {
        ArrayList<Operation> firstOperationList = new ArrayList<Operation>();
        firstOperationList.add(this.getQueryOperationFromName("NSCMD_ETHN_GET_MST_ADMINEDGE_WBID", slotid, vbid, logicPortID));
        firstOperationList.add(this.getQueryOperationFromName("NSCMD_ETHN_GET_MST_ADMINP2P_WBID", slotid, vbid, logicPortID));
        firstOperationList.add(this.getQueryOperationFromName("NSCMD_ETHN_GET_MST_TRANSLIMIT_WBID", slotid, vbid, logicPortID));
        int result = this.sendMessage(this.neid, firstOperationList);
        if (0 != result) {
            return result;
        }
        Output[] output1 = ((Operation)firstOperationList.get(0)).getOutput();
        this.operationList.clear();
        int iSize = output1.length;
        for (int i = 0; i < iSize; ++i) {
            for (Fault fault : output1[i].getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 0) continue;
                return this.handleErrorInfo(slotid, vbid, code);
            }
            this.operationList.add(this.getQueryOperationFromName("NSCMD_ETHN_GET_MST_ADMINEDGEREAL_WBID", slotid, vbid, output1[i].getPartValue("logicPortID")));
            this.operationList.add(this.getQueryOperationFromName("NSCMD_ETHN_GET_MST_ADMINP2PREAL_WBID", slotid, vbid, output1[i].getPartValue("logicPortID")));
            this.operationList.add(this.getQueryOperationFromName("NSCMD_ETHN_GET_MST_PORTENABLE_WBID", slotid, vbid, output1[i].getPartValue("logicPortID")));
        }
        result = this.sendMessage(this.neid);
        if (0 != result) {
            return result;
        }
        this.operationList.addAll(firstOperationList);
        this.outputData = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operationList);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        RowParams rowparams = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String portProtocolEnable;
            String p2pinfact;
            rowparams = bussiness.getRowParams(i);
            if (rowparams.getRowErrorsCount() > 0) continue;
            int portid = Integer.valueOf(rowparams.getParam("logicPortID").getValue());
            String portName = "LP" + (portid - 28672);
            rowparams.addParam("portname", portName);
            String edgeAttriInFact = rowparams.getParam("edgeAttriInFact").getValue();
            if ("-1".equals(edgeAttriInFact)) {
                rowparams.getParam("edgeAttriInFact").setValue("9");
            }
            if ("-1".equals(p2pinfact = rowparams.getParam("p2pinfact").getValue())) {
                rowparams.getParam("p2pinfact").setValue("9");
            }
            if (!"-1".equals(portProtocolEnable = rowparams.getParam("portProtocolEnable").getValue())) continue;
            rowparams.getParam("portProtocolEnable").setValue("9");
        }
        return 0;
    }

    private int handleErrorInfo(String slotid, String vbid, int code) {
        TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String neName = neObj.getNEName();
        TEBoard bd = neObj.getBoard(Integer.parseInt(slotid));
        String bdName = bd.getBoardName();
        String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)Integer.valueOf(slotid));
        RowErrors rowError = new RowErrors();
        Param errorParam = new Param("errorBbj", slotid + "Query Port Group");
        rowError.addParam(errorParam);
        Param errorParamNeName = new Param("nename", neName + "-" + subrack);
        rowError.addParam(errorParamNeName);
        Param errorParamBdName = new Param("boardname", bdName);
        rowError.addParam(errorParamBdName);
        Param errorParamSlotId = new Param("slotid", slotid);
        rowError.addParam(errorParamSlotId);
        Param errorParamVbID = new Param("vbid", vbid);
        rowError.addParam(errorParamVbID);
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
        this.rowErrorList.add(rowError);
        return 2;
    }

    private Operation getQueryOperationFromName(String name, String slotid, String vbid, String logicPortID) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)name);
        Input input1 = oper.getInput();
        input1.setPartValue("slotid", slotid);
        input1.setPartValue("vbid", vbid);
        input1.setPartValue("logicPortID", logicPortID);
        return oper;
    }

    public int getTimeOut() {
        return 120;
    }
}

