/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.mstp;

import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TEConfigPGBean
extends TENEExplorerBean {
    private static final int INVALID_VALUE = 255;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        BussinessParams businessparams2 = inputData.getBussinessParams();
        this.getCreatePGOper(businessparams2);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result2 = this.sendMessage(neid);
        if (result2 == 0) {
            this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result2));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void getCreatePGOper(BussinessParams bussinessparams) {
        String portGroupID = bussinessparams.getRowParams(0).getParam("portGroupID").getValue();
        RowParams rowparams2 = null;
        int len = bussinessparams.getRowParamsCount();
        for (int i = 1; i < len; ++i) {
            rowparams2 = bussinessparams.getRowParams(i);
            String operateFlag = rowparams2.getParam("operateFlag").getValue();
            if ("addPorts".equals(operateFlag)) {
                Operation addPortOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_ADD_MSTPPORTMEMBER");
                Input addPortOperInput2 = addPortOper.getInput();
                addPortOperInput2.setPartValue("idFlag", "0");
                addPortOperInput2.setPartValue("portGroupID", portGroupID);
                addPortOperInput2.setPartValue("slotid", rowparams2.getParam("slotid").getValue());
                addPortOperInput2.setPartValue("subslotid", rowparams2.getParam("subslotid").getValue());
                addPortOperInput2.setPartValue("port", rowparams2.getParam("port").getValue());
                this.operationList.add(addPortOper);
                continue;
            }
            Operation deletePortOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_DEL_MSTPPORTMEMBER");
            Input deletePortOperInput2 = deletePortOper.getInput();
            deletePortOperInput2.setPartValue("portGroupID", portGroupID);
            deletePortOperInput2.setPartValue("slotid", rowparams2.getParam("slotid").getValue());
            deletePortOperInput2.setPartValue("subslotid", rowparams2.getParam("subslotid").getValue());
            deletePortOperInput2.setPartValue("port", rowparams2.getParam("port").getValue());
            this.operationList.add(deletePortOper);
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final Datainterface finputData = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEConfigPGBean.this.getDetailStr(finputData.getBussinessParams());
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    public String getDetailStr(BussinessParams bussinessparams) {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String MSTP_RES = "ip" + File.separator + "sdh" + File.separator + "res" + File.separator + "MSTP_" + LANGUAGE + ".ini";
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)MSTP_RES);
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(resourceUtil.getString("port")).append(":");
        RowParams rowparams = null;
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int len = bussinessparams.getRowParamsCount();
        for (int i = 1; i < len; ++i) {
            rowparams = bussinessparams.getRowParams(i);
            int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            int boardType = configurDataMgr.getBoardType(this.neid, slotid);
            String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
            int subslotid = Integer.parseInt(rowparams.getParam("subslotid").getValue());
            if (255 != subslotid) {
                int subboardType = configurDataMgr.getSubboardType(this.neid, slotid, subslotid);
                String subboardName = configurDataMgr.getBoardTypeName(this.neid, subboardType);
                String port = rowparams.getParam("port").getValue();
                String portName = configurDataMgr.getPortName(this.neid, slotid, boardType, Integer.parseInt(port));
                operDesc.append(slotid).append("-").append(boardName).append("-").append(subslotid).append("-").append(subboardName).append("-").append(portName).append(" ");
                continue;
            }
            String port = rowparams.getParam("port").getValue();
            String portName = configurDataMgr.getPortName(this.neid, slotid, boardType, Integer.parseInt(port));
            operDesc.append(slotid).append("-").append(boardName).append("-").append(portName).append(" ");
        }
        return operDesc.toString();
    }
}

