/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.lpt.TEPTNLPTExtParaMOPO;
import com.huawei.nglct.po.embeddednemgrmo.lpt.TEPTNPTMLPTMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEPtnLPTUtil {
    private static final int GET_DATA_FROM_NE = 1;
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();
    public static final int LPT_TYPE_P2P = 1;
    public static final int LPT_TYPE_P2M = 2;
    public static final int CARRY_TYPE_UNI = 1;
    public static final int CARRY_TYPE_L2NET = 5;

    public static boolean checkOutputSuccess(int neID, Datainterface inputData, Datainterface outputData, String errorMsg) {
        String errorCode = outputData.getErrorMessage().getErrorcode();
        if (!errorCode.equals(String.valueOf(0))) {
            String tipStr = "perform " + errorMsg + " is fail and not save data to DB! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.info(tipStr);
            return false;
        }
        return true;
    }

    public static int getParamIntValue(RowParams rowparam, String name) {
        Param param = rowparam.getParam(name);
        int value = -1;
        if (null != param && null != param.getValue() && !"".equals(param.getValue())) {
            value = Integer.parseInt(param.getValue());
        }
        return value;
    }

    public static long getParamLongValue(RowParams rowparam, String name) {
        Param param = rowparam.getParam(name);
        long value = -1L;
        if (null != param && null != param.getValue() && !"".equals(param.getValue())) {
            value = Long.parseLong(param.getValue());
        }
        return value;
    }

    public static void deletePTNPTMLPTList(int neID, List<TEPTNPTMLPTMOPO> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            TEPtnLPTUtil.deletePTNPTMLPT(neID, list.get(i));
        }
    }

    public static void createPTNPTMLPTList(int neID, List<TEPTNPTMLPTMOPO> lptmopoList) {
        for (int i = lptmopoList.size() - 1; i >= 0; --i) {
            TEPtnLPTUtil.createPTNPTMLPT(neID, lptmopoList.get(i));
        }
    }

    public static void createPTNPTMLPT(int neID, TEPTNPTMLPTMOPO lptmopo) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((int)neID, (int[])new int[]{neID}, (Object)lptmopo);
            if (null == dbResult) {
                String tipStr = "create TEPTNPTMLPTMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return;
            }
        }
        catch (Exception e) {
            String tipStr = "create TEPTNPTMLPTMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            String tipStr = "create TEPTNPTMLPTMOPO fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
        }
    }

    public static void updatePTNPTMLPT(int neID, TEPTNPTMLPTMOPO lptmopo) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((int)neID, (int[])new int[]{neID}, (Object)lptmopo);
            if (null == dbResult) {
                String tipStr = "update TEPTNPTMLPTMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return;
            }
        }
        catch (Exception e) {
            String tipStr = "update TEPTNPTMLPTMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            String tipStr = "update TEPTNPTMLPTMOPO fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
        }
    }

    public static void deletePTNPTMLPT(int neID, TEPTNPTMLPTMOPO lptmopo) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.delete((int)neID, (int[])new int[]{neID}, (Object)lptmopo);
            if (null == dbResult) {
                String tipStr = "delete TEPTNPTMLPTMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return;
            }
        }
        catch (Exception e) {
            String tipStr = "delete TEPTNPTMLPTMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            String tipStr = "delete TEPTNPTMLPTMOPO fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
        }
    }

    public static TEPTNPTMLPTMOPO getPTNPTMLPT(int neID, int topCarryMode, long slotid, long subslotid, long port) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("RootType", String.valueOf(topCarryMode));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair("RootPara1", String.valueOf(slotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair("RootPara2", String.valueOf(subslotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair("RootPara3", String.valueOf(port));
        criteria.add(aPair);
        TEPTNPTMLPTMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findByID((int)neID, (int[])new int[]{neID}, TEPTNPTMLPTMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEPTNPTMLPTMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEPTNPTMLPTMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEPTNPTMLPTMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static List<TEPTNPTMLPTMOPO> getPTNPTMLPTList(int neID) {
        ArrayList<TEPTNPTMLPTMOPO> list = new ArrayList<TEPTNPTMLPTMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int)neID, (int[])new int[]{neID}, TEPTNPTMLPTMOPO.class);
            if (null == dbResult) {
                String tipStr = "Get TEPTNPTMLPTMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return list;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEPTNPTMLPTMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return list;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                int len = data.size();
                for (int i = 0; i < len; ++i) {
                    list.add((TEPTNPTMLPTMOPO)data.get(i));
                }
            }
        } else {
            String tipStr = "Get TEPTNPTMLPTMOPO fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
        }
        E2ELOGGER.info("get TEPTNPTMLPTMOPO from db end.");
        return list;
    }

    public static Datainterface performSubFunc(int neID, int firstfid, int secondfid, Datainterface inputData) {
        Datainterface allData = null;
        try {
            SubFunc subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)firstfid);
            if (null == subFunc && null == (subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)secondfid)) && null == (subFunc = TECreateObjectFactory.getSubFunc((int)firstfid))) {
                E2ELOGGER.info("Don't found subfunction(sfid = " + firstfid + ") description in Functions description file\u00a3\u00a1");
                return null;
            }
            Datainterface memeryData = new Datainterface();
            allData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neID, (SubFunc)subFunc, (Datainterface)inputData, (Datainterface)memeryData, null, null, (int)1);
        }
        catch (Exception e) {
            E2ELOGGER.error("The PTNPTMLPT from weblct exception " + neID, (Throwable)e);
            allData = new Datainterface();
            allData.setBussinessParams(new BussinessParams());
            allData.setErrorMessage(new ErrorMessage());
            allData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)1090646019));
        }
        return allData;
    }

    public static int getNEAllLPTToDB(int neID, boolean uploadFlag) {
        TENE ne;
        String firstFlag = "Upload";
        if (!uploadFlag) {
            firstFlag = "Sync";
        }
        if ((ne = TENEListMgr.getInstance().getNE(neID)) == null) {
            String tipStr = firstFlag + " PTN LPT NE is Not Exist!";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            TELogFactory.getE2ELogger().info(tipStr);
            return 0;
        }
        String domain = TEGetNEDomainVersion.getInstance().getDomain(ne.getNEType());
        if (!domain.equalsIgnoreCase("sdh")) {
            String tipStr = firstFlag + " PTN LPT NE is not support!";
            tipStr = tipStr + String.format("[neID:%d,DOMAIN:%s]", neID, domain);
            TELogFactory.getE2ELogger().info(tipStr);
            return 0;
        }
        E2ELOGGER.info(firstFlag + " PTN LPT begin.");
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            String tipStr = firstFlag + " PTN LPT fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
            E2ELOGGER.info(firstFlag + " PTN LPT end.");
            return retCode;
        }
        TEPtnLPTUtil.getNEP2PLMTTODB(neID);
        TEPtnLPTUtil.getNEP2MLPTTODB(neID);
        return 0;
    }

    public static int getNEP2PLMTTODB(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams row = new RowParams();
        row.addParam("neid", String.valueOf(neID));
        bussiness.addRowParams(row);
        row.addParam("servType", "1");
        bussiness.addRowParams(row);
        row.addParam("servIndex", "0");
        bussiness.addRowParams(row);
        row.addParam("vuniId", "0");
        bussiness.addRowParams(row);
        row.addParam("vnniId", "0");
        bussiness.addRowParams(row);
        Datainterface outputData = TEPtnLPTUtil.performSubFunc(neID, 2179101, 0, inputData);
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            String tipStr = "Query PTN P2PLPT from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, errCode:%d]", neID, errorCode);
            E2ELOGGER.error(tipStr);
        }
        return errorCode;
    }

    public static int getNEP2MLPTTODB(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams row = new RowParams();
        row.addParam("neid", String.valueOf(neID));
        bussiness.addRowParams(row);
        Datainterface outputData = TEPtnLPTUtil.performSubFunc(neID, 2279105, 2179105, inputData);
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            String tipStr = "Query PTN P2MLPT from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, errCode:%d]", neID, errorCode);
            E2ELOGGER.error(tipStr);
        }
        return errorCode;
    }

    public static List<TEPTNLPTExtParaMOPO> getPTNLPTExtParaList(int neID) {
        ArrayList<TEPTNLPTExtParaMOPO> list = new ArrayList<TEPTNLPTExtParaMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int)neID, (int[])new int[]{neID}, TEPTNLPTExtParaMOPO.class);
            if (null == dbResult) {
                String tipStr = "Get TEPTNLPTExtParaMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return list;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEPTNLPTExtParaMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return list;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                int len = data.size();
                for (int i = 0; i < len; ++i) {
                    list.add((TEPTNLPTExtParaMOPO)data.get(i));
                }
            }
        } else {
            String tipStr = "Get TEPTNLPTExtParaMOPO fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
        }
        E2ELOGGER.info("get TEPTNLPTExtParaMOPO from db end.");
        return list;
    }

    public TEPTNLPTExtParaMOPO getPTNLPTExtPara(int neID, int carryType, long param1, long param2, long param3) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("CarryType", String.valueOf(carryType));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair("Param1", String.valueOf(param1));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair("Param2", String.valueOf(param2));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair("Param3", String.valueOf(param3));
        criteria.add(aPair);
        TEPTNLPTExtParaMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findByID((int)neID, (int[])new int[]{neID}, TEPTNLPTExtParaMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEPTNLPTExtParaMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEPTNLPTExtParaMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEPTNLPTExtParaMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updatePTNLPTExtPara(int neID, TEPTNLPTExtParaMOPO lptmopo) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((int)neID, (int[])new int[]{neID}, (Object)lptmopo);
            if (null == dbResult) {
                String tipStr = "update TEPTNLPTExtParaMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return;
            }
        }
        catch (Exception e) {
            String tipStr = "update TEPTNLPTExtParaMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            String tipStr = "update TEPTNLPTExtParaMOPO fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
        }
    }

    public static void deletePTNLPTExtPara(int neID, int lpttype) {
        List<TEPTNLPTExtParaMOPO> list = TEPtnLPTUtil.getPTNLPTExtParaList(neID);
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (list.get(i).getLPTType() != lpttype) continue;
                TEPtnLPTUtil.deletePTNLPTExtPara(neID, list.get(i));
                list.remove(i);
            }
        }
    }

    public static void deletePTNLPTExtPara(int neID, TEPTNLPTExtParaMOPO lptmopo) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.delete((int)neID, (int[])new int[]{neID}, (Object)lptmopo);
            if (null == dbResult) {
                String tipStr = "delete TEPTNLPTExtParaMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return;
            }
        }
        catch (Exception e) {
            String tipStr = "delete TEPTNLPTExtParaMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            String tipStr = "delete TEPTNLPTExtParaMOPO fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
        }
    }

    public static void createPTNLPTExtPara(int neID, TEPTNLPTExtParaMOPO mopo) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((int)neID, (int[])new int[]{neID}, (Object)mopo);
            if (null == dbResult) {
                String tipStr = "create TEPTNLPTExtParaMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                E2ELOGGER.error(tipStr);
                return;
            }
        }
        catch (Exception e) {
            String tipStr = "create TEPTNLPTExtParaMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            String tipStr = "create TEPTNLPTExtParaMOPO fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
        }
    }

    public static void createPTNLPTExtParaList(int neID, List<TEPTNLPTExtParaMOPO> listExt) {
        for (int i = listExt.size() - 1; i >= 0; --i) {
            TEPtnLPTUtil.createPTNLPTExtPara(neID, listExt.get(i));
        }
    }

    public static void deletePTNLPTExtParaList(int neID, List<TEPTNLPTExtParaMOPO> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            TEPtnLPTUtil.deletePTNLPTExtPara(neID, list.get(i));
        }
    }
}

