/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.lpt.TEP2PLPTMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEP2PLPTDBMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    public static final String DB_COL_SLOT = "SlotID";
    public static final String DB_COL_PORT = "PortID";
    public static final String DB_COL_SUBCARD = "SubCardID";

    private TEP2PLPTDBMgr() {
    }

    public static List<TEP2PLPTMOPO> getAllP2PLptsFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEP2PLPTDBMgr.getP2PLptFromDB";
        normalLogger.info("TEP2PLPTDBMgr.getP2PLptFromDB: begin.");
        ArrayList<TEP2PLPTMOPO> lptList = new ArrayList<TEP2PLPTMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEP2PLPTDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.getP2PLptFromDB");
                return lptList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEP2PLPTMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEP2PLPTMOPO.class);
        }
        catch (Exception e) {
            normalLogger.error("get arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.getP2PLptFromDB");
            return lptList;
        }
        if (null == dbResult) {
            normalLogger.error("get clock device from db fail! dbResult is null! neID->" + neID);
            errRet.setResult(1092743443);
            TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.getP2PLptFromDB");
            return lptList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    lptList.add((TEP2PLPTMOPO)obj);
                }
            }
        } else {
            TEP2PLPTDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.getP2PLptFromDB");
        return lptList;
    }

    public static TEP2PLPTMOPO getP2PLptFromDB(int neID, int slotid, int subslotid, int port) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair(DB_COL_SLOT, String.valueOf(slotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_SUBCARD, String.valueOf(subslotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_PORT, String.valueOf(port));
        criteria.add(aPair);
        TEP2PLPTMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TEP2PLPTMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TEP2PLPTMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEP2PLPTMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                normalLogger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEPTNPTPLPTMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            normalLogger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEP2PLPTMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void delP2PLptFromDB(int neID, TEP2PLPTMOPO lptMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEP2PLPTDBMgr.delP2PLptFromDB";
        normalLogger.info("TEP2PLPTDBMgr.delP2PLptFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)lptMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)lptMO);
        }
        catch (Exception e) {
            normalLogger.error("delete arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.delP2PLptFromDB");
            return;
        }
        if (null == dbResult) {
            TEP2PLPTDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.delP2PLptFromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEP2PLPTDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.delP2PLptFromDB");
    }

    public static void createP2PLptToDB(int neID, TEP2PLPTMOPO lptMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEP2PLPTDBMgr.createP2PLptToDB";
        normalLogger.info("TEP2PLPTDBMgr.createP2PLptToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)lptMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)lptMO);
        }
        catch (Exception e) {
            TEP2PLPTDBMgr.logExceptionError(neID, e);
            errRet.setResult(1092743443);
            TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.createP2PLptToDB");
            return;
        }
        if (null == dbResult) {
            TEP2PLPTDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.createP2PLptToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEP2PLPTDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.createP2PLptToDB");
    }

    public static void updateP2PLptToDB(int neID, TEP2PLPTMOPO lptMo, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEP2PLPTDBMgr.updateP2PLptToDB";
        normalLogger.info("TEP2PLPTDBMgr.updateP2PLptToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)lptMo) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)lptMo);
        }
        catch (Exception e) {
            TEP2PLPTDBMgr.logExceptionError(neID, e);
            errRet.setResult(1092743443);
            TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.updateP2PLptToDB");
            return;
        }
        if (null == dbResult) {
            TEP2PLPTDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.updateP2PLptToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEP2PLPTDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.updateP2PLptToDB");
    }

    public static void delAllP2PLptFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEP2PLPTDBMgr.delAllP2PLptFromDB";
        normalLogger.info("TEP2PLPTDBMgr.delAllP2PLptFromDB: begin.");
        List<TEP2PLPTMOPO> lptList = TEP2PLPTDBMgr.getAllP2PLptsFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEP2PLPTDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(1090596385);
        }
        for (TEP2PLPTMOPO lpt : lptList) {
            TEP2PLPTDBMgr.delP2PLptFromDB(neID, lpt, errRet);
        }
        TEP2PLPTDBMgr.logFuncEnd("TEP2PLPTDBMgr.delAllP2PLptFromDB");
    }

    private static void logNullNEError(int neID) {
        normalLogger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logNullError(int neID) {
        normalLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logFuncEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }

    private static void logRetCodeError(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logExceptionError(int neID, Exception e) {
        normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
    }
}

