/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TEIPUtils;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TELptBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class TEQueryUNIP2PLPT
extends TENEExplorerBean {
    private static final String PW = "1";
    private static final String QinQ = "4";
    private static final String LPTPW = "2";
    private static final String LPTQinQ = "3";
    private static final String LNET = "5";
    public static final String INVALID_ID = "4294967295";
    int neID = 0;
    Vector boardList = null;
    private Map<String, String> pwMap = new HashMap<String, String>();
    private Map<String, String> qinqMap = new HashMap<String, String>();
    private Map<String, RowParams> rowMap = new HashMap<String, RowParams>();
    ArrayList keyList = new ArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList getf) {
        int boardType;
        TELptBean lptBean;
        String key;
        Output out;
        int i;
        this.neID = neid;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Operation nniOper = (Operation)operationList.get(0);
        Operation uniOper = (Operation)operationList.get(1);
        Operation elineOper = (Operation)operationList.get(2);
        if (nniOper.getOutputCount() == 0 || uniOper.getOutputCount() == 0 || elineOper.getOutputCount() == 0) {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return;
        }
        HashMap<String, TELptBean> resultMap = new HashMap<String, TELptBean>();
        int iLength = nniOper.getOutput().length;
        for (i = 0; i < iLength; ++i) {
            out = nniOper.getOutput()[i];
            key = out.getPartValue("servType") + "-" + out.getPartValue("servIndex");
            lptBean = new TELptBean();
            lptBean.setServType(out.getPartValue("servType"));
            lptBean.setServIndex(out.getPartValue("servIndex"));
            lptBean.setVnniId(out.getPartValue("vnniId"));
            lptBean.setRole(out.getPartValue("role"));
            lptBean.setCarrierType(out.getPartValue("carrierType"));
            lptBean.setParam1(out.getPartValue("param1"));
            lptBean.setParam2(out.getPartValue("param2"));
            lptBean.setParam3(out.getPartValue("param3"));
            resultMap.put(key, lptBean);
        }
        iLength = uniOper.getOutput().length;
        for (i = 0; i < iLength; ++i) {
            out = uniOper.getOutput()[i];
            key = out.getPartValue("servType") + "-" + out.getPartValue("servIndex");
            lptBean = (TELptBean)resultMap.get(key);
            if (lptBean == null) continue;
            lptBean.setSlotid(out.getPartValue("slotid"));
            lptBean.setPort(out.getPartValue("port"));
            lptBean.setTagNum(out.getPartValue("tagNum"));
            lptBean.setTagIds(out.getPartValue("tagIds"));
        }
        iLength = elineOper.getOutput().length;
        for (i = 0; i < iLength; ++i) {
            out = elineOper.getOutput()[i];
            key = "1-" + out.getPartValue("servIndex");
            lptBean = (TELptBean)resultMap.get(key);
            if (lptBean == null) continue;
            lptBean.setBpduFlag(out.getPartValue("bpduFlag"));
        }
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        for (Map.Entry entry : resultMap.entrySet()) {
            TELptBean lptBean2 = (TELptBean)entry.getValue();
            RowParams row = new RowParams();
            if (lptBean2.getSlotid() == null) continue;
            int slotid = Integer.parseInt(lptBean2.getSlotid());
            boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            this.addParam(row, "servType", lptBean2.getServType());
            this.addParam(row, "servIndex", lptBean2.getServIndex());
            this.addParam(row, "vnniId", lptBean2.getVnniId());
            this.addParam(row, "role", lptBean2.getRole());
            this.addParam(row, "carrierType", lptBean2.getCarrierType());
            this.addParam(row, "param1", lptBean2.getParam1());
            this.addParam(row, "param2", lptBean2.getParam2());
            this.addParam(row, "param3", lptBean2.getParam3());
            this.addParam(row, "vuniId", lptBean2.getVuniId());
            this.addParam(row, "slotid", lptBean2.getSlotid());
            this.addParam(row, "port", lptBean2.getPort());
            this.addParam(row, "tagNum", lptBean2.getTagNum());
            this.addParam(row, "tagIds", lptBean2.getTagIds());
            this.addParam(row, "bpduFlag", lptBean2.getBpduFlag());
            this.addParam(row, "subslotid", "255");
            this.addParam(row, "neid", String.valueOf(neid));
            this.addParam(row, "boardtype", String.valueOf(boardType));
            String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardType, Integer.parseInt(lptBean2.getPort()));
            this.addParam(row, "portname", portname);
            this.addParam(row, "boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType));
            this.outputData.getBussinessParams().addRowParams(row);
        }
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.setErrorMessage(this.outputData.getErrorMessage());
            RowParams[] brows = this.outputData.getBussinessParams().getRowParams();
            for (int i2 = brows.length - 1; i2 >= 0; --i2) {
                if (brows[i2].getRowErrorsCount() <= 0) continue;
                this.outputData.getBussinessParams().addRowParams(brows[i2]);
            }
            return;
        }
        if (ne != null) {
            this.boardList = ne.getBoardList();
        }
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_PTPLPT_GET_BIND");
        int size = this.boardList.size();
        for (int i3 = 0; i3 < size; ++i3) {
            TEBoard board = (TEBoard)this.boardList.get(i3);
            boardType = board.getBoardType();
            if (!TEIPUtils.isSupportGroupBoard(neid, boardType)) continue;
            int slotid = board.getSlotID();
            String subslotid = "255";
            String port = "0";
            Input input = operation.getInput();
            input.setPartValue("slotid", String.valueOf(slotid));
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", port);
            operList.add(operation.clone());
        }
        Datainterface returnData = new Datainterface();
        if (null == operList || operList.isEmpty()) {
            returnData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            this.outputData = returnData;
            return;
        }
        int retCode = super.sendMessage(neid, operList);
        if (retCode == 0) {
            this.constructL2netData(neid, operList);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)retCode));
            RowParams[] inrows = this.outputData.getBussinessParams().getRowParams();
            ArrayList<Object> otherOperList = new ArrayList<Object>();
            for (int i4 = inrows.length - 1; i4 >= 0; --i4) {
                String slotid = inrows[i4].getParam("slotid").getValue();
                String subslotid = "255";
                String port = inrows[i4].getParam("port").getValue();
                Operation otherOperation = null;
                otherOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_STATE");
                Input input = otherOperation.getInput();
                input.setPartValue("topCarryMode", PW);
                input.setPartValue("slotid", slotid);
                input.setPartValue("subslotid", subslotid);
                input.setPartValue("port", port);
                otherOperList.add(otherOperation.clone());
                if (null != inrows[i4].getParam("bottomCarryMode") && inrows[i4].getParam("bottomCarryMode").getValue().equals(LNET)) {
                    String param3 = inrows[i4].getParam("param3").getValue();
                    otherOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_EXTPARA");
                    input = otherOperation.getInput();
                    input.setPartValue("bottomCarryMode", LNET);
                    input.setPartValue("param1", INVALID_ID);
                    input.setPartValue("param2", INVALID_ID);
                    input.setPartValue("param3", param3);
                    otherOperList.add(otherOperation.clone());
                }
                otherOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_PORTSTATE");
                input = otherOperation.getInput();
                input.setPartValue("slotid", slotid);
                input.setPartValue("subslotid", subslotid);
                input.setPartValue("port", port);
                otherOperList.add(otherOperation.clone());
                if (null != otherOperList && !otherOperList.isEmpty()) continue;
                returnData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                this.outputData = returnData;
                return;
            }
            if (!otherOperList.isEmpty()) {
                int inretCode = super.sendMessage(neid, otherOperList);
                this.constructOutputData(neid, otherOperList);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)inretCode));
            }
        } else {
            returnData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)retCode));
            this.outputData = returnData;
        }
    }

    private void addParam(RowParams row, String name, String value) {
        if (value == null) {
            row.addParam(name, "");
        } else {
            row.addParam(name, value);
        }
    }

    private void joinUniLPTport() {
        Collection<RowParams> coll = this.rowMap.values();
        Object[] rows = coll.toArray();
        BussinessParams bussinessParams2 = new BussinessParams();
        for (int j = rows.length - 1; j >= 0; --j) {
            RowParams row = (RowParams)rows[j];
            String rowslotid = row.getParam("slotid").getValue();
            String rowport = row.getParam("port").getValue();
            if (this.keyList.contains(rowslotid + "-" + rowport)) continue;
            bussinessParams2.addRowParams(row);
        }
        RowParams[] rows2 = this.outputData.getBussinessParams().getRowParams();
        for (int i = rows2.length - 1; i >= 0; --i) {
            String tagNum = rows2[i].getParam("tagNum").getValue();
            String carrierType = rows2[i].getParam("carrierType").getValue();
            String param3 = rows2[i].getParam("param3").getValue();
            String slotid = rows2[i].getParam("slotid").getValue();
            if (rows2[i].getRowErrorsCount() > 0 || "".equals(param3) || !PW.equals(carrierType) && !QinQ.equals(carrierType) || "".equals(slotid) || !tagNum.equals("0")) continue;
            rows2[i].addParam("lptFlag", "0");
            rows2[i].addParam("lptstate", "-");
            rows2[i].addParam("uniportstatus", "-");
            bussinessParams2.addRowParams(rows2[i]);
        }
        this.outputData.setBussinessParams(bussinessParams2);
    }

    private void constructL2netData(int neid, ArrayList operList) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null == ne) {
            return;
        }
        for (int i = operList.size() - 1; i >= 0; --i) {
            Operation operation = (Operation)operList.get(i);
            Output[] outputArr = operation.getOutput();
            int len = outputArr.length;
            for (int j = 0; j < len; ++j) {
                this.joinL2Data(outputArr, j);
            }
        }
        this.joinUniLPTport();
        this.dealwithParams(ne, operList);
    }

    private void dealwithParams(TENE ne, ArrayList operList) {
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        try {
            for (int i = rows.length - 1; i >= 0; --i) {
                TEBoard board;
                int inslotid = Integer.valueOf(rows[i].getParam("slotid").getValue());
                int inport = Integer.valueOf(rows[i].getParam("port").getValue());
                if (null != rows[i].getParam("bottomCarryMode")) {
                    if (null != rows[i].getParam("lptFlag")) {
                        rows[i].getParam("lptFlag").setValue(PW);
                    } else {
                        rows[i].addParam("lptFlag", PW);
                    }
                    if (LNET.equals(rows[i].getParam("bottomCarryMode").getValue())) {
                        rows[i].addParam("connectPortName", rows[i].getParam("param3").getValue());
                    } else if (LPTPW.equals(rows[i].getParam("bottomCarryMode").getValue())) {
                        rows[i].addParam("connectPortName", this.getPW(rows[i].getParam("param3").getValue()));
                    } else if (LPTQinQ.equals(rows[i].getParam("bottomCarryMode").getValue())) {
                        rows[i].addParam("connectPortName", this.getQinq(rows[i].getParam("param3").getValue()));
                    } else {
                        int slotid = Integer.valueOf(rows[i].getParam("param1").getValue());
                        int port = Integer.valueOf(rows[i].getParam("param3").getValue());
                        TEBoard board2 = ne.getBoard(inslotid);
                        if (null != board2) {
                            String boardname = board2.getBoardName();
                            String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, slotid, board2.getBoardType(), port);
                            rows[i].addParam("connectPortName", slotid + "-" + boardname + "-" + portname);
                        }
                    }
                }
                if (null == (board = ne.getBoard(inslotid))) continue;
                String mainboardname = board.getBoardName();
                String mainportname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, inslotid, board.getBoardType(), inport);
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)board.getSlotID());
                if (!subrackName.isEmpty()) {
                    rows[i].addParam("subrackname", subrackName);
                }
                if (null != rows[i].getParam("boardname")) {
                    rows[i].getParam("boardname").setValue(mainboardname);
                } else {
                    rows[i].addParam("boardname", mainboardname);
                }
                if (null != rows[i].getParam("portname")) {
                    rows[i].getParam("portname").setValue(mainportname);
                    continue;
                }
                rows[i].addParam("portname", mainportname);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryP2PLPT fail!", (Throwable)e);
        }
        this.filterQueryLPTStateError(operList);
        Datainterface outputDataTemp = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)operList, (ArrayList)this.getFilterErrorCodeList());
        if (!outputDataTemp.getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.setErrorMessage(outputDataTemp.getErrorMessage());
            rows = outputDataTemp.getBussinessParams().getRowParams();
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i].getRowErrorsCount() <= 0) continue;
                this.outputData.getBussinessParams().addRowParams(rows[i]);
            }
        }
    }

    private void joinL2Data(Output[] output, int num) {
        if (!output[num].getFault()[0].getCode().equals("0")) {
            return;
        }
        String slotid = output[num].getPartValue("slotid");
        String port = output[num].getPartValue("port");
        String inkey = slotid + "-" + port;
        String btype = output[num].getPartValue("bottomCarryMode");
        String name = null;
        String value = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        if (rows.length == 0) {
            RowParams rParams = new RowParams();
            for (int index = output[num].getPartCount() - 1; index >= 0; --index) {
                name = output[num].getPart(index).getName();
                value = output[num].getPart(index).getValue();
                rParams.addParam(name, value);
            }
            this.rowMap.put(inkey, rParams);
        } else {
            for (int i = rows.length - 1; i >= 0; --i) {
                String rowslotid = rows[i].getParam("slotid").getValue();
                String rowport = rows[i].getParam("port").getValue();
                rows[i].addParam("key", rowslotid + "-" + rowport);
                if (rows[i].getParam("key").getValue().equals(inkey) && !btype.equals(LNET)) {
                    for (int index = output[num].getPartCount() - 1; index >= 0; --index) {
                        name = output[num].getPart(index).getName();
                        value = output[num].getPart(index).getValue();
                        if (null != rows[i].getParam(name)) {
                            rows[i].getParam(name).setValue(value);
                            continue;
                        }
                        rows[i].addParam(name, value);
                    }
                    this.keyList.add(rowslotid + "-" + rowport);
                    continue;
                }
                RowParams rParams = new RowParams();
                for (int index = output[num].getPartCount() - 1; index >= 0; --index) {
                    name = output[num].getPart(index).getName();
                    value = output[num].getPart(index).getValue();
                    rParams.addParam(name, value);
                }
                this.rowMap.put(inkey, rParams);
            }
        }
    }

    private void constructOutputData(int neid, ArrayList operList) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null == ne) {
            return;
        }
        for (int i = operList.size() - 1; i >= 0; --i) {
            Operation operation = (Operation)operList.get(i);
            Output[] outputArr = operation.getOutput();
            int len = outputArr.length;
            for (int j = 0; j < len; ++j) {
                this.join(outputArr[j]);
            }
        }
        Param param = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        try {
            for (int i = rows.length - 1; i >= 0; --i) {
                String portname;
                String boardname;
                TEBoard board;
                if (null == rows[i].getParam("lptstate") || "".equals(rows[i].getParam("lptstate").getValue())) {
                    rows[i].addParam("lptstate", "-");
                }
                if (null == rows[i].getParam("uniportstatus") || "".equals(rows[i].getParam("uniportstatus").getValue())) {
                    rows[i].addParam("uniportstatus", "-");
                }
                if (null != rows[i].getParam("bottomCarryMode")) {
                    rows[i].getParam("lptFlag").setValue(PW);
                    if (rows[i].getParam("carrierType") == null || rows[i].getParam("carrierType").getValue().equals("")) {
                        if (LNET.equals(rows[i].getParam("bottomCarryMode").getValue())) {
                            String param3 = rows[i].getParam("param3").getValue();
                            String peerParam3 = rows[i].getParam("peerParam3").getValue();
                            rows[i].addParam("localpeerid", param3 + "-" + peerParam3);
                            String sendslotid = rows[i].getParam("sendslotid").getValue();
                            String sendport = rows[i].getParam("sendport").getValue();
                            String vlanId = rows[i].getParam("vlanId").getValue();
                            String vlanName = vlanId + "(Vlan ID-" + vlanId + ")";
                            TEBoard board2 = ne.getBoard(Integer.parseInt(sendslotid));
                            if (null != board2) {
                                String boardname2 = board2.getBoardName();
                                String portname2 = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, Integer.parseInt(sendslotid), board2.getBoardType(), Integer.parseInt(sendport));
                                rows[i].addParam("connectPortName", sendslotid + "-" + boardname2 + "-" + portname2 + "-" + vlanName);
                            }
                            rows[i].getParam("connectPortName").setValue(rows[i].getParam("param3").getValue());
                            rows[i].addParam("carrierType", LNET);
                        } else if (LPTPW.equals(rows[i].getParam("bottomCarryMode").getValue())) {
                            if (null != rows[i].getParam("connectPortName")) {
                                rows[i].getParam("connectPortName").setValue(this.getPW(rows[i].getParam("param3").getValue()));
                            } else {
                                rows[i].addParam("connectPortName", "");
                                rows[i].getParam("connectPortName").setValue(this.getPW(rows[i].getParam("param3").getValue()));
                            }
                            rows[i].addParam("carrierType", String.valueOf(Integer.parseInt(LPTPW) - 1));
                        } else if (LPTQinQ.equals(rows[i].getParam("bottomCarryMode").getValue())) {
                            if (null != rows[i].getParam("connectPortName")) {
                                rows[i].getParam("connectPortName").setValue(this.getQinq(rows[i].getParam("param3").getValue()));
                            } else {
                                rows[i].addParam("connectPortName", "");
                                rows[i].getParam("connectPortName").setValue(this.getQinq(rows[i].getParam("param3").getValue()));
                            }
                            rows[i].addParam("carrierType", String.valueOf(Integer.parseInt(LPTQinQ) + 1));
                        } else {
                            int slotid = Integer.valueOf(rows[i].getParam("param1").getValue());
                            int port = Integer.valueOf(rows[i].getParam("param3").getValue());
                            board = ne.getBoard(slotid);
                            if (null != board) {
                                boardname = board.getBoardName();
                                portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, board.getBoardType(), port);
                                rows[i].getParam("connectPortName").setValue(slotid + "-" + boardname + "-" + portname);
                            }
                        }
                    }
                }
                if ((param = rows[i].getParam("carrierType")) == null) continue;
                if (LNET.equals(param.getValue())) {
                    rows[i].getParam("connectPortName").setValue(rows[i].getParam("param3").getValue());
                    continue;
                }
                if (PW.equals(param.getValue())) {
                    if (null != rows[i].getParam("connectPortName")) {
                        rows[i].getParam("connectPortName").setValue(this.getPW(rows[i].getParam("param3").getValue()));
                        continue;
                    }
                    rows[i].addParam("connectPortName", "");
                    rows[i].getParam("connectPortName").setValue(this.getPW(rows[i].getParam("param3").getValue()));
                    continue;
                }
                if (QinQ.equals(param.getValue())) {
                    if (null != rows[i].getParam("connectPortName")) {
                        rows[i].getParam("connectPortName").setValue(this.getQinq(rows[i].getParam("param3").getValue()));
                        continue;
                    }
                    rows[i].addParam("connectPortName", "");
                    rows[i].getParam("connectPortName").setValue(this.getQinq(rows[i].getParam("param3").getValue()));
                    continue;
                }
                int slotid = Integer.valueOf(rows[i].getParam("param1").getValue());
                int port = Integer.valueOf(rows[i].getParam("param3").getValue());
                board = ne.getBoard(slotid);
                if (null == board) continue;
                boardname = board.getBoardName();
                portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, board.getBoardType(), port);
                rows[i].getParam("connectPortName").setValue(slotid + "-" + boardname + "-" + portname);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryP2PLPT fail!", (Throwable)e);
        }
        this.filterQueryLPTStateError(operList);
        Datainterface outputDataTemp = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)this.subfunc, (ArrayList)operList, (ArrayList)this.getFilterErrorCodeList());
        if (!outputDataTemp.getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.setErrorMessage(outputDataTemp.getErrorMessage());
            rows = outputDataTemp.getBussinessParams().getRowParams();
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i].getRowErrorsCount() <= 0) continue;
                this.outputData.getBussinessParams().addRowParams(rows[i]);
            }
        }
    }

    private void join(Output output) {
        if (!output.getFault()[0].getCode().equals("0")) {
            return;
        }
        String slotid = output.getPartValue("slotid");
        String port = output.getPartValue("port");
        String inkey = slotid + "-" + port;
        String bCarryMode = output.getPartValue("bCarryMode");
        String param3 = output.getPartValue("param3");
        String lnetindex = bCarryMode + "-" + param3;
        String name = null;
        String value = null;
        String rowsbottomCarryMode = null;
        String rowsparam3 = null;
        String rowslnetindex = "";
        String rowslotid = null;
        String rowport = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        Param bundStatusParam = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            if (null != rows[i].getParam("slotid") && null != rows[i].getParam("port")) {
                rowslotid = rows[i].getParam("slotid").getValue();
                rowport = rows[i].getParam("port").getValue();
            }
            if (null != rows[i].getParam("bottomCarryMode") && null != rows[i].getParam("param3")) {
                rowsbottomCarryMode = rows[i].getParam("bottomCarryMode").getValue();
                rowsparam3 = rows[i].getParam("param3").getValue();
                rowslnetindex = rowsbottomCarryMode + "-" + rowsparam3;
            }
            rows[i].addParam("key", rowslotid + "-" + rowport);
            bundStatusParam = rows[i].getParam("lptFlag");
            if (!rows[i].getParam("key").getValue().equals(inkey) && !rowslnetindex.equals(lnetindex)) continue;
            for (int index = output.getPartCount() - 1; index >= 0; --index) {
                name = output.getPart(index).getName();
                value = output.getPart(index).getValue();
                if (bundStatusParam != null && "0".equals(bundStatusParam.getValue()) && "lptstate".equals(name)) continue;
                if (null != rows[i].getParam(name)) {
                    rows[i].getParam(name).setValue(value);
                    continue;
                }
                rows[i].addParam(name, value);
            }
        }
    }

    private void filterQueryLPTStateError(ArrayList operList) {
        Operation operation = null;
        for (int i = operList.size() - 1; i >= 0; --i) {
            operation = (Operation)operList.get(i);
            if (!operation.getName().equalsIgnoreCase("NSCMD_CFG_ETHN_LPT_GET_STATE")) continue;
            operList.remove(i);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(44406);
        return list;
    }

    public String getPW(String pwIndex) {
        String tempId = this.pwMap.get(pwIndex);
        if (null != tempId) {
            return tempId;
        }
        String pwID = "";
        String index = "";
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_PTN_MPLS_PW_GET_PW_1");
        Input input = oper.getInput();
        input.setPartValue("pwIndex", "" + pwIndex);
        operationList.add(oper.clone());
        super.sendMessage(this.neID, operationList);
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            index = output.getPartValue("pwIndex");
            pwID = output.getPartValue("pwId");
            this.pwMap.put(index, pwID);
        }
        tempId = this.pwMap.get(pwIndex);
        return tempId == null ? pwIndex : tempId;
    }

    public String getQinq(String qinqIndex) {
        String tempId = this.qinqMap.get(qinqIndex);
        if (null != tempId) {
            return tempId;
        }
        String qinqID = "";
        String index = "";
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_SERVICE_GET_QINQLINK_EX");
        Input input = oper.getInput();
        input.setPartValue("linkid", "" + qinqIndex);
        operationList.add(oper.clone());
        super.sendMessage(this.neID, operationList);
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            index = output.getPartValue("linkid");
            qinqID = output.getPartValue("linkid");
            this.qinqMap.put(index, qinqID);
        }
        tempId = this.qinqMap.get(qinqIndex);
        return tempId == null ? qinqIndex : tempId;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        subfunc.setDes("TECMDCODE_QUERY_P2PLPT");
        subfunc.setCode(2179101);
        super.writeLog(neid, subfunc, inputData, user, ipAddress, outputData, false);
    }
}

