/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TEIPUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEQueryUNIP2MPLPT
extends TENEExplorerBean {
    private static final String UNI = "1";
    private static final String PW = "2";
    private static final String QinQ = "3";
    private static final String LNET = "5";
    public static final String INVALID_ID = "4294967295";
    private Map<String, String> pwMap = new HashMap<String, String>();
    private Map<String, String> qinqMap = new HashMap<String, String>();

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList operList = new ArrayList();
        try {
            Operation bindOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_PMPLP_GET_BIND");
            Vector boardList = new Vector(0);
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (ne != null) {
                boardList = ne.getBoardList();
            }
            int size = boardList.size();
            for (int i = 0; i < size; ++i) {
                TEBoard board = (TEBoard)boardList.get(i);
                int boardType = board.getBoardType();
                if (!TEIPUtils.isSupportGroupBoard(neid, boardType)) continue;
                int slotid = board.getSlotID();
                List subBoardList = board.getSubBoardList();
                if (!subBoardList.isEmpty()) {
                    int isize = subBoardList.size();
                    for (int k = 0; k < isize; ++k) {
                        TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                        int subslotid = subBoards.getSubSlotID();
                        this.setOperation(1, slotid, subslotid, 0L, bindOperation, operList);
                    }
                    continue;
                }
                int subslotid = 255;
                this.setOperation(1, slotid, subslotid, 0L, bindOperation, operList);
            }
            this.setOperation(Integer.valueOf(PW), 0xFFFFFFFFL, 0xFFFFFFFFL, 0L, bindOperation, operList);
            this.setOperation(Integer.valueOf(QinQ), 0xFFFFFFFFL, 0xFFFFFFFFL, 0L, bindOperation, operList);
            this.setOperation(Integer.valueOf(LNET), 0xFFFFFFFFL, 0xFFFFFFFFL, 0L, bindOperation, operList);
            return operList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    private void setOperation(int carryMode, long slotid, long subslotid, long port, Operation operation, List operList) {
        Input input = operation.getInput();
        input.setPartValue("topCarryMode", "" + carryMode);
        input.setPartValue("slotid", "" + slotid);
        input.setPartValue("subslotid", "" + subslotid);
        input.setPartValue("port", "" + port);
        operList.add(operation.clone());
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null == ne) {
            return;
        }
        ArrayList<Object> operList = new ArrayList<Object>();
        Param param = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        try {
            Operation operation = null;
            Input input = null;
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i].getRowErrorsCount() > 0 || null == (param = rows[i].getParam("topCarryMode")) || null == param.getValue() || param.getValue().isEmpty()) continue;
                String topCarryMode = param.getValue();
                String slotid = rows[i].getParam("slotid").getValue();
                String subslotid = rows[i].getParam("subslotid").getValue();
                String port = rows[i].getParam("port").getValue();
                rows[i].addParam("key", slotid + "-" + port);
                rows[i].getParam("lptstate").setValue("-");
                operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_STATE");
                this.setOperation(Integer.valueOf(topCarryMode), Long.valueOf(slotid), Long.valueOf(subslotid), Long.valueOf(port), operation, operList);
                if (topCarryMode.equals(LNET)) {
                    String param3 = rows[i].getParam("port").getValue();
                    operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_EXTPARA");
                    input = operation.getInput();
                    input.setPartValue("bottomCarryMode", LNET);
                    input.setPartValue("param1", INVALID_ID);
                    input.setPartValue("param2", INVALID_ID);
                    input.setPartValue("param3", param3);
                    operList.add(operation.clone());
                }
                operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_ENABLE");
                this.setOperation(Integer.valueOf(topCarryMode), Long.valueOf(slotid), Long.valueOf(subslotid), Long.valueOf(port), operation, operList);
                rows[i].addParam("mainportname", "");
                if (topCarryMode.equals(UNI)) {
                    rows[i].getParam("uniportstatus").setValue("/");
                    String boardname = rows[i].getParam("boardname").getValue();
                    TEBoard board = ne.getBoard(Integer.valueOf(slotid).intValue());
                    String ptnportname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, Integer.valueOf(slotid).intValue(), board.getBoardType(), Integer.valueOf(port).intValue());
                    String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)Integer.parseInt(slotid));
                    if (!subrackName.isEmpty()) {
                        rows[i].getParam("mainportname").setValue(subrackName + "-" + slotid + "-" + boardname + "-" + ptnportname);
                    } else {
                        rows[i].getParam("mainportname").setValue(slotid + "-" + boardname + "-" + ptnportname);
                    }
                    operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_PORTSTATE");
                    input = operation.getInput();
                    input.setPartValue("slotid", slotid);
                    input.setPartValue("subslotid", subslotid);
                    input.setPartValue("port", port);
                    operList.add(operation.clone());
                    continue;
                }
                if (topCarryMode.equals(PW)) {
                    rows[i].getParam("uniportstatus").setValue("-");
                    rows[i].getParam("mainportname").setValue(this.getPW(rows[i].getParam("port").getValue(), neid));
                    continue;
                }
                if (topCarryMode.equals(QinQ)) {
                    rows[i].getParam("uniportstatus").setValue("-");
                    rows[i].getParam("mainportname").setValue(this.getQinq(rows[i].getParam("port").getValue(), neid));
                    continue;
                }
                if (!topCarryMode.equals(LNET)) continue;
                rows[i].getParam("uniportstatus").setValue("/");
                String portname = rows[i].getParam("port").getValue();
                rows[i].getParam("mainportname").setValue(portname);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryP2PLPT fail!", (Throwable)e);
        }
        Datainterface returnData = new Datainterface();
        if (null == operList || operList.isEmpty()) {
            returnData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            this.outputData = returnData;
            return;
        }
        int retCode = super.sendMessage(neid, operList);
        if (retCode != 0) {
            returnData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)retCode));
            this.outputData = returnData;
            return;
        }
        this.constructOutputData(neid, operList);
    }

    private void constructOutputData(int neid, ArrayList operList) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null == ne) {
            return;
        }
        for (int i = operList.size() - 1; i >= 0; --i) {
            Operation operation = (Operation)operList.get(i);
            for (Output output : operation.getOutput()) {
                this.join(output);
            }
        }
        Param param = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        try {
            for (int i = rows.length - 1; i >= 0; --i) {
                String topCarryMode;
                param = rows[i].getParam("topCarryMode");
                if (null == param || null == param.getValue() || param.getValue().isEmpty() || !LNET.equals(topCarryMode = param.getValue())) continue;
                String param3 = rows[i].getParam("param3").getValue();
                String peerParam3 = rows[i].getParam("peerParam3").getValue();
                rows[i].addParam("localpeerid", param3 + "-" + peerParam3);
                String sendslotid = rows[i].getParam("sendslotid").getValue();
                String sendport = rows[i].getParam("sendport").getValue();
                String vlanId = rows[i].getParam("vlanId").getValue();
                String vlanName = vlanId + "(Vlan ID-" + vlanId + ")";
                TEBoard board = ne.getBoard(Integer.parseInt(sendslotid));
                if (null == board) continue;
                String boardname = board.getBoardName();
                String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, Integer.parseInt(sendslotid), board.getBoardType(), Integer.parseInt(sendport));
                rows[i].addParam("mainportname", sendslotid + "-" + boardname + "-" + portname + "-" + vlanName);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryP2PLPT fail!", (Throwable)e);
        }
        this.filterQueryLPTStateError(operList);
        Datainterface outputDataTemp = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)this.subfunc, (ArrayList)operList, (ArrayList)this.getFilterErrorCodeList());
        if (!outputDataTemp.getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.setErrorMessage(outputDataTemp.getErrorMessage());
            rows = outputDataTemp.getBussinessParams().getRowParams();
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i].getRowErrorsCount() <= 0) continue;
                this.outputData.getBussinessParams().addRowParams(rows[i]);
            }
        }
    }

    private void join(Output output) {
        if (!output.getFault()[0].getCode().equals("0")) {
            return;
        }
        String slotid = "";
        String port = "";
        slotid = output.getPartValue("slotid");
        port = output.getPartValue("port");
        String inkey = slotid + "-" + port;
        String topCarryMode = "";
        topCarryMode = output.getPartValue("topCarryMode");
        String uniportstatus = "";
        if (null != output.getPartValue("uniportstatus")) {
            uniportstatus = output.getPartValue("uniportstatus");
        }
        String bCarryMode = output.getPartValue("bCarryMode");
        String param3 = output.getPartValue("param3");
        String lnetindex = bCarryMode + "-" + param3;
        String name = null;
        String value = null;
        String rowsbottomCarryMode = "";
        String rowsparam3 = null;
        String rowslnetindex = "";
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        for (int i = rows.length - 1; i >= 0; --i) {
            if (null != rows[i].getParam("topCarryMode") && null != rows[i].getParam("port")) {
                rowsbottomCarryMode = rows[i].getParam("topCarryMode").getValue();
                rowsparam3 = rows[i].getParam("port").getValue();
                rowslnetindex = rowsbottomCarryMode + "-" + rowsparam3;
            }
            if (!(rows[i].getParam("key").getValue().equals(inkey) && rowsbottomCarryMode.equals(topCarryMode) || rowslnetindex.equals(lnetindex) && rowsbottomCarryMode.equals(bCarryMode)) && (!rows[i].getParam("key").getValue().equals(inkey) || !uniportstatus.equals(UNI) && !uniportstatus.equals("0"))) continue;
            for (int index = output.getPartCount() - 1; index >= 0; --index) {
                name = output.getPart(index).getName();
                value = output.getPart(index).getValue();
                if (null != rows[i].getParam(name)) {
                    rows[i].getParam(name).setValue(value);
                    continue;
                }
                rows[i].addParam(name, value);
            }
        }
    }

    private void filterQueryLPTStateError(ArrayList operList) {
        Operation operation = null;
        for (int i = operList.size() - 1; i >= 0; --i) {
            operation = (Operation)operList.get(i);
            if (!operation.getName().equalsIgnoreCase("NSCMD_CFG_ETHN_LPT_GET_STATE")) continue;
            operList.remove(i);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(44406);
        return list;
    }

    public String getPW(String pwIndex, int neID) {
        String tempId = this.pwMap.get(pwIndex);
        if (null != tempId) {
            return tempId;
        }
        String pwID = "";
        String index = "";
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_PTN_MPLS_PW_GET_PW_1");
        Input input = oper.getInput();
        input.setPartValue("pwIndex", pwIndex);
        operationList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(neID, operationList, this.getTimeOut());
        Operation tmpOper = (Operation)operationList.get(0);
        for (Output output : tmpOper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            index = output.getPartValue("pwIndex");
            pwID = output.getPartValue("pwId");
            this.pwMap.put(index, pwID);
        }
        tempId = this.pwMap.get(pwIndex);
        return tempId == null ? pwIndex : tempId;
    }

    public String getQinq(String qinqIndex, int neID) {
        String tempId = this.qinqMap.get(qinqIndex);
        if (null != tempId) {
            return tempId;
        }
        String qinqID = "";
        String index = "";
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_SERVICE_GET_QINQLINK_EX");
        Input input = oper.getInput();
        input.setPartValue("linkid", qinqIndex);
        operationList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(neID, operationList, this.getTimeOut());
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            index = output.getPartValue("linkid");
            qinqID = output.getPartValue("linkid");
            this.qinqMap.put(index, qinqID);
        }
        tempId = this.qinqMap.get(qinqIndex);
        return tempId == null ? qinqIndex : tempId;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        subfunc.setDes("TECMDCODE_QUERY_P2MPLPT");
        subfunc.setCode(2179105);
        super.writeLog(neid, subfunc, inputData, user, ipAddress, outputData, false);
    }
}

