/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryPorts
extends TENEExplorerBean {
    private Datainterface datainterface = null;
    int neID = 0;
    int slotID = 0;
    int subslotID = 0;
    private static final int INVALID_SUBSLOTID = 255;
    int SSN1PEG16 = 1584;
    int SSN1PETF8 = 1587;
    int SSN1PEX1 = 1585;
    int SSN1PEFF8 = 2235;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        RowParams rParams = inputData.getBussinessParams().getRowParams()[0];
        Param slotidParam = rParams.getParam("slotid");
        this.slotID = Integer.parseInt(slotidParam.getValue());
        Param subSlotidParam = rParams.getParam("subslotid");
        this.subslotID = Integer.parseInt(subSlotidParam.getValue());
        this.datainterface = this.constructEthPortData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.log.error("Get BoardInfo Fail!\n");
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructEthPortData() {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        RowParams rParams = null;
        int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
        String boardName = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardName();
        if (this.subslotID == 255) {
            TEPortModelConfigurationDataMgr cfgMgr = TEPortModelConfigurationDataMgr.getInstance();
            List boardPortList = cfgMgr.getLogicPortList(this.neID, this.slotID, 1799);
            boardPortList.addAll(cfgMgr.getLogicPortList(this.neID, this.slotID, 1025));
            boardPortList.addAll(cfgMgr.getLogicPortList(this.neID, this.slotID, 63213));
            Collections.sort(boardPortList);
            int len = boardPortList.size();
            for (int j = 0; j < len; ++j) {
                rParams = new RowParams();
                int portID = ((TEPort)boardPortList.get(j)).getPortNo();
                String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neID, this.slotID, boardType, portID, 16);
                rParams.addParam("slotid", "" + this.slotID);
                rParams.addParam("boardName", boardName);
                rParams.addParam("subslotid", "" + this.subslotID);
                rParams.addParam("subBoardName", "");
                rParams.addParam("portid", "" + portID);
                rParams.addParam("portName", portName);
                bParams.addRowParams(rParams);
            }
        } else {
            List subBoardList = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getSubBoardList();
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardType = subBoards.getSubBoardType();
                int subBoardSlot = subBoards.getSubSlotID();
                String subBoardName = subBoards.getSubBoardName();
                ArrayList subBoardPortList = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(this.neID, subBoardType);
                int len = subBoardPortList.size();
                for (int j = 0; j < len; ++j) {
                    rParams = new RowParams();
                    int portID = (Integer)subBoardPortList.get(j);
                    String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neID, subBoardSlot, subBoardType, portID);
                    rParams.addParam("slotid", "" + this.slotID);
                    rParams.addParam("boardName", boardName);
                    rParams.addParam("subslotid", "" + this.subslotID);
                    rParams.addParam("subBoardName", subBoardName);
                    rParams.addParam("portid", "" + portID);
                    rParams.addParam("portName", portName);
                    bParams.addRowParams(rParams);
                }
            }
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

