/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryPTNPorts
extends TENEExplorerBean {
    private Datainterface datainterface = null;
    int neID = 0;
    int slotID = 0;
    int subslotID = 0;
    private final int TIMEOUT = 10;
    private final String PORTMODE_LEVEL3 = "3";
    private static final int INVALID_SUBSLOTID = 255;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        RowParams rParams1 = inputData.getBussinessParams().getRowParams()[0];
        Param slotidParam = rParams1.getParam("slotid");
        this.slotID = Integer.parseInt(slotidParam.getValue());
        Param subSlotidParam1 = rParams1.getParam("subslotid");
        this.subslotID = Integer.parseInt(subSlotidParam1.getValue());
        this.datainterface = this.constructEthPortData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.log.error("Get BoardInfo Fail!\n");
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructEthPortData() {
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        RowParams rParams = null;
        int boardType1 = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
        String boardName = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardName();
        if (this.subslotID == 255) {
            TEPortModelConfigurationDataMgr cfgMgr = TEPortModelConfigurationDataMgr.getInstance();
            List boardPortList = cfgMgr.getLogicPortList(this.neID, this.slotID, 1799);
            if (TEVirtualPortUtil.isMSOTNBoard((int)this.neID, (int)this.slotID)) {
                boardPortList.addAll(cfgMgr.getLogicPortList(this.neID, this.slotID, 63213));
            }
            if (boardType1 != 2102 && boardType1 != 2439 && !TESpecialAttrMgr.getInstance().isCPSupport(this.neID, this.slotID, "TE_FUNC_CFG_ETH_LPT", "LPT_ATTR_NOTSUPPORT_MACPORT")) {
                boardPortList.addAll(cfgMgr.getLogicPortList(this.neID, this.slotID, 1025));
            }
            ArrayList<String> level3BoardPortList = new ArrayList();
            try {
                level3BoardPortList = this.queryPortModeOfAllBoards(String.valueOf(this.slotID));
            }
            catch (Exception e) {
                this.log.error("queryPortModeOfAllBoards Fail!\n");
            }
            Collections.sort(boardPortList);
            int len = boardPortList.size();
            for (int j = 0; j < len; ++j) {
                rParams = new RowParams();
                int portID = ((TEPort)boardPortList.get(j)).getPortNo();
                String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neID, this.slotID, boardType1, portID);
                if (this.isPortModeLv3(this.slotID, portID, level3BoardPortList)) continue;
                rParams.addParam("subrackName", TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)this.slotID));
                rParams.addParam("slotid", "" + this.slotID);
                rParams.addParam("boardName", boardName);
                rParams.addParam("subslotid", "" + this.subslotID);
                rParams.addParam("subBoardName", "");
                rParams.addParam("portid", "" + portID);
                rParams.addParam("portName", portName);
                bParams.addRowParams(rParams);
            }
        } else {
            List subBoardList = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getSubBoardList();
            int isize = subBoardList.size();
            for (int k = 0; k < isize; ++k) {
                TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                int subBoardType = subBoards.getSubBoardType();
                String subBoardName = subBoards.getSubBoardName();
                ArrayList subBoardPortList = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(this.neID, subBoardType);
                int len = subBoardPortList.size();
                for (int j = 0; j < len; ++j) {
                    rParams = new RowParams();
                    int portID = (Integer)subBoardPortList.get(j);
                    String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neID, this.slotID, boardType1, portID);
                    rParams.addParam("subrackName", TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)this.slotID));
                    rParams.addParam("slotid", "" + this.slotID);
                    rParams.addParam("boardName", boardName);
                    rParams.addParam("subslotid", "" + this.subslotID);
                    rParams.addParam("subBoardName", subBoardName);
                    rParams.addParam("portid", "" + portID);
                    rParams.addParam("portName", portName);
                    bParams.addRowParams(rParams);
                }
            }
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private List<String> queryPortModeOfAllBoards(String slotID) {
        ArrayList<String> level3BoardPortList = new ArrayList<String>();
        Operation operationOri = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_PTNETY_GET_LEVELMODE_EX");
        ArrayList<Operation> queryLevelOperationList = new ArrayList<Operation>();
        Operation clonedOperation = (Operation)operationOri.clone();
        clonedOperation.getInput().setPartValue("slotid", slotID);
        clonedOperation.getInput().setPartValue("subslotid", "255");
        clonedOperation.getInput().setPartValue("port", "0");
        queryLevelOperationList.add(clonedOperation);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, queryLevelOperationList, 10);
        if (0 == result.retCode) {
            for (Operation operation : queryLevelOperationList) {
                int errorCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
                if (0 != errorCode) continue;
                Output[] outputArray = operation.getOutput();
                for (int i = 0; i < outputArray.length; ++i) {
                    Output output = outputArray[i];
                    String slotidVal = output.getPartValue("slotid");
                    String portVal = output.getPartValue("port");
                    String portModeVal = output.getPartValue("SDHPORT_ATTR_MODE");
                    if (!"3".equals(portModeVal)) continue;
                    String portLv3Description = slotidVal + "-" + portVal;
                    level3BoardPortList.add(portLv3Description);
                }
            }
        }
        return level3BoardPortList;
    }

    private boolean isPortModeLv3(int slotid, int portid, List<String> level3BoardPortList) {
        String key = String.valueOf(slotid) + "-" + String.valueOf(portid);
        for (String level3BoardPort : level3BoardPortList) {
            if (!key.equals(level3BoardPort)) continue;
            return true;
        }
        return false;
    }
}

