/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TEIPUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class TEQueryPTMPLPT
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private int slotID = -1;
    private static final String SLOT_ID_PARAM = "slotid";
    private static final int VCTRUNK = 32768;
    private static final String NOVALUE = "-";
    private static final String NONE = "2";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        Param param = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)SLOT_ID_PARAM);
        this.slotID = Integer.parseInt(param.getValue());
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subFunc) {
        ArrayList rowErrorList = new ArrayList();
        ArrayList funblockList = TEQueryPTMPLPT.getEthBoardInfo(neid, this.slotID);
        boolean hasFault = false;
        boolean hasSucc = false;
        HashMap<String, String[]> lptLinkList = new HashMap<String, String[]>();
        HashMap<String, String> lptDelayTimeList = new HashMap<String, String>();
        HashMap<String, String> lptCarryModeList = new HashMap<String, String>();
        Operation operation = null;
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        int length = operationList.size();
        for (int k = 0; k < length; ++k) {
            operation = (Operation)operationList.get(k);
            int retcode = 0;
            String cmdName = operation.getName();
            if ("NSCMD_CFG_ETHN_GET_P2MP_LPT".equals(cmdName)) {
                retcode = this.handleLptLinkList(operation, lptLinkList, rowErrorList);
            } else if ("NSCMD_ETHN_GET_P2MPLPT_HOLDOFFTIME".equals(cmdName)) {
                retcode = this.handleDelayTime(operation, lptDelayTimeList, rowErrorList);
            } else if ("NSCMD_CFG_GET_VCTRUNK_LPT_CARRYMODE".equals(cmdName)) {
                retcode = this.handleCarryMode(operation, lptCarryModeList, rowErrorList);
            }
            if (0 != retcode) continue;
            hasSucc = true;
        }
        if (rowErrorList.size() > 0) {
            hasFault = true;
            int errNum = rowErrorList.size();
            for (int errIndex = 0; errIndex < errNum; ++errIndex) {
                bussinessParams.addRowParams((RowParams)rowErrorList.get(errIndex));
            }
        } else {
            hasSucc = true;
        }
        int len = funblockList.size();
        for (int i = 0; i < len; ++i) {
            String[] ports = ((String)funblockList.get(i)).split(NOVALUE);
            String portid = ports[0];
            String portName = ports[1];
            String returnName = portName;
            if (returnName.indexOf("PORT") < 0 && returnName.indexOf("VCTRUNK") < 0) continue;
            if (lptLinkList.containsKey(portid)) {
                this.handleOutput(portid, lptLinkList, lptDelayTimeList, lptCarryModeList, bussinessParams);
                continue;
            }
            this.handleOutput(portid, bussinessParams);
        }
        rowErrorList.clear();
        funblockList.clear();
        lptLinkList.clear();
        lptDelayTimeList.clear();
        lptCarryModeList.clear();
        this.outputData.setErrorMessage(new ErrorMessage());
        if (!hasFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!hasSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
    }

    private int handleLptLinkList(Operation operation, HashMap lptLinkList, ArrayList rowErrorList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String portNumber = "";
        String portList = "";
        int retCode = 2;
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                rowErrorList.add(errRow);
                continue;
            }
            if (38662 == retCode) continue;
            port = output.getPartValue("port");
            portNumber = output.getPartValue("portNumber");
            portList = output.getPartValue("portList");
            if ("0".equals(portNumber)) continue;
            int portCount = Integer.parseInt(portNumber);
            String[] connectPorts = new String[portCount];
            int temp = 0;
            int portLength = portList.length() / portCount;
            String tempNumber = "";
            int i = 0;
            int p = 0;
            while (i < portCount) {
                tempNumber = portList.substring(p + (portLength - 4), p + portLength);
                temp = Integer.parseInt(tempNumber, 16);
                connectPorts[i] = String.valueOf(temp);
                ++i;
                p += portLength;
            }
            lptLinkList.put(port, connectPorts);
        }
        return retCode;
    }

    private int handleDelayTime(Operation operation, HashMap lptDelayTimeList, ArrayList rowErrorList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String delayTime = "";
        int retCode = 2;
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                rowErrorList.add(errRow);
                continue;
            }
            if (38662 == retCode) continue;
            port = output.getPartValue("port");
            delayTime = output.getPartValue("delayTime");
            lptDelayTimeList.put(port, delayTime);
        }
        return retCode;
    }

    private int handleCarryMode(Operation operation, HashMap lptCarryModeList, ArrayList rowErrorList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String carryMode = "";
        int retCode = 2;
        int j = 0;
        int i = 0;
        while (j < outputArr.length) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                rowErrorList.add(errRow);
            } else if (38662 != retCode) {
                port = output.getPartValue("port");
                carryMode = output.getPartValue("carryMode");
                lptCarryModeList.put(port, carryMode);
            }
            ++j;
            i += 2;
        }
        return retCode;
    }

    public static ArrayList getEthBoardInfo(int neID, int slotID) {
        ArrayList<String> ports = new ArrayList<String>();
        int portNO = -1;
        String portName = "";
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        if (null == configurDataMgr.getBoard(neID, slotID)) {
            return ports;
        }
        int boardType = configurDataMgr.getBoard(neID, slotID).getBoardType();
        ArrayList macPortList = TEIPUtils.getMacPortList(neID, slotID, boardType);
        int len = macPortList.size();
        for (int i = 0; i < len; ++i) {
            portNO = Integer.parseInt(macPortList.get(i).toString());
            portName = TEConfigurationDataMgr.getMACName((int)portNO);
            ports.add(portNO + NOVALUE + portName);
        }
        ArrayList vcPortList = configurDataMgr.getETHVCTrunkPort(neID, boardType);
        int len2 = vcPortList.size();
        for (int i = 0; i < len2; ++i) {
            portNO = Integer.parseInt(vcPortList.get(i).toString());
            portName = TEConfigurationDataMgr.getVCTrunkName((int)(portNO - 32768));
            ports.add(portNO + NOVALUE + portName);
        }
        return ports;
    }

    private void handleOutput(String portid, HashMap<String, String[]> lptLinkList, HashMap<String, String> lptDelayTimeList, HashMap<String, String> lptCarryModeList, BussinessParams bussinessParams) {
        String[] connctPorts = lptLinkList.get(portid);
        RowParams rowparams = null;
        Param param = null;
        for (String tempPortId : connctPorts) {
            rowparams = new RowParams();
            param = new Param("portid", portid);
            rowparams.addParam(param);
            if (Integer.parseInt(portid) < 32768) {
                param = new Param("port", "PORT" + portid);
                rowparams.addParam(param);
                param = new Param("lptCarryMode", NONE);
                rowparams.addParam(param);
            } else {
                param = new Param("port", "VCTRUNK" + (Integer.parseInt(portid) - 32768));
                rowparams.addParam(param);
                param = new Param("lptCarryMode", lptCarryModeList.get(portid));
                rowparams.addParam(param);
            }
            param = new Param("portDlayTime", lptDelayTimeList.get(portid));
            rowparams.addParam(param);
            param = new Param("desPortid", tempPortId);
            rowparams.addParam(param);
            if (Integer.parseInt(tempPortId) < 32768) {
                param = new Param("desPort", "PORT" + tempPortId);
                rowparams.addParam(param);
                param = new Param("desPortCarryMode", NONE);
                rowparams.addParam(param);
            } else {
                param = new Param("desPort", "VCTRUNK" + (Integer.parseInt(tempPortId) - 32768));
                rowparams.addParam(param);
                param = new Param("desPortCarryMode", lptCarryModeList.get(tempPortId));
                rowparams.addParam(param);
            }
            bussinessParams.addRowParams(rowparams);
        }
    }

    private void handleOutput(String portid, BussinessParams bussinessParams) {
        RowParams rowparams = new RowParams();
        Param param = new Param("portid", portid);
        rowparams.addParam(param);
        param = Integer.parseInt(portid) < 32768 ? new Param("port", "PORT" + portid) : new Param("port", "VCTRUNK" + (Integer.parseInt(portid) - 32768));
        rowparams.addParam(param);
        param = new Param("portDlayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("lptCarryMode", NOVALUE);
        rowparams.addParam(param);
        param = new Param("desPortid", NOVALUE);
        rowparams.addParam(param);
        param = new Param("desPort", NOVALUE);
        rowparams.addParam(param);
        param = new Param("desPortCarryMode", NOVALUE);
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("ip").append(File.separator).append("sdh").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("lpt").append(File.separator).append("lptmanagement_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBuf = new StringBuffer();
        Param[] params = this.inputData.getBussinessParams().getRowParams(0).getParam();
        strBuf.append(this.res.getString("QUERY_PTMPLPT")).append(" ");
        String slotid = Datainterface.getParam((Param[])params, (String)SLOT_ID_PARAM).getValue();
        String port = Datainterface.getParam((Param[])params, (String)"port").getValue();
        return TEIPUtils.getMainPTLogInfo(strBuf, this.res, this.neid, slotid, port, null, null);
    }
}

