/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TEIPUtils;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TELptBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TEQueryP2PLPT
extends TENEExplorerBean {
    private static final String PW = "1";
    private static final String IS_TRANSPARENT = "0";
    int neID = 0;
    private Map<String, String> pwMap = new HashMap<String, String>();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList getf) {
        TELptBean lptBean;
        String key;
        Output out;
        int i;
        this.neID = neid;
        this.pwMap.clear();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Operation nniOper = (Operation)operationList.get(0);
        Operation uniOper = (Operation)operationList.get(1);
        if (nniOper.getOutputCount() == 0 || uniOper.getOutputCount() == 0) {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return;
        }
        HashMap<String, TELptBean> resultMap = new HashMap<String, TELptBean>();
        int iLength = nniOper.getOutput().length;
        for (i = 0; i < iLength; ++i) {
            out = nniOper.getOutput()[i];
            key = out.getPartValue("servType") + "-" + out.getPartValue("servIndex");
            lptBean = new TELptBean();
            lptBean.setServType(out.getPartValue("servType"));
            lptBean.setServIndex(out.getPartValue("servIndex"));
            lptBean.setVnniId(out.getPartValue("vnniId"));
            lptBean.setRole(out.getPartValue("role"));
            lptBean.setCarrierType(out.getPartValue("carrierType"));
            lptBean.setParam1(out.getPartValue("param1"));
            lptBean.setParam2(out.getPartValue("param2"));
            lptBean.setParam3(out.getPartValue("param3"));
            resultMap.put(key, lptBean);
        }
        iLength = uniOper.getOutput().length;
        for (i = 0; i < iLength; ++i) {
            out = uniOper.getOutput()[i];
            key = out.getPartValue("servType") + "-" + out.getPartValue("servIndex");
            lptBean = (TELptBean)resultMap.get(key);
            if (lptBean == null) continue;
            lptBean.setSlotid(out.getPartValue("slotid"));
            lptBean.setPort(out.getPartValue("port"));
            lptBean.setTagNum(out.getPartValue("tagNum"));
            lptBean.setTagIds(out.getPartValue("tagIds"));
        }
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        for (Map.Entry entry : resultMap.entrySet()) {
            TELptBean lptBean2 = (TELptBean)entry.getValue();
            RowParams row = new RowParams();
            if (lptBean2.getSlotid() == null) continue;
            int slotid = Integer.parseInt(lptBean2.getSlotid());
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            this.addParam(row, "servType", lptBean2.getServType());
            this.addParam(row, "servIndex", lptBean2.getServIndex());
            this.addParam(row, "vnniId", lptBean2.getVnniId());
            this.addParam(row, "role", lptBean2.getRole());
            this.addParam(row, "carrierType", lptBean2.getCarrierType());
            this.addParam(row, "param1", lptBean2.getParam1());
            this.addParam(row, "param2", lptBean2.getParam2());
            this.addParam(row, "param3", lptBean2.getParam3());
            this.addParam(row, "vuniId", lptBean2.getVuniId());
            this.addParam(row, "slotid", lptBean2.getSlotid());
            this.addParam(row, "port", lptBean2.getPort());
            this.addParam(row, "tagNum", lptBean2.getTagNum());
            this.addParam(row, "tagIds", lptBean2.getTagIds());
            this.addParam(row, "subslotid", "255");
            this.addParam(row, "neid", String.valueOf(neid));
            this.addParam(row, "boardtype", String.valueOf(boardType));
            String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardType, Integer.parseInt(lptBean2.getPort()));
            this.addParam(row, "portname", portname);
            this.addParam(row, "boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType));
            this.outputData.getBussinessParams().addRowParams(row);
        }
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation operation = null;
        TEBoard tempbd = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        for (int i2 = rows.length - 1; i2 >= 0; --i2) {
            if (rows[i2].getRowErrorsCount() > 0) {
                this.outputData.getBussinessParams().removeRowParams(i2);
                continue;
            }
            String tagNum = rows[i2].getParam("tagNum").getValue();
            String carrierType = rows[i2].getParam("carrierType").getValue();
            String param3 = rows[i2].getParam("param3").getValue();
            if ("".equals(param3) || !PW.equals(carrierType) || !IS_TRANSPARENT.equals(tagNum)) {
                this.outputData.getBussinessParams().removeRowParams(i2);
                continue;
            }
            String slotid = rows[i2].getParam("slotid").getValue();
            String subslotid = "255";
            String port = rows[i2].getParam("port").getValue();
            tempbd = ne.getBoard(Integer.valueOf(slotid).intValue());
            if (null == tempbd || !TEIPUtils.isSupportGroupBoard(neid, tempbd.getBoardType())) {
                this.outputData.getBussinessParams().removeRowParams(i2);
                continue;
            }
            rows[i2].addParam("key", slotid + "-" + port);
            rows[i2].addParam("lptFlag", IS_TRANSPARENT);
            rows[i2].addParam("lptstate", "-");
            rows[i2].addParam("uniportstatus", "-");
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_PTPLPT_GET_BIND");
            Input input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", port);
            operList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_STATE");
            input = operation.getInput();
            input.setPartValue("topCarryMode", PW);
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", port);
            operList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_PORTSTATE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", port);
            operList.add(operation.clone());
        }
        Datainterface returnData = new Datainterface();
        if (null == operList || operList.isEmpty()) {
            returnData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            this.outputData = returnData;
            return;
        }
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operList, 60);
        if (null != result) {
            retCode = result.retCode;
        }
        if (retCode != 0) {
            returnData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)retCode));
            this.outputData = returnData;
            return;
        }
        this.constructOutputData(neid, operList);
    }

    private void addParam(RowParams row, String name, String value) {
        if (value == null) {
            row.addParam(name, "");
        } else {
            row.addParam(name, value);
        }
    }

    private void constructOutputData(int neid, ArrayList operList) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null == ne) {
            return;
        }
        for (int i = operList.size() - 1; i >= 0; --i) {
            Operation operation = (Operation)operList.get(i);
            for (Output output : operation.getOutput()) {
                this.join(output);
            }
        }
        Param param = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        try {
            for (int i = rows.length - 1; i >= 0; --i) {
                if (null != rows[i].getParam("bottomCarryMode")) {
                    rows[i].getParam("lptFlag").setValue(PW);
                }
                rows[i].addParam("connectPortName", "");
                param = rows[i].getParam("carrierType");
                if (PW.equals(param.getValue())) {
                    rows[i].getParam("connectPortName").setValue(TEIPUtils.getLPTPW(neid, rows[i].getParam("param3").getValue(), this.pwMap));
                    continue;
                }
                int slotid = Integer.valueOf(rows[i].getParam("param1").getValue());
                int port = Integer.valueOf(rows[i].getParam("param3").getValue());
                TEBoard board = ne.getBoard(slotid);
                if (null == board) continue;
                String boardname = board.getBoardName();
                String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, board.getBoardType(), port);
                rows[i].getParam("connectPortName").setValue(slotid + "-" + boardname + "-" + portname);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryP2PLPT fail!", (Throwable)e);
        }
        TEIPUtils.filterQueryLPTStateError(operList);
        Datainterface outputDataTemp = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)this.subfunc, (ArrayList)operList, (ArrayList)this.getFilterErrorCodeList());
        if (!outputDataTemp.getErrorMessage().getErrorcode().equals(IS_TRANSPARENT)) {
            this.outputData.setErrorMessage(outputDataTemp.getErrorMessage());
            rows = outputDataTemp.getBussinessParams().getRowParams();
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i].getRowErrorsCount() <= 0) continue;
                this.outputData.getBussinessParams().addRowParams(rows[i]);
            }
        }
    }

    private void join(Output p2pLptOutput) {
        if (!p2pLptOutput.getFault()[0].getCode().equals(IS_TRANSPARENT)) {
            return;
        }
        String slotid = "";
        String port = "";
        slotid = p2pLptOutput.getPartValue("slotid");
        port = p2pLptOutput.getPartValue("port");
        String inkey = slotid + "-" + port;
        String name = null;
        String value = null;
        RowParams[] p2pLptRows = this.outputData.getBussinessParams().getRowParams();
        for (int i = p2pLptRows.length - 1; i >= 0; --i) {
            if (!p2pLptRows[i].getParam("key").getValue().equals(inkey)) continue;
            for (int index = p2pLptOutput.getPartCount() - 1; index >= 0; --index) {
                name = p2pLptOutput.getPart(index).getName();
                value = p2pLptOutput.getPart(index).getValue();
                if (null != p2pLptRows[i].getParam(name)) {
                    p2pLptRows[i].getParam(name).setValue(value);
                    continue;
                }
                p2pLptRows[i].addParam(name, value);
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(44406);
        return list;
    }
}

