/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TEIPUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEQueryEthBoards
extends TENEExplorerBean {
    private Datainterface datainterface = null;
    Vector boardList = null;
    int neID = 0;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        if (ne != null) {
            this.boardList = ne.getBoardList();
        }
        if (null == this.boardList || 0 == this.boardList.size()) {
            this.datainterface = new Datainterface();
            this.datainterface.setBussinessParams(new BussinessParams());
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        this.datainterface = this.constructBoardListData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.log.error("Get BoardInfo Fail!\n");
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructBoardListData() {
        Datainterface data1 = new Datainterface();
        BussinessParams bussinessParams1 = new BussinessParams();
        Collections.sort(this.boardList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TEBoard board0 = (TEBoard)arg0;
                TEBoard board1 = (TEBoard)arg1;
                if (board0.getSlotID() >= board1.getSlotID()) {
                    return 1;
                }
                return 0;
            }
        });
        int size1 = this.boardList.size();
        for (int i = 0; i < size1; ++i) {
            TEBoard board1 = (TEBoard)this.boardList.get(i);
            int boardType = board1.getBoardType();
            if (!TEIPUtils.isSupportGroupBoard(this.neid, boardType)) continue;
            RowParams rParams = new RowParams();
            int slotid = board1.getSlotID();
            String boardName = board1.getBoardName();
            List subBoardList = board1.getSubBoardList();
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)slotid);
            if (subBoardList.size() != 0) {
                int isize = subBoardList.size();
                for (int k = 0; k < isize; ++k) {
                    TESubBoard subBoards = (TESubBoard)subBoardList.get(k);
                    int subslotid = subBoards.getSubSlotID();
                    String subBoardName = subBoards.getSubBoardName();
                    rParams.addParam("subrackName", subrackName);
                    rParams.addParam("slotid", "" + slotid);
                    rParams.addParam("boardName", boardName);
                    rParams.addParam("subslotid", "" + subslotid);
                    rParams.addParam("subBoardName", subBoardName);
                    bussinessParams1.addRowParams(rParams);
                }
                continue;
            }
            rParams.addParam("subrackName", subrackName);
            rParams.addParam("slotid", "" + slotid);
            rParams.addParam("boardName", boardName);
            bussinessParams1.addRowParams(rParams);
        }
        RowParams rParams = new RowParams();
        String pwListStr = this.getPW(0);
        rParams.addParam("pwList", pwListStr);
        bussinessParams1.addRowParams(rParams);
        data1.setBussinessParams(bussinessParams1);
        return data1;
    }

    public String getPW(int pwIndex) {
        String pwID = "";
        String index = "";
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_PTN_MPLS_PW_GET_PW_1");
        Input input = oper.getInput();
        input.setPartValue("pwIndex", "" + pwIndex);
        operationList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, this.getTimeOut());
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        Output[] outputArr = tmpOper.getOutput();
        StringBuilder sb = new StringBuilder();
        for (Output output : outputArr) {
            if (output == null || output.getFault()[0] == null || !"0".equals(output.getFault()[0].getCode())) continue;
            index = output.getPartValue("pwIndex");
            pwID = output.getPartValue("pwId");
            sb.append(index).append("-").append(pwID).append(",");
        }
        return sb.toString();
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    public static void main(String[] args) {
    }
}

