/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TELPTWriteLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQueryConnectNode
extends TENEExplorerBean {
    private String PW = "2";
    private String QinQ = "3";
    private String LNET = "5";
    ArrayList operList = null;
    int neID = 0;
    private Map<String, String> pwMap = new HashMap<String, String>();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.neID = neid;
        this.pwMap.clear();
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null == ne) {
            return;
        }
        this.operList = new ArrayList();
        int num = 0;
        String portListStr = "";
        String bottomCarryMode = "";
        Param param = null;
        RowParams row = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        ArrayList<RowParams> errRows = new ArrayList<RowParams>();
        try {
            Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_PORTSTATE");
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i].getRowErrorsCount() > 0) {
                    errRows.add(rows[i]);
                    this.outputData.getBussinessParams().removeRowParams(i);
                    continue;
                }
                param = rows[i].getParam("portNumber");
                num = Integer.parseInt(param.getValue());
                portListStr = rows[i].getParam("portList").getValue();
                bottomCarryMode = rows[i].getParam("bottomCarryMode").getValue();
                this.outputData.getBussinessParams().removeRowParams(i);
                String slotportStr = "";
                String slotidStr = "";
                String subslotidStr = "";
                String portStr = "";
                for (int index = 0; index < num; ++index) {
                    row = new RowParams();
                    row.addParam("bottomCarryMode", bottomCarryMode);
                    slotportStr = portListStr.substring(24 * index, 24 * (index + 1));
                    slotidStr = slotportStr.substring(0, 8);
                    subslotidStr = slotportStr.substring(8, 16);
                    portStr = slotportStr.substring(16, 24);
                    if (bottomCarryMode.equals(this.PW)) {
                        row.addParam("uniportstatus", "-");
                        long port = TELPTWriteLogBean.getLongFrom8BitHexStr(portStr);
                        row.addParam("connectPortName", this.getPW(String.valueOf(port)));
                        row.addParam("param1", "4294967295");
                        row.addParam("param2", "4294967295");
                        row.addParam("param3", "" + port);
                        row.addParam("key", "4294967295-" + port);
                    } else if (bottomCarryMode.equals(this.QinQ)) {
                        row.addParam("uniportstatus", "-");
                        long port = TELPTWriteLogBean.getLongFrom8BitHexStr(portStr);
                        row.addParam("connectPortName", String.valueOf(port));
                        row.addParam("param1", "4294967295");
                        row.addParam("param2", "4294967295");
                        row.addParam("param3", "" + port);
                        row.addParam("key", "4294967295-" + port);
                    } else if (bottomCarryMode.equals(this.LNET)) {
                        row.addParam("uniportstatus", "-");
                        long port = TELPTWriteLogBean.getLongFrom8BitHexStr(portStr);
                        row.addParam("connectPortName", String.valueOf(port));
                        row.addParam("param1", "4294967295");
                        row.addParam("param2", "4294967295");
                        row.addParam("param3", "" + port);
                        row.addParam("key", "4294967295-" + port);
                        operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_ETHN_LPT_GET_EXTPARA");
                        Input input = operation.getInput();
                        input.setPartValue("bottomCarryMode", "5");
                        input.setPartValue("param1", String.valueOf(0xFFFFFFFFL));
                        input.setPartValue("param2", String.valueOf(0xFFFFFFFFL));
                        input.setPartValue("param3", String.valueOf(port));
                        this.operList.add(operation.clone());
                    } else {
                        row.addParam("uniportstatus", "/");
                        int slotid = (int)TELPTWriteLogBean.getLongFrom8BitHexStr(slotidStr);
                        int subslotid = (int)TELPTWriteLogBean.getLongFrom8BitHexStr(subslotidStr);
                        int port = (int)TELPTWriteLogBean.getLongFrom8BitHexStr(portStr);
                        TEBoard board = ne.getBoard(slotid);
                        if (null != board) {
                            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)board.getSlotID());
                            String boardname = board.getBoardName();
                            String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, board.getBoardType(), port);
                            if (subrackName.isEmpty()) {
                                row.addParam("connectPortName", "" + slotid + "-" + boardname + "-" + portname);
                            } else {
                                row.addParam("connectPortName", subrackName + "-" + slotid + "-" + boardname + "-" + portname);
                            }
                            row.addParam("param1", "" + slotid);
                            row.addParam("param2", "" + subslotid);
                            row.addParam("param3", "" + port);
                            row.addParam("key", slotid + "-" + port);
                            Input input = operation.getInput();
                            input.setPartValue("slotid", "" + slotid);
                            input.setPartValue("subslotid", "" + subslotid);
                            input.setPartValue("port", "" + port);
                            this.operList.add(operation.clone());
                        }
                    }
                    this.outputData.getBussinessParams().addRowParams(row);
                }
            }
            int len = errRows.size();
            for (int j = 0; j < len; ++j) {
                this.outputData.getBussinessParams().addRowParams((RowParams)errRows.get(j));
            }
            if (null == this.operList || this.operList.size() == 0) {
                return;
            }
            int retCode = 0;
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)this.operList, 60);
            if (null != result) {
                retCode = result.retCode;
            }
            if (retCode != 0) {
                return;
            }
            this.constructOutputData(neid, this.operList);
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("TEQueryP2PLPT fail!", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("TEQueryP2PLPT fail!", (Throwable)e);
        }
    }

    private void constructOutputData(int neid, ArrayList operList) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null == ne) {
            return;
        }
        for (int i = operList.size() - 1; i >= 0; --i) {
            Operation operation = (Operation)operList.get(i);
            for (Output output : operation.getOutput()) {
                this.join(output);
            }
        }
        Param param = null;
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        try {
            for (int i = rows.length - 1; i >= 0; --i) {
                String bottomCarryMode;
                param = rows[i].getParam("bottomCarryMode");
                if (null == param || null == param.getValue() || param.getValue().isEmpty() || !this.LNET.equals(bottomCarryMode = param.getValue())) continue;
                String param3 = rows[i].getParam("param3").getValue();
                String peerParam3 = rows[i].getParam("peerParam3").getValue();
                rows[i].addParam("localpeerid", param3 + "-" + peerParam3);
                String sendslotid = rows[i].getParam("sendslotid").getValue();
                String sendport = rows[i].getParam("sendport").getValue();
                String vlanId = rows[i].getParam("vlanId").getValue();
                String vlanName = vlanId + "(Vlan ID-" + vlanId + ")";
                TEBoard board = ne.getBoard(Integer.parseInt(sendslotid));
                if (null == board) continue;
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)board.getSlotID());
                String boardname = board.getBoardName();
                String portname = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, Integer.parseInt(sendslotid), board.getBoardType(), Integer.parseInt(sendport));
                if (subrackName.isEmpty()) {
                    rows[i].addParam("connectPortName", sendslotid + "-" + boardname + "-" + portname + "-" + vlanName);
                    continue;
                }
                rows[i].addParam("connectPortName", subrackName + "-" + sendslotid + "-" + boardname + "-" + portname + "-" + vlanName);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryP2PLPT fail!", (Throwable)e);
        }
        Datainterface outputDataTemp = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)this.subfunc, (ArrayList)operList, (ArrayList)this.getFilterErrorCodeList());
        if (!outputDataTemp.getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            rows = outputDataTemp.getBussinessParams().getRowParams();
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i].getRowErrorsCount() <= 0) continue;
                this.outputData.getBussinessParams().addRowParams(rows[i]);
            }
        }
    }

    private void join(Output output) {
        if (!output.getFault()[0].getCode().equals("0")) {
            return;
        }
        String slotid = "";
        String port = "";
        slotid = output.getPartValue("slotid");
        port = output.getPartValue("port");
        String inkey = slotid + "-" + port;
        String bCarryMode = output.getPartValue("bCarryMode");
        String param3 = output.getPartValue("param3");
        String lnetindex = bCarryMode + "-" + param3;
        String name = null;
        String value = null;
        String rowsbottomCarryMode = null;
        String rowsparam3 = null;
        String rowslnetindex = "";
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        for (int i = rows.length - 1; i >= 0; --i) {
            if (null != rows[i].getParam("bottomCarryMode") && null != rows[i].getParam("param3")) {
                rowsbottomCarryMode = rows[i].getParam("bottomCarryMode").getValue();
                rowsparam3 = rows[i].getParam("param3").getValue();
                rowslnetindex = rowsbottomCarryMode + "-" + rowsparam3;
            }
            if (!rows[i].getParam("key").getValue().equals(inkey) && !rowslnetindex.equals(lnetindex)) continue;
            for (int index = output.getPartCount() - 1; index >= 0; --index) {
                name = output.getPart(index).getName();
                value = output.getPart(index).getValue();
                if (null != rows[i].getParam(name)) {
                    if (!rows[i].getParam(name).getValue().equals("") && !rows[i].getParam(name).getValue().equals("/")) continue;
                    rows[i].getParam(name).setValue(value);
                    continue;
                }
                rows[i].addParam(name, value);
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        return list;
    }

    public String getPW(String pwIndex) {
        String tempId = this.pwMap.get(pwIndex);
        if (null != tempId) {
            return tempId;
        }
        String pwID = "";
        String index = "";
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_PTN_MPLS_PW_GET_PW_1");
        Input input = oper.getInput();
        input.setPartValue("pwIndex", "" + pwIndex);
        operationList.add(oper.clone());
        TENECommMgr.getInstance().sendCommand(this.neID, operationList, this.getTimeOut());
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        for (Output output : tmpOper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0")) continue;
            index = output.getPartValue("pwIndex");
            pwID = output.getPartValue("pwId");
            this.pwMap.put(index, pwID);
        }
        tempId = this.pwMap.get(pwIndex);
        return tempId == null ? pwIndex : tempId;
    }
}

