/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEIPUtils {
    private static final Set<Integer> groupBoards = new HashSet<Integer>();

    public static List<Integer> getSupportGroupBoards(int neid) {
        ArrayList<Integer> supportBoardList = new ArrayList<Integer>();
        supportBoardList.addAll(groupBoards);
        return supportBoardList;
    }

    public static boolean isSupportGroupBoard(int neid, int boardType) {
        if (groupBoards.contains(boardType)) {
            return true;
        }
        return TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_ETH_LPT", "LPT_ATTR_SUPPORT_GROUPBOARD");
    }

    static boolean isNoRecordError(String errCode) {
        return "38662".equals(errCode) || "38900".equals(errCode) || "39182".equals(errCode) || "39174".equals(errCode);
    }

    public static RowParams handleRowError(Output output) {
        RowParams errRow = null;
        String errCode = output.getFault(0).getCode();
        if (null != errCode && !"0".equals(errCode) && !TEIPUtils.isNoRecordError(errCode)) {
            errRow = new RowParams();
            RowErrors err = new RowErrors();
            ErrorMessage errMsg = new ErrorMessage();
            errMsg.setErrorcode(errCode);
            if (!errCode.equals("") && (output.getFault(0).getValue() == null || "".equals(output.getFault(0).getValue()))) {
                errMsg.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errCode)));
            } else {
                errMsg.setErrorinfo(output.getFault(0).getValue());
            }
            err.setErrorMessage(errMsg);
            errRow.addRowErrors(err);
        }
        return errRow;
    }

    public static ArrayList getMacPortList(int neID, int slotID, int boardType) {
        ArrayList allPortList = TEConfigurationDataMgr.getInstance().getETHMACPort(neID, boardType);
        ArrayList existPortList = TEIPUtils.getExistPortList(neID, slotID, allPortList);
        if (existPortList.isEmpty()) {
            existPortList.addAll(allPortList);
        }
        int portId = 0;
        Iterator iter = existPortList.iterator();
        while (iter.hasNext()) {
            portId = (Integer)iter.next();
            if (TEGenCfgDataMgr.isSupportAttr((int)neID, (int)boardType, (int)portId, (String)"ATTR_ETHOVERSDH_MAC_PHY_LOOPBACK")) continue;
            iter.remove();
        }
        return existPortList;
    }

    private static ArrayList getExistPortList(int neID, int slotID, ArrayList portList) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_GET_PORT");
        Input input = oper.getInput();
        Part part = input.getPart("slotID");
        part.setValue(String.valueOf(slotID));
        part = input.getPart("portID");
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            part.setValue(String.valueOf((Integer)portList.get(i)));
            operationList.add(oper.clone());
        }
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        if (operationList.size() == 0) {
            return returnList;
        }
        int result = TECommuNEMgr.getInstance().sendCommand((int)neID, operationList, (int)10, null).retCode;
        if (result == 0) {
            int len = operationList.size();
            for (int j = 0; j < len; ++j) {
                Operation oOperation = (Operation)operationList.get(j);
                if (!String.valueOf(0).equals(oOperation.getOutput()[0].getFault()[0].getCode())) continue;
                String portId = oOperation.getOutput()[0].getPartValue("portID");
                returnList.add(Integer.valueOf(portId));
            }
        }
        return returnList;
    }

    public static String getMainPTLogInfo(StringBuffer strBuf, TEResourceUtil res, int neid, String slotid, String port, String mainCarryMode, String mainDelayTime) {
        String boardName = null;
        String portName = null;
        try {
            int wSlotid = Integer.parseInt(slotid);
            int wPort = Integer.parseInt(port);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, wSlotid);
            boardName = TEBoardUtil.getShelfBoardName((int)neid, (int)wSlotid);
            portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, wSlotid, boardType, wPort);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Slotid or PortID is not integer.\n");
            boardName = slotid;
            portName = port;
        }
        strBuf.append(res.getString("poolSlotId") + ":");
        strBuf.append(boardName).append(",");
        strBuf.append(res.getString("poolPortId") + ":");
        strBuf.append(portName);
        if (mainCarryMode != null) {
            strBuf.append(",");
            strBuf.append(res.getString("mainCarryMode") + ":").append(res.getString("mainCarryMode" + mainCarryMode));
        }
        if (mainDelayTime != null) {
            strBuf.append(",");
            strBuf.append(res.getString("mainDelayTime") + ":").append(mainDelayTime);
        }
        return strBuf.toString();
    }

    public static void filterQueryLPTStateError(ArrayList operList) {
        Operation operation = null;
        for (int i = operList.size() - 1; i >= 0; --i) {
            operation = (Operation)operList.get(i);
            if (!operation.getName().equalsIgnoreCase("NSCMD_CFG_ETHN_LPT_GET_STATE")) continue;
            operList.remove(i);
        }
    }

    public static String getLPTPW(int neID, String pwIndex, Map<String, String> pwMap) {
        String tempId = pwMap.get(pwIndex);
        if (null != tempId) {
            return tempId;
        }
        String pwID = "";
        String index = "";
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_PTN_MPLS_PW_GET_PW_1");
        Input input = oper.getInput();
        input.setPartValue("pwIndex", String.valueOf(pwIndex));
        operationList.add((Operation)oper.clone());
        OperationResult operResult = TENECommMgr.getInstance().sendCommand(neID, operationList, 30);
        if (operResult.retCode == 0) {
            Operation tmpOper = (Operation)operationList.get(0);
            operationList.clear();
            for (Output output : tmpOper.getOutput()) {
                if (!output.getFault()[0].getCode().equals("0")) continue;
                index = output.getPartValue("pwIndex");
                pwID = output.getPartValue("pwId");
                pwMap.put(index, pwID);
            }
        }
        return (tempId = pwMap.get(pwIndex)) == null ? pwIndex : tempId;
    }

    static {
        groupBoards.add(1590);
        groupBoards.add(1589);
        groupBoards.add(1591);
        groupBoards.add(1584);
        groupBoards.add(1587);
        groupBoards.add(1585);
        groupBoards.add(2115);
        groupBoards.add(2111);
        groupBoards.add(2112);
        groupBoards.add(2121);
        groupBoards.add(2235);
        groupBoards.add(2261);
        groupBoards.add(2260);
        groupBoards.add(2082);
        groupBoards.add(2455);
        groupBoards.add(2083);
        groupBoards.add(2418);
        groupBoards.add(2417);
        groupBoards.add(2268);
        groupBoards.add(2265);
        groupBoards.add(2088);
        groupBoards.add(2087);
        groupBoards.add(2386);
        groupBoards.add(2416);
        groupBoards.add(2420);
        groupBoards.add(2411);
        groupBoards.add(2412);
        groupBoards.add(2102);
        groupBoards.add(2439);
        groupBoards.add(2490);
        groupBoards.add(2488);
        groupBoards.add(2489);
        groupBoards.add(2471);
        groupBoards.add(2519);
        groupBoards.add(2483);
    }
}

