/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TEEVPL;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TEIPUtils;
import com.huawei.nglct.nemgr.ip.sdh.lpt.TEQueryPTMPLPT;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;

public class TEGetEplForLpt
extends TENEExplorerBean {
    private int slotID = -1;
    private int boardType = -1;
    private static final String SLOT_ID_PARAM = "slotid";
    private static final String VLAN_NULL = "65535";
    private static final int BOARDTYPE_EFT4 = 1066;
    private static final int VCTRUNK = 32768;
    private static final int SL91EMS6_PORT7 = 7;
    private static final String DISABLE = "0";
    private static final String ENABLE = "1";
    private static final String DIRECTION_POSITIVE = "2";
    private static final String DIRECTION_REVERSE = "3";
    private static String NOVALUE = "-";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        Param param = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)SLOT_ID_PARAM);
        this.slotID = Integer.parseInt(param.getValue());
        this.boardType = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotID).getBoardType();
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subFunc) {
        int i;
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        Operation operation = null;
        boolean hasFault = false;
        boolean hasSucc = false;
        ArrayList errList = new ArrayList();
        ArrayList funblockList = TEQueryPTMPLPT.getEthBoardInfo(neid, this.slotID);
        ArrayList eplList = new ArrayList();
        HashMap<String, String> lptLinkList = new HashMap<String, String>();
        HashMap<String, String> ptmpList = new HashMap<String, String>();
        HashMap<String, String> lptDelayTimeList = new HashMap<String, String>();
        HashMap<String, String> lptCarryModeList = new HashMap<String, String>();
        int len = operationList.size();
        for (int index = 0; index < len; ++index) {
            operation = (Operation)operationList.get(index);
            int retcode = 0;
            String cmdName = operation.getName();
            if ("NSCMD_ETHN_GET_VLANSWITCHLINK".equals(cmdName)) {
                retcode = this.handleEPL(operation, eplList, errList);
            } else if ("NSCMD_ETHN_GET_LPTLINK".equals(cmdName)) {
                retcode = this.handleLPTLink(operation, lptLinkList, errList);
            } else if ("NSCMD_CFG_GET_P2PLPT_HOLDOFFTIME".equals(cmdName)) {
                retcode = this.handleDelayTime(operation, lptDelayTimeList, errList);
            } else if ("NSCMD_CFG_GET_VCTRUNK_LPT_CARRYMODE".equals(cmdName)) {
                retcode = this.handleLptCarryMode(operation, lptCarryModeList, errList);
            } else if ("NSCMD_CFG_ETHN_GET_P2MP_LPT".equals(cmdName)) {
                retcode = this.handleLPTLink(operation, ptmpList, errList);
            }
            if (0 != retcode) continue;
            hasSucc = true;
        }
        if (errList.size() > 0) {
            hasFault = true;
            int errNum = errList.size();
            for (int errIndex = 0; errIndex < errNum; ++errIndex) {
                bussinessParams.addRowParams((RowParams)errList.get(errIndex));
            }
        }
        for (i = 0; i < funblockList.size(); ++i) {
            String[] ports = ((String)funblockList.get(i)).split("-");
            String portid = ports[0];
            String portName = ports[1];
            String returnName = portName;
            if (returnName.indexOf("PORT") < 0 && returnName.indexOf("VCTRUNK") < 0) continue;
            if (lptLinkList.containsKey(portid)) {
                this.handleOutput(portid, returnName, lptLinkList, lptDelayTimeList, lptCarryModeList, ptmpList, bussinessParams);
                continue;
            }
            if (null != this.isContainsObj(eplList, portid)) {
                this.handleOutput(portid, eplList, ptmpList, bussinessParams);
                continue;
            }
            if (returnName.indexOf("VCTRUNK") >= 0) continue;
            this.handleOutput(portid, returnName, ptmpList, bussinessParams);
        }
        errList.clear();
        funblockList.clear();
        eplList.clear();
        lptLinkList.clear();
        lptDelayTimeList.clear();
        lptCarryModeList.clear();
        this.outputData.setErrorMessage(new ErrorMessage());
        if (!hasFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!hasSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        int m = this.outputData.getBussinessParams().getRowParamsCount();
        for (i = 0; i < m; ++i) {
            RowParams rp = this.outputData.getBussinessParams().getRowParams(i);
            int n = rp.getParamCount();
            for (int j = 0; j < n; ++j) {
                Param p = rp.getParam(j);
                if (p.getValue() != null) continue;
                p.setValue("");
            }
        }
    }

    private void parseVlanSwitchLink(Operation operation, ArrayList eplList) {
        Output output = null;
        TEEVPL link = null;
        RowParams errRow = null;
        int linkNum = operation.getOutputCount();
        for (int j = 0; j < linkNum; ++j) {
            output = operation.getOutput(j);
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) continue;
            link = new TEEVPL();
            int partNum = output.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                link.setPropValue(output.getPart(k));
            }
            link.direction = 0;
            link.linkType = 0;
            if (link.upLinkID > 0) {
                eplList.add(link);
                continue;
            }
            TELogFactory.getNormalLogger().error("parseVlanSwitchLink() invalid link=" + (Object)((Object)link));
        }
    }

    private int handleEPL(Operation operation, ArrayList eplList, ArrayList errList) {
        Output[] outputArr = operation.getOutput();
        Operation validOutputList = new Operation();
        int retCode = 2;
        if (1066 != this.boardType) {
            for (int j = 0; j < outputArr.length; ++j) {
                Output output = outputArr[j];
                retCode = new Integer(output.getFault()[0].getCode());
                RowParams errRow = TEIPUtils.handleRowError(output);
                if (errRow != null) {
                    errList.add(errRow);
                    continue;
                }
                String tmpPort = output.getPartValue("srcPort");
                String tempPort = output.getPartValue("snkPort");
                if (null == tmpPort || null == tempPort) continue;
                int srcPort = Integer.parseInt(tmpPort);
                int snkPort = Integer.parseInt(tempPort);
                if (2439 == this.boardType && (srcPort == 7 || snkPort == 7) || !VLAN_NULL.equals(output.getPartValue("srcVlan")) || !VLAN_NULL.equals(output.getPartValue("snkVlan")) || 32768 < srcPort && 32768 < snkPort || 32768 > srcPort && 32768 > snkPort) continue;
                validOutputList.addOutput(output);
            }
            this.parseVlanSwitchLink(validOutputList, eplList);
        } else {
            retCode = 0;
            ArrayList allPorts = TEQueryPTMPLPT.getEthBoardInfo(this.neid, this.slotID);
            String portid = "";
            for (int i = 0; i < allPorts.size(); ++i) {
                TEEVPL link = new TEEVPL();
                String[] ports = ((String)allPorts.get(i)).split("-");
                portid = ports[0];
                int portID = Integer.parseInt(portid);
                link.setPropValue("srcPort", portid, "int");
                if (32768 > portID) {
                    link.setPropValue("snkPort", portID + 32768 + "", "int");
                } else {
                    link.setPropValue("snkPort", portID - 32768 + "", "int");
                }
                link.direction = 0;
                link.linkType = 0;
                if (link.upLinkID <= 0) continue;
                eplList.add(link);
            }
        }
        return retCode;
    }

    private int handleLPTLink(Operation operation, HashMap lptLinkList, ArrayList errList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String portNumber = "";
        String portList = "";
        int retCode = 2;
        int j = 0;
        int i = 0;
        while (j < outputArr.length) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errList.add(errRow);
            } else if (38662 != retCode) {
                port = output.getPartValue("port");
                portNumber = output.getPartValue("portNumber");
                portList = output.getPartValue("portList");
                if (!DISABLE.equals(portNumber)) {
                    lptLinkList.put(port, portList);
                }
            }
            ++j;
            i += 2;
        }
        return retCode;
    }

    private int handleDelayTime(Operation operation, HashMap lptDelayTimeList, ArrayList errList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String delayTime = "";
        int retCode = 2;
        int j = 0;
        int i = 0;
        while (j < outputArr.length) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errList.add(errRow);
            } else if (38662 != retCode) {
                port = output.getPartValue("port");
                delayTime = output.getPartValue("delayTime");
                lptDelayTimeList.put(port, delayTime);
            }
            ++j;
            i += 2;
        }
        return retCode;
    }

    private int handleLptCarryMode(Operation operation, HashMap lptCarryModeList, ArrayList errList) {
        Output[] outputArr = operation.getOutput();
        String port = "";
        String carryMode = "";
        int retCode = 2;
        int j = 0;
        int i = 0;
        while (j < outputArr.length) {
            Output output = outputArr[j];
            retCode = new Integer(output.getFault()[0].getCode());
            RowParams errRow = null;
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errList.add(errRow);
            } else if (38662 != retCode) {
                port = output.getPartValue("port");
                carryMode = output.getPartValue("carryMode");
                lptCarryModeList.put(port, carryMode);
            }
            ++j;
            i += 2;
        }
        return retCode;
    }

    private TEEVPL isContainsObj(ArrayList list, String port) {
        TEEVPL isContain = null;
        if (null == list || list.size() == 0) {
            return isContain;
        }
        for (int i = 0; i < list.size(); ++i) {
            TEEVPL link = (TEEVPL)((Object)list.get(i));
            if (!port.equals(String.valueOf(link.srcPort))) continue;
            isContain = link;
            break;
        }
        return isContain;
    }

    private void handleOutput(String portid, String returnName, HashMap<String, String> lptLinkList, HashMap<String, String> lptDelayTimeList, HashMap<String, String> lptCarryModeList, HashMap<String, String> ptmpList, BussinessParams bussinessParams) {
        RowParams rowparams = new RowParams();
        Param param = null;
        String endPortid = "";
        String endPortName = "";
        String ptmpPortid = "";
        if (returnName.indexOf("VCTRUNK") < 0) {
            param = new Param("portid", portid);
            rowparams.addParam(param);
            param = new Param("port", returnName);
            rowparams.addParam(param);
            endPortid = Integer.parseInt(lptLinkList.get(portid), 16) + "";
            endPortName = "VCTRUNK" + (Integer.parseInt(endPortid) - 32768);
            param = new Param("vctrunkid", endPortid + "");
            rowparams.addParam(param);
            ptmpPortid = ptmpList.get(portid);
            param = new Param("ptmpPort", ptmpPortid);
            rowparams.addParam(param);
            param = new Param("vcTrunk", endPortName);
            rowparams.addParam(param);
            param = new Param("portDlayTime", null == lptDelayTimeList.get(portid) ? NOVALUE : lptDelayTimeList.get(portid));
            rowparams.addParam(param);
            param = new Param("vcTrunkLateDelayTime", null == lptDelayTimeList.get(endPortid) ? NOVALUE : lptDelayTimeList.get(endPortid));
            rowparams.addParam(param);
            param = new Param("lptCarryMode", lptCarryModeList.get(endPortid));
            rowparams.addParam(param);
            param = new Param("direction", DIRECTION_POSITIVE);
            rowparams.addParam(param);
        } else {
            endPortid = Integer.parseInt(lptLinkList.get(portid), 16) + "";
            endPortName = "PORT" + Integer.parseInt(endPortid);
            param = new Param("portid", Integer.parseInt(endPortid) + "");
            rowparams.addParam(param);
            param = new Param("port", endPortName);
            rowparams.addParam(param);
            param = new Param("vctrunkid", portid);
            rowparams.addParam(param);
            param = new Param("vcTrunk", returnName);
            rowparams.addParam(param);
            ptmpPortid = ptmpList.get(portid);
            param = new Param("ptmpPort", ptmpPortid);
            rowparams.addParam(param);
            param = new Param("portDlayTime", null == lptDelayTimeList.get(endPortid) ? NOVALUE : lptDelayTimeList.get(endPortid));
            rowparams.addParam(param);
            param = new Param("vcTrunkLateDelayTime", null == lptDelayTimeList.get(portid) ? NOVALUE : lptDelayTimeList.get(portid));
            rowparams.addParam(param);
            param = new Param("lptCarryMode", lptCarryModeList.get(portid));
            rowparams.addParam(param);
            param = new Param("direction", DIRECTION_REVERSE);
            rowparams.addParam(param);
        }
        param = new Param("W32BRD_ATTR_LPTENABLE", ENABLE);
        rowparams.addParam(param);
        param = new Param("originEnableStatus", ENABLE);
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }

    private void handleOutput(String portid, ArrayList eplList, HashMap<String, String> ptmpList, BussinessParams bussinessParams) {
        TEEVPL link = this.isContainsObj(eplList, portid);
        RowParams rowparams = new RowParams();
        Param param = null;
        String endPortid = "";
        String endPortName = "";
        if (32768 > link.srcPort) {
            endPortid = "" + link.snkPort;
            endPortName = "VCTRUNK" + (link.snkPort - 32768);
            param = new Param("portid", "" + link.srcPort);
            rowparams.addParam(param);
            param = new Param("port", "PORT" + link.srcPort);
            rowparams.addParam(param);
            param = new Param("vctrunkid", endPortid);
            rowparams.addParam(param);
            param = new Param("vcTrunk", endPortName);
            rowparams.addParam(param);
            link.direction = 2;
        } else {
            endPortid = "" + link.snkPort;
            endPortName = "PORT" + link.snkPort;
            param = new Param("portid", endPortid);
            rowparams.addParam(param);
            param = new Param("port", endPortName);
            rowparams.addParam(param);
            param = new Param("vctrunkid", "" + link.srcPort);
            rowparams.addParam(param);
            param = new Param("vcTrunk", "VCTRUNK" + (link.srcPort - 32768));
            rowparams.addParam(param);
            link.direction = 3;
        }
        param = new Param("portDlayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("vcTrunkLateDelayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("lptCarryMode", NOVALUE);
        rowparams.addParam(param);
        param = new Param("direction", "" + link.direction);
        rowparams.addParam(param);
        param = new Param("W32BRD_ATTR_LPTENABLE", DISABLE);
        rowparams.addParam(param);
        param = new Param("originEnableStatus", DISABLE);
        rowparams.addParam(param);
        param = new Param("ptmp", ptmpList.get(portid));
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }

    private void handleOutput(String portid, String returnName, HashMap<String, String> ptmpList, BussinessParams bussinessParams) {
        RowParams rowparams = new RowParams();
        Param param = null;
        param = new Param("portid", "" + portid);
        rowparams.addParam(param);
        param = new Param("port", returnName);
        rowparams.addParam(param);
        param = new Param("portDlayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("vctrunkid", NOVALUE);
        rowparams.addParam(param);
        param = new Param("vcTrunk", NOVALUE);
        rowparams.addParam(param);
        param = new Param("vcTrunkLateDelayTime", NOVALUE);
        rowparams.addParam(param);
        param = new Param("lptCarryMode", DIRECTION_POSITIVE);
        rowparams.addParam(param);
        param = new Param("direction", "4");
        rowparams.addParam(param);
        param = new Param("W32BRD_ATTR_LPTENABLE", NOVALUE);
        rowparams.addParam(param);
        param = new Param("originEnableStatus", DISABLE);
        rowparams.addParam(param);
        param = new Param("ptmp", ptmpList.get(portid));
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }
}

