/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.linkaggregation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TEQueryLagPort
extends TENEExplorerBean {
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK = 31443;
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK_EX = 34293;
    private static final int NSCMD_ETHN_GET_QINQLINK = 31458;
    private static final int NSCMD_ETHN_GET_QINQLINK_EX = 34298;
    private static final int NSCMD_ETHN_GET_LINKAGG = 31448;
    private static final int NSCMD_ETHN_GET_LINKAGG_EX = 34211;
    private Set usedPortSet = new HashSet();
    private List ethnPortList = new ArrayList();
    private Set servicePortSet = new HashSet();
    private List nonPhyPortList = new ArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.getPortAndVCtrunk(neid, this.inputData);
        Operation operation = null;
        Output output = null;
        int m = operationList.size();
        block4: for (int i = 0; i < m; ++i) {
            operation = (Operation)operationList.get(i);
            switch (operation.getCmdid()) {
                case 31448: 
                case 34211: {
                    int n = operation.getOutputCount();
                    for (int j = 0; j < n; ++j) {
                        output = operation.getOutput(j);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.usedPortSet.add(Integer.valueOf(output.getPartValue("mainPort")));
                        int branchPortNum = Integer.parseInt(output.getPartValue("branchPortNum"));
                        if (branchPortNum <= 0) continue;
                        byte[] bValue = output.getPartValue("branchPort").getBytes();
                        int nCount = bValue.length / branchPortNum;
                        int nPos = 0;
                        int nParaSize = bValue.length;
                        while (nPos + nCount <= nParaSize) {
                            byte[] bTmp = new byte[4];
                            System.arraycopy(bValue, nPos + (nCount - 4), bTmp, 0, 4);
                            this.usedPortSet.add(new Integer(IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0)));
                            nPos += nCount;
                        }
                    }
                    continue block4;
                }
                case 31443: 
                case 31458: 
                case 34293: 
                case 34298: {
                    int t = operation.getOutputCount();
                    for (int k = 0; k < t; ++k) {
                        output = operation.getOutput(k);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.servicePortSet.add(Integer.valueOf(output.getPartValue("srcPort")));
                        this.servicePortSet.add(Integer.valueOf(output.getPartValue("snkPort")));
                    }
                    continue block4;
                }
                default: {
                    TELogFactory.getNormalLogger().info("TEQueryLagPort.handleMessage() operation.getCmdid():" + operation.getCmdid() + " not in case!");
                }
            }
        }
        this.ethnPortList.removeAll(this.usedPortSet);
        this.servicePortSet.removeAll(this.usedPortSet);
        this.servicePortSet.removeAll(this.nonPhyPortList);
        this.outputData.setBussinessParams(new BussinessParams());
        if (this.ethnPortList.size() > 0) {
            Option option;
            RowParams rowParams = new RowParams();
            Param param = new Param("mainport", "");
            int mm = this.ethnPortList.size();
            for (int ii = 0; ii < mm; ++ii) {
                Integer portId = (Integer)this.ethnPortList.get(ii);
                option = new Option(String.valueOf(portId));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.ethnPortList.removeAll(this.servicePortSet);
            param = new Param("branchport", "");
            int nn = this.ethnPortList.size();
            for (int jj = 0; jj < nn; ++jj) {
                Integer portId = (Integer)this.ethnPortList.get(jj);
                option = new Option(String.valueOf(portId));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void getPortAndVCtrunk(int neid, Datainterface inputData) {
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        Param boardTypeParam = Datainterface.getParam((Param[])params, (String)"boardType");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        ArrayList vcTrunkPortList = mgr.getETHVCTrunkPort(neid, boardType);
        ArrayList macPortList = mgr.getETHMACPort(neid, boardType);
        int portId = 0;
        Iterator iter = macPortList.iterator();
        while (iter.hasNext()) {
            portId = (Integer)iter.next();
            if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)portId, (String)"ATTR_ETHOVERSDH_MAC_PHY_LOOPBACK")) continue;
            this.nonPhyPortList.add(portId);
            iter.remove();
        }
        this.ethnPortList.addAll(macPortList);
        this.ethnPortList.addAll(vcTrunkPortList);
    }
}

