/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.linkaggregation;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.sdh.linkaggregation.TELAGUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryLagParams
extends TENEExplorerBean {
    private String neName = "";
    private String boardName = "";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        this.neName = mgr.getNE(neid).getNEName();
        int slotId = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        this.boardName = mgr.getBoardTypeName(neid, mgr.getBoardType(neid, slotId));
        Operation oper = null;
        Output output = null;
        boolean sysFlag = false;
        boolean macFlag = false;
        RowParams rowParams = new RowParams();
        int m = operationList.size();
        for (int i = 0; i < m; ++i) {
            Param param;
            oper = (Operation)operationList.get(i);
            String operName = oper.getName();
            if (operName.equals("NSCMD_ETHN_GET_LINKAGGPORTPRIOR")) {
                ArrayList<Object> operList = new ArrayList<Object>();
                operList.add(oper.clone());
                this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, operList, (ArrayList)filterErrorCodeList);
                continue;
            }
            if (operName.equals("NSCMD_ETHN_GET_LINKAGGSYSPRIOR")) {
                output = oper.getOutput(0);
                if (output.getFault(0).getCode().equals("0")) {
                    param = new Param("LAGSystemPriority", output.getPartValue("LAGSystemPriority"));
                    rowParams.addParam(param);
                    continue;
                }
                sysFlag = true;
                rowParams.addRowErrors(this.setRowErrors(oper));
                continue;
            }
            if (!operName.equals("NSCMD_ETHN_GET_LINKAGGSYSMAC")) continue;
            output = oper.getOutput(0);
            if (output.getFault(0).getCode().equals("0")) {
                param = new Param("systemMAC", TELAGUtil.getMACforFormat(output.getPartValue("systemMAC")));
                rowParams.addParam(param);
                continue;
            }
            macFlag = true;
            rowParams.addRowErrors(this.setRowErrors(oper));
        }
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (0 == errorCode) {
            if (sysFlag || macFlag) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            }
        } else if (!sysFlag || !macFlag) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
        this.outputData.getBussinessParams().addRowParams(rowParams);
    }

    public String getDetailStr(RowParams rowparams) {
        int slotId = Integer.parseInt(rowparams.getParam("slotid").getValue());
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        String boardName = mgr.getBoardTypeName(this.neid, mgr.getBoardType(this.neid, slotId));
        return slotId + "-" + boardName;
    }

    private RowErrors setRowErrors(Operation oper) {
        RowErrors rowErrors = new RowErrors();
        Input input = oper.getInput();
        rowErrors.addParam(new Param("nename", this.neName));
        int m = input.getPartCount();
        for (int i = 0; i < m; ++i) {
            Part part = input.getPart(i);
            rowErrors.addParam(new Param(part.getName(), part.getValue()));
        }
        rowErrors.addParam(new Param("boardname", this.boardName));
        rowErrors.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(oper.getOutput(0).getFault(0).getCode())));
        return rowErrors;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(39185);
        list.add(38662);
        return list;
    }
}

