/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.linkaggregation;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryLACPInfo
extends TENEExplorerBean {
    private static final String RECIVIED_LACP = "1";
    private static final String RECIVIED_FAULT_LACP = "2";
    private static final String SENT_LACP = "3";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        RowParams rowSdhParams = inputData.getBussinessParams().getRowParams(0);
        String ports = rowSdhParams.getParam("portid").getValue();
        String slotid = rowSdhParams.getParam("slotid").getValue();
        this.operationList = this.constructOperationList(ports, slotid, neid);
        int result = this.sendMessage(neid);
        if (0 == result) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        return this.outputData;
    }

    private ArrayList constructOperationList(String ports, String slotid, int neid) {
        String[] sdhPortList = ports.split(",");
        ArrayList<Object> sdhOperationList = new ArrayList<Object>();
        Operation oper = null;
        Input input = null;
        int len = sdhPortList.length;
        for (int i = 0; i < len; ++i) {
            oper = (Operation)TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_LINKAGGPCK").clone();
            input = oper.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("port", sdhPortList[i]);
            input.setPartValue("lagpacType", RECIVIED_LACP);
            sdhOperationList.add(oper.clone());
            input = oper.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("port", sdhPortList[i]);
            input.setPartValue("lagpacType", RECIVIED_FAULT_LACP);
            sdhOperationList.add(oper.clone());
            input = oper.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("port", sdhPortList[i]);
            input.setPartValue("lagpacType", SENT_LACP);
            sdhOperationList.add(oper.clone());
        }
        return sdhOperationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation oper = null;
        Output output = null;
        Part sdhPartType = null;
        Part partNum = null;
        int operLength = operationList.size();
        for (int i = 0; i < operLength; ++i) {
            oper = (Operation)operationList.get(i);
            int outputLength = oper.getOutputCount();
            for (int j = 0; j < outputLength; ++j) {
                output = oper.getOutput(j);
                if (!output.getFault(0).getCode().equals("0")) continue;
                sdhPartType = output.getPart("lagpacType");
                partNum = output.getPart("lagpacNum");
                Part newPart = new Part();
                if (RECIVIED_LACP.equals(sdhPartType.getValue())) {
                    newPart.setName("receivedLACP");
                } else if (RECIVIED_FAULT_LACP.equals(sdhPartType.getValue())) {
                    newPart.setName("receivedFaultLACP");
                } else if (SENT_LACP.equals(sdhPartType.getValue())) {
                    newPart.setName("sentLACP");
                }
                newPart.setValue(partNum.getValue());
                output.addPart(newPart);
                output.removePart(sdhPartType);
                output.removePart(partNum);
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
    }

    public String getDetailStr(RowParams rowparams) {
        int slotId = Integer.parseInt(rowparams.getParam("slotid").getValue());
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        String boardName = mgr.getBoardTypeName(this.neid, mgr.getBoardType(this.neid, slotId));
        return slotId + "-" + boardName;
    }
}

