/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethserviceoam;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryEthServiceOAMBean
extends TENEExplorerBean {
    private static final int errorCode0 = 38662;
    private static final int errorCode1 = 39326;
    private static final String NE_NOT_LOGIN = "37926";
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        errorCodeList.add(new Integer(39326));
        return errorCodeList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Operation queryMAOper = (Operation)operationList.remove(operationList.size() - 1);
        Operation queryMDOper = (Operation)operationList.remove(operationList.size() - 1);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        RowParams[] rowParams = bussinessParams.getRowParams();
        if (0 != errorCode) {
            RowParams rowparam = null;
            RowErrors rowErrors = null;
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                rowparam = rowParams[i];
                if (0 == rowparam.getRowErrorsCount() || !(rowErrors = rowparam.getRowErrors(0)).getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) continue;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
                for (int j = rowparam.getRowErrorsCount() - 1; j >= 0; --j) {
                    rowparam.removeRowErrors(rowparam.getRowErrors(j));
                }
                return;
            }
        }
        boolean faultFlag = false;
        RowParams rowparam = null;
        RowErrors rowErrors = null;
        int slotId = 0;
        int portId = 0;
        String mpid = "";
        String cmpid = "";
        String ccMac = "";
        String ccMacStr = "";
        if (0 == errorCode || 1 == errorCode) {
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                faultFlag = false;
                rowparam = rowParams[i];
                if (0 != rowparam.getRowErrorsCount() && !(rowErrors = rowparam.getRowErrors(0)).getErrorMessage().getErrorcode().equals("0")) {
                    faultFlag = true;
                }
                if (faultFlag) continue;
                slotId = Integer.parseInt(rowparam.getParam("slotid").getValue());
                portId = Integer.parseInt(rowparam.getParam("port").getValue());
                rowparam.getParam("portname").setValue(this.getPortName(slotId, portId));
                mpid = rowparam.getParam("mpid").getValue();
                cmpid = mpid.substring(0, 2) + "-" + mpid.substring(2, 4) + "-" + mpid.substring(4);
                rowparam.getParam("mpid").setValue(cmpid);
                if (rowparam.getParam("mdid").getValue().equals("")) {
                    rowparam.getParam("mdid").setValue("0");
                    rowparam.getParam("mdName").setValue("NULL");
                    rowparam.getParam("mAName").setValue("NULL");
                    continue;
                }
                ccMac = rowparam.getParam("ccMac").getValue();
                if (!"".equals(ccMac)) {
                    ccMacStr = ccMac.substring(0, 2) + "-" + ccMac.substring(2, 4) + "-" + ccMac.substring(4, 6) + "-" + ccMac.substring(6, 8) + "-" + ccMac.substring(8, 10) + "-" + ccMac.substring(10, 12);
                    rowparam.getParam("ccMac").setValue(ccMacStr);
                }
                this.handleMDMAOper(rowparam, queryMDOper, queryMAOper);
            }
        }
    }

    private String getPortName(int slotId, int portId) {
        String portName = "";
        int boardType = this.mgr.getBoardType(this.neid, slotId);
        int portType = this.mgr.getPortType(this.neid, boardType, portId);
        portName = portType == 61005 ? TEConfigurationDataMgr.getVCTrunkName((int)(portId - 32768)) : TEConfigurationDataMgr.getMACName((int)portId);
        return portName;
    }

    private void handleMDMAOper(RowParams rowparam, Operation mdOper, Operation maOper) {
        int i;
        String mdid = rowparam.getParam("mdid").getValue();
        String maid = rowparam.getParam("maid").getValue();
        Output output = null;
        for (i = mdOper.getOutputCount() - 1; i >= 0; --i) {
            output = mdOper.getOutput(i);
            if (!output.getFault(0).getCode().equals("0")) {
                mdOper.removeOutput(i);
                continue;
            }
            if (!output.getPart("mdid").getValue().equals(mdid)) continue;
            rowparam.getParam("mdName").setValue(IOStreamConvertor.replaceSpecialStr((String)output.getPart("mdName").getValue()));
            rowparam.getParam("level").setValue(output.getPart("level").getValue());
            break;
        }
        for (i = maOper.getOutputCount() - 1; i >= 0; --i) {
            output = maOper.getOutput(i);
            if (!output.getFault(0).getCode().equals("0")) {
                maOper.removeOutput(i);
                continue;
            }
            if (!output.getPart("mdid").getValue().equals(mdid) || !output.getPart("maid").getValue().equals(maid)) continue;
            rowparam.getParam("maName").setValue(IOStreamConvertor.replaceSpecialStr((String)output.getPart("maName").getValue()));
            break;
        }
    }
}

