/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.sdh.ethserviceoam;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TENewEthServiceOAMBean
extends TENEExplorerBean {
    private static final int VCTRUNK_BASE_NUM = 32768;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String SERVICE_OAM_RES = "ip" + File.separator + "sdh" + File.separator + "res" + File.separator + "serviceoam" + File.separator + "serviceoamres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = null;
    private TEConfigurationDataMgr mgr = null;
    private ArrayList firstOperationList = new ArrayList();
    private ArrayList secondOperationList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            int mdid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("mdid").getValue());
            ArrayList<String> firstOpeName = new ArrayList<String>();
            ArrayList<String> secondOperName = new ArrayList<String>();
            secondOperName.add("NSCMD_ETHN_ETHOAM_SET_CCSTATUS");
            secondOperName.add("NSCMD_ETHN_ETHOAM_SET_LBTIMER");
            secondOperName.add("NSCMD_ETHN_ETHOAM_SET_LTTIMER");
            secondOperName.add("NSCMD_ETHN_ETHOAM_SET_CCTIMER");
            if (mdid == 0) {
                firstOpeName.add("NSCMD_ETHN_ETHOAM_ADD_MP");
            } else {
                firstOpeName.add("NSCMD_ETHN_ETHOAM_ADD_STDMP");
                secondOperName.add("NSCMD_ETHN_ETHOAM_SET_AISSTATE");
                secondOperName.add("NSCMD_ETHN_ETHOAM_STDMP_SET_CCMAC");
            }
            this.firstOperationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, firstOpeName);
            this.secondOperationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, secondOperName);
            Operation operation = null;
            int result = this.sendMessage(neid, this.firstOperationList);
            if (result == 0) {
                operation = (Operation)this.firstOperationList.get(0);
                if (operation.getOutput(0).getFault(0).getCode().equals("0") && null != this.secondOperationList && this.secondOperationList.size() > 0 && (result = this.sendMessage(neid, this.secondOperationList)) == 0) {
                    this.firstOperationList.addAll(this.secondOperationList);
                }
                this.handleMessage(neid, this.firstOperationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            this.res = TEGetFilePath.getResource((int)neid, (String)SERVICE_OAM_RES);
            TELogInfo loginfo = new TELogInfo();
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserID(userID);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            String operateName = subfunc.getSubFuncDes(neid);
            loginfo.setOperateName(operateName);
            loginfo.setOperateObject(operObj);
            StringBuffer desc = new StringBuffer();
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            this.mgr = TEConfigurationDataMgr.getInstance();
            int slot = Integer.parseInt(rowParams.getParam("slotid").getValue());
            int boardType = this.mgr.getBoardType(neid, slot);
            String boardName = this.mgr.getBoardTypeName(neid, boardType);
            int port = Integer.parseInt(rowParams.getParam("port").getValue());
            desc.append(this.res.getString("node")).append(":").append(slot).append("-").append(boardName).append("-").append(this.getPortName(slot, boardType, port)).append(",");
            desc.append(this.res.getString("vlanid")).append(":").append(rowParams.getParam("vlanid").getValue()).append(",");
            String mpid = rowParams.getParam("mpid").getValue();
            StringBuffer sb = new StringBuffer(15);
            sb.append(mpid.substring(0, 2)).append("-");
            sb.append(mpid.substring(2, 4)).append("-").append(mpid.substring(4));
            desc.append(this.res.getString("mpid")).append(":").append(sb.toString()).append(",");
            desc.append(this.res.getString("type")).append(":");
            int type = Integer.parseInt(rowParams.getParam("type").getValue());
            if (1 == type) {
                desc.append(this.res.getString("mep")).append(",");
            } else if (2 == type) {
                desc.append(this.res.getString("mip")).append(",");
            }
            desc.append(this.res.getString("direction")).append(":");
            int direction = Integer.parseInt(rowParams.getParam("direction").getValue());
            if (0 == direction) {
                desc.append(this.res.getString("doubledirection")).append(",");
            } else if (1 == direction) {
                if (port < 32768) {
                    desc.append(this.res.getString("wdmdirection")).append(",");
                } else {
                    desc.append(this.res.getString("ipdirection")).append(",");
                }
            } else if (2 == direction) {
                if (port < 32768) {
                    desc.append(this.res.getString("ipdirection")).append(",");
                } else {
                    desc.append(this.res.getString("wdmdirection")).append(",");
                }
            }
            desc.append(this.res.getString("level")).append(":");
            int level = Integer.parseInt(rowParams.getParam("level").getValue());
            String levelStr = "";
            switch (level) {
                case 0: {
                    levelStr = this.res.getString("level0");
                    break;
                }
                case 1: {
                    levelStr = this.res.getString("level1");
                    break;
                }
                case 2: {
                    levelStr = this.res.getString("level2");
                    break;
                }
                case 3: {
                    levelStr = this.res.getString("level3");
                    break;
                }
                case 4: {
                    levelStr = this.res.getString("level4");
                    break;
                }
                case 5: {
                    levelStr = this.res.getString("level5");
                    break;
                }
                case 6: {
                    levelStr = this.res.getString("level6");
                    break;
                }
                case 7: {
                    levelStr = this.res.getString("level7");
                    break;
                }
            }
            desc.append(levelStr);
            desc.append(",").append("MD").append(":");
            desc.append(rowParams.getParam("mdName").getValue());
            desc.append(",").append("MA").append(":");
            desc.append(rowParams.getParam("maName").getValue());
            if (1 == type) {
                desc.append(",").append(this.res.getString("ccstatus")).append(":");
                int status = Integer.parseInt(rowParams.getParam("ccstatus").getValue());
                if (1 == status) {
                    desc.append(this.res.getString("active"));
                } else {
                    desc.append(this.res.getString("inactive"));
                }
                desc.append(",").append(this.res.getString("lbtesttime")).append(":").append(rowParams.getParam("lbtesttime").getValue()).append("ms");
                desc.append(",").append(this.res.getString("lttesttime")).append(":").append(rowParams.getParam("lttesttime").getValue()).append("ms");
                desc.append(",").append(this.res.getString("ccperiod")).append(":").append(rowParams.getParam("ccperiod").getValue()).append("ms");
            }
            loginfo.setOperateDesc(desc.toString());
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (0 == errorCode) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else {
                loginfo.setResult(2);
                if (1 == errorCode || 2 == errorCode) {
                    rowParams = outputData.getBussinessParams().getRowParams(0);
                    int errorCount = rowParams.getRowErrorsCount();
                    for (int j = 0; j < errorCount; ++j) {
                        RowErrors rowErrors = rowParams.getRowErrors(j);
                        loginfo.setErrCode(Integer.parseInt(rowErrors.getErrorMessage().getErrorcode()));
                        loginfo.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
                    }
                } else {
                    loginfo.setResult(2);
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                }
            }
            TELogMgr.writeLog((TELogInfo)loginfo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String getPortName(int slotId, int boardType, int portId) {
        String portName = "";
        int portType = this.mgr.getPortType(this.neid, boardType, portId);
        portName = portType == 1025 ? TEConfigurationDataMgr.getMACName((int)portId) : (portType == 61005 ? TEConfigurationDataMgr.getVCTrunkName((int)(portId - 32768)) : this.mgr.getPortName(this.neid, slotId, boardType, portId));
        return portName;
    }
}

